/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPubMeth.h: interface for the DlgAddPubMeth class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGADDPUBMETH_H
#define DLGADDPUBMETH_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>



#include <stdio.h>
#include <string.h>
#include <HashTable/HashTable_String.h>
#include "Error.h"
#include "Functions.h"
#include <libxml/parserInternals.h>
#include <libxml/parser.h>

class DlgAddPubMethListCtrl: public wxListCtrl
{
public:
	DlgAddPubMethListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,
			const wxSize& size, long style):
		wxListCtrl(parent, id, pos, size, style)
		{
		}

	void OnItemClick(wxListEvent& event);
private:
	DECLARE_EVENT_TABLE()
};


#include <ASN1/Asn1Conf.h>


class DlgAddPubMeth: public wxDialog
{
public:
	DlgAddPubMeth(wxWindow * wParent, const PublicationMethodInfo & pubEntry);
	virtual ~DlgAddPubMeth();
	
	bool IsOK();
	void OnItemClick(wxListEvent& event);
	const PublicationMethodInfo & GetPublication();

	void OnValueChanged(wxCommandEvent& event);
	void OnBrowseXML(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent& event);


private:
	wxListCtrl * m_listCtrl;
	wxImageList *m_imageListSmall;

	void ReloadList();
	bool m_IsOk;
	PublicationMethodInfo m_Entry;
	xmlParserCtxtPtr ctxt;

	DECLARE_EVENT_TABLE()
};

#endif
