/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgCsrProperties.h: interface for the DlgCsrProperties class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGCSRPROPERTIES_H
#define DLGCSRPROPERTIES_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>


#include <stdio.h>
#include <string.h>
#include "Error.h"
#include "Functions.h"
#include <PKI_CSR.h>


class DlgCsrPropertiesListCtrl: public wxListCtrl
{
public:
	DlgCsrPropertiesListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,
			const wxSize& size, long style):
		wxListCtrl(parent, id, pos, size, style)
		{
		}

	void OnItemClick(wxListEvent& event);
private:
	DECLARE_EVENT_TABLE()
};


class DlgCsrProperties: public wxDialog  
{
public:
	DlgCsrProperties(wxWindow * wParent, const PKI_CSR & Csr);
	virtual ~DlgCsrProperties();
	void OnOk(wxCommandEvent& event);
	void OnItemClick(wxListEvent& event);
	void OnSaveCsr(wxCommandEvent& event);
private:
	void InserItem(const char * name, const char * value, const char * datas, int icon_id);
	mString GetPubKey(const EVP_PKEY * pkey);
	void InitDatas();

	DlgCsrPropertiesListCtrl * m_listCtrl;
	wxImageList *m_imageListSmall;
	const PKI_CSR & m_csr;
	DECLARE_EVENT_TABLE()
};

#endif
