/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgExtension.cpp: implementation of the DlgExtension class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgExtension.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgExtension, wxDialog)
    EVT_BUTTON(IDC_OK, DlgExtension::OnOk)
END_EVENT_TABLE()


DlgExtension::DlgExtension(wxWindow * wParent, const mVector<ExtensionValue> & Ext):wxDialog(wParent, (wxWindowID)-1, _("Extensions"), wxDefaultPosition)
{
	size_t i;

	DlgExtension_SetWindow(this);


	m_listCtrl = ((wxListCtrl *)FindWindow(IDC_LIST_FIELDS));

	wxIcon ico;
	m_imageListSmall = new wxImageList(16, 16, TRUE);	
	ico.CopyFromBitmap(DlgCertProperties_GetBitmap(0));
	m_imageListSmall->Add(ico);

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Field"), wxLIST_FORMAT_LEFT, 135);
	m_listCtrl->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 198);

	for(i=0; i<Ext.size(); i++)
	{
		m_listCtrl->InsertItem(i, Ext[i].get_name().c_str(), 0);
		m_listCtrl->SetItem(i, 1, Ext[i].get_value().c_str());
	}

	CenterOnScreen();
	ShowModal();
}

DlgExtension::~DlgExtension()
{
	if(m_listCtrl) m_listCtrl->DeleteAllItems();
	if(m_imageListSmall) delete m_imageListSmall;
}

void DlgExtension::OnOk(wxCommandEvent &event)
{
	Close(TRUE);
}

