/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "HashCorrelation_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(INTERNAL_HASH) = {
	ASN1_SIMPLE(INTERNAL_HASH, hash, ASN1_OCTET_STRING),
}ASN1_SEQUENCE_END(INTERNAL_HASH)
InternalHash InternalHash::EmptyInstance;
bool InternalHash::set_hash(const Asn1OctetString & c_hash)
{
	m_hash = c_hash;
	return true;
}

const Asn1OctetString & InternalHash::get_hash() const
{
	return m_hash;
}

Asn1OctetString & InternalHash::get_hash()
{
	return m_hash;
}

bool InternalHash::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	INTERNAL_HASH * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool InternalHash::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	INTERNAL_HASH * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

InternalHash::InternalHash():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

InternalHash::InternalHash(const InternalHash & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

InternalHash::~InternalHash()
{
	Clear();
}

void InternalHash::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalHash::freeAll()
{
}

void InternalHash::resetAll()
{
	m_hash.Clear();
}

bool InternalHash::load_Datas(const INTERNAL_HASH * Datas)
{
	Clear();
	if(Datas->hash)
	{
		if(!m_hash.load_Datas(Datas->hash))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalHash::give_Datas(INTERNAL_HASH ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_HASH*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->hash && !((*Datas)->hash = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_hash.give_Datas(&(*Datas)->hash))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->hash, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
		(*Datas)->hash = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool InternalHash::operator=(const InternalHash & other)
{
	Clear();
	m_hash = other.m_hash;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalHash::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_HASH);
}
