/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Semaphore.h: interface for the Semaphore class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SEMAPHORE_H
#define SEMAPHORE_H

#include <assert.h>
#include <newpki_threads.h>
#include <CriticalSection.h>


/*!
  This class implements the Semaphore algorithm
*/
class Semaphore  
{
public:
	/*! \brief This is the constructor.
	 */
	Semaphore();

	/*! \brief This is the destructor.
	 */
	virtual ~Semaphore();
	
	/*! \brief Releases a lock.
	 */
	void Post() const;

	/*! \brief Requests a lock.
	 */
	void Wait() const;
	
	/*! \brief Checks the owner of the lock.
	 *  \param id [IN] The thread id.
	 *  \return true if owner, false if not owner.
	 */
	bool isOwner( NEWPKI_THREAD_ID id ) const;

	/*! \brief Set the owner of the lock.
	 *  \param id [IN] The thread id.
	 */
	void setOwner( NEWPKI_THREAD_ID id ) const;
private:
	NEWPKI_THREAD_ID OwnerThread;
	unsigned long LocksCount;
	bool IsAvailable;
	CriticalSection AccessLock;
};

#endif
