/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// UserHandle.h: interface for the UserHandle class.
//
//////////////////////////////////////////////////////////////////////

#ifndef USERHANDLE_H
#define USERHANDLE_H

#include <NewPKI.h>

#include "SQL/SQL_Conn.h"
#include <PKI_CERT.h>
#include <map>
using namespace std;

/*!
	This function represents a authenticated user
*/
class UserHandle  
{
public:
	/*! \brief This is the constructor.
	 */
	UserHandle();

	/*! \brief This is the constructor.
	 *  \param other [IN] Load datas from another instance.
	 */
	UserHandle(const UserHandle & other);
	
	/*! \brief This is the destructor.
	 */
	virtual ~UserHandle();
	
	/*! \brief This function returns the user's cert.
	 *  \return The user's cert.
	 */
	const PKI_CERT & GetUserCert() const;

	/*! \brief This function sets the user's cert.
	 *  \param UserCert [IN] The user's cert.
	 */
	bool SetUserCert(const PKI_CERT & UserCert);
	
	/*! \brief This function sets the user's name.
	 *  \param UserName [IN] The user's name.
	 */
	void SetUserName(const mString & UserName);
	
	/*! \brief This function returns the user's name.
	 *  \return The user's name.
	 */
	const mString & GetUserName() const;
	
	/*! \brief This function sets the user's password.
	 *  \param Password [IN] The user's password.
	 */
	void SetPassword(const mString & Password);
	
	/*! \brief This function returns the user's password.
	 *  \return The user's password.
	 */
	const mString & GetPassword() const;
	
	/*! \brief This function returns the user's ID.
	 *  \return The user's ID.
	 */
	unsigned long GetUserId() const;
	
	/*! \brief This function sets the user's ID.
	 *  \param UserId [IN] The user's ID.
	 */
	void SetUserId(unsigned long UserId);
	
	/*! \brief This function sets the user's client data.
	 *  \param Datas [IN] The user's client data.
	 */
	void SetClientData(void * Datas);
	
	/*! \brief This function returns the user's client data.
	 *  \return The user's client data.
	 */
	const void * GetClientData() const;
	
	/*! \brief This function returns the user's private context.
	 *  \return The user's private context.
	 */
	const mString & get_context(const mString & name) const;

	/*! \brief This function returns the user's private context.
	 *  \return The user's private context.
	 */
	mString & get_context(const mString & name);

	/*! \brief This function return 1 when the handle is operable and 0 when not.
	 *  \return return 1 when the handle is operable and 0 when not.
	 */
	operator int() const;
	
	/*! \brief This operator copies one UserHandle into another.
	 *  \param other [IN] The other handle to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const UserHandle &other);

	static UserHandle EmptyInstance;
private:
	mString m_UserName;
	mString m_Password;
	PKI_CERT m_UserCert;
	void * m_Datas;
	unsigned long m_UserId;
	map< mString, mString > m_context;
};

#endif
