/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.EmptyIntIterator;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;

public class NamespaceCodeIterator
implements IntIterator {
    private NodeInfo element;
    private int index;
    private int next;
    private int[] localDeclarations;
    IntHashSet undeclared;

    public static IntIterator iterateNamespaces(NodeInfo element) {
        if (element.getNodeKind() == 1) {
            return new NamespaceCodeIterator(element);
        }
        return EmptyIntIterator.getInstance();
    }

    public static void sendNamespaces(NodeInfo element, Receiver receiver) throws XPathException {
        if (element.getNodeKind() == 1) {
            int[] undeclared = new int[8];
            int undeclaredSize = 0;
            int[] localDeclarations = element.getDeclaredNamespaces(null);
            while (true) {
                int nsCode;
                int i = 0;
                while (i < localDeclarations.length && (nsCode = localDeclarations[i++]) != -1) {
                    short uriCode = (short)(nsCode & 0xFFFF);
                    short prefixCode = (short)(nsCode >> 16);
                    boolean isnew = true;
                    for (int j = 0; j < undeclaredSize; ++j) {
                        if (undeclared[j] != prefixCode) continue;
                        isnew = false;
                        break;
                    }
                    if (!isnew) continue;
                    if (undeclared.length == undeclaredSize) {
                        int[] u2 = new int[undeclaredSize * 2];
                        System.arraycopy(undeclared, 0, u2, 0, undeclaredSize);
                        undeclared = u2;
                    }
                    undeclared[undeclaredSize++] = prefixCode;
                    if (uriCode == 0 && prefixCode != 0) continue;
                    receiver.namespace(nsCode, 0);
                }
                if ((element = element.getParent()) == null || element.getNodeKind() != 1) {
                    return;
                }
                localDeclarations = element.getDeclaredNamespaces(localDeclarations);
            }
        }
    }

    private NamespaceCodeIterator(NodeInfo element) {
        this.element = element;
        this.undeclared = new IntHashSet(8);
        this.index = 0;
        this.localDeclarations = element.getDeclaredNamespaces(null);
    }

    public boolean hasNext() {
        if (this.next == -1) {
            return false;
        }
        this.advance();
        return this.next != -1;
    }

    public int next() {
        return this.next;
    }

    private void advance() {
        int nsCode;
        while (true) {
            boolean ascend = this.index >= this.localDeclarations.length;
            nsCode = 0;
            if (!ascend) {
                boolean bl = ascend = (nsCode = this.localDeclarations[this.index++]) == -1;
            }
            if (ascend) {
                this.element = this.element.getParent();
                if (this.element != null && this.element.getNodeKind() == 1) {
                    this.localDeclarations = this.element.getDeclaredNamespaces(this.localDeclarations);
                    this.index = 0;
                    continue;
                }
                this.next = -1;
                return;
            }
            short uriCode = (short)(nsCode & 0xFFFF);
            short prefixCode = (short)(nsCode >> 16);
            if (uriCode == 0) {
                this.undeclared.add(prefixCode);
                continue;
            }
            if (this.undeclared.add(prefixCode)) break;
        }
        this.next = nsCode;
    }
}

