/*
 *  Copyright (c) 2004, SWITCH - Teleinformatikdienste fuer Lehre und Forschung
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions are met:
 *  
 *   * Redistributions of source code must retain the above copyright notice, 
 *	 this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright notice, 
 *	 this list of conditions and the following disclaimer in the documentation 
 *	 and/or other materials provided with the distribution.
 *   * Neither the name of SWITCH nor the names of its contributors may be 
 *	 used to endorse or promote products derived from this software without 
 *	 specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 *  POSSIBILITY OF SUCH DAMAGE.
 *  
 *  $Author: peter $
 *
 *  $Id: nfdump_inline.c 100 2008-08-15 11:36:21Z peter $
 *
 *  $LastChangedRevision: 100 $
 *	
 *
 */


// to improve readability - separate some code blocks in functions and make them inline
static inline void UpdateStat(stat_record_t	*stat_record, master_record_t *master_record);

static inline void AppendToBuffer(nffile_t *nffile, void *record, size_t required);

static inline void UpdateStat(stat_record_t	*stat_record, master_record_t *master_record) {

	switch (master_record->prot) {
		case IPPROTO_ICMP:
			stat_record->numflows_icmp++;
			stat_record->numpackets_icmp += master_record->dPkts;
			stat_record->numbytes_icmp   += master_record->dOctets;
			break;
		case IPPROTO_TCP:
			stat_record->numflows_tcp++;
			stat_record->numpackets_tcp += master_record->dPkts;
			stat_record->numbytes_tcp   += master_record->dOctets;
			break;
		case IPPROTO_UDP:
			stat_record->numflows_udp++;
			stat_record->numpackets_udp += master_record->dPkts;
			stat_record->numbytes_udp   += master_record->dOctets;
			break;
		default:
			stat_record->numflows_other++;
			stat_record->numpackets_other += master_record->dPkts;
			stat_record->numbytes_other   += master_record->dOctets;
	}
	stat_record->numflows++;
	stat_record->numpackets	+= master_record->dPkts;
	stat_record->numbytes 	+= master_record->dOctets;

	if ( master_record->first < stat_record->first_seen ) {
		stat_record->first_seen = master_record->first;
		stat_record->msec_first = master_record->msec_first;
	}
	if ( master_record->first == stat_record->first_seen && 
	 	master_record->msec_first < stat_record->msec_first ) 
			stat_record->msec_first = master_record->msec_first;

	if ( master_record->last > stat_record->last_seen ) {
		stat_record->last_seen = master_record->last;
		stat_record->msec_last = master_record->msec_last;
	}
	if ( master_record->last == stat_record->last_seen && 
	 	master_record->msec_last > stat_record->msec_last ) 
			stat_record->msec_last = master_record->msec_last;

} // End of UpdateStat

static inline void AppendToBuffer(nffile_t *nffile, void *record, size_t required) {

	// flush current buffer to disc
	if ( (nffile->block_header->size + required )  > BUFFSIZE ) {

		// this should never happen, but catch it anyway
		if ( required > BUFFSIZE ) {
			fprintf(stderr, "Required buffer size %zu too big for output buffer!" , required);
			return;
		}

		if ( WriteBlock(nffile) <= 0 ) {
			fprintf(stderr, "Failed to write output buffer to disk: '%s'" , strerror(errno));
			return;
		} else {
			nffile->block_header->size 		 = 0;
			nffile->block_header->NumRecords = 0;
			nffile->writeto = (void *)((pointer_addr_t)nffile->block_header + sizeof(data_block_header_t) );
			nffile->file_blocks++;
		}

	}

	// enough buffer space available at this point
	memcpy(nffile->writeto, record, required);

	// update stat
	nffile->block_header->NumRecords++;
	nffile->block_header->size += required;

	// advance write pointer
	nffile->writeto = (void *)((pointer_addr_t)nffile->writeto + required);

} // End of AppendToBuffer

