/*
 * nghttp2 - HTTP/2 C Library
 *
 * Copyright (c) 2013 Tatsuhiro Tsujikawa
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "nghttp2_hd_huffman.h"

const nghttp2_huff_sym huff_sym_table[] = {
  { 26, 0x3ffffbau },
  { 26, 0x3ffffbbu },
  { 26, 0x3ffffbcu },
  { 26, 0x3ffffbdu },
  { 26, 0x3ffffbeu },
  { 26, 0x3ffffbfu },
  { 26, 0x3ffffc0u },
  { 26, 0x3ffffc1u },
  { 26, 0x3ffffc2u },
  { 26, 0x3ffffc3u },
  { 26, 0x3ffffc4u },
  { 26, 0x3ffffc5u },
  { 26, 0x3ffffc6u },
  { 26, 0x3ffffc7u },
  { 26, 0x3ffffc8u },
  { 26, 0x3ffffc9u },
  { 26, 0x3ffffcau },
  { 26, 0x3ffffcbu },
  { 26, 0x3ffffccu },
  { 26, 0x3ffffcdu },
  { 26, 0x3ffffceu },
  { 26, 0x3ffffcfu },
  { 26, 0x3ffffd0u },
  { 26, 0x3ffffd1u },
  { 26, 0x3ffffd2u },
  { 26, 0x3ffffd3u },
  { 26, 0x3ffffd4u },
  { 26, 0x3ffffd5u },
  { 26, 0x3ffffd6u },
  { 26, 0x3ffffd7u },
  { 26, 0x3ffffd8u },
  { 26, 0x3ffffd9u },
  { 5, 0x6u },
  { 13, 0x1ffcu },
  { 9, 0x1f0u },
  { 14, 0x3ffcu },
  { 15, 0x7ffcu },
  { 6, 0x1eu },
  { 7, 0x64u },
  { 13, 0x1ffdu },
  { 10, 0x3fau },
  { 9, 0x1f1u },
  { 10, 0x3fbu },
  { 10, 0x3fcu },
  { 7, 0x65u },
  { 7, 0x66u },
  { 6, 0x1fu },
  { 5, 0x7u },
  { 4, 0x0u },
  { 4, 0x1u },
  { 4, 0x2u },
  { 5, 0x8u },
  { 6, 0x20u },
  { 6, 0x21u },
  { 6, 0x22u },
  { 6, 0x23u },
  { 6, 0x24u },
  { 6, 0x25u },
  { 6, 0x26u },
  { 8, 0xecu },
  { 17, 0x1fffcu },
  { 6, 0x27u },
  { 15, 0x7ffdu },
  { 10, 0x3fdu },
  { 15, 0x7ffeu },
  { 7, 0x67u },
  { 8, 0xedu },
  { 8, 0xeeu },
  { 7, 0x68u },
  { 8, 0xefu },
  { 7, 0x69u },
  { 7, 0x6au },
  { 9, 0x1f2u },
  { 8, 0xf0u },
  { 9, 0x1f3u },
  { 9, 0x1f4u },
  { 9, 0x1f5u },
  { 7, 0x6bu },
  { 7, 0x6cu },
  { 8, 0xf1u },
  { 8, 0xf2u },
  { 9, 0x1f6u },
  { 9, 0x1f7u },
  { 7, 0x6du },
  { 6, 0x28u },
  { 8, 0xf3u },
  { 9, 0x1f8u },
  { 9, 0x1f9u },
  { 8, 0xf4u },
  { 9, 0x1fau },
  { 9, 0x1fbu },
  { 11, 0x7fcu },
  { 26, 0x3ffffdau },
  { 11, 0x7fdu },
  { 14, 0x3ffdu },
  { 7, 0x6eu },
  { 18, 0x3fffeu },
  { 5, 0x9u },
  { 7, 0x6fu },
  { 5, 0xau },
  { 6, 0x29u },
  { 5, 0xbu },
  { 7, 0x70u },
  { 6, 0x2au },
  { 6, 0x2bu },
  { 5, 0xcu },
  { 8, 0xf5u },
  { 8, 0xf6u },
  { 6, 0x2cu },
  { 6, 0x2du },
  { 6, 0x2eu },
  { 5, 0xdu },
  { 6, 0x2fu },
  { 9, 0x1fcu },
  { 6, 0x30u },
  { 6, 0x31u },
  { 5, 0xeu },
  { 7, 0x71u },
  { 7, 0x72u },
  { 7, 0x73u },
  { 7, 0x74u },
  { 7, 0x75u },
  { 8, 0xf7u },
  { 17, 0x1fffdu },
  { 12, 0xffcu },
  { 17, 0x1fffeu },
  { 12, 0xffdu },
  { 26, 0x3ffffdbu },
  { 26, 0x3ffffdcu },
  { 26, 0x3ffffddu },
  { 26, 0x3ffffdeu },
  { 26, 0x3ffffdfu },
  { 26, 0x3ffffe0u },
  { 26, 0x3ffffe1u },
  { 26, 0x3ffffe2u },
  { 26, 0x3ffffe3u },
  { 26, 0x3ffffe4u },
  { 26, 0x3ffffe5u },
  { 26, 0x3ffffe6u },
  { 26, 0x3ffffe7u },
  { 26, 0x3ffffe8u },
  { 26, 0x3ffffe9u },
  { 26, 0x3ffffeau },
  { 26, 0x3ffffebu },
  { 26, 0x3ffffecu },
  { 26, 0x3ffffedu },
  { 26, 0x3ffffeeu },
  { 26, 0x3ffffefu },
  { 26, 0x3fffff0u },
  { 26, 0x3fffff1u },
  { 26, 0x3fffff2u },
  { 26, 0x3fffff3u },
  { 26, 0x3fffff4u },
  { 26, 0x3fffff5u },
  { 26, 0x3fffff6u },
  { 26, 0x3fffff7u },
  { 26, 0x3fffff8u },
  { 26, 0x3fffff9u },
  { 26, 0x3fffffau },
  { 26, 0x3fffffbu },
  { 26, 0x3fffffcu },
  { 26, 0x3fffffdu },
  { 26, 0x3fffffeu },
  { 26, 0x3ffffffu },
  { 25, 0x1ffff80u },
  { 25, 0x1ffff81u },
  { 25, 0x1ffff82u },
  { 25, 0x1ffff83u },
  { 25, 0x1ffff84u },
  { 25, 0x1ffff85u },
  { 25, 0x1ffff86u },
  { 25, 0x1ffff87u },
  { 25, 0x1ffff88u },
  { 25, 0x1ffff89u },
  { 25, 0x1ffff8au },
  { 25, 0x1ffff8bu },
  { 25, 0x1ffff8cu },
  { 25, 0x1ffff8du },
  { 25, 0x1ffff8eu },
  { 25, 0x1ffff8fu },
  { 25, 0x1ffff90u },
  { 25, 0x1ffff91u },
  { 25, 0x1ffff92u },
  { 25, 0x1ffff93u },
  { 25, 0x1ffff94u },
  { 25, 0x1ffff95u },
  { 25, 0x1ffff96u },
  { 25, 0x1ffff97u },
  { 25, 0x1ffff98u },
  { 25, 0x1ffff99u },
  { 25, 0x1ffff9au },
  { 25, 0x1ffff9bu },
  { 25, 0x1ffff9cu },
  { 25, 0x1ffff9du },
  { 25, 0x1ffff9eu },
  { 25, 0x1ffff9fu },
  { 25, 0x1ffffa0u },
  { 25, 0x1ffffa1u },
  { 25, 0x1ffffa2u },
  { 25, 0x1ffffa3u },
  { 25, 0x1ffffa4u },
  { 25, 0x1ffffa5u },
  { 25, 0x1ffffa6u },
  { 25, 0x1ffffa7u },
  { 25, 0x1ffffa8u },
  { 25, 0x1ffffa9u },
  { 25, 0x1ffffaau },
  { 25, 0x1ffffabu },
  { 25, 0x1ffffacu },
  { 25, 0x1ffffadu },
  { 25, 0x1ffffaeu },
  { 25, 0x1ffffafu },
  { 25, 0x1ffffb0u },
  { 25, 0x1ffffb1u },
  { 25, 0x1ffffb2u },
  { 25, 0x1ffffb3u },
  { 25, 0x1ffffb4u },
  { 25, 0x1ffffb5u },
  { 25, 0x1ffffb6u },
  { 25, 0x1ffffb7u },
  { 25, 0x1ffffb8u },
  { 25, 0x1ffffb9u },
  { 25, 0x1ffffbau },
  { 25, 0x1ffffbbu },
  { 25, 0x1ffffbcu },
  { 25, 0x1ffffbdu },
  { 25, 0x1ffffbeu },
  { 25, 0x1ffffbfu },
  { 25, 0x1ffffc0u },
  { 25, 0x1ffffc1u },
  { 25, 0x1ffffc2u },
  { 25, 0x1ffffc3u },
  { 25, 0x1ffffc4u },
  { 25, 0x1ffffc5u },
  { 25, 0x1ffffc6u },
  { 25, 0x1ffffc7u },
  { 25, 0x1ffffc8u },
  { 25, 0x1ffffc9u },
  { 25, 0x1ffffcau },
  { 25, 0x1ffffcbu },
  { 25, 0x1ffffccu },
  { 25, 0x1ffffcdu },
  { 25, 0x1ffffceu },
  { 25, 0x1ffffcfu },
  { 25, 0x1ffffd0u },
  { 25, 0x1ffffd1u },
  { 25, 0x1ffffd2u },
  { 25, 0x1ffffd3u },
  { 25, 0x1ffffd4u },
  { 25, 0x1ffffd5u },
  { 25, 0x1ffffd6u },
  { 25, 0x1ffffd7u },
  { 25, 0x1ffffd8u },
  { 25, 0x1ffffd9u },
  { 25, 0x1ffffdau },
  { 25, 0x1ffffdbu },
  { 25, 0x1ffffdcu }
};

const nghttp2_huff_decode huff_decode_table[][16] = {
  /* 0 */
  {
    {0, 0x03, 48},
    {0, 0x03, 49},
    {0, 0x03, 50},
    {5, 0x00, 0},
    {8, 0x00, 0},
    {9, 0x00, 0},
    {11, 0x00, 0},
    {12, 0x00, 0},
    {17, 0x00, 0},
    {20, 0x00, 0},
    {24, 0x00, 0},
    {27, 0x00, 0},
    {32, 0x00, 0},
    {37, 0x00, 0},
    {45, 0x00, 0},
    {54, 0x01, 0},
  },
  /* 1 */
  {
    {1, 0x02, 48},
    {14, 0x03, 48},
    {1, 0x02, 49},
    {14, 0x03, 49},
    {1, 0x02, 50},
    {14, 0x03, 50},
    {0, 0x03, 32},
    {0, 0x03, 47},
    {0, 0x03, 51},
    {0, 0x03, 97},
    {0, 0x03, 99},
    {0, 0x03, 101},
    {0, 0x03, 105},
    {0, 0x03, 111},
    {0, 0x03, 116},
    {13, 0x00, 0},
  },
  /* 2 */
  {
    {2, 0x02, 48},
    {6, 0x02, 48},
    {15, 0x02, 48},
    {30, 0x03, 48},
    {2, 0x02, 49},
    {6, 0x02, 49},
    {15, 0x02, 49},
    {30, 0x03, 49},
    {2, 0x02, 50},
    {6, 0x02, 50},
    {15, 0x02, 50},
    {30, 0x03, 50},
    {1, 0x02, 32},
    {14, 0x03, 32},
    {1, 0x02, 47},
    {14, 0x03, 47},
  },
  /* 3 */
  {
    {3, 0x02, 48},
    {4, 0x02, 48},
    {7, 0x02, 48},
    {10, 0x02, 48},
    {16, 0x02, 48},
    {23, 0x02, 48},
    {31, 0x02, 48},
    {44, 0x03, 48},
    {3, 0x02, 49},
    {4, 0x02, 49},
    {7, 0x02, 49},
    {10, 0x02, 49},
    {16, 0x02, 49},
    {23, 0x02, 49},
    {31, 0x02, 49},
    {44, 0x03, 49},
  },
  /* 4 */
  {
    {3, 0x02, 50},
    {4, 0x02, 50},
    {7, 0x02, 50},
    {10, 0x02, 50},
    {16, 0x02, 50},
    {23, 0x02, 50},
    {31, 0x02, 50},
    {44, 0x03, 50},
    {2, 0x02, 32},
    {6, 0x02, 32},
    {15, 0x02, 32},
    {30, 0x03, 32},
    {2, 0x02, 47},
    {6, 0x02, 47},
    {15, 0x02, 47},
    {30, 0x03, 47},
  },
  /* 5 */
  {
    {3, 0x02, 32},
    {4, 0x02, 32},
    {7, 0x02, 32},
    {10, 0x02, 32},
    {16, 0x02, 32},
    {23, 0x02, 32},
    {31, 0x02, 32},
    {44, 0x03, 32},
    {3, 0x02, 47},
    {4, 0x02, 47},
    {7, 0x02, 47},
    {10, 0x02, 47},
    {16, 0x02, 47},
    {23, 0x02, 47},
    {31, 0x02, 47},
    {44, 0x03, 47},
  },
  /* 6 */
  {
    {1, 0x02, 51},
    {14, 0x03, 51},
    {1, 0x02, 97},
    {14, 0x03, 97},
    {1, 0x02, 99},
    {14, 0x03, 99},
    {1, 0x02, 101},
    {14, 0x03, 101},
    {1, 0x02, 105},
    {14, 0x03, 105},
    {1, 0x02, 111},
    {14, 0x03, 111},
    {1, 0x02, 116},
    {14, 0x03, 116},
    {0, 0x03, 37},
    {0, 0x03, 46},
  },
  /* 7 */
  {
    {2, 0x02, 51},
    {6, 0x02, 51},
    {15, 0x02, 51},
    {30, 0x03, 51},
    {2, 0x02, 97},
    {6, 0x02, 97},
    {15, 0x02, 97},
    {30, 0x03, 97},
    {2, 0x02, 99},
    {6, 0x02, 99},
    {15, 0x02, 99},
    {30, 0x03, 99},
    {2, 0x02, 101},
    {6, 0x02, 101},
    {15, 0x02, 101},
    {30, 0x03, 101},
  },
  /* 8 */
  {
    {3, 0x02, 51},
    {4, 0x02, 51},
    {7, 0x02, 51},
    {10, 0x02, 51},
    {16, 0x02, 51},
    {23, 0x02, 51},
    {31, 0x02, 51},
    {44, 0x03, 51},
    {3, 0x02, 97},
    {4, 0x02, 97},
    {7, 0x02, 97},
    {10, 0x02, 97},
    {16, 0x02, 97},
    {23, 0x02, 97},
    {31, 0x02, 97},
    {44, 0x03, 97},
  },
  /* 9 */
  {
    {3, 0x02, 99},
    {4, 0x02, 99},
    {7, 0x02, 99},
    {10, 0x02, 99},
    {16, 0x02, 99},
    {23, 0x02, 99},
    {31, 0x02, 99},
    {44, 0x03, 99},
    {3, 0x02, 101},
    {4, 0x02, 101},
    {7, 0x02, 101},
    {10, 0x02, 101},
    {16, 0x02, 101},
    {23, 0x02, 101},
    {31, 0x02, 101},
    {44, 0x03, 101},
  },
  /* 10 */
  {
    {2, 0x02, 105},
    {6, 0x02, 105},
    {15, 0x02, 105},
    {30, 0x03, 105},
    {2, 0x02, 111},
    {6, 0x02, 111},
    {15, 0x02, 111},
    {30, 0x03, 111},
    {2, 0x02, 116},
    {6, 0x02, 116},
    {15, 0x02, 116},
    {30, 0x03, 116},
    {1, 0x02, 37},
    {14, 0x03, 37},
    {1, 0x02, 46},
    {14, 0x03, 46},
  },
  /* 11 */
  {
    {3, 0x02, 105},
    {4, 0x02, 105},
    {7, 0x02, 105},
    {10, 0x02, 105},
    {16, 0x02, 105},
    {23, 0x02, 105},
    {31, 0x02, 105},
    {44, 0x03, 105},
    {3, 0x02, 111},
    {4, 0x02, 111},
    {7, 0x02, 111},
    {10, 0x02, 111},
    {16, 0x02, 111},
    {23, 0x02, 111},
    {31, 0x02, 111},
    {44, 0x03, 111},
  },
  /* 12 */
  {
    {3, 0x02, 116},
    {4, 0x02, 116},
    {7, 0x02, 116},
    {10, 0x02, 116},
    {16, 0x02, 116},
    {23, 0x02, 116},
    {31, 0x02, 116},
    {44, 0x03, 116},
    {2, 0x02, 37},
    {6, 0x02, 37},
    {15, 0x02, 37},
    {30, 0x03, 37},
    {2, 0x02, 46},
    {6, 0x02, 46},
    {15, 0x02, 46},
    {30, 0x03, 46},
  },
  /* 13 */
  {
    {3, 0x02, 37},
    {4, 0x02, 37},
    {7, 0x02, 37},
    {10, 0x02, 37},
    {16, 0x02, 37},
    {23, 0x02, 37},
    {31, 0x02, 37},
    {44, 0x03, 37},
    {3, 0x02, 46},
    {4, 0x02, 46},
    {7, 0x02, 46},
    {10, 0x02, 46},
    {16, 0x02, 46},
    {23, 0x02, 46},
    {31, 0x02, 46},
    {44, 0x03, 46},
  },
  /* 14 */
  {
    {18, 0x00, 0},
    {19, 0x00, 0},
    {21, 0x00, 0},
    {22, 0x00, 0},
    {25, 0x00, 0},
    {26, 0x00, 0},
    {28, 0x00, 0},
    {29, 0x00, 0},
    {33, 0x00, 0},
    {34, 0x00, 0},
    {38, 0x00, 0},
    {41, 0x00, 0},
    {46, 0x00, 0},
    {49, 0x00, 0},
    {55, 0x00, 0},
    {62, 0x01, 0},
  },
  /* 15 */
  {
    {0, 0x03, 52},
    {0, 0x03, 53},
    {0, 0x03, 54},
    {0, 0x03, 55},
    {0, 0x03, 56},
    {0, 0x03, 57},
    {0, 0x03, 58},
    {0, 0x03, 61},
    {0, 0x03, 84},
    {0, 0x03, 100},
    {0, 0x03, 103},
    {0, 0x03, 104},
    {0, 0x03, 108},
    {0, 0x03, 109},
    {0, 0x03, 110},
    {0, 0x03, 112},
  },
  /* 16 */
  {
    {1, 0x02, 52},
    {14, 0x03, 52},
    {1, 0x02, 53},
    {14, 0x03, 53},
    {1, 0x02, 54},
    {14, 0x03, 54},
    {1, 0x02, 55},
    {14, 0x03, 55},
    {1, 0x02, 56},
    {14, 0x03, 56},
    {1, 0x02, 57},
    {14, 0x03, 57},
    {1, 0x02, 58},
    {14, 0x03, 58},
    {1, 0x02, 61},
    {14, 0x03, 61},
  },
  /* 17 */
  {
    {2, 0x02, 52},
    {6, 0x02, 52},
    {15, 0x02, 52},
    {30, 0x03, 52},
    {2, 0x02, 53},
    {6, 0x02, 53},
    {15, 0x02, 53},
    {30, 0x03, 53},
    {2, 0x02, 54},
    {6, 0x02, 54},
    {15, 0x02, 54},
    {30, 0x03, 54},
    {2, 0x02, 55},
    {6, 0x02, 55},
    {15, 0x02, 55},
    {30, 0x03, 55},
  },
  /* 18 */
  {
    {3, 0x02, 52},
    {4, 0x02, 52},
    {7, 0x02, 52},
    {10, 0x02, 52},
    {16, 0x02, 52},
    {23, 0x02, 52},
    {31, 0x02, 52},
    {44, 0x03, 52},
    {3, 0x02, 53},
    {4, 0x02, 53},
    {7, 0x02, 53},
    {10, 0x02, 53},
    {16, 0x02, 53},
    {23, 0x02, 53},
    {31, 0x02, 53},
    {44, 0x03, 53},
  },
  /* 19 */
  {
    {3, 0x02, 54},
    {4, 0x02, 54},
    {7, 0x02, 54},
    {10, 0x02, 54},
    {16, 0x02, 54},
    {23, 0x02, 54},
    {31, 0x02, 54},
    {44, 0x03, 54},
    {3, 0x02, 55},
    {4, 0x02, 55},
    {7, 0x02, 55},
    {10, 0x02, 55},
    {16, 0x02, 55},
    {23, 0x02, 55},
    {31, 0x02, 55},
    {44, 0x03, 55},
  },
  /* 20 */
  {
    {2, 0x02, 56},
    {6, 0x02, 56},
    {15, 0x02, 56},
    {30, 0x03, 56},
    {2, 0x02, 57},
    {6, 0x02, 57},
    {15, 0x02, 57},
    {30, 0x03, 57},
    {2, 0x02, 58},
    {6, 0x02, 58},
    {15, 0x02, 58},
    {30, 0x03, 58},
    {2, 0x02, 61},
    {6, 0x02, 61},
    {15, 0x02, 61},
    {30, 0x03, 61},
  },
  /* 21 */
  {
    {3, 0x02, 56},
    {4, 0x02, 56},
    {7, 0x02, 56},
    {10, 0x02, 56},
    {16, 0x02, 56},
    {23, 0x02, 56},
    {31, 0x02, 56},
    {44, 0x03, 56},
    {3, 0x02, 57},
    {4, 0x02, 57},
    {7, 0x02, 57},
    {10, 0x02, 57},
    {16, 0x02, 57},
    {23, 0x02, 57},
    {31, 0x02, 57},
    {44, 0x03, 57},
  },
  /* 22 */
  {
    {3, 0x02, 58},
    {4, 0x02, 58},
    {7, 0x02, 58},
    {10, 0x02, 58},
    {16, 0x02, 58},
    {23, 0x02, 58},
    {31, 0x02, 58},
    {44, 0x03, 58},
    {3, 0x02, 61},
    {4, 0x02, 61},
    {7, 0x02, 61},
    {10, 0x02, 61},
    {16, 0x02, 61},
    {23, 0x02, 61},
    {31, 0x02, 61},
    {44, 0x03, 61},
  },
  /* 23 */
  {
    {1, 0x02, 84},
    {14, 0x03, 84},
    {1, 0x02, 100},
    {14, 0x03, 100},
    {1, 0x02, 103},
    {14, 0x03, 103},
    {1, 0x02, 104},
    {14, 0x03, 104},
    {1, 0x02, 108},
    {14, 0x03, 108},
    {1, 0x02, 109},
    {14, 0x03, 109},
    {1, 0x02, 110},
    {14, 0x03, 110},
    {1, 0x02, 112},
    {14, 0x03, 112},
  },
  /* 24 */
  {
    {2, 0x02, 84},
    {6, 0x02, 84},
    {15, 0x02, 84},
    {30, 0x03, 84},
    {2, 0x02, 100},
    {6, 0x02, 100},
    {15, 0x02, 100},
    {30, 0x03, 100},
    {2, 0x02, 103},
    {6, 0x02, 103},
    {15, 0x02, 103},
    {30, 0x03, 103},
    {2, 0x02, 104},
    {6, 0x02, 104},
    {15, 0x02, 104},
    {30, 0x03, 104},
  },
  /* 25 */
  {
    {3, 0x02, 84},
    {4, 0x02, 84},
    {7, 0x02, 84},
    {10, 0x02, 84},
    {16, 0x02, 84},
    {23, 0x02, 84},
    {31, 0x02, 84},
    {44, 0x03, 84},
    {3, 0x02, 100},
    {4, 0x02, 100},
    {7, 0x02, 100},
    {10, 0x02, 100},
    {16, 0x02, 100},
    {23, 0x02, 100},
    {31, 0x02, 100},
    {44, 0x03, 100},
  },
  /* 26 */
  {
    {3, 0x02, 103},
    {4, 0x02, 103},
    {7, 0x02, 103},
    {10, 0x02, 103},
    {16, 0x02, 103},
    {23, 0x02, 103},
    {31, 0x02, 103},
    {44, 0x03, 103},
    {3, 0x02, 104},
    {4, 0x02, 104},
    {7, 0x02, 104},
    {10, 0x02, 104},
    {16, 0x02, 104},
    {23, 0x02, 104},
    {31, 0x02, 104},
    {44, 0x03, 104},
  },
  /* 27 */
  {
    {2, 0x02, 108},
    {6, 0x02, 108},
    {15, 0x02, 108},
    {30, 0x03, 108},
    {2, 0x02, 109},
    {6, 0x02, 109},
    {15, 0x02, 109},
    {30, 0x03, 109},
    {2, 0x02, 110},
    {6, 0x02, 110},
    {15, 0x02, 110},
    {30, 0x03, 110},
    {2, 0x02, 112},
    {6, 0x02, 112},
    {15, 0x02, 112},
    {30, 0x03, 112},
  },
  /* 28 */
  {
    {3, 0x02, 108},
    {4, 0x02, 108},
    {7, 0x02, 108},
    {10, 0x02, 108},
    {16, 0x02, 108},
    {23, 0x02, 108},
    {31, 0x02, 108},
    {44, 0x03, 108},
    {3, 0x02, 109},
    {4, 0x02, 109},
    {7, 0x02, 109},
    {10, 0x02, 109},
    {16, 0x02, 109},
    {23, 0x02, 109},
    {31, 0x02, 109},
    {44, 0x03, 109},
  },
  /* 29 */
  {
    {3, 0x02, 110},
    {4, 0x02, 110},
    {7, 0x02, 110},
    {10, 0x02, 110},
    {16, 0x02, 110},
    {23, 0x02, 110},
    {31, 0x02, 110},
    {44, 0x03, 110},
    {3, 0x02, 112},
    {4, 0x02, 112},
    {7, 0x02, 112},
    {10, 0x02, 112},
    {16, 0x02, 112},
    {23, 0x02, 112},
    {31, 0x02, 112},
    {44, 0x03, 112},
  },
  /* 30 */
  {
    {0, 0x03, 114},
    {0, 0x03, 115},
    {35, 0x00, 0},
    {36, 0x00, 0},
    {39, 0x00, 0},
    {40, 0x00, 0},
    {42, 0x00, 0},
    {43, 0x00, 0},
    {47, 0x00, 0},
    {48, 0x00, 0},
    {50, 0x00, 0},
    {51, 0x00, 0},
    {56, 0x00, 0},
    {59, 0x00, 0},
    {63, 0x00, 0},
    {70, 0x01, 0},
  },
  /* 31 */
  {
    {1, 0x02, 114},
    {14, 0x03, 114},
    {1, 0x02, 115},
    {14, 0x03, 115},
    {0, 0x03, 38},
    {0, 0x03, 44},
    {0, 0x03, 45},
    {0, 0x03, 65},
    {0, 0x03, 68},
    {0, 0x03, 70},
    {0, 0x03, 71},
    {0, 0x03, 77},
    {0, 0x03, 78},
    {0, 0x03, 83},
    {0, 0x03, 95},
    {0, 0x03, 98},
  },
  /* 32 */
  {
    {2, 0x02, 114},
    {6, 0x02, 114},
    {15, 0x02, 114},
    {30, 0x03, 114},
    {2, 0x02, 115},
    {6, 0x02, 115},
    {15, 0x02, 115},
    {30, 0x03, 115},
    {1, 0x02, 38},
    {14, 0x03, 38},
    {1, 0x02, 44},
    {14, 0x03, 44},
    {1, 0x02, 45},
    {14, 0x03, 45},
    {1, 0x02, 65},
    {14, 0x03, 65},
  },
  /* 33 */
  {
    {3, 0x02, 114},
    {4, 0x02, 114},
    {7, 0x02, 114},
    {10, 0x02, 114},
    {16, 0x02, 114},
    {23, 0x02, 114},
    {31, 0x02, 114},
    {44, 0x03, 114},
    {3, 0x02, 115},
    {4, 0x02, 115},
    {7, 0x02, 115},
    {10, 0x02, 115},
    {16, 0x02, 115},
    {23, 0x02, 115},
    {31, 0x02, 115},
    {44, 0x03, 115},
  },
  /* 34 */
  {
    {2, 0x02, 38},
    {6, 0x02, 38},
    {15, 0x02, 38},
    {30, 0x03, 38},
    {2, 0x02, 44},
    {6, 0x02, 44},
    {15, 0x02, 44},
    {30, 0x03, 44},
    {2, 0x02, 45},
    {6, 0x02, 45},
    {15, 0x02, 45},
    {30, 0x03, 45},
    {2, 0x02, 65},
    {6, 0x02, 65},
    {15, 0x02, 65},
    {30, 0x03, 65},
  },
  /* 35 */
  {
    {3, 0x02, 38},
    {4, 0x02, 38},
    {7, 0x02, 38},
    {10, 0x02, 38},
    {16, 0x02, 38},
    {23, 0x02, 38},
    {31, 0x02, 38},
    {44, 0x03, 38},
    {3, 0x02, 44},
    {4, 0x02, 44},
    {7, 0x02, 44},
    {10, 0x02, 44},
    {16, 0x02, 44},
    {23, 0x02, 44},
    {31, 0x02, 44},
    {44, 0x03, 44},
  },
  /* 36 */
  {
    {3, 0x02, 45},
    {4, 0x02, 45},
    {7, 0x02, 45},
    {10, 0x02, 45},
    {16, 0x02, 45},
    {23, 0x02, 45},
    {31, 0x02, 45},
    {44, 0x03, 45},
    {3, 0x02, 65},
    {4, 0x02, 65},
    {7, 0x02, 65},
    {10, 0x02, 65},
    {16, 0x02, 65},
    {23, 0x02, 65},
    {31, 0x02, 65},
    {44, 0x03, 65},
  },
  /* 37 */
  {
    {1, 0x02, 68},
    {14, 0x03, 68},
    {1, 0x02, 70},
    {14, 0x03, 70},
    {1, 0x02, 71},
    {14, 0x03, 71},
    {1, 0x02, 77},
    {14, 0x03, 77},
    {1, 0x02, 78},
    {14, 0x03, 78},
    {1, 0x02, 83},
    {14, 0x03, 83},
    {1, 0x02, 95},
    {14, 0x03, 95},
    {1, 0x02, 98},
    {14, 0x03, 98},
  },
  /* 38 */
  {
    {2, 0x02, 68},
    {6, 0x02, 68},
    {15, 0x02, 68},
    {30, 0x03, 68},
    {2, 0x02, 70},
    {6, 0x02, 70},
    {15, 0x02, 70},
    {30, 0x03, 70},
    {2, 0x02, 71},
    {6, 0x02, 71},
    {15, 0x02, 71},
    {30, 0x03, 71},
    {2, 0x02, 77},
    {6, 0x02, 77},
    {15, 0x02, 77},
    {30, 0x03, 77},
  },
  /* 39 */
  {
    {3, 0x02, 68},
    {4, 0x02, 68},
    {7, 0x02, 68},
    {10, 0x02, 68},
    {16, 0x02, 68},
    {23, 0x02, 68},
    {31, 0x02, 68},
    {44, 0x03, 68},
    {3, 0x02, 70},
    {4, 0x02, 70},
    {7, 0x02, 70},
    {10, 0x02, 70},
    {16, 0x02, 70},
    {23, 0x02, 70},
    {31, 0x02, 70},
    {44, 0x03, 70},
  },
  /* 40 */
  {
    {3, 0x02, 71},
    {4, 0x02, 71},
    {7, 0x02, 71},
    {10, 0x02, 71},
    {16, 0x02, 71},
    {23, 0x02, 71},
    {31, 0x02, 71},
    {44, 0x03, 71},
    {3, 0x02, 77},
    {4, 0x02, 77},
    {7, 0x02, 77},
    {10, 0x02, 77},
    {16, 0x02, 77},
    {23, 0x02, 77},
    {31, 0x02, 77},
    {44, 0x03, 77},
  },
  /* 41 */
  {
    {2, 0x02, 78},
    {6, 0x02, 78},
    {15, 0x02, 78},
    {30, 0x03, 78},
    {2, 0x02, 83},
    {6, 0x02, 83},
    {15, 0x02, 83},
    {30, 0x03, 83},
    {2, 0x02, 95},
    {6, 0x02, 95},
    {15, 0x02, 95},
    {30, 0x03, 95},
    {2, 0x02, 98},
    {6, 0x02, 98},
    {15, 0x02, 98},
    {30, 0x03, 98},
  },
  /* 42 */
  {
    {3, 0x02, 78},
    {4, 0x02, 78},
    {7, 0x02, 78},
    {10, 0x02, 78},
    {16, 0x02, 78},
    {23, 0x02, 78},
    {31, 0x02, 78},
    {44, 0x03, 78},
    {3, 0x02, 83},
    {4, 0x02, 83},
    {7, 0x02, 83},
    {10, 0x02, 83},
    {16, 0x02, 83},
    {23, 0x02, 83},
    {31, 0x02, 83},
    {44, 0x03, 83},
  },
  /* 43 */
  {
    {3, 0x02, 95},
    {4, 0x02, 95},
    {7, 0x02, 95},
    {10, 0x02, 95},
    {16, 0x02, 95},
    {23, 0x02, 95},
    {31, 0x02, 95},
    {44, 0x03, 95},
    {3, 0x02, 98},
    {4, 0x02, 98},
    {7, 0x02, 98},
    {10, 0x02, 98},
    {16, 0x02, 98},
    {23, 0x02, 98},
    {31, 0x02, 98},
    {44, 0x03, 98},
  },
  /* 44 */
  {
    {0, 0x03, 102},
    {0, 0x03, 117},
    {0, 0x03, 118},
    {0, 0x03, 119},
    {0, 0x03, 120},
    {0, 0x03, 121},
    {52, 0x00, 0},
    {53, 0x00, 0},
    {57, 0x00, 0},
    {58, 0x00, 0},
    {60, 0x00, 0},
    {61, 0x00, 0},
    {64, 0x00, 0},
    {67, 0x00, 0},
    {71, 0x00, 0},
    {74, 0x01, 0},
  },
  /* 45 */
  {
    {1, 0x02, 102},
    {14, 0x03, 102},
    {1, 0x02, 117},
    {14, 0x03, 117},
    {1, 0x02, 118},
    {14, 0x03, 118},
    {1, 0x02, 119},
    {14, 0x03, 119},
    {1, 0x02, 120},
    {14, 0x03, 120},
    {1, 0x02, 121},
    {14, 0x03, 121},
    {0, 0x03, 59},
    {0, 0x03, 66},
    {0, 0x03, 67},
    {0, 0x03, 69},
  },
  /* 46 */
  {
    {2, 0x02, 102},
    {6, 0x02, 102},
    {15, 0x02, 102},
    {30, 0x03, 102},
    {2, 0x02, 117},
    {6, 0x02, 117},
    {15, 0x02, 117},
    {30, 0x03, 117},
    {2, 0x02, 118},
    {6, 0x02, 118},
    {15, 0x02, 118},
    {30, 0x03, 118},
    {2, 0x02, 119},
    {6, 0x02, 119},
    {15, 0x02, 119},
    {30, 0x03, 119},
  },
  /* 47 */
  {
    {3, 0x02, 102},
    {4, 0x02, 102},
    {7, 0x02, 102},
    {10, 0x02, 102},
    {16, 0x02, 102},
    {23, 0x02, 102},
    {31, 0x02, 102},
    {44, 0x03, 102},
    {3, 0x02, 117},
    {4, 0x02, 117},
    {7, 0x02, 117},
    {10, 0x02, 117},
    {16, 0x02, 117},
    {23, 0x02, 117},
    {31, 0x02, 117},
    {44, 0x03, 117},
  },
  /* 48 */
  {
    {3, 0x02, 118},
    {4, 0x02, 118},
    {7, 0x02, 118},
    {10, 0x02, 118},
    {16, 0x02, 118},
    {23, 0x02, 118},
    {31, 0x02, 118},
    {44, 0x03, 118},
    {3, 0x02, 119},
    {4, 0x02, 119},
    {7, 0x02, 119},
    {10, 0x02, 119},
    {16, 0x02, 119},
    {23, 0x02, 119},
    {31, 0x02, 119},
    {44, 0x03, 119},
  },
  /* 49 */
  {
    {2, 0x02, 120},
    {6, 0x02, 120},
    {15, 0x02, 120},
    {30, 0x03, 120},
    {2, 0x02, 121},
    {6, 0x02, 121},
    {15, 0x02, 121},
    {30, 0x03, 121},
    {1, 0x02, 59},
    {14, 0x03, 59},
    {1, 0x02, 66},
    {14, 0x03, 66},
    {1, 0x02, 67},
    {14, 0x03, 67},
    {1, 0x02, 69},
    {14, 0x03, 69},
  },
  /* 50 */
  {
    {3, 0x02, 120},
    {4, 0x02, 120},
    {7, 0x02, 120},
    {10, 0x02, 120},
    {16, 0x02, 120},
    {23, 0x02, 120},
    {31, 0x02, 120},
    {44, 0x03, 120},
    {3, 0x02, 121},
    {4, 0x02, 121},
    {7, 0x02, 121},
    {10, 0x02, 121},
    {16, 0x02, 121},
    {23, 0x02, 121},
    {31, 0x02, 121},
    {44, 0x03, 121},
  },
  /* 51 */
  {
    {2, 0x02, 59},
    {6, 0x02, 59},
    {15, 0x02, 59},
    {30, 0x03, 59},
    {2, 0x02, 66},
    {6, 0x02, 66},
    {15, 0x02, 66},
    {30, 0x03, 66},
    {2, 0x02, 67},
    {6, 0x02, 67},
    {15, 0x02, 67},
    {30, 0x03, 67},
    {2, 0x02, 69},
    {6, 0x02, 69},
    {15, 0x02, 69},
    {30, 0x03, 69},
  },
  /* 52 */
  {
    {3, 0x02, 59},
    {4, 0x02, 59},
    {7, 0x02, 59},
    {10, 0x02, 59},
    {16, 0x02, 59},
    {23, 0x02, 59},
    {31, 0x02, 59},
    {44, 0x03, 59},
    {3, 0x02, 66},
    {4, 0x02, 66},
    {7, 0x02, 66},
    {10, 0x02, 66},
    {16, 0x02, 66},
    {23, 0x02, 66},
    {31, 0x02, 66},
    {44, 0x03, 66},
  },
  /* 53 */
  {
    {3, 0x02, 67},
    {4, 0x02, 67},
    {7, 0x02, 67},
    {10, 0x02, 67},
    {16, 0x02, 67},
    {23, 0x02, 67},
    {31, 0x02, 67},
    {44, 0x03, 67},
    {3, 0x02, 69},
    {4, 0x02, 69},
    {7, 0x02, 69},
    {10, 0x02, 69},
    {16, 0x02, 69},
    {23, 0x02, 69},
    {31, 0x02, 69},
    {44, 0x03, 69},
  },
  /* 54 */
  {
    {0, 0x03, 73},
    {0, 0x03, 79},
    {0, 0x03, 80},
    {0, 0x03, 85},
    {0, 0x03, 88},
    {0, 0x03, 106},
    {0, 0x03, 107},
    {0, 0x03, 122},
    {65, 0x00, 0},
    {66, 0x00, 0},
    {68, 0x00, 0},
    {69, 0x00, 0},
    {72, 0x00, 0},
    {73, 0x00, 0},
    {75, 0x00, 0},
    {77, 0x00, 0},
  },
  /* 55 */
  {
    {1, 0x02, 73},
    {14, 0x03, 73},
    {1, 0x02, 79},
    {14, 0x03, 79},
    {1, 0x02, 80},
    {14, 0x03, 80},
    {1, 0x02, 85},
    {14, 0x03, 85},
    {1, 0x02, 88},
    {14, 0x03, 88},
    {1, 0x02, 106},
    {14, 0x03, 106},
    {1, 0x02, 107},
    {14, 0x03, 107},
    {1, 0x02, 122},
    {14, 0x03, 122},
  },
  /* 56 */
  {
    {2, 0x02, 73},
    {6, 0x02, 73},
    {15, 0x02, 73},
    {30, 0x03, 73},
    {2, 0x02, 79},
    {6, 0x02, 79},
    {15, 0x02, 79},
    {30, 0x03, 79},
    {2, 0x02, 80},
    {6, 0x02, 80},
    {15, 0x02, 80},
    {30, 0x03, 80},
    {2, 0x02, 85},
    {6, 0x02, 85},
    {15, 0x02, 85},
    {30, 0x03, 85},
  },
  /* 57 */
  {
    {3, 0x02, 73},
    {4, 0x02, 73},
    {7, 0x02, 73},
    {10, 0x02, 73},
    {16, 0x02, 73},
    {23, 0x02, 73},
    {31, 0x02, 73},
    {44, 0x03, 73},
    {3, 0x02, 79},
    {4, 0x02, 79},
    {7, 0x02, 79},
    {10, 0x02, 79},
    {16, 0x02, 79},
    {23, 0x02, 79},
    {31, 0x02, 79},
    {44, 0x03, 79},
  },
  /* 58 */
  {
    {3, 0x02, 80},
    {4, 0x02, 80},
    {7, 0x02, 80},
    {10, 0x02, 80},
    {16, 0x02, 80},
    {23, 0x02, 80},
    {31, 0x02, 80},
    {44, 0x03, 80},
    {3, 0x02, 85},
    {4, 0x02, 85},
    {7, 0x02, 85},
    {10, 0x02, 85},
    {16, 0x02, 85},
    {23, 0x02, 85},
    {31, 0x02, 85},
    {44, 0x03, 85},
  },
  /* 59 */
  {
    {2, 0x02, 88},
    {6, 0x02, 88},
    {15, 0x02, 88},
    {30, 0x03, 88},
    {2, 0x02, 106},
    {6, 0x02, 106},
    {15, 0x02, 106},
    {30, 0x03, 106},
    {2, 0x02, 107},
    {6, 0x02, 107},
    {15, 0x02, 107},
    {30, 0x03, 107},
    {2, 0x02, 122},
    {6, 0x02, 122},
    {15, 0x02, 122},
    {30, 0x03, 122},
  },
  /* 60 */
  {
    {3, 0x02, 88},
    {4, 0x02, 88},
    {7, 0x02, 88},
    {10, 0x02, 88},
    {16, 0x02, 88},
    {23, 0x02, 88},
    {31, 0x02, 88},
    {44, 0x03, 88},
    {3, 0x02, 106},
    {4, 0x02, 106},
    {7, 0x02, 106},
    {10, 0x02, 106},
    {16, 0x02, 106},
    {23, 0x02, 106},
    {31, 0x02, 106},
    {44, 0x03, 106},
  },
  /* 61 */
  {
    {3, 0x02, 107},
    {4, 0x02, 107},
    {7, 0x02, 107},
    {10, 0x02, 107},
    {16, 0x02, 107},
    {23, 0x02, 107},
    {31, 0x02, 107},
    {44, 0x03, 107},
    {3, 0x02, 122},
    {4, 0x02, 122},
    {7, 0x02, 122},
    {10, 0x02, 122},
    {16, 0x02, 122},
    {23, 0x02, 122},
    {31, 0x02, 122},
    {44, 0x03, 122},
  },
  /* 62 */
  {
    {0, 0x03, 34},
    {0, 0x03, 41},
    {0, 0x03, 72},
    {0, 0x03, 74},
    {0, 0x03, 75},
    {0, 0x03, 76},
    {0, 0x03, 81},
    {0, 0x03, 82},
    {0, 0x03, 86},
    {0, 0x03, 87},
    {0, 0x03, 89},
    {0, 0x03, 90},
    {0, 0x03, 113},
    {76, 0x00, 0},
    {78, 0x00, 0},
    {79, 0x00, 0},
  },
  /* 63 */
  {
    {1, 0x02, 34},
    {14, 0x03, 34},
    {1, 0x02, 41},
    {14, 0x03, 41},
    {1, 0x02, 72},
    {14, 0x03, 72},
    {1, 0x02, 74},
    {14, 0x03, 74},
    {1, 0x02, 75},
    {14, 0x03, 75},
    {1, 0x02, 76},
    {14, 0x03, 76},
    {1, 0x02, 81},
    {14, 0x03, 81},
    {1, 0x02, 82},
    {14, 0x03, 82},
  },
  /* 64 */
  {
    {2, 0x02, 34},
    {6, 0x02, 34},
    {15, 0x02, 34},
    {30, 0x03, 34},
    {2, 0x02, 41},
    {6, 0x02, 41},
    {15, 0x02, 41},
    {30, 0x03, 41},
    {2, 0x02, 72},
    {6, 0x02, 72},
    {15, 0x02, 72},
    {30, 0x03, 72},
    {2, 0x02, 74},
    {6, 0x02, 74},
    {15, 0x02, 74},
    {30, 0x03, 74},
  },
  /* 65 */
  {
    {3, 0x02, 34},
    {4, 0x02, 34},
    {7, 0x02, 34},
    {10, 0x02, 34},
    {16, 0x02, 34},
    {23, 0x02, 34},
    {31, 0x02, 34},
    {44, 0x03, 34},
    {3, 0x02, 41},
    {4, 0x02, 41},
    {7, 0x02, 41},
    {10, 0x02, 41},
    {16, 0x02, 41},
    {23, 0x02, 41},
    {31, 0x02, 41},
    {44, 0x03, 41},
  },
  /* 66 */
  {
    {3, 0x02, 72},
    {4, 0x02, 72},
    {7, 0x02, 72},
    {10, 0x02, 72},
    {16, 0x02, 72},
    {23, 0x02, 72},
    {31, 0x02, 72},
    {44, 0x03, 72},
    {3, 0x02, 74},
    {4, 0x02, 74},
    {7, 0x02, 74},
    {10, 0x02, 74},
    {16, 0x02, 74},
    {23, 0x02, 74},
    {31, 0x02, 74},
    {44, 0x03, 74},
  },
  /* 67 */
  {
    {2, 0x02, 75},
    {6, 0x02, 75},
    {15, 0x02, 75},
    {30, 0x03, 75},
    {2, 0x02, 76},
    {6, 0x02, 76},
    {15, 0x02, 76},
    {30, 0x03, 76},
    {2, 0x02, 81},
    {6, 0x02, 81},
    {15, 0x02, 81},
    {30, 0x03, 81},
    {2, 0x02, 82},
    {6, 0x02, 82},
    {15, 0x02, 82},
    {30, 0x03, 82},
  },
  /* 68 */
  {
    {3, 0x02, 75},
    {4, 0x02, 75},
    {7, 0x02, 75},
    {10, 0x02, 75},
    {16, 0x02, 75},
    {23, 0x02, 75},
    {31, 0x02, 75},
    {44, 0x03, 75},
    {3, 0x02, 76},
    {4, 0x02, 76},
    {7, 0x02, 76},
    {10, 0x02, 76},
    {16, 0x02, 76},
    {23, 0x02, 76},
    {31, 0x02, 76},
    {44, 0x03, 76},
  },
  /* 69 */
  {
    {3, 0x02, 81},
    {4, 0x02, 81},
    {7, 0x02, 81},
    {10, 0x02, 81},
    {16, 0x02, 81},
    {23, 0x02, 81},
    {31, 0x02, 81},
    {44, 0x03, 81},
    {3, 0x02, 82},
    {4, 0x02, 82},
    {7, 0x02, 82},
    {10, 0x02, 82},
    {16, 0x02, 82},
    {23, 0x02, 82},
    {31, 0x02, 82},
    {44, 0x03, 82},
  },
  /* 70 */
  {
    {1, 0x02, 86},
    {14, 0x03, 86},
    {1, 0x02, 87},
    {14, 0x03, 87},
    {1, 0x02, 89},
    {14, 0x03, 89},
    {1, 0x02, 90},
    {14, 0x03, 90},
    {1, 0x02, 113},
    {14, 0x03, 113},
    {0, 0x03, 40},
    {0, 0x03, 42},
    {0, 0x03, 43},
    {0, 0x03, 63},
    {80, 0x00, 0},
    {81, 0x00, 0},
  },
  /* 71 */
  {
    {2, 0x02, 86},
    {6, 0x02, 86},
    {15, 0x02, 86},
    {30, 0x03, 86},
    {2, 0x02, 87},
    {6, 0x02, 87},
    {15, 0x02, 87},
    {30, 0x03, 87},
    {2, 0x02, 89},
    {6, 0x02, 89},
    {15, 0x02, 89},
    {30, 0x03, 89},
    {2, 0x02, 90},
    {6, 0x02, 90},
    {15, 0x02, 90},
    {30, 0x03, 90},
  },
  /* 72 */
  {
    {3, 0x02, 86},
    {4, 0x02, 86},
    {7, 0x02, 86},
    {10, 0x02, 86},
    {16, 0x02, 86},
    {23, 0x02, 86},
    {31, 0x02, 86},
    {44, 0x03, 86},
    {3, 0x02, 87},
    {4, 0x02, 87},
    {7, 0x02, 87},
    {10, 0x02, 87},
    {16, 0x02, 87},
    {23, 0x02, 87},
    {31, 0x02, 87},
    {44, 0x03, 87},
  },
  /* 73 */
  {
    {3, 0x02, 89},
    {4, 0x02, 89},
    {7, 0x02, 89},
    {10, 0x02, 89},
    {16, 0x02, 89},
    {23, 0x02, 89},
    {31, 0x02, 89},
    {44, 0x03, 89},
    {3, 0x02, 90},
    {4, 0x02, 90},
    {7, 0x02, 90},
    {10, 0x02, 90},
    {16, 0x02, 90},
    {23, 0x02, 90},
    {31, 0x02, 90},
    {44, 0x03, 90},
  },
  /* 74 */
  {
    {2, 0x02, 113},
    {6, 0x02, 113},
    {15, 0x02, 113},
    {30, 0x03, 113},
    {1, 0x02, 40},
    {14, 0x03, 40},
    {1, 0x02, 42},
    {14, 0x03, 42},
    {1, 0x02, 43},
    {14, 0x03, 43},
    {1, 0x02, 63},
    {14, 0x03, 63},
    {0, 0x03, 91},
    {0, 0x03, 93},
    {82, 0x00, 0},
    {83, 0x00, 0},
  },
  /* 75 */
  {
    {3, 0x02, 113},
    {4, 0x02, 113},
    {7, 0x02, 113},
    {10, 0x02, 113},
    {16, 0x02, 113},
    {23, 0x02, 113},
    {31, 0x02, 113},
    {44, 0x03, 113},
    {2, 0x02, 40},
    {6, 0x02, 40},
    {15, 0x02, 40},
    {30, 0x03, 40},
    {2, 0x02, 42},
    {6, 0x02, 42},
    {15, 0x02, 42},
    {30, 0x03, 42},
  },
  /* 76 */
  {
    {3, 0x02, 40},
    {4, 0x02, 40},
    {7, 0x02, 40},
    {10, 0x02, 40},
    {16, 0x02, 40},
    {23, 0x02, 40},
    {31, 0x02, 40},
    {44, 0x03, 40},
    {3, 0x02, 42},
    {4, 0x02, 42},
    {7, 0x02, 42},
    {10, 0x02, 42},
    {16, 0x02, 42},
    {23, 0x02, 42},
    {31, 0x02, 42},
    {44, 0x03, 42},
  },
  /* 77 */
  {
    {2, 0x02, 43},
    {6, 0x02, 43},
    {15, 0x02, 43},
    {30, 0x03, 43},
    {2, 0x02, 63},
    {6, 0x02, 63},
    {15, 0x02, 63},
    {30, 0x03, 63},
    {1, 0x02, 91},
    {14, 0x03, 91},
    {1, 0x02, 93},
    {14, 0x03, 93},
    {0, 0x03, 124},
    {0, 0x03, 126},
    {84, 0x00, 0},
    {85, 0x00, 0},
  },
  /* 78 */
  {
    {3, 0x02, 43},
    {4, 0x02, 43},
    {7, 0x02, 43},
    {10, 0x02, 43},
    {16, 0x02, 43},
    {23, 0x02, 43},
    {31, 0x02, 43},
    {44, 0x03, 43},
    {3, 0x02, 63},
    {4, 0x02, 63},
    {7, 0x02, 63},
    {10, 0x02, 63},
    {16, 0x02, 63},
    {23, 0x02, 63},
    {31, 0x02, 63},
    {44, 0x03, 63},
  },
  /* 79 */
  {
    {2, 0x02, 91},
    {6, 0x02, 91},
    {15, 0x02, 91},
    {30, 0x03, 91},
    {2, 0x02, 93},
    {6, 0x02, 93},
    {15, 0x02, 93},
    {30, 0x03, 93},
    {1, 0x02, 124},
    {14, 0x03, 124},
    {1, 0x02, 126},
    {14, 0x03, 126},
    {0, 0x03, 33},
    {0, 0x03, 39},
    {86, 0x00, 0},
    {87, 0x00, 0},
  },
  /* 80 */
  {
    {3, 0x02, 91},
    {4, 0x02, 91},
    {7, 0x02, 91},
    {10, 0x02, 91},
    {16, 0x02, 91},
    {23, 0x02, 91},
    {31, 0x02, 91},
    {44, 0x03, 91},
    {3, 0x02, 93},
    {4, 0x02, 93},
    {7, 0x02, 93},
    {10, 0x02, 93},
    {16, 0x02, 93},
    {23, 0x02, 93},
    {31, 0x02, 93},
    {44, 0x03, 93},
  },
  /* 81 */
  {
    {2, 0x02, 124},
    {6, 0x02, 124},
    {15, 0x02, 124},
    {30, 0x03, 124},
    {2, 0x02, 126},
    {6, 0x02, 126},
    {15, 0x02, 126},
    {30, 0x03, 126},
    {1, 0x02, 33},
    {14, 0x03, 33},
    {1, 0x02, 39},
    {14, 0x03, 39},
    {0, 0x03, 35},
    {0, 0x03, 94},
    {88, 0x00, 0},
    {89, 0x00, 0},
  },
  /* 82 */
  {
    {3, 0x02, 124},
    {4, 0x02, 124},
    {7, 0x02, 124},
    {10, 0x02, 124},
    {16, 0x02, 124},
    {23, 0x02, 124},
    {31, 0x02, 124},
    {44, 0x03, 124},
    {3, 0x02, 126},
    {4, 0x02, 126},
    {7, 0x02, 126},
    {10, 0x02, 126},
    {16, 0x02, 126},
    {23, 0x02, 126},
    {31, 0x02, 126},
    {44, 0x03, 126},
  },
  /* 83 */
  {
    {2, 0x02, 33},
    {6, 0x02, 33},
    {15, 0x02, 33},
    {30, 0x03, 33},
    {2, 0x02, 39},
    {6, 0x02, 39},
    {15, 0x02, 39},
    {30, 0x03, 39},
    {1, 0x02, 35},
    {14, 0x03, 35},
    {1, 0x02, 94},
    {14, 0x03, 94},
    {0, 0x03, 36},
    {0, 0x03, 62},
    {0, 0x03, 64},
    {90, 0x00, 0},
  },
  /* 84 */
  {
    {3, 0x02, 33},
    {4, 0x02, 33},
    {7, 0x02, 33},
    {10, 0x02, 33},
    {16, 0x02, 33},
    {23, 0x02, 33},
    {31, 0x02, 33},
    {44, 0x03, 33},
    {3, 0x02, 39},
    {4, 0x02, 39},
    {7, 0x02, 39},
    {10, 0x02, 39},
    {16, 0x02, 39},
    {23, 0x02, 39},
    {31, 0x02, 39},
    {44, 0x03, 39},
  },
  /* 85 */
  {
    {2, 0x02, 35},
    {6, 0x02, 35},
    {15, 0x02, 35},
    {30, 0x03, 35},
    {2, 0x02, 94},
    {6, 0x02, 94},
    {15, 0x02, 94},
    {30, 0x03, 94},
    {1, 0x02, 36},
    {14, 0x03, 36},
    {1, 0x02, 62},
    {14, 0x03, 62},
    {1, 0x02, 64},
    {14, 0x03, 64},
    {91, 0x00, 0},
    {92, 0x00, 0},
  },
  /* 86 */
  {
    {3, 0x02, 35},
    {4, 0x02, 35},
    {7, 0x02, 35},
    {10, 0x02, 35},
    {16, 0x02, 35},
    {23, 0x02, 35},
    {31, 0x02, 35},
    {44, 0x03, 35},
    {3, 0x02, 94},
    {4, 0x02, 94},
    {7, 0x02, 94},
    {10, 0x02, 94},
    {16, 0x02, 94},
    {23, 0x02, 94},
    {31, 0x02, 94},
    {44, 0x03, 94},
  },
  /* 87 */
  {
    {2, 0x02, 36},
    {6, 0x02, 36},
    {15, 0x02, 36},
    {30, 0x03, 36},
    {2, 0x02, 62},
    {6, 0x02, 62},
    {15, 0x02, 62},
    {30, 0x03, 62},
    {2, 0x02, 64},
    {6, 0x02, 64},
    {15, 0x02, 64},
    {30, 0x03, 64},
    {0, 0x03, 60},
    {0, 0x03, 123},
    {0, 0x03, 125},
    {93, 0x00, 0},
  },
  /* 88 */
  {
    {3, 0x02, 36},
    {4, 0x02, 36},
    {7, 0x02, 36},
    {10, 0x02, 36},
    {16, 0x02, 36},
    {23, 0x02, 36},
    {31, 0x02, 36},
    {44, 0x03, 36},
    {3, 0x02, 62},
    {4, 0x02, 62},
    {7, 0x02, 62},
    {10, 0x02, 62},
    {16, 0x02, 62},
    {23, 0x02, 62},
    {31, 0x02, 62},
    {44, 0x03, 62},
  },
  /* 89 */
  {
    {3, 0x02, 64},
    {4, 0x02, 64},
    {7, 0x02, 64},
    {10, 0x02, 64},
    {16, 0x02, 64},
    {23, 0x02, 64},
    {31, 0x02, 64},
    {44, 0x03, 64},
    {1, 0x02, 60},
    {14, 0x03, 60},
    {1, 0x02, 123},
    {14, 0x03, 123},
    {1, 0x02, 125},
    {14, 0x03, 125},
    {0, 0x03, 96},
    {94, 0x00, 0},
  },
  /* 90 */
  {
    {2, 0x02, 60},
    {6, 0x02, 60},
    {15, 0x02, 60},
    {30, 0x03, 60},
    {2, 0x02, 123},
    {6, 0x02, 123},
    {15, 0x02, 123},
    {30, 0x03, 123},
    {2, 0x02, 125},
    {6, 0x02, 125},
    {15, 0x02, 125},
    {30, 0x03, 125},
    {1, 0x02, 96},
    {14, 0x03, 96},
    {95, 0x00, 0},
    {158, 0x00, 0},
  },
  /* 91 */
  {
    {3, 0x02, 60},
    {4, 0x02, 60},
    {7, 0x02, 60},
    {10, 0x02, 60},
    {16, 0x02, 60},
    {23, 0x02, 60},
    {31, 0x02, 60},
    {44, 0x03, 60},
    {3, 0x02, 123},
    {4, 0x02, 123},
    {7, 0x02, 123},
    {10, 0x02, 123},
    {16, 0x02, 123},
    {23, 0x02, 123},
    {31, 0x02, 123},
    {44, 0x03, 123},
  },
  /* 92 */
  {
    {3, 0x02, 125},
    {4, 0x02, 125},
    {7, 0x02, 125},
    {10, 0x02, 125},
    {16, 0x02, 125},
    {23, 0x02, 125},
    {31, 0x02, 125},
    {44, 0x03, 125},
    {2, 0x02, 96},
    {6, 0x02, 96},
    {15, 0x02, 96},
    {30, 0x03, 96},
    {96, 0x00, 0},
    {127, 0x00, 0},
    {159, 0x00, 0},
    {193, 0x00, 0},
  },
  /* 93 */
  {
    {3, 0x02, 96},
    {4, 0x02, 96},
    {7, 0x02, 96},
    {10, 0x02, 96},
    {16, 0x02, 96},
    {23, 0x02, 96},
    {31, 0x02, 96},
    {44, 0x03, 96},
    {97, 0x00, 0},
    {112, 0x00, 0},
    {128, 0x00, 0},
    {143, 0x00, 0},
    {160, 0x00, 0},
    {175, 0x00, 0},
    {194, 0x00, 0},
    {225, 0x00, 0},
  },
  /* 94 */
  {
    {98, 0x00, 0},
    {105, 0x00, 0},
    {113, 0x00, 0},
    {120, 0x00, 0},
    {129, 0x00, 0},
    {136, 0x00, 0},
    {144, 0x00, 0},
    {151, 0x00, 0},
    {161, 0x00, 0},
    {168, 0x00, 0},
    {176, 0x00, 0},
    {183, 0x00, 0},
    {195, 0x00, 0},
    {210, 0x00, 0},
    {226, 0x00, 0},
    {241, 0x00, 0},
  },
  /* 95 */
  {
    {99, 0x00, 0},
    {102, 0x00, 0},
    {106, 0x00, 0},
    {109, 0x00, 0},
    {114, 0x00, 0},
    {117, 0x00, 0},
    {121, 0x00, 0},
    {124, 0x00, 0},
    {130, 0x00, 0},
    {133, 0x00, 0},
    {137, 0x00, 0},
    {140, 0x00, 0},
    {145, 0x00, 0},
    {148, 0x00, 0},
    {152, 0x00, 0},
    {155, 0x00, 0},
  },
  /* 96 */
  {
    {100, 0x00, 0},
    {101, 0x00, 0},
    {103, 0x00, 0},
    {104, 0x00, 0},
    {107, 0x00, 0},
    {108, 0x00, 0},
    {110, 0x00, 0},
    {111, 0x00, 0},
    {115, 0x00, 0},
    {116, 0x00, 0},
    {118, 0x00, 0},
    {119, 0x00, 0},
    {122, 0x00, 0},
    {123, 0x00, 0},
    {125, 0x00, 0},
    {126, 0x00, 0},
  },
  /* 97 */
  {
    {0, 0x03, 164},
    {0, 0x03, 165},
    {0, 0x03, 166},
    {0, 0x03, 167},
    {0, 0x03, 168},
    {0, 0x03, 169},
    {0, 0x03, 170},
    {0, 0x03, 171},
    {0, 0x03, 172},
    {0, 0x03, 173},
    {0, 0x03, 174},
    {0, 0x03, 175},
    {0, 0x03, 176},
    {0, 0x03, 177},
    {0, 0x03, 178},
    {0, 0x03, 179},
  },
  /* 98 */
  {
    {1, 0x02, 164},
    {14, 0x03, 164},
    {1, 0x02, 165},
    {14, 0x03, 165},
    {1, 0x02, 166},
    {14, 0x03, 166},
    {1, 0x02, 167},
    {14, 0x03, 167},
    {1, 0x02, 168},
    {14, 0x03, 168},
    {1, 0x02, 169},
    {14, 0x03, 169},
    {1, 0x02, 170},
    {14, 0x03, 170},
    {1, 0x02, 171},
    {14, 0x03, 171},
  },
  /* 99 */
  {
    {2, 0x02, 164},
    {6, 0x02, 164},
    {15, 0x02, 164},
    {30, 0x03, 164},
    {2, 0x02, 165},
    {6, 0x02, 165},
    {15, 0x02, 165},
    {30, 0x03, 165},
    {2, 0x02, 166},
    {6, 0x02, 166},
    {15, 0x02, 166},
    {30, 0x03, 166},
    {2, 0x02, 167},
    {6, 0x02, 167},
    {15, 0x02, 167},
    {30, 0x03, 167},
  },
  /* 100 */
  {
    {3, 0x02, 164},
    {4, 0x02, 164},
    {7, 0x02, 164},
    {10, 0x02, 164},
    {16, 0x02, 164},
    {23, 0x02, 164},
    {31, 0x02, 164},
    {44, 0x03, 164},
    {3, 0x02, 165},
    {4, 0x02, 165},
    {7, 0x02, 165},
    {10, 0x02, 165},
    {16, 0x02, 165},
    {23, 0x02, 165},
    {31, 0x02, 165},
    {44, 0x03, 165},
  },
  /* 101 */
  {
    {3, 0x02, 166},
    {4, 0x02, 166},
    {7, 0x02, 166},
    {10, 0x02, 166},
    {16, 0x02, 166},
    {23, 0x02, 166},
    {31, 0x02, 166},
    {44, 0x03, 166},
    {3, 0x02, 167},
    {4, 0x02, 167},
    {7, 0x02, 167},
    {10, 0x02, 167},
    {16, 0x02, 167},
    {23, 0x02, 167},
    {31, 0x02, 167},
    {44, 0x03, 167},
  },
  /* 102 */
  {
    {2, 0x02, 168},
    {6, 0x02, 168},
    {15, 0x02, 168},
    {30, 0x03, 168},
    {2, 0x02, 169},
    {6, 0x02, 169},
    {15, 0x02, 169},
    {30, 0x03, 169},
    {2, 0x02, 170},
    {6, 0x02, 170},
    {15, 0x02, 170},
    {30, 0x03, 170},
    {2, 0x02, 171},
    {6, 0x02, 171},
    {15, 0x02, 171},
    {30, 0x03, 171},
  },
  /* 103 */
  {
    {3, 0x02, 168},
    {4, 0x02, 168},
    {7, 0x02, 168},
    {10, 0x02, 168},
    {16, 0x02, 168},
    {23, 0x02, 168},
    {31, 0x02, 168},
    {44, 0x03, 168},
    {3, 0x02, 169},
    {4, 0x02, 169},
    {7, 0x02, 169},
    {10, 0x02, 169},
    {16, 0x02, 169},
    {23, 0x02, 169},
    {31, 0x02, 169},
    {44, 0x03, 169},
  },
  /* 104 */
  {
    {3, 0x02, 170},
    {4, 0x02, 170},
    {7, 0x02, 170},
    {10, 0x02, 170},
    {16, 0x02, 170},
    {23, 0x02, 170},
    {31, 0x02, 170},
    {44, 0x03, 170},
    {3, 0x02, 171},
    {4, 0x02, 171},
    {7, 0x02, 171},
    {10, 0x02, 171},
    {16, 0x02, 171},
    {23, 0x02, 171},
    {31, 0x02, 171},
    {44, 0x03, 171},
  },
  /* 105 */
  {
    {1, 0x02, 172},
    {14, 0x03, 172},
    {1, 0x02, 173},
    {14, 0x03, 173},
    {1, 0x02, 174},
    {14, 0x03, 174},
    {1, 0x02, 175},
    {14, 0x03, 175},
    {1, 0x02, 176},
    {14, 0x03, 176},
    {1, 0x02, 177},
    {14, 0x03, 177},
    {1, 0x02, 178},
    {14, 0x03, 178},
    {1, 0x02, 179},
    {14, 0x03, 179},
  },
  /* 106 */
  {
    {2, 0x02, 172},
    {6, 0x02, 172},
    {15, 0x02, 172},
    {30, 0x03, 172},
    {2, 0x02, 173},
    {6, 0x02, 173},
    {15, 0x02, 173},
    {30, 0x03, 173},
    {2, 0x02, 174},
    {6, 0x02, 174},
    {15, 0x02, 174},
    {30, 0x03, 174},
    {2, 0x02, 175},
    {6, 0x02, 175},
    {15, 0x02, 175},
    {30, 0x03, 175},
  },
  /* 107 */
  {
    {3, 0x02, 172},
    {4, 0x02, 172},
    {7, 0x02, 172},
    {10, 0x02, 172},
    {16, 0x02, 172},
    {23, 0x02, 172},
    {31, 0x02, 172},
    {44, 0x03, 172},
    {3, 0x02, 173},
    {4, 0x02, 173},
    {7, 0x02, 173},
    {10, 0x02, 173},
    {16, 0x02, 173},
    {23, 0x02, 173},
    {31, 0x02, 173},
    {44, 0x03, 173},
  },
  /* 108 */
  {
    {3, 0x02, 174},
    {4, 0x02, 174},
    {7, 0x02, 174},
    {10, 0x02, 174},
    {16, 0x02, 174},
    {23, 0x02, 174},
    {31, 0x02, 174},
    {44, 0x03, 174},
    {3, 0x02, 175},
    {4, 0x02, 175},
    {7, 0x02, 175},
    {10, 0x02, 175},
    {16, 0x02, 175},
    {23, 0x02, 175},
    {31, 0x02, 175},
    {44, 0x03, 175},
  },
  /* 109 */
  {
    {2, 0x02, 176},
    {6, 0x02, 176},
    {15, 0x02, 176},
    {30, 0x03, 176},
    {2, 0x02, 177},
    {6, 0x02, 177},
    {15, 0x02, 177},
    {30, 0x03, 177},
    {2, 0x02, 178},
    {6, 0x02, 178},
    {15, 0x02, 178},
    {30, 0x03, 178},
    {2, 0x02, 179},
    {6, 0x02, 179},
    {15, 0x02, 179},
    {30, 0x03, 179},
  },
  /* 110 */
  {
    {3, 0x02, 176},
    {4, 0x02, 176},
    {7, 0x02, 176},
    {10, 0x02, 176},
    {16, 0x02, 176},
    {23, 0x02, 176},
    {31, 0x02, 176},
    {44, 0x03, 176},
    {3, 0x02, 177},
    {4, 0x02, 177},
    {7, 0x02, 177},
    {10, 0x02, 177},
    {16, 0x02, 177},
    {23, 0x02, 177},
    {31, 0x02, 177},
    {44, 0x03, 177},
  },
  /* 111 */
  {
    {3, 0x02, 178},
    {4, 0x02, 178},
    {7, 0x02, 178},
    {10, 0x02, 178},
    {16, 0x02, 178},
    {23, 0x02, 178},
    {31, 0x02, 178},
    {44, 0x03, 178},
    {3, 0x02, 179},
    {4, 0x02, 179},
    {7, 0x02, 179},
    {10, 0x02, 179},
    {16, 0x02, 179},
    {23, 0x02, 179},
    {31, 0x02, 179},
    {44, 0x03, 179},
  },
  /* 112 */
  {
    {0, 0x03, 180},
    {0, 0x03, 181},
    {0, 0x03, 182},
    {0, 0x03, 183},
    {0, 0x03, 184},
    {0, 0x03, 185},
    {0, 0x03, 186},
    {0, 0x03, 187},
    {0, 0x03, 188},
    {0, 0x03, 189},
    {0, 0x03, 190},
    {0, 0x03, 191},
    {0, 0x03, 192},
    {0, 0x03, 193},
    {0, 0x03, 194},
    {0, 0x03, 195},
  },
  /* 113 */
  {
    {1, 0x02, 180},
    {14, 0x03, 180},
    {1, 0x02, 181},
    {14, 0x03, 181},
    {1, 0x02, 182},
    {14, 0x03, 182},
    {1, 0x02, 183},
    {14, 0x03, 183},
    {1, 0x02, 184},
    {14, 0x03, 184},
    {1, 0x02, 185},
    {14, 0x03, 185},
    {1, 0x02, 186},
    {14, 0x03, 186},
    {1, 0x02, 187},
    {14, 0x03, 187},
  },
  /* 114 */
  {
    {2, 0x02, 180},
    {6, 0x02, 180},
    {15, 0x02, 180},
    {30, 0x03, 180},
    {2, 0x02, 181},
    {6, 0x02, 181},
    {15, 0x02, 181},
    {30, 0x03, 181},
    {2, 0x02, 182},
    {6, 0x02, 182},
    {15, 0x02, 182},
    {30, 0x03, 182},
    {2, 0x02, 183},
    {6, 0x02, 183},
    {15, 0x02, 183},
    {30, 0x03, 183},
  },
  /* 115 */
  {
    {3, 0x02, 180},
    {4, 0x02, 180},
    {7, 0x02, 180},
    {10, 0x02, 180},
    {16, 0x02, 180},
    {23, 0x02, 180},
    {31, 0x02, 180},
    {44, 0x03, 180},
    {3, 0x02, 181},
    {4, 0x02, 181},
    {7, 0x02, 181},
    {10, 0x02, 181},
    {16, 0x02, 181},
    {23, 0x02, 181},
    {31, 0x02, 181},
    {44, 0x03, 181},
  },
  /* 116 */
  {
    {3, 0x02, 182},
    {4, 0x02, 182},
    {7, 0x02, 182},
    {10, 0x02, 182},
    {16, 0x02, 182},
    {23, 0x02, 182},
    {31, 0x02, 182},
    {44, 0x03, 182},
    {3, 0x02, 183},
    {4, 0x02, 183},
    {7, 0x02, 183},
    {10, 0x02, 183},
    {16, 0x02, 183},
    {23, 0x02, 183},
    {31, 0x02, 183},
    {44, 0x03, 183},
  },
  /* 117 */
  {
    {2, 0x02, 184},
    {6, 0x02, 184},
    {15, 0x02, 184},
    {30, 0x03, 184},
    {2, 0x02, 185},
    {6, 0x02, 185},
    {15, 0x02, 185},
    {30, 0x03, 185},
    {2, 0x02, 186},
    {6, 0x02, 186},
    {15, 0x02, 186},
    {30, 0x03, 186},
    {2, 0x02, 187},
    {6, 0x02, 187},
    {15, 0x02, 187},
    {30, 0x03, 187},
  },
  /* 118 */
  {
    {3, 0x02, 184},
    {4, 0x02, 184},
    {7, 0x02, 184},
    {10, 0x02, 184},
    {16, 0x02, 184},
    {23, 0x02, 184},
    {31, 0x02, 184},
    {44, 0x03, 184},
    {3, 0x02, 185},
    {4, 0x02, 185},
    {7, 0x02, 185},
    {10, 0x02, 185},
    {16, 0x02, 185},
    {23, 0x02, 185},
    {31, 0x02, 185},
    {44, 0x03, 185},
  },
  /* 119 */
  {
    {3, 0x02, 186},
    {4, 0x02, 186},
    {7, 0x02, 186},
    {10, 0x02, 186},
    {16, 0x02, 186},
    {23, 0x02, 186},
    {31, 0x02, 186},
    {44, 0x03, 186},
    {3, 0x02, 187},
    {4, 0x02, 187},
    {7, 0x02, 187},
    {10, 0x02, 187},
    {16, 0x02, 187},
    {23, 0x02, 187},
    {31, 0x02, 187},
    {44, 0x03, 187},
  },
  /* 120 */
  {
    {1, 0x02, 188},
    {14, 0x03, 188},
    {1, 0x02, 189},
    {14, 0x03, 189},
    {1, 0x02, 190},
    {14, 0x03, 190},
    {1, 0x02, 191},
    {14, 0x03, 191},
    {1, 0x02, 192},
    {14, 0x03, 192},
    {1, 0x02, 193},
    {14, 0x03, 193},
    {1, 0x02, 194},
    {14, 0x03, 194},
    {1, 0x02, 195},
    {14, 0x03, 195},
  },
  /* 121 */
  {
    {2, 0x02, 188},
    {6, 0x02, 188},
    {15, 0x02, 188},
    {30, 0x03, 188},
    {2, 0x02, 189},
    {6, 0x02, 189},
    {15, 0x02, 189},
    {30, 0x03, 189},
    {2, 0x02, 190},
    {6, 0x02, 190},
    {15, 0x02, 190},
    {30, 0x03, 190},
    {2, 0x02, 191},
    {6, 0x02, 191},
    {15, 0x02, 191},
    {30, 0x03, 191},
  },
  /* 122 */
  {
    {3, 0x02, 188},
    {4, 0x02, 188},
    {7, 0x02, 188},
    {10, 0x02, 188},
    {16, 0x02, 188},
    {23, 0x02, 188},
    {31, 0x02, 188},
    {44, 0x03, 188},
    {3, 0x02, 189},
    {4, 0x02, 189},
    {7, 0x02, 189},
    {10, 0x02, 189},
    {16, 0x02, 189},
    {23, 0x02, 189},
    {31, 0x02, 189},
    {44, 0x03, 189},
  },
  /* 123 */
  {
    {3, 0x02, 190},
    {4, 0x02, 190},
    {7, 0x02, 190},
    {10, 0x02, 190},
    {16, 0x02, 190},
    {23, 0x02, 190},
    {31, 0x02, 190},
    {44, 0x03, 190},
    {3, 0x02, 191},
    {4, 0x02, 191},
    {7, 0x02, 191},
    {10, 0x02, 191},
    {16, 0x02, 191},
    {23, 0x02, 191},
    {31, 0x02, 191},
    {44, 0x03, 191},
  },
  /* 124 */
  {
    {2, 0x02, 192},
    {6, 0x02, 192},
    {15, 0x02, 192},
    {30, 0x03, 192},
    {2, 0x02, 193},
    {6, 0x02, 193},
    {15, 0x02, 193},
    {30, 0x03, 193},
    {2, 0x02, 194},
    {6, 0x02, 194},
    {15, 0x02, 194},
    {30, 0x03, 194},
    {2, 0x02, 195},
    {6, 0x02, 195},
    {15, 0x02, 195},
    {30, 0x03, 195},
  },
  /* 125 */
  {
    {3, 0x02, 192},
    {4, 0x02, 192},
    {7, 0x02, 192},
    {10, 0x02, 192},
    {16, 0x02, 192},
    {23, 0x02, 192},
    {31, 0x02, 192},
    {44, 0x03, 192},
    {3, 0x02, 193},
    {4, 0x02, 193},
    {7, 0x02, 193},
    {10, 0x02, 193},
    {16, 0x02, 193},
    {23, 0x02, 193},
    {31, 0x02, 193},
    {44, 0x03, 193},
  },
  /* 126 */
  {
    {3, 0x02, 194},
    {4, 0x02, 194},
    {7, 0x02, 194},
    {10, 0x02, 194},
    {16, 0x02, 194},
    {23, 0x02, 194},
    {31, 0x02, 194},
    {44, 0x03, 194},
    {3, 0x02, 195},
    {4, 0x02, 195},
    {7, 0x02, 195},
    {10, 0x02, 195},
    {16, 0x02, 195},
    {23, 0x02, 195},
    {31, 0x02, 195},
    {44, 0x03, 195},
  },
  /* 127 */
  {
    {131, 0x00, 0},
    {132, 0x00, 0},
    {134, 0x00, 0},
    {135, 0x00, 0},
    {138, 0x00, 0},
    {139, 0x00, 0},
    {141, 0x00, 0},
    {142, 0x00, 0},
    {146, 0x00, 0},
    {147, 0x00, 0},
    {149, 0x00, 0},
    {150, 0x00, 0},
    {153, 0x00, 0},
    {154, 0x00, 0},
    {156, 0x00, 0},
    {157, 0x00, 0},
  },
  /* 128 */
  {
    {0, 0x03, 196},
    {0, 0x03, 197},
    {0, 0x03, 198},
    {0, 0x03, 199},
    {0, 0x03, 200},
    {0, 0x03, 201},
    {0, 0x03, 202},
    {0, 0x03, 203},
    {0, 0x03, 204},
    {0, 0x03, 205},
    {0, 0x03, 206},
    {0, 0x03, 207},
    {0, 0x03, 208},
    {0, 0x03, 209},
    {0, 0x03, 210},
    {0, 0x03, 211},
  },
  /* 129 */
  {
    {1, 0x02, 196},
    {14, 0x03, 196},
    {1, 0x02, 197},
    {14, 0x03, 197},
    {1, 0x02, 198},
    {14, 0x03, 198},
    {1, 0x02, 199},
    {14, 0x03, 199},
    {1, 0x02, 200},
    {14, 0x03, 200},
    {1, 0x02, 201},
    {14, 0x03, 201},
    {1, 0x02, 202},
    {14, 0x03, 202},
    {1, 0x02, 203},
    {14, 0x03, 203},
  },
  /* 130 */
  {
    {2, 0x02, 196},
    {6, 0x02, 196},
    {15, 0x02, 196},
    {30, 0x03, 196},
    {2, 0x02, 197},
    {6, 0x02, 197},
    {15, 0x02, 197},
    {30, 0x03, 197},
    {2, 0x02, 198},
    {6, 0x02, 198},
    {15, 0x02, 198},
    {30, 0x03, 198},
    {2, 0x02, 199},
    {6, 0x02, 199},
    {15, 0x02, 199},
    {30, 0x03, 199},
  },
  /* 131 */
  {
    {3, 0x02, 196},
    {4, 0x02, 196},
    {7, 0x02, 196},
    {10, 0x02, 196},
    {16, 0x02, 196},
    {23, 0x02, 196},
    {31, 0x02, 196},
    {44, 0x03, 196},
    {3, 0x02, 197},
    {4, 0x02, 197},
    {7, 0x02, 197},
    {10, 0x02, 197},
    {16, 0x02, 197},
    {23, 0x02, 197},
    {31, 0x02, 197},
    {44, 0x03, 197},
  },
  /* 132 */
  {
    {3, 0x02, 198},
    {4, 0x02, 198},
    {7, 0x02, 198},
    {10, 0x02, 198},
    {16, 0x02, 198},
    {23, 0x02, 198},
    {31, 0x02, 198},
    {44, 0x03, 198},
    {3, 0x02, 199},
    {4, 0x02, 199},
    {7, 0x02, 199},
    {10, 0x02, 199},
    {16, 0x02, 199},
    {23, 0x02, 199},
    {31, 0x02, 199},
    {44, 0x03, 199},
  },
  /* 133 */
  {
    {2, 0x02, 200},
    {6, 0x02, 200},
    {15, 0x02, 200},
    {30, 0x03, 200},
    {2, 0x02, 201},
    {6, 0x02, 201},
    {15, 0x02, 201},
    {30, 0x03, 201},
    {2, 0x02, 202},
    {6, 0x02, 202},
    {15, 0x02, 202},
    {30, 0x03, 202},
    {2, 0x02, 203},
    {6, 0x02, 203},
    {15, 0x02, 203},
    {30, 0x03, 203},
  },
  /* 134 */
  {
    {3, 0x02, 200},
    {4, 0x02, 200},
    {7, 0x02, 200},
    {10, 0x02, 200},
    {16, 0x02, 200},
    {23, 0x02, 200},
    {31, 0x02, 200},
    {44, 0x03, 200},
    {3, 0x02, 201},
    {4, 0x02, 201},
    {7, 0x02, 201},
    {10, 0x02, 201},
    {16, 0x02, 201},
    {23, 0x02, 201},
    {31, 0x02, 201},
    {44, 0x03, 201},
  },
  /* 135 */
  {
    {3, 0x02, 202},
    {4, 0x02, 202},
    {7, 0x02, 202},
    {10, 0x02, 202},
    {16, 0x02, 202},
    {23, 0x02, 202},
    {31, 0x02, 202},
    {44, 0x03, 202},
    {3, 0x02, 203},
    {4, 0x02, 203},
    {7, 0x02, 203},
    {10, 0x02, 203},
    {16, 0x02, 203},
    {23, 0x02, 203},
    {31, 0x02, 203},
    {44, 0x03, 203},
  },
  /* 136 */
  {
    {1, 0x02, 204},
    {14, 0x03, 204},
    {1, 0x02, 205},
    {14, 0x03, 205},
    {1, 0x02, 206},
    {14, 0x03, 206},
    {1, 0x02, 207},
    {14, 0x03, 207},
    {1, 0x02, 208},
    {14, 0x03, 208},
    {1, 0x02, 209},
    {14, 0x03, 209},
    {1, 0x02, 210},
    {14, 0x03, 210},
    {1, 0x02, 211},
    {14, 0x03, 211},
  },
  /* 137 */
  {
    {2, 0x02, 204},
    {6, 0x02, 204},
    {15, 0x02, 204},
    {30, 0x03, 204},
    {2, 0x02, 205},
    {6, 0x02, 205},
    {15, 0x02, 205},
    {30, 0x03, 205},
    {2, 0x02, 206},
    {6, 0x02, 206},
    {15, 0x02, 206},
    {30, 0x03, 206},
    {2, 0x02, 207},
    {6, 0x02, 207},
    {15, 0x02, 207},
    {30, 0x03, 207},
  },
  /* 138 */
  {
    {3, 0x02, 204},
    {4, 0x02, 204},
    {7, 0x02, 204},
    {10, 0x02, 204},
    {16, 0x02, 204},
    {23, 0x02, 204},
    {31, 0x02, 204},
    {44, 0x03, 204},
    {3, 0x02, 205},
    {4, 0x02, 205},
    {7, 0x02, 205},
    {10, 0x02, 205},
    {16, 0x02, 205},
    {23, 0x02, 205},
    {31, 0x02, 205},
    {44, 0x03, 205},
  },
  /* 139 */
  {
    {3, 0x02, 206},
    {4, 0x02, 206},
    {7, 0x02, 206},
    {10, 0x02, 206},
    {16, 0x02, 206},
    {23, 0x02, 206},
    {31, 0x02, 206},
    {44, 0x03, 206},
    {3, 0x02, 207},
    {4, 0x02, 207},
    {7, 0x02, 207},
    {10, 0x02, 207},
    {16, 0x02, 207},
    {23, 0x02, 207},
    {31, 0x02, 207},
    {44, 0x03, 207},
  },
  /* 140 */
  {
    {2, 0x02, 208},
    {6, 0x02, 208},
    {15, 0x02, 208},
    {30, 0x03, 208},
    {2, 0x02, 209},
    {6, 0x02, 209},
    {15, 0x02, 209},
    {30, 0x03, 209},
    {2, 0x02, 210},
    {6, 0x02, 210},
    {15, 0x02, 210},
    {30, 0x03, 210},
    {2, 0x02, 211},
    {6, 0x02, 211},
    {15, 0x02, 211},
    {30, 0x03, 211},
  },
  /* 141 */
  {
    {3, 0x02, 208},
    {4, 0x02, 208},
    {7, 0x02, 208},
    {10, 0x02, 208},
    {16, 0x02, 208},
    {23, 0x02, 208},
    {31, 0x02, 208},
    {44, 0x03, 208},
    {3, 0x02, 209},
    {4, 0x02, 209},
    {7, 0x02, 209},
    {10, 0x02, 209},
    {16, 0x02, 209},
    {23, 0x02, 209},
    {31, 0x02, 209},
    {44, 0x03, 209},
  },
  /* 142 */
  {
    {3, 0x02, 210},
    {4, 0x02, 210},
    {7, 0x02, 210},
    {10, 0x02, 210},
    {16, 0x02, 210},
    {23, 0x02, 210},
    {31, 0x02, 210},
    {44, 0x03, 210},
    {3, 0x02, 211},
    {4, 0x02, 211},
    {7, 0x02, 211},
    {10, 0x02, 211},
    {16, 0x02, 211},
    {23, 0x02, 211},
    {31, 0x02, 211},
    {44, 0x03, 211},
  },
  /* 143 */
  {
    {0, 0x03, 212},
    {0, 0x03, 213},
    {0, 0x03, 214},
    {0, 0x03, 215},
    {0, 0x03, 216},
    {0, 0x03, 217},
    {0, 0x03, 218},
    {0, 0x03, 219},
    {0, 0x03, 220},
    {0, 0x03, 221},
    {0, 0x03, 222},
    {0, 0x03, 223},
    {0, 0x03, 224},
    {0, 0x03, 225},
    {0, 0x03, 226},
    {0, 0x03, 227},
  },
  /* 144 */
  {
    {1, 0x02, 212},
    {14, 0x03, 212},
    {1, 0x02, 213},
    {14, 0x03, 213},
    {1, 0x02, 214},
    {14, 0x03, 214},
    {1, 0x02, 215},
    {14, 0x03, 215},
    {1, 0x02, 216},
    {14, 0x03, 216},
    {1, 0x02, 217},
    {14, 0x03, 217},
    {1, 0x02, 218},
    {14, 0x03, 218},
    {1, 0x02, 219},
    {14, 0x03, 219},
  },
  /* 145 */
  {
    {2, 0x02, 212},
    {6, 0x02, 212},
    {15, 0x02, 212},
    {30, 0x03, 212},
    {2, 0x02, 213},
    {6, 0x02, 213},
    {15, 0x02, 213},
    {30, 0x03, 213},
    {2, 0x02, 214},
    {6, 0x02, 214},
    {15, 0x02, 214},
    {30, 0x03, 214},
    {2, 0x02, 215},
    {6, 0x02, 215},
    {15, 0x02, 215},
    {30, 0x03, 215},
  },
  /* 146 */
  {
    {3, 0x02, 212},
    {4, 0x02, 212},
    {7, 0x02, 212},
    {10, 0x02, 212},
    {16, 0x02, 212},
    {23, 0x02, 212},
    {31, 0x02, 212},
    {44, 0x03, 212},
    {3, 0x02, 213},
    {4, 0x02, 213},
    {7, 0x02, 213},
    {10, 0x02, 213},
    {16, 0x02, 213},
    {23, 0x02, 213},
    {31, 0x02, 213},
    {44, 0x03, 213},
  },
  /* 147 */
  {
    {3, 0x02, 214},
    {4, 0x02, 214},
    {7, 0x02, 214},
    {10, 0x02, 214},
    {16, 0x02, 214},
    {23, 0x02, 214},
    {31, 0x02, 214},
    {44, 0x03, 214},
    {3, 0x02, 215},
    {4, 0x02, 215},
    {7, 0x02, 215},
    {10, 0x02, 215},
    {16, 0x02, 215},
    {23, 0x02, 215},
    {31, 0x02, 215},
    {44, 0x03, 215},
  },
  /* 148 */
  {
    {2, 0x02, 216},
    {6, 0x02, 216},
    {15, 0x02, 216},
    {30, 0x03, 216},
    {2, 0x02, 217},
    {6, 0x02, 217},
    {15, 0x02, 217},
    {30, 0x03, 217},
    {2, 0x02, 218},
    {6, 0x02, 218},
    {15, 0x02, 218},
    {30, 0x03, 218},
    {2, 0x02, 219},
    {6, 0x02, 219},
    {15, 0x02, 219},
    {30, 0x03, 219},
  },
  /* 149 */
  {
    {3, 0x02, 216},
    {4, 0x02, 216},
    {7, 0x02, 216},
    {10, 0x02, 216},
    {16, 0x02, 216},
    {23, 0x02, 216},
    {31, 0x02, 216},
    {44, 0x03, 216},
    {3, 0x02, 217},
    {4, 0x02, 217},
    {7, 0x02, 217},
    {10, 0x02, 217},
    {16, 0x02, 217},
    {23, 0x02, 217},
    {31, 0x02, 217},
    {44, 0x03, 217},
  },
  /* 150 */
  {
    {3, 0x02, 218},
    {4, 0x02, 218},
    {7, 0x02, 218},
    {10, 0x02, 218},
    {16, 0x02, 218},
    {23, 0x02, 218},
    {31, 0x02, 218},
    {44, 0x03, 218},
    {3, 0x02, 219},
    {4, 0x02, 219},
    {7, 0x02, 219},
    {10, 0x02, 219},
    {16, 0x02, 219},
    {23, 0x02, 219},
    {31, 0x02, 219},
    {44, 0x03, 219},
  },
  /* 151 */
  {
    {1, 0x02, 220},
    {14, 0x03, 220},
    {1, 0x02, 221},
    {14, 0x03, 221},
    {1, 0x02, 222},
    {14, 0x03, 222},
    {1, 0x02, 223},
    {14, 0x03, 223},
    {1, 0x02, 224},
    {14, 0x03, 224},
    {1, 0x02, 225},
    {14, 0x03, 225},
    {1, 0x02, 226},
    {14, 0x03, 226},
    {1, 0x02, 227},
    {14, 0x03, 227},
  },
  /* 152 */
  {
    {2, 0x02, 220},
    {6, 0x02, 220},
    {15, 0x02, 220},
    {30, 0x03, 220},
    {2, 0x02, 221},
    {6, 0x02, 221},
    {15, 0x02, 221},
    {30, 0x03, 221},
    {2, 0x02, 222},
    {6, 0x02, 222},
    {15, 0x02, 222},
    {30, 0x03, 222},
    {2, 0x02, 223},
    {6, 0x02, 223},
    {15, 0x02, 223},
    {30, 0x03, 223},
  },
  /* 153 */
  {
    {3, 0x02, 220},
    {4, 0x02, 220},
    {7, 0x02, 220},
    {10, 0x02, 220},
    {16, 0x02, 220},
    {23, 0x02, 220},
    {31, 0x02, 220},
    {44, 0x03, 220},
    {3, 0x02, 221},
    {4, 0x02, 221},
    {7, 0x02, 221},
    {10, 0x02, 221},
    {16, 0x02, 221},
    {23, 0x02, 221},
    {31, 0x02, 221},
    {44, 0x03, 221},
  },
  /* 154 */
  {
    {3, 0x02, 222},
    {4, 0x02, 222},
    {7, 0x02, 222},
    {10, 0x02, 222},
    {16, 0x02, 222},
    {23, 0x02, 222},
    {31, 0x02, 222},
    {44, 0x03, 222},
    {3, 0x02, 223},
    {4, 0x02, 223},
    {7, 0x02, 223},
    {10, 0x02, 223},
    {16, 0x02, 223},
    {23, 0x02, 223},
    {31, 0x02, 223},
    {44, 0x03, 223},
  },
  /* 155 */
  {
    {2, 0x02, 224},
    {6, 0x02, 224},
    {15, 0x02, 224},
    {30, 0x03, 224},
    {2, 0x02, 225},
    {6, 0x02, 225},
    {15, 0x02, 225},
    {30, 0x03, 225},
    {2, 0x02, 226},
    {6, 0x02, 226},
    {15, 0x02, 226},
    {30, 0x03, 226},
    {2, 0x02, 227},
    {6, 0x02, 227},
    {15, 0x02, 227},
    {30, 0x03, 227},
  },
  /* 156 */
  {
    {3, 0x02, 224},
    {4, 0x02, 224},
    {7, 0x02, 224},
    {10, 0x02, 224},
    {16, 0x02, 224},
    {23, 0x02, 224},
    {31, 0x02, 224},
    {44, 0x03, 224},
    {3, 0x02, 225},
    {4, 0x02, 225},
    {7, 0x02, 225},
    {10, 0x02, 225},
    {16, 0x02, 225},
    {23, 0x02, 225},
    {31, 0x02, 225},
    {44, 0x03, 225},
  },
  /* 157 */
  {
    {3, 0x02, 226},
    {4, 0x02, 226},
    {7, 0x02, 226},
    {10, 0x02, 226},
    {16, 0x02, 226},
    {23, 0x02, 226},
    {31, 0x02, 226},
    {44, 0x03, 226},
    {3, 0x02, 227},
    {4, 0x02, 227},
    {7, 0x02, 227},
    {10, 0x02, 227},
    {16, 0x02, 227},
    {23, 0x02, 227},
    {31, 0x02, 227},
    {44, 0x03, 227},
  },
  /* 158 */
  {
    {162, 0x00, 0},
    {165, 0x00, 0},
    {169, 0x00, 0},
    {172, 0x00, 0},
    {177, 0x00, 0},
    {180, 0x00, 0},
    {184, 0x00, 0},
    {187, 0x00, 0},
    {196, 0x00, 0},
    {203, 0x00, 0},
    {211, 0x00, 0},
    {218, 0x00, 0},
    {227, 0x00, 0},
    {234, 0x00, 0},
    {242, 0x00, 0},
    {249, 0x00, 0},
  },
  /* 159 */
  {
    {163, 0x00, 0},
    {164, 0x00, 0},
    {166, 0x00, 0},
    {167, 0x00, 0},
    {170, 0x00, 0},
    {171, 0x00, 0},
    {173, 0x00, 0},
    {174, 0x00, 0},
    {178, 0x00, 0},
    {179, 0x00, 0},
    {181, 0x00, 0},
    {182, 0x00, 0},
    {185, 0x00, 0},
    {186, 0x00, 0},
    {188, 0x00, 0},
    {190, 0x00, 0},
  },
  /* 160 */
  {
    {0, 0x03, 228},
    {0, 0x03, 229},
    {0, 0x03, 230},
    {0, 0x03, 231},
    {0, 0x03, 232},
    {0, 0x03, 233},
    {0, 0x03, 234},
    {0, 0x03, 235},
    {0, 0x03, 236},
    {0, 0x03, 237},
    {0, 0x03, 238},
    {0, 0x03, 239},
    {0, 0x03, 240},
    {0, 0x03, 241},
    {0, 0x03, 242},
    {0, 0x03, 243},
  },
  /* 161 */
  {
    {1, 0x02, 228},
    {14, 0x03, 228},
    {1, 0x02, 229},
    {14, 0x03, 229},
    {1, 0x02, 230},
    {14, 0x03, 230},
    {1, 0x02, 231},
    {14, 0x03, 231},
    {1, 0x02, 232},
    {14, 0x03, 232},
    {1, 0x02, 233},
    {14, 0x03, 233},
    {1, 0x02, 234},
    {14, 0x03, 234},
    {1, 0x02, 235},
    {14, 0x03, 235},
  },
  /* 162 */
  {
    {2, 0x02, 228},
    {6, 0x02, 228},
    {15, 0x02, 228},
    {30, 0x03, 228},
    {2, 0x02, 229},
    {6, 0x02, 229},
    {15, 0x02, 229},
    {30, 0x03, 229},
    {2, 0x02, 230},
    {6, 0x02, 230},
    {15, 0x02, 230},
    {30, 0x03, 230},
    {2, 0x02, 231},
    {6, 0x02, 231},
    {15, 0x02, 231},
    {30, 0x03, 231},
  },
  /* 163 */
  {
    {3, 0x02, 228},
    {4, 0x02, 228},
    {7, 0x02, 228},
    {10, 0x02, 228},
    {16, 0x02, 228},
    {23, 0x02, 228},
    {31, 0x02, 228},
    {44, 0x03, 228},
    {3, 0x02, 229},
    {4, 0x02, 229},
    {7, 0x02, 229},
    {10, 0x02, 229},
    {16, 0x02, 229},
    {23, 0x02, 229},
    {31, 0x02, 229},
    {44, 0x03, 229},
  },
  /* 164 */
  {
    {3, 0x02, 230},
    {4, 0x02, 230},
    {7, 0x02, 230},
    {10, 0x02, 230},
    {16, 0x02, 230},
    {23, 0x02, 230},
    {31, 0x02, 230},
    {44, 0x03, 230},
    {3, 0x02, 231},
    {4, 0x02, 231},
    {7, 0x02, 231},
    {10, 0x02, 231},
    {16, 0x02, 231},
    {23, 0x02, 231},
    {31, 0x02, 231},
    {44, 0x03, 231},
  },
  /* 165 */
  {
    {2, 0x02, 232},
    {6, 0x02, 232},
    {15, 0x02, 232},
    {30, 0x03, 232},
    {2, 0x02, 233},
    {6, 0x02, 233},
    {15, 0x02, 233},
    {30, 0x03, 233},
    {2, 0x02, 234},
    {6, 0x02, 234},
    {15, 0x02, 234},
    {30, 0x03, 234},
    {2, 0x02, 235},
    {6, 0x02, 235},
    {15, 0x02, 235},
    {30, 0x03, 235},
  },
  /* 166 */
  {
    {3, 0x02, 232},
    {4, 0x02, 232},
    {7, 0x02, 232},
    {10, 0x02, 232},
    {16, 0x02, 232},
    {23, 0x02, 232},
    {31, 0x02, 232},
    {44, 0x03, 232},
    {3, 0x02, 233},
    {4, 0x02, 233},
    {7, 0x02, 233},
    {10, 0x02, 233},
    {16, 0x02, 233},
    {23, 0x02, 233},
    {31, 0x02, 233},
    {44, 0x03, 233},
  },
  /* 167 */
  {
    {3, 0x02, 234},
    {4, 0x02, 234},
    {7, 0x02, 234},
    {10, 0x02, 234},
    {16, 0x02, 234},
    {23, 0x02, 234},
    {31, 0x02, 234},
    {44, 0x03, 234},
    {3, 0x02, 235},
    {4, 0x02, 235},
    {7, 0x02, 235},
    {10, 0x02, 235},
    {16, 0x02, 235},
    {23, 0x02, 235},
    {31, 0x02, 235},
    {44, 0x03, 235},
  },
  /* 168 */
  {
    {1, 0x02, 236},
    {14, 0x03, 236},
    {1, 0x02, 237},
    {14, 0x03, 237},
    {1, 0x02, 238},
    {14, 0x03, 238},
    {1, 0x02, 239},
    {14, 0x03, 239},
    {1, 0x02, 240},
    {14, 0x03, 240},
    {1, 0x02, 241},
    {14, 0x03, 241},
    {1, 0x02, 242},
    {14, 0x03, 242},
    {1, 0x02, 243},
    {14, 0x03, 243},
  },
  /* 169 */
  {
    {2, 0x02, 236},
    {6, 0x02, 236},
    {15, 0x02, 236},
    {30, 0x03, 236},
    {2, 0x02, 237},
    {6, 0x02, 237},
    {15, 0x02, 237},
    {30, 0x03, 237},
    {2, 0x02, 238},
    {6, 0x02, 238},
    {15, 0x02, 238},
    {30, 0x03, 238},
    {2, 0x02, 239},
    {6, 0x02, 239},
    {15, 0x02, 239},
    {30, 0x03, 239},
  },
  /* 170 */
  {
    {3, 0x02, 236},
    {4, 0x02, 236},
    {7, 0x02, 236},
    {10, 0x02, 236},
    {16, 0x02, 236},
    {23, 0x02, 236},
    {31, 0x02, 236},
    {44, 0x03, 236},
    {3, 0x02, 237},
    {4, 0x02, 237},
    {7, 0x02, 237},
    {10, 0x02, 237},
    {16, 0x02, 237},
    {23, 0x02, 237},
    {31, 0x02, 237},
    {44, 0x03, 237},
  },
  /* 171 */
  {
    {3, 0x02, 238},
    {4, 0x02, 238},
    {7, 0x02, 238},
    {10, 0x02, 238},
    {16, 0x02, 238},
    {23, 0x02, 238},
    {31, 0x02, 238},
    {44, 0x03, 238},
    {3, 0x02, 239},
    {4, 0x02, 239},
    {7, 0x02, 239},
    {10, 0x02, 239},
    {16, 0x02, 239},
    {23, 0x02, 239},
    {31, 0x02, 239},
    {44, 0x03, 239},
  },
  /* 172 */
  {
    {2, 0x02, 240},
    {6, 0x02, 240},
    {15, 0x02, 240},
    {30, 0x03, 240},
    {2, 0x02, 241},
    {6, 0x02, 241},
    {15, 0x02, 241},
    {30, 0x03, 241},
    {2, 0x02, 242},
    {6, 0x02, 242},
    {15, 0x02, 242},
    {30, 0x03, 242},
    {2, 0x02, 243},
    {6, 0x02, 243},
    {15, 0x02, 243},
    {30, 0x03, 243},
  },
  /* 173 */
  {
    {3, 0x02, 240},
    {4, 0x02, 240},
    {7, 0x02, 240},
    {10, 0x02, 240},
    {16, 0x02, 240},
    {23, 0x02, 240},
    {31, 0x02, 240},
    {44, 0x03, 240},
    {3, 0x02, 241},
    {4, 0x02, 241},
    {7, 0x02, 241},
    {10, 0x02, 241},
    {16, 0x02, 241},
    {23, 0x02, 241},
    {31, 0x02, 241},
    {44, 0x03, 241},
  },
  /* 174 */
  {
    {3, 0x02, 242},
    {4, 0x02, 242},
    {7, 0x02, 242},
    {10, 0x02, 242},
    {16, 0x02, 242},
    {23, 0x02, 242},
    {31, 0x02, 242},
    {44, 0x03, 242},
    {3, 0x02, 243},
    {4, 0x02, 243},
    {7, 0x02, 243},
    {10, 0x02, 243},
    {16, 0x02, 243},
    {23, 0x02, 243},
    {31, 0x02, 243},
    {44, 0x03, 243},
  },
  /* 175 */
  {
    {0, 0x03, 244},
    {0, 0x03, 245},
    {0, 0x03, 246},
    {0, 0x03, 247},
    {0, 0x03, 248},
    {0, 0x03, 249},
    {0, 0x03, 250},
    {0, 0x03, 251},
    {0, 0x03, 252},
    {0, 0x03, 253},
    {0, 0x03, 254},
    {0, 0x03, 255},
    {0, 0x04, 0},
    {189, 0x00, 0},
    {191, 0x00, 0},
    {192, 0x00, 0},
  },
  /* 176 */
  {
    {1, 0x02, 244},
    {14, 0x03, 244},
    {1, 0x02, 245},
    {14, 0x03, 245},
    {1, 0x02, 246},
    {14, 0x03, 246},
    {1, 0x02, 247},
    {14, 0x03, 247},
    {1, 0x02, 248},
    {14, 0x03, 248},
    {1, 0x02, 249},
    {14, 0x03, 249},
    {1, 0x02, 250},
    {14, 0x03, 250},
    {1, 0x02, 251},
    {14, 0x03, 251},
  },
  /* 177 */
  {
    {2, 0x02, 244},
    {6, 0x02, 244},
    {15, 0x02, 244},
    {30, 0x03, 244},
    {2, 0x02, 245},
    {6, 0x02, 245},
    {15, 0x02, 245},
    {30, 0x03, 245},
    {2, 0x02, 246},
    {6, 0x02, 246},
    {15, 0x02, 246},
    {30, 0x03, 246},
    {2, 0x02, 247},
    {6, 0x02, 247},
    {15, 0x02, 247},
    {30, 0x03, 247},
  },
  /* 178 */
  {
    {3, 0x02, 244},
    {4, 0x02, 244},
    {7, 0x02, 244},
    {10, 0x02, 244},
    {16, 0x02, 244},
    {23, 0x02, 244},
    {31, 0x02, 244},
    {44, 0x03, 244},
    {3, 0x02, 245},
    {4, 0x02, 245},
    {7, 0x02, 245},
    {10, 0x02, 245},
    {16, 0x02, 245},
    {23, 0x02, 245},
    {31, 0x02, 245},
    {44, 0x03, 245},
  },
  /* 179 */
  {
    {3, 0x02, 246},
    {4, 0x02, 246},
    {7, 0x02, 246},
    {10, 0x02, 246},
    {16, 0x02, 246},
    {23, 0x02, 246},
    {31, 0x02, 246},
    {44, 0x03, 246},
    {3, 0x02, 247},
    {4, 0x02, 247},
    {7, 0x02, 247},
    {10, 0x02, 247},
    {16, 0x02, 247},
    {23, 0x02, 247},
    {31, 0x02, 247},
    {44, 0x03, 247},
  },
  /* 180 */
  {
    {2, 0x02, 248},
    {6, 0x02, 248},
    {15, 0x02, 248},
    {30, 0x03, 248},
    {2, 0x02, 249},
    {6, 0x02, 249},
    {15, 0x02, 249},
    {30, 0x03, 249},
    {2, 0x02, 250},
    {6, 0x02, 250},
    {15, 0x02, 250},
    {30, 0x03, 250},
    {2, 0x02, 251},
    {6, 0x02, 251},
    {15, 0x02, 251},
    {30, 0x03, 251},
  },
  /* 181 */
  {
    {3, 0x02, 248},
    {4, 0x02, 248},
    {7, 0x02, 248},
    {10, 0x02, 248},
    {16, 0x02, 248},
    {23, 0x02, 248},
    {31, 0x02, 248},
    {44, 0x03, 248},
    {3, 0x02, 249},
    {4, 0x02, 249},
    {7, 0x02, 249},
    {10, 0x02, 249},
    {16, 0x02, 249},
    {23, 0x02, 249},
    {31, 0x02, 249},
    {44, 0x03, 249},
  },
  /* 182 */
  {
    {3, 0x02, 250},
    {4, 0x02, 250},
    {7, 0x02, 250},
    {10, 0x02, 250},
    {16, 0x02, 250},
    {23, 0x02, 250},
    {31, 0x02, 250},
    {44, 0x03, 250},
    {3, 0x02, 251},
    {4, 0x02, 251},
    {7, 0x02, 251},
    {10, 0x02, 251},
    {16, 0x02, 251},
    {23, 0x02, 251},
    {31, 0x02, 251},
    {44, 0x03, 251},
  },
  /* 183 */
  {
    {1, 0x02, 252},
    {14, 0x03, 252},
    {1, 0x02, 253},
    {14, 0x03, 253},
    {1, 0x02, 254},
    {14, 0x03, 254},
    {1, 0x02, 255},
    {14, 0x03, 255},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x03, 0},
    {0, 0x03, 1},
    {0, 0x03, 2},
    {0, 0x03, 3},
    {0, 0x03, 4},
    {0, 0x03, 5},
  },
  /* 184 */
  {
    {2, 0x02, 252},
    {6, 0x02, 252},
    {15, 0x02, 252},
    {30, 0x03, 252},
    {2, 0x02, 253},
    {6, 0x02, 253},
    {15, 0x02, 253},
    {30, 0x03, 253},
    {2, 0x02, 254},
    {6, 0x02, 254},
    {15, 0x02, 254},
    {30, 0x03, 254},
    {2, 0x02, 255},
    {6, 0x02, 255},
    {15, 0x02, 255},
    {30, 0x03, 255},
  },
  /* 185 */
  {
    {3, 0x02, 252},
    {4, 0x02, 252},
    {7, 0x02, 252},
    {10, 0x02, 252},
    {16, 0x02, 252},
    {23, 0x02, 252},
    {31, 0x02, 252},
    {44, 0x03, 252},
    {3, 0x02, 253},
    {4, 0x02, 253},
    {7, 0x02, 253},
    {10, 0x02, 253},
    {16, 0x02, 253},
    {23, 0x02, 253},
    {31, 0x02, 253},
    {44, 0x03, 253},
  },
  /* 186 */
  {
    {3, 0x02, 254},
    {4, 0x02, 254},
    {7, 0x02, 254},
    {10, 0x02, 254},
    {16, 0x02, 254},
    {23, 0x02, 254},
    {31, 0x02, 254},
    {44, 0x03, 254},
    {3, 0x02, 255},
    {4, 0x02, 255},
    {7, 0x02, 255},
    {10, 0x02, 255},
    {16, 0x02, 255},
    {23, 0x02, 255},
    {31, 0x02, 255},
    {44, 0x03, 255},
  },
  /* 187 */
  {
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {1, 0x02, 0},
    {14, 0x03, 0},
    {1, 0x02, 1},
    {14, 0x03, 1},
    {1, 0x02, 2},
    {14, 0x03, 2},
    {1, 0x02, 3},
    {14, 0x03, 3},
    {1, 0x02, 4},
    {14, 0x03, 4},
    {1, 0x02, 5},
    {14, 0x03, 5},
  },
  /* 188 */
  {
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {0, 0x04, 0},
    {2, 0x02, 0},
    {6, 0x02, 0},
    {15, 0x02, 0},
    {30, 0x03, 0},
    {2, 0x02, 1},
    {6, 0x02, 1},
    {15, 0x02, 1},
    {30, 0x03, 1},
  },
  /* 189 */
  {
    {3, 0x02, 0},
    {4, 0x02, 0},
    {7, 0x02, 0},
    {10, 0x02, 0},
    {16, 0x02, 0},
    {23, 0x02, 0},
    {31, 0x02, 0},
    {44, 0x03, 0},
    {3, 0x02, 1},
    {4, 0x02, 1},
    {7, 0x02, 1},
    {10, 0x02, 1},
    {16, 0x02, 1},
    {23, 0x02, 1},
    {31, 0x02, 1},
    {44, 0x03, 1},
  },
  /* 190 */
  {
    {2, 0x02, 2},
    {6, 0x02, 2},
    {15, 0x02, 2},
    {30, 0x03, 2},
    {2, 0x02, 3},
    {6, 0x02, 3},
    {15, 0x02, 3},
    {30, 0x03, 3},
    {2, 0x02, 4},
    {6, 0x02, 4},
    {15, 0x02, 4},
    {30, 0x03, 4},
    {2, 0x02, 5},
    {6, 0x02, 5},
    {15, 0x02, 5},
    {30, 0x03, 5},
  },
  /* 191 */
  {
    {3, 0x02, 2},
    {4, 0x02, 2},
    {7, 0x02, 2},
    {10, 0x02, 2},
    {16, 0x02, 2},
    {23, 0x02, 2},
    {31, 0x02, 2},
    {44, 0x03, 2},
    {3, 0x02, 3},
    {4, 0x02, 3},
    {7, 0x02, 3},
    {10, 0x02, 3},
    {16, 0x02, 3},
    {23, 0x02, 3},
    {31, 0x02, 3},
    {44, 0x03, 3},
  },
  /* 192 */
  {
    {3, 0x02, 4},
    {4, 0x02, 4},
    {7, 0x02, 4},
    {10, 0x02, 4},
    {16, 0x02, 4},
    {23, 0x02, 4},
    {31, 0x02, 4},
    {44, 0x03, 4},
    {3, 0x02, 5},
    {4, 0x02, 5},
    {7, 0x02, 5},
    {10, 0x02, 5},
    {16, 0x02, 5},
    {23, 0x02, 5},
    {31, 0x02, 5},
    {44, 0x03, 5},
  },
  /* 193 */
  {
    {197, 0x00, 0},
    {200, 0x00, 0},
    {204, 0x00, 0},
    {207, 0x00, 0},
    {212, 0x00, 0},
    {215, 0x00, 0},
    {219, 0x00, 0},
    {222, 0x00, 0},
    {228, 0x00, 0},
    {231, 0x00, 0},
    {235, 0x00, 0},
    {238, 0x00, 0},
    {243, 0x00, 0},
    {246, 0x00, 0},
    {250, 0x00, 0},
    {253, 0x00, 0},
  },
  /* 194 */
  {
    {198, 0x00, 0},
    {199, 0x00, 0},
    {201, 0x00, 0},
    {202, 0x00, 0},
    {205, 0x00, 0},
    {206, 0x00, 0},
    {208, 0x00, 0},
    {209, 0x00, 0},
    {213, 0x00, 0},
    {214, 0x00, 0},
    {216, 0x00, 0},
    {217, 0x00, 0},
    {220, 0x00, 0},
    {221, 0x00, 0},
    {223, 0x00, 0},
    {224, 0x00, 0},
  },
  /* 195 */
  {
    {0, 0x03, 6},
    {0, 0x03, 7},
    {0, 0x03, 8},
    {0, 0x03, 9},
    {0, 0x03, 10},
    {0, 0x03, 11},
    {0, 0x03, 12},
    {0, 0x03, 13},
    {0, 0x03, 14},
    {0, 0x03, 15},
    {0, 0x03, 16},
    {0, 0x03, 17},
    {0, 0x03, 18},
    {0, 0x03, 19},
    {0, 0x03, 20},
    {0, 0x03, 21},
  },
  /* 196 */
  {
    {1, 0x02, 6},
    {14, 0x03, 6},
    {1, 0x02, 7},
    {14, 0x03, 7},
    {1, 0x02, 8},
    {14, 0x03, 8},
    {1, 0x02, 9},
    {14, 0x03, 9},
    {1, 0x02, 10},
    {14, 0x03, 10},
    {1, 0x02, 11},
    {14, 0x03, 11},
    {1, 0x02, 12},
    {14, 0x03, 12},
    {1, 0x02, 13},
    {14, 0x03, 13},
  },
  /* 197 */
  {
    {2, 0x02, 6},
    {6, 0x02, 6},
    {15, 0x02, 6},
    {30, 0x03, 6},
    {2, 0x02, 7},
    {6, 0x02, 7},
    {15, 0x02, 7},
    {30, 0x03, 7},
    {2, 0x02, 8},
    {6, 0x02, 8},
    {15, 0x02, 8},
    {30, 0x03, 8},
    {2, 0x02, 9},
    {6, 0x02, 9},
    {15, 0x02, 9},
    {30, 0x03, 9},
  },
  /* 198 */
  {
    {3, 0x02, 6},
    {4, 0x02, 6},
    {7, 0x02, 6},
    {10, 0x02, 6},
    {16, 0x02, 6},
    {23, 0x02, 6},
    {31, 0x02, 6},
    {44, 0x03, 6},
    {3, 0x02, 7},
    {4, 0x02, 7},
    {7, 0x02, 7},
    {10, 0x02, 7},
    {16, 0x02, 7},
    {23, 0x02, 7},
    {31, 0x02, 7},
    {44, 0x03, 7},
  },
  /* 199 */
  {
    {3, 0x02, 8},
    {4, 0x02, 8},
    {7, 0x02, 8},
    {10, 0x02, 8},
    {16, 0x02, 8},
    {23, 0x02, 8},
    {31, 0x02, 8},
    {44, 0x03, 8},
    {3, 0x02, 9},
    {4, 0x02, 9},
    {7, 0x02, 9},
    {10, 0x02, 9},
    {16, 0x02, 9},
    {23, 0x02, 9},
    {31, 0x02, 9},
    {44, 0x03, 9},
  },
  /* 200 */
  {
    {2, 0x02, 10},
    {6, 0x02, 10},
    {15, 0x02, 10},
    {30, 0x03, 10},
    {2, 0x02, 11},
    {6, 0x02, 11},
    {15, 0x02, 11},
    {30, 0x03, 11},
    {2, 0x02, 12},
    {6, 0x02, 12},
    {15, 0x02, 12},
    {30, 0x03, 12},
    {2, 0x02, 13},
    {6, 0x02, 13},
    {15, 0x02, 13},
    {30, 0x03, 13},
  },
  /* 201 */
  {
    {3, 0x02, 10},
    {4, 0x02, 10},
    {7, 0x02, 10},
    {10, 0x02, 10},
    {16, 0x02, 10},
    {23, 0x02, 10},
    {31, 0x02, 10},
    {44, 0x03, 10},
    {3, 0x02, 11},
    {4, 0x02, 11},
    {7, 0x02, 11},
    {10, 0x02, 11},
    {16, 0x02, 11},
    {23, 0x02, 11},
    {31, 0x02, 11},
    {44, 0x03, 11},
  },
  /* 202 */
  {
    {3, 0x02, 12},
    {4, 0x02, 12},
    {7, 0x02, 12},
    {10, 0x02, 12},
    {16, 0x02, 12},
    {23, 0x02, 12},
    {31, 0x02, 12},
    {44, 0x03, 12},
    {3, 0x02, 13},
    {4, 0x02, 13},
    {7, 0x02, 13},
    {10, 0x02, 13},
    {16, 0x02, 13},
    {23, 0x02, 13},
    {31, 0x02, 13},
    {44, 0x03, 13},
  },
  /* 203 */
  {
    {1, 0x02, 14},
    {14, 0x03, 14},
    {1, 0x02, 15},
    {14, 0x03, 15},
    {1, 0x02, 16},
    {14, 0x03, 16},
    {1, 0x02, 17},
    {14, 0x03, 17},
    {1, 0x02, 18},
    {14, 0x03, 18},
    {1, 0x02, 19},
    {14, 0x03, 19},
    {1, 0x02, 20},
    {14, 0x03, 20},
    {1, 0x02, 21},
    {14, 0x03, 21},
  },
  /* 204 */
  {
    {2, 0x02, 14},
    {6, 0x02, 14},
    {15, 0x02, 14},
    {30, 0x03, 14},
    {2, 0x02, 15},
    {6, 0x02, 15},
    {15, 0x02, 15},
    {30, 0x03, 15},
    {2, 0x02, 16},
    {6, 0x02, 16},
    {15, 0x02, 16},
    {30, 0x03, 16},
    {2, 0x02, 17},
    {6, 0x02, 17},
    {15, 0x02, 17},
    {30, 0x03, 17},
  },
  /* 205 */
  {
    {3, 0x02, 14},
    {4, 0x02, 14},
    {7, 0x02, 14},
    {10, 0x02, 14},
    {16, 0x02, 14},
    {23, 0x02, 14},
    {31, 0x02, 14},
    {44, 0x03, 14},
    {3, 0x02, 15},
    {4, 0x02, 15},
    {7, 0x02, 15},
    {10, 0x02, 15},
    {16, 0x02, 15},
    {23, 0x02, 15},
    {31, 0x02, 15},
    {44, 0x03, 15},
  },
  /* 206 */
  {
    {3, 0x02, 16},
    {4, 0x02, 16},
    {7, 0x02, 16},
    {10, 0x02, 16},
    {16, 0x02, 16},
    {23, 0x02, 16},
    {31, 0x02, 16},
    {44, 0x03, 16},
    {3, 0x02, 17},
    {4, 0x02, 17},
    {7, 0x02, 17},
    {10, 0x02, 17},
    {16, 0x02, 17},
    {23, 0x02, 17},
    {31, 0x02, 17},
    {44, 0x03, 17},
  },
  /* 207 */
  {
    {2, 0x02, 18},
    {6, 0x02, 18},
    {15, 0x02, 18},
    {30, 0x03, 18},
    {2, 0x02, 19},
    {6, 0x02, 19},
    {15, 0x02, 19},
    {30, 0x03, 19},
    {2, 0x02, 20},
    {6, 0x02, 20},
    {15, 0x02, 20},
    {30, 0x03, 20},
    {2, 0x02, 21},
    {6, 0x02, 21},
    {15, 0x02, 21},
    {30, 0x03, 21},
  },
  /* 208 */
  {
    {3, 0x02, 18},
    {4, 0x02, 18},
    {7, 0x02, 18},
    {10, 0x02, 18},
    {16, 0x02, 18},
    {23, 0x02, 18},
    {31, 0x02, 18},
    {44, 0x03, 18},
    {3, 0x02, 19},
    {4, 0x02, 19},
    {7, 0x02, 19},
    {10, 0x02, 19},
    {16, 0x02, 19},
    {23, 0x02, 19},
    {31, 0x02, 19},
    {44, 0x03, 19},
  },
  /* 209 */
  {
    {3, 0x02, 20},
    {4, 0x02, 20},
    {7, 0x02, 20},
    {10, 0x02, 20},
    {16, 0x02, 20},
    {23, 0x02, 20},
    {31, 0x02, 20},
    {44, 0x03, 20},
    {3, 0x02, 21},
    {4, 0x02, 21},
    {7, 0x02, 21},
    {10, 0x02, 21},
    {16, 0x02, 21},
    {23, 0x02, 21},
    {31, 0x02, 21},
    {44, 0x03, 21},
  },
  /* 210 */
  {
    {0, 0x03, 22},
    {0, 0x03, 23},
    {0, 0x03, 24},
    {0, 0x03, 25},
    {0, 0x03, 26},
    {0, 0x03, 27},
    {0, 0x03, 28},
    {0, 0x03, 29},
    {0, 0x03, 30},
    {0, 0x03, 31},
    {0, 0x03, 92},
    {0, 0x03, 127},
    {0, 0x03, 128},
    {0, 0x03, 129},
    {0, 0x03, 130},
    {0, 0x03, 131},
  },
  /* 211 */
  {
    {1, 0x02, 22},
    {14, 0x03, 22},
    {1, 0x02, 23},
    {14, 0x03, 23},
    {1, 0x02, 24},
    {14, 0x03, 24},
    {1, 0x02, 25},
    {14, 0x03, 25},
    {1, 0x02, 26},
    {14, 0x03, 26},
    {1, 0x02, 27},
    {14, 0x03, 27},
    {1, 0x02, 28},
    {14, 0x03, 28},
    {1, 0x02, 29},
    {14, 0x03, 29},
  },
  /* 212 */
  {
    {2, 0x02, 22},
    {6, 0x02, 22},
    {15, 0x02, 22},
    {30, 0x03, 22},
    {2, 0x02, 23},
    {6, 0x02, 23},
    {15, 0x02, 23},
    {30, 0x03, 23},
    {2, 0x02, 24},
    {6, 0x02, 24},
    {15, 0x02, 24},
    {30, 0x03, 24},
    {2, 0x02, 25},
    {6, 0x02, 25},
    {15, 0x02, 25},
    {30, 0x03, 25},
  },
  /* 213 */
  {
    {3, 0x02, 22},
    {4, 0x02, 22},
    {7, 0x02, 22},
    {10, 0x02, 22},
    {16, 0x02, 22},
    {23, 0x02, 22},
    {31, 0x02, 22},
    {44, 0x03, 22},
    {3, 0x02, 23},
    {4, 0x02, 23},
    {7, 0x02, 23},
    {10, 0x02, 23},
    {16, 0x02, 23},
    {23, 0x02, 23},
    {31, 0x02, 23},
    {44, 0x03, 23},
  },
  /* 214 */
  {
    {3, 0x02, 24},
    {4, 0x02, 24},
    {7, 0x02, 24},
    {10, 0x02, 24},
    {16, 0x02, 24},
    {23, 0x02, 24},
    {31, 0x02, 24},
    {44, 0x03, 24},
    {3, 0x02, 25},
    {4, 0x02, 25},
    {7, 0x02, 25},
    {10, 0x02, 25},
    {16, 0x02, 25},
    {23, 0x02, 25},
    {31, 0x02, 25},
    {44, 0x03, 25},
  },
  /* 215 */
  {
    {2, 0x02, 26},
    {6, 0x02, 26},
    {15, 0x02, 26},
    {30, 0x03, 26},
    {2, 0x02, 27},
    {6, 0x02, 27},
    {15, 0x02, 27},
    {30, 0x03, 27},
    {2, 0x02, 28},
    {6, 0x02, 28},
    {15, 0x02, 28},
    {30, 0x03, 28},
    {2, 0x02, 29},
    {6, 0x02, 29},
    {15, 0x02, 29},
    {30, 0x03, 29},
  },
  /* 216 */
  {
    {3, 0x02, 26},
    {4, 0x02, 26},
    {7, 0x02, 26},
    {10, 0x02, 26},
    {16, 0x02, 26},
    {23, 0x02, 26},
    {31, 0x02, 26},
    {44, 0x03, 26},
    {3, 0x02, 27},
    {4, 0x02, 27},
    {7, 0x02, 27},
    {10, 0x02, 27},
    {16, 0x02, 27},
    {23, 0x02, 27},
    {31, 0x02, 27},
    {44, 0x03, 27},
  },
  /* 217 */
  {
    {3, 0x02, 28},
    {4, 0x02, 28},
    {7, 0x02, 28},
    {10, 0x02, 28},
    {16, 0x02, 28},
    {23, 0x02, 28},
    {31, 0x02, 28},
    {44, 0x03, 28},
    {3, 0x02, 29},
    {4, 0x02, 29},
    {7, 0x02, 29},
    {10, 0x02, 29},
    {16, 0x02, 29},
    {23, 0x02, 29},
    {31, 0x02, 29},
    {44, 0x03, 29},
  },
  /* 218 */
  {
    {1, 0x02, 30},
    {14, 0x03, 30},
    {1, 0x02, 31},
    {14, 0x03, 31},
    {1, 0x02, 92},
    {14, 0x03, 92},
    {1, 0x02, 127},
    {14, 0x03, 127},
    {1, 0x02, 128},
    {14, 0x03, 128},
    {1, 0x02, 129},
    {14, 0x03, 129},
    {1, 0x02, 130},
    {14, 0x03, 130},
    {1, 0x02, 131},
    {14, 0x03, 131},
  },
  /* 219 */
  {
    {2, 0x02, 30},
    {6, 0x02, 30},
    {15, 0x02, 30},
    {30, 0x03, 30},
    {2, 0x02, 31},
    {6, 0x02, 31},
    {15, 0x02, 31},
    {30, 0x03, 31},
    {2, 0x02, 92},
    {6, 0x02, 92},
    {15, 0x02, 92},
    {30, 0x03, 92},
    {2, 0x02, 127},
    {6, 0x02, 127},
    {15, 0x02, 127},
    {30, 0x03, 127},
  },
  /* 220 */
  {
    {3, 0x02, 30},
    {4, 0x02, 30},
    {7, 0x02, 30},
    {10, 0x02, 30},
    {16, 0x02, 30},
    {23, 0x02, 30},
    {31, 0x02, 30},
    {44, 0x03, 30},
    {3, 0x02, 31},
    {4, 0x02, 31},
    {7, 0x02, 31},
    {10, 0x02, 31},
    {16, 0x02, 31},
    {23, 0x02, 31},
    {31, 0x02, 31},
    {44, 0x03, 31},
  },
  /* 221 */
  {
    {3, 0x02, 92},
    {4, 0x02, 92},
    {7, 0x02, 92},
    {10, 0x02, 92},
    {16, 0x02, 92},
    {23, 0x02, 92},
    {31, 0x02, 92},
    {44, 0x03, 92},
    {3, 0x02, 127},
    {4, 0x02, 127},
    {7, 0x02, 127},
    {10, 0x02, 127},
    {16, 0x02, 127},
    {23, 0x02, 127},
    {31, 0x02, 127},
    {44, 0x03, 127},
  },
  /* 222 */
  {
    {2, 0x02, 128},
    {6, 0x02, 128},
    {15, 0x02, 128},
    {30, 0x03, 128},
    {2, 0x02, 129},
    {6, 0x02, 129},
    {15, 0x02, 129},
    {30, 0x03, 129},
    {2, 0x02, 130},
    {6, 0x02, 130},
    {15, 0x02, 130},
    {30, 0x03, 130},
    {2, 0x02, 131},
    {6, 0x02, 131},
    {15, 0x02, 131},
    {30, 0x03, 131},
  },
  /* 223 */
  {
    {3, 0x02, 128},
    {4, 0x02, 128},
    {7, 0x02, 128},
    {10, 0x02, 128},
    {16, 0x02, 128},
    {23, 0x02, 128},
    {31, 0x02, 128},
    {44, 0x03, 128},
    {3, 0x02, 129},
    {4, 0x02, 129},
    {7, 0x02, 129},
    {10, 0x02, 129},
    {16, 0x02, 129},
    {23, 0x02, 129},
    {31, 0x02, 129},
    {44, 0x03, 129},
  },
  /* 224 */
  {
    {3, 0x02, 130},
    {4, 0x02, 130},
    {7, 0x02, 130},
    {10, 0x02, 130},
    {16, 0x02, 130},
    {23, 0x02, 130},
    {31, 0x02, 130},
    {44, 0x03, 130},
    {3, 0x02, 131},
    {4, 0x02, 131},
    {7, 0x02, 131},
    {10, 0x02, 131},
    {16, 0x02, 131},
    {23, 0x02, 131},
    {31, 0x02, 131},
    {44, 0x03, 131},
  },
  /* 225 */
  {
    {229, 0x00, 0},
    {230, 0x00, 0},
    {232, 0x00, 0},
    {233, 0x00, 0},
    {236, 0x00, 0},
    {237, 0x00, 0},
    {239, 0x00, 0},
    {240, 0x00, 0},
    {244, 0x00, 0},
    {245, 0x00, 0},
    {247, 0x00, 0},
    {248, 0x00, 0},
    {251, 0x00, 0},
    {252, 0x00, 0},
    {254, 0x00, 0},
    {255, 0x00, 0},
  },
  /* 226 */
  {
    {0, 0x03, 132},
    {0, 0x03, 133},
    {0, 0x03, 134},
    {0, 0x03, 135},
    {0, 0x03, 136},
    {0, 0x03, 137},
    {0, 0x03, 138},
    {0, 0x03, 139},
    {0, 0x03, 140},
    {0, 0x03, 141},
    {0, 0x03, 142},
    {0, 0x03, 143},
    {0, 0x03, 144},
    {0, 0x03, 145},
    {0, 0x03, 146},
    {0, 0x03, 147},
  },
  /* 227 */
  {
    {1, 0x02, 132},
    {14, 0x03, 132},
    {1, 0x02, 133},
    {14, 0x03, 133},
    {1, 0x02, 134},
    {14, 0x03, 134},
    {1, 0x02, 135},
    {14, 0x03, 135},
    {1, 0x02, 136},
    {14, 0x03, 136},
    {1, 0x02, 137},
    {14, 0x03, 137},
    {1, 0x02, 138},
    {14, 0x03, 138},
    {1, 0x02, 139},
    {14, 0x03, 139},
  },
  /* 228 */
  {
    {2, 0x02, 132},
    {6, 0x02, 132},
    {15, 0x02, 132},
    {30, 0x03, 132},
    {2, 0x02, 133},
    {6, 0x02, 133},
    {15, 0x02, 133},
    {30, 0x03, 133},
    {2, 0x02, 134},
    {6, 0x02, 134},
    {15, 0x02, 134},
    {30, 0x03, 134},
    {2, 0x02, 135},
    {6, 0x02, 135},
    {15, 0x02, 135},
    {30, 0x03, 135},
  },
  /* 229 */
  {
    {3, 0x02, 132},
    {4, 0x02, 132},
    {7, 0x02, 132},
    {10, 0x02, 132},
    {16, 0x02, 132},
    {23, 0x02, 132},
    {31, 0x02, 132},
    {44, 0x03, 132},
    {3, 0x02, 133},
    {4, 0x02, 133},
    {7, 0x02, 133},
    {10, 0x02, 133},
    {16, 0x02, 133},
    {23, 0x02, 133},
    {31, 0x02, 133},
    {44, 0x03, 133},
  },
  /* 230 */
  {
    {3, 0x02, 134},
    {4, 0x02, 134},
    {7, 0x02, 134},
    {10, 0x02, 134},
    {16, 0x02, 134},
    {23, 0x02, 134},
    {31, 0x02, 134},
    {44, 0x03, 134},
    {3, 0x02, 135},
    {4, 0x02, 135},
    {7, 0x02, 135},
    {10, 0x02, 135},
    {16, 0x02, 135},
    {23, 0x02, 135},
    {31, 0x02, 135},
    {44, 0x03, 135},
  },
  /* 231 */
  {
    {2, 0x02, 136},
    {6, 0x02, 136},
    {15, 0x02, 136},
    {30, 0x03, 136},
    {2, 0x02, 137},
    {6, 0x02, 137},
    {15, 0x02, 137},
    {30, 0x03, 137},
    {2, 0x02, 138},
    {6, 0x02, 138},
    {15, 0x02, 138},
    {30, 0x03, 138},
    {2, 0x02, 139},
    {6, 0x02, 139},
    {15, 0x02, 139},
    {30, 0x03, 139},
  },
  /* 232 */
  {
    {3, 0x02, 136},
    {4, 0x02, 136},
    {7, 0x02, 136},
    {10, 0x02, 136},
    {16, 0x02, 136},
    {23, 0x02, 136},
    {31, 0x02, 136},
    {44, 0x03, 136},
    {3, 0x02, 137},
    {4, 0x02, 137},
    {7, 0x02, 137},
    {10, 0x02, 137},
    {16, 0x02, 137},
    {23, 0x02, 137},
    {31, 0x02, 137},
    {44, 0x03, 137},
  },
  /* 233 */
  {
    {3, 0x02, 138},
    {4, 0x02, 138},
    {7, 0x02, 138},
    {10, 0x02, 138},
    {16, 0x02, 138},
    {23, 0x02, 138},
    {31, 0x02, 138},
    {44, 0x03, 138},
    {3, 0x02, 139},
    {4, 0x02, 139},
    {7, 0x02, 139},
    {10, 0x02, 139},
    {16, 0x02, 139},
    {23, 0x02, 139},
    {31, 0x02, 139},
    {44, 0x03, 139},
  },
  /* 234 */
  {
    {1, 0x02, 140},
    {14, 0x03, 140},
    {1, 0x02, 141},
    {14, 0x03, 141},
    {1, 0x02, 142},
    {14, 0x03, 142},
    {1, 0x02, 143},
    {14, 0x03, 143},
    {1, 0x02, 144},
    {14, 0x03, 144},
    {1, 0x02, 145},
    {14, 0x03, 145},
    {1, 0x02, 146},
    {14, 0x03, 146},
    {1, 0x02, 147},
    {14, 0x03, 147},
  },
  /* 235 */
  {
    {2, 0x02, 140},
    {6, 0x02, 140},
    {15, 0x02, 140},
    {30, 0x03, 140},
    {2, 0x02, 141},
    {6, 0x02, 141},
    {15, 0x02, 141},
    {30, 0x03, 141},
    {2, 0x02, 142},
    {6, 0x02, 142},
    {15, 0x02, 142},
    {30, 0x03, 142},
    {2, 0x02, 143},
    {6, 0x02, 143},
    {15, 0x02, 143},
    {30, 0x03, 143},
  },
  /* 236 */
  {
    {3, 0x02, 140},
    {4, 0x02, 140},
    {7, 0x02, 140},
    {10, 0x02, 140},
    {16, 0x02, 140},
    {23, 0x02, 140},
    {31, 0x02, 140},
    {44, 0x03, 140},
    {3, 0x02, 141},
    {4, 0x02, 141},
    {7, 0x02, 141},
    {10, 0x02, 141},
    {16, 0x02, 141},
    {23, 0x02, 141},
    {31, 0x02, 141},
    {44, 0x03, 141},
  },
  /* 237 */
  {
    {3, 0x02, 142},
    {4, 0x02, 142},
    {7, 0x02, 142},
    {10, 0x02, 142},
    {16, 0x02, 142},
    {23, 0x02, 142},
    {31, 0x02, 142},
    {44, 0x03, 142},
    {3, 0x02, 143},
    {4, 0x02, 143},
    {7, 0x02, 143},
    {10, 0x02, 143},
    {16, 0x02, 143},
    {23, 0x02, 143},
    {31, 0x02, 143},
    {44, 0x03, 143},
  },
  /* 238 */
  {
    {2, 0x02, 144},
    {6, 0x02, 144},
    {15, 0x02, 144},
    {30, 0x03, 144},
    {2, 0x02, 145},
    {6, 0x02, 145},
    {15, 0x02, 145},
    {30, 0x03, 145},
    {2, 0x02, 146},
    {6, 0x02, 146},
    {15, 0x02, 146},
    {30, 0x03, 146},
    {2, 0x02, 147},
    {6, 0x02, 147},
    {15, 0x02, 147},
    {30, 0x03, 147},
  },
  /* 239 */
  {
    {3, 0x02, 144},
    {4, 0x02, 144},
    {7, 0x02, 144},
    {10, 0x02, 144},
    {16, 0x02, 144},
    {23, 0x02, 144},
    {31, 0x02, 144},
    {44, 0x03, 144},
    {3, 0x02, 145},
    {4, 0x02, 145},
    {7, 0x02, 145},
    {10, 0x02, 145},
    {16, 0x02, 145},
    {23, 0x02, 145},
    {31, 0x02, 145},
    {44, 0x03, 145},
  },
  /* 240 */
  {
    {3, 0x02, 146},
    {4, 0x02, 146},
    {7, 0x02, 146},
    {10, 0x02, 146},
    {16, 0x02, 146},
    {23, 0x02, 146},
    {31, 0x02, 146},
    {44, 0x03, 146},
    {3, 0x02, 147},
    {4, 0x02, 147},
    {7, 0x02, 147},
    {10, 0x02, 147},
    {16, 0x02, 147},
    {23, 0x02, 147},
    {31, 0x02, 147},
    {44, 0x03, 147},
  },
  /* 241 */
  {
    {0, 0x03, 148},
    {0, 0x03, 149},
    {0, 0x03, 150},
    {0, 0x03, 151},
    {0, 0x03, 152},
    {0, 0x03, 153},
    {0, 0x03, 154},
    {0, 0x03, 155},
    {0, 0x03, 156},
    {0, 0x03, 157},
    {0, 0x03, 158},
    {0, 0x03, 159},
    {0, 0x03, 160},
    {0, 0x03, 161},
    {0, 0x03, 162},
    {0, 0x03, 163},
  },
  /* 242 */
  {
    {1, 0x02, 148},
    {14, 0x03, 148},
    {1, 0x02, 149},
    {14, 0x03, 149},
    {1, 0x02, 150},
    {14, 0x03, 150},
    {1, 0x02, 151},
    {14, 0x03, 151},
    {1, 0x02, 152},
    {14, 0x03, 152},
    {1, 0x02, 153},
    {14, 0x03, 153},
    {1, 0x02, 154},
    {14, 0x03, 154},
    {1, 0x02, 155},
    {14, 0x03, 155},
  },
  /* 243 */
  {
    {2, 0x02, 148},
    {6, 0x02, 148},
    {15, 0x02, 148},
    {30, 0x03, 148},
    {2, 0x02, 149},
    {6, 0x02, 149},
    {15, 0x02, 149},
    {30, 0x03, 149},
    {2, 0x02, 150},
    {6, 0x02, 150},
    {15, 0x02, 150},
    {30, 0x03, 150},
    {2, 0x02, 151},
    {6, 0x02, 151},
    {15, 0x02, 151},
    {30, 0x03, 151},
  },
  /* 244 */
  {
    {3, 0x02, 148},
    {4, 0x02, 148},
    {7, 0x02, 148},
    {10, 0x02, 148},
    {16, 0x02, 148},
    {23, 0x02, 148},
    {31, 0x02, 148},
    {44, 0x03, 148},
    {3, 0x02, 149},
    {4, 0x02, 149},
    {7, 0x02, 149},
    {10, 0x02, 149},
    {16, 0x02, 149},
    {23, 0x02, 149},
    {31, 0x02, 149},
    {44, 0x03, 149},
  },
  /* 245 */
  {
    {3, 0x02, 150},
    {4, 0x02, 150},
    {7, 0x02, 150},
    {10, 0x02, 150},
    {16, 0x02, 150},
    {23, 0x02, 150},
    {31, 0x02, 150},
    {44, 0x03, 150},
    {3, 0x02, 151},
    {4, 0x02, 151},
    {7, 0x02, 151},
    {10, 0x02, 151},
    {16, 0x02, 151},
    {23, 0x02, 151},
    {31, 0x02, 151},
    {44, 0x03, 151},
  },
  /* 246 */
  {
    {2, 0x02, 152},
    {6, 0x02, 152},
    {15, 0x02, 152},
    {30, 0x03, 152},
    {2, 0x02, 153},
    {6, 0x02, 153},
    {15, 0x02, 153},
    {30, 0x03, 153},
    {2, 0x02, 154},
    {6, 0x02, 154},
    {15, 0x02, 154},
    {30, 0x03, 154},
    {2, 0x02, 155},
    {6, 0x02, 155},
    {15, 0x02, 155},
    {30, 0x03, 155},
  },
  /* 247 */
  {
    {3, 0x02, 152},
    {4, 0x02, 152},
    {7, 0x02, 152},
    {10, 0x02, 152},
    {16, 0x02, 152},
    {23, 0x02, 152},
    {31, 0x02, 152},
    {44, 0x03, 152},
    {3, 0x02, 153},
    {4, 0x02, 153},
    {7, 0x02, 153},
    {10, 0x02, 153},
    {16, 0x02, 153},
    {23, 0x02, 153},
    {31, 0x02, 153},
    {44, 0x03, 153},
  },
  /* 248 */
  {
    {3, 0x02, 154},
    {4, 0x02, 154},
    {7, 0x02, 154},
    {10, 0x02, 154},
    {16, 0x02, 154},
    {23, 0x02, 154},
    {31, 0x02, 154},
    {44, 0x03, 154},
    {3, 0x02, 155},
    {4, 0x02, 155},
    {7, 0x02, 155},
    {10, 0x02, 155},
    {16, 0x02, 155},
    {23, 0x02, 155},
    {31, 0x02, 155},
    {44, 0x03, 155},
  },
  /* 249 */
  {
    {1, 0x02, 156},
    {14, 0x03, 156},
    {1, 0x02, 157},
    {14, 0x03, 157},
    {1, 0x02, 158},
    {14, 0x03, 158},
    {1, 0x02, 159},
    {14, 0x03, 159},
    {1, 0x02, 160},
    {14, 0x03, 160},
    {1, 0x02, 161},
    {14, 0x03, 161},
    {1, 0x02, 162},
    {14, 0x03, 162},
    {1, 0x02, 163},
    {14, 0x03, 163},
  },
  /* 250 */
  {
    {2, 0x02, 156},
    {6, 0x02, 156},
    {15, 0x02, 156},
    {30, 0x03, 156},
    {2, 0x02, 157},
    {6, 0x02, 157},
    {15, 0x02, 157},
    {30, 0x03, 157},
    {2, 0x02, 158},
    {6, 0x02, 158},
    {15, 0x02, 158},
    {30, 0x03, 158},
    {2, 0x02, 159},
    {6, 0x02, 159},
    {15, 0x02, 159},
    {30, 0x03, 159},
  },
  /* 251 */
  {
    {3, 0x02, 156},
    {4, 0x02, 156},
    {7, 0x02, 156},
    {10, 0x02, 156},
    {16, 0x02, 156},
    {23, 0x02, 156},
    {31, 0x02, 156},
    {44, 0x03, 156},
    {3, 0x02, 157},
    {4, 0x02, 157},
    {7, 0x02, 157},
    {10, 0x02, 157},
    {16, 0x02, 157},
    {23, 0x02, 157},
    {31, 0x02, 157},
    {44, 0x03, 157},
  },
  /* 252 */
  {
    {3, 0x02, 158},
    {4, 0x02, 158},
    {7, 0x02, 158},
    {10, 0x02, 158},
    {16, 0x02, 158},
    {23, 0x02, 158},
    {31, 0x02, 158},
    {44, 0x03, 158},
    {3, 0x02, 159},
    {4, 0x02, 159},
    {7, 0x02, 159},
    {10, 0x02, 159},
    {16, 0x02, 159},
    {23, 0x02, 159},
    {31, 0x02, 159},
    {44, 0x03, 159},
  },
  /* 253 */
  {
    {2, 0x02, 160},
    {6, 0x02, 160},
    {15, 0x02, 160},
    {30, 0x03, 160},
    {2, 0x02, 161},
    {6, 0x02, 161},
    {15, 0x02, 161},
    {30, 0x03, 161},
    {2, 0x02, 162},
    {6, 0x02, 162},
    {15, 0x02, 162},
    {30, 0x03, 162},
    {2, 0x02, 163},
    {6, 0x02, 163},
    {15, 0x02, 163},
    {30, 0x03, 163},
  },
  /* 254 */
  {
    {3, 0x02, 160},
    {4, 0x02, 160},
    {7, 0x02, 160},
    {10, 0x02, 160},
    {16, 0x02, 160},
    {23, 0x02, 160},
    {31, 0x02, 160},
    {44, 0x03, 160},
    {3, 0x02, 161},
    {4, 0x02, 161},
    {7, 0x02, 161},
    {10, 0x02, 161},
    {16, 0x02, 161},
    {23, 0x02, 161},
    {31, 0x02, 161},
    {44, 0x03, 161},
  },
  /* 255 */
  {
    {3, 0x02, 162},
    {4, 0x02, 162},
    {7, 0x02, 162},
    {10, 0x02, 162},
    {16, 0x02, 162},
    {23, 0x02, 162},
    {31, 0x02, 162},
    {44, 0x03, 162},
    {3, 0x02, 163},
    {4, 0x02, 163},
    {7, 0x02, 163},
    {10, 0x02, 163},
    {16, 0x02, 163},
    {23, 0x02, 163},
    {31, 0x02, 163},
    {44, 0x03, 163},
  },
};
