/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1998 Samuel Fung, Dennis Sinitsky and Stephen Tang
File: b3soinoi.c          98/5/01
Modified by Hui Wan 02/3/5
Modified by Paolo Nenzi 2002
**********/

#include "ngspice.h"
#include "b3soidef.h"
#include "cktdefs.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "suffix.h"
#include "const.h"  /* jwan */

/*
 * B3SOInoise (mode, operation, firstModel, ckt, data, OnDens)
 *    This routine names and evaluates all of the noise sources
 *    associated with MOSFET's.  It starts with the model *firstModel and
 *    traverses all of its insts.  It then proceeds to any other models
 *    on the linked list.  The total output noise density generated by
 *    all of the MOSFET's is summed with the variable "OnDens".
 */

/*
 Channel thermal and flicker noises are calculated based on the value
 of model->B3SOInoiMod.
 If model->B3SOInoiMod = 1,
    Channel thermal noise = SPICE2 model
    Flicker noise         = SPICE2 model
 If model->B3SOInoiMod = 2,
    Channel thermal noise = B3SOI model
    Flicker noise         = B3SOI model
 If model->B3SOInoiMod = 3,
    Channel thermal noise = SPICE2 model
    Flicker noise         = B3SOI model
 If model->B3SOInoiMod = 4,
    Channel thermal noise = B3SOI model
    Flicker noise         = SPICE2 model
 */

extern void   NevalSrc();
extern double Nintegrate();

double
B3SOIStrongInversionNoiseEval(double vgs, double vds, B3SOImodel *model, 
                              B3SOIinstance *here, double freq, double temp)
{
struct b3soiSizeDependParam *pParam;
double cd, esat, DelClm, EffFreq, N0, Nl;
double T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, Ssi;

    pParam = here->pParam;
    cd = fabs(here->B3SOIcd) * here->B3SOIm;

/* v2.2.3 bug fix */
    if(model->B3SOIem<=0.0) DelClm = 0.0;
    else {
    	    esat = 2.0 * pParam->B3SOIvsattemp / here->B3SOIueff;
            T0 = ((((vds - here->B3SOIVdseff) / pParam->B3SOIlitl)
                + model->B3SOIem) / esat);
            DelClm = pParam->B3SOIlitl * log (MAX(T0, N_MINLOG));
    }


    EffFreq = pow(freq, model->B3SOIef);
    T1 = CHARGE * CHARGE * 8.62e-5 * cd * temp * here->B3SOIueff;
    T2 = 1.0e8 * EffFreq * model->B3SOIcox
       * pParam->B3SOIleff * pParam->B3SOIleff;

/* v2.2.3 bug fix */
    N0 = model->B3SOIcox * here->B3SOIVgsteff / CHARGE; 
    Nl = model->B3SOIcox * here->B3SOIVgsteff
         * (1.0 - here->B3SOIAbovVgst2Vtm * here->B3SOIVdseff) / CHARGE; 


    T3 = model->B3SOIoxideTrapDensityA
       * log(MAX(((N0 + 2.0e14) / (Nl + 2.0e14)), N_MINLOG));
    T4 = model->B3SOIoxideTrapDensityB * (N0 - Nl);
    T5 = model->B3SOIoxideTrapDensityC * 0.5 * (N0 * N0 - Nl * Nl);

    T6 = 8.62e-5 * temp * cd * cd;
    T7 = 1.0e8 * EffFreq * pParam->B3SOIleff
       * pParam->B3SOIleff * pParam->B3SOIweff * here->B3SOIm;
    T8 = model->B3SOIoxideTrapDensityA + model->B3SOIoxideTrapDensityB * Nl
       + model->B3SOIoxideTrapDensityC * Nl * Nl;
    T9 = (Nl + 2.0e14) * (Nl + 2.0e14);

    Ssi = T1 / T2 * (T3 + T4 + T5) + T6 / T7 * DelClm * T8 / T9;

    return Ssi;
}

int
B3SOInoise (int mode, int operation, GENmodel *inModel, CKTcircuit *ckt, 
            Ndata *data, double *OnDens)
{
B3SOImodel *model = (B3SOImodel *)inModel;
B3SOIinstance *here;
struct b3soiSizeDependParam *pParam;
char name[N_MXVLNTH];
double tempOnoise;
double tempInoise;
double noizDens[B3SOINSRCS];
double lnNdens[B3SOINSRCS];

double vgs, vds, Slimit;
double T1, T10, T11;
double Ssi, Swi;

int i;

    /* define the names of the noise sources */
    static char *B3SOInNames[B3SOINSRCS] =
    {   /* Note that we have to keep the order */
	".rd",              /* noise due to rd */
			    /* consistent with the index definitions */
	".rs",              /* noise due to rs */
			    /* in B3SOIdefs.h */
	".id",              /* noise due to id */
	".1overf",          /* flicker (1/f) noise */
        ".fb", 		    /* noise due to floating body */
	""                  /* total transistor noise */
    };

    for (; model != NULL; model = model->B3SOInextModel)
    {    for (here = model->B3SOIinstances; here != NULL;
	      here = here->B3SOInextInstance)
	 {    
	 
	      if (here->B3SOIowner != ARCHme)
	              continue;

	 
	      pParam = here->pParam;
	      switch (operation)
	      {  case N_OPEN:
		     /* see if we have to to produce a summary report */
		     /* if so, name all the noise generators */

		      if (((NOISEAN*)ckt->CKTcurJob)->NStpsSm != 0)
		      {   switch (mode)
			  {  case N_DENS:
			          for (i = 0; i < B3SOINSRCS; i++)
				  {    (void) sprintf(name, "onoise.%s%s",
					              here->B3SOIname,
						      B3SOInNames[i]);
                                       data->namelist = (IFuid *) trealloc(
					     (char *) data->namelist,
					     (data->numPlots + 1)
					     * sizeof(IFuid));
                                       if (!data->namelist)
					   return(E_NOMEM);
		                       (*(SPfrontEnd->IFnewUid)) (ckt,
			                  &(data->namelist[data->numPlots++]),
			                  (IFuid) NULL, name, UID_OTHER,
					  (void **) NULL);
				       /* we've added one more plot */
			          }
			          break;
		             case INT_NOIZ:
			          for (i = 0; i < B3SOINSRCS; i++)
				  {    (void) sprintf(name, "onoise_total.%s%s",
						      here->B3SOIname,
						      B3SOInNames[i]);
                                       data->namelist = (IFuid *) trealloc(
					     (char *) data->namelist,
					     (data->numPlots + 1)
					     * sizeof(IFuid));
                                       if (!data->namelist)
					   return(E_NOMEM);
		                       (*(SPfrontEnd->IFnewUid)) (ckt,
			                  &(data->namelist[data->numPlots++]),
			                  (IFuid) NULL, name, UID_OTHER,
					  (void **) NULL);
				       /* we've added one more plot */

			               (void) sprintf(name, "inoise_total.%s%s",
						      here->B3SOIname,
						      B3SOInNames[i]);
                                       data->namelist = (IFuid *) trealloc(
					     (char *) data->namelist,
					     (data->numPlots + 1)
					     * sizeof(IFuid));
                                       if (!data->namelist)
					   return(E_NOMEM);
		                       (*(SPfrontEnd->IFnewUid)) (ckt,
			                  &(data->namelist[data->numPlots++]),
			                  (IFuid) NULL, name, UID_OTHER,
					  (void **)NULL);
				       /* we've added one more plot */
			          }
			          break;
		          }
		      }
		      break;
	         case N_CALC:
		      switch (mode)
		      {  case N_DENS:
		              NevalSrc(&noizDens[B3SOIRDNOIZ],
				       &lnNdens[B3SOIRDNOIZ], ckt, THERMNOISE,
				       here->B3SOIdNodePrime, here->B3SOIdNode,
				       here->B3SOIdrainConductance * here->B3SOIm);

		              NevalSrc(&noizDens[B3SOIRSNOIZ],
				       &lnNdens[B3SOIRSNOIZ], ckt, THERMNOISE,
				       here->B3SOIsNodePrime, here->B3SOIsNode,
				       here->B3SOIsourceConductance * here->B3SOIm);

                              switch( model->B3SOInoiMod )
			      {  case 1:
			         case 3:
			              NevalSrc(&noizDens[B3SOIIDNOIZ],
				               &lnNdens[B3SOIIDNOIZ], ckt, 
					       THERMNOISE, here->B3SOIdNodePrime,
				               here->B3SOIsNodePrime,
                                               (2.0 / 3.0 * fabs( here->B3SOIm *
					       (here->B3SOIgm
				               + here->B3SOIgds
					       + here->B3SOIgmbs))));
				      break;
			         case 2:

/* v2.2.3 bug fix */
			         case 4:
		                      NevalSrc(&noizDens[B3SOIIDNOIZ],
				               &lnNdens[B3SOIIDNOIZ], ckt,
					       THERMNOISE, here->B3SOIdNodePrime,
                                               here->B3SOIsNodePrime,
					       (here->B3SOIueff
					       * fabs((here->B3SOIqinv * here->B3SOIm)
					       / (pParam->B3SOIleff
					       * pParam->B3SOIleff+
						 here->B3SOIueff*fabs
						 (here->B3SOIqinv * here->B3SOIm) *
						  (here->B3SOIrds / here->B3SOIm))))); 
				      break;
			      }
		              NevalSrc(&noizDens[B3SOIFLNOIZ], (double*) NULL,
				       ckt, N_GAIN, here->B3SOIdNodePrime,
				       here->B3SOIsNodePrime, (double) 0.0);

                              switch( model->B3SOInoiMod )
			      {  case 1:
			         case 4:
			              noizDens[B3SOIFLNOIZ] *= model->B3SOIkf
					    * exp(model->B3SOIaf
					    * log(MAX(fabs(here->B3SOIm * here->B3SOIcd),
					    N_MINLOG)))
					    / (pow(data->freq, model->B3SOIef)
					    * pParam->B3SOIleff
				            * pParam->B3SOIleff
					    * model->B3SOIcox);
				      break;
			         case 2:
			         case 3:
			              vgs = *(ckt->CKTstates[0] + here->B3SOIvgs);
		                      vds = *(ckt->CKTstates[0] + here->B3SOIvds);
			              if (vds < 0.0)
			              {   vds = -vds;
				          vgs = vgs + vds;
			              }
                                      if (vgs >= here->B3SOIvon + 0.1)
			              {   Ssi = B3SOIStrongInversionNoiseEval(vgs,
					      vds, model, here, data->freq,
					      ckt->CKTtemp);
                                          noizDens[B3SOIFLNOIZ] *= Ssi;
			              }
                                      else 
			              {   pParam = here->pParam;
				          T10 = model->B3SOIoxideTrapDensityA
					      * 8.62e-5 * ckt->CKTtemp;
		                          T11 = pParam->B3SOIweff * here->B3SOIm
					      * pParam->B3SOIleff
				              * pow(data->freq, model->B3SOIef)
				              * 4.0e36;
		                          Swi = T10 / T11 * here->B3SOIcd * here->B3SOIm
				              * here->B3SOIcd * here->B3SOIm;
                                          Slimit = B3SOIStrongInversionNoiseEval(
				               here->B3SOIvon + 0.1, vds, model,
					       here, data->freq, ckt->CKTtemp);
				          T1 = Swi + Slimit;
				          if (T1 > 0.0)
                                              noizDens[B3SOIFLNOIZ] *= (Slimit
								    * Swi) / T1; 
				          else
                                              noizDens[B3SOIFLNOIZ] *= 0.0;
			              }
				      break;
			      }

		              lnNdens[B3SOIFLNOIZ] =
				     log(MAX(noizDens[B3SOIFLNOIZ], N_MINLOG));

			      /* Low frequency excess noise due to FBE */
		              NevalSrc(&noizDens[B3SOIFBNOIZ], &lnNdens[B3SOIFBNOIZ],
				          ckt, SHOTNOISE, here->B3SOIsNodePrime,
				          here->B3SOIbNode, 
                                          2.0 * model->B3SOInoif * here->B3SOIibs * here->B3SOIm);

		              noizDens[B3SOITOTNOIZ] = noizDens[B3SOIRDNOIZ]
						     + noizDens[B3SOIRSNOIZ]
						     + noizDens[B3SOIIDNOIZ]
						     + noizDens[B3SOIFLNOIZ]
						     + noizDens[B3SOIFBNOIZ];
		              lnNdens[B3SOITOTNOIZ] = 
				     log(MAX(noizDens[B3SOITOTNOIZ], N_MINLOG));

		              *OnDens += noizDens[B3SOITOTNOIZ];

		              if (data->delFreq == 0.0)
			      {   /* if we haven't done any previous 
				     integration, we need to initialize our
				     "history" variables.
				    */

			          for (i = 0; i < B3SOINSRCS; i++)
				  {    here->B3SOInVar[LNLSTDENS][i] =
					     lnNdens[i];
			          }

			          /* clear out our integration variables
				     if it's the first pass
				   */
			          if (data->freq ==
				      ((NOISEAN*) ckt->CKTcurJob)->NstartFreq)
				  {   for (i = 0; i < B3SOINSRCS; i++)
				      {    here->B3SOInVar[OUTNOIZ][i] = 0.0;
				           here->B3SOInVar[INNOIZ][i] = 0.0;
			              }
			          }
		              }
			      else
			      {   /* data->delFreq != 0.0,
				     we have to integrate.
				   */
			          for (i = 0; i < B3SOINSRCS; i++)
				  {    if (i != B3SOITOTNOIZ)
				       {   tempOnoise = Nintegrate(noizDens[i],
						lnNdens[i],
				                here->B3SOInVar[LNLSTDENS][i],
						data);
				           tempInoise = Nintegrate(noizDens[i]
						* data->GainSqInv, lnNdens[i]
						+ data->lnGainInv,
				                here->B3SOInVar[LNLSTDENS][i]
						+ data->lnGainInv, data);
				           here->B3SOInVar[LNLSTDENS][i] =
						lnNdens[i];
				           data->outNoiz += tempOnoise;
				           data->inNoise += tempInoise;
				           if (((NOISEAN*)
					       ckt->CKTcurJob)->NStpsSm != 0)
					   {   here->B3SOInVar[OUTNOIZ][i]
						     += tempOnoise;
				               here->B3SOInVar[OUTNOIZ][B3SOITOTNOIZ]
						     += tempOnoise;
				               here->B3SOInVar[INNOIZ][i]
						     += tempInoise;
				               here->B3SOInVar[INNOIZ][B3SOITOTNOIZ]
						     += tempInoise;
                                           }
			               }
			          }
		              }
		              if (data->prtSummary)
			      {   for (i = 0; i < B3SOINSRCS; i++)
				  {    /* print a summary report */
			               data->outpVector[data->outNumber++]
					     = noizDens[i];
			          }
		              }
		              break;
		         case INT_NOIZ:
			      /* already calculated, just output */
		              if (((NOISEAN*)ckt->CKTcurJob)->NStpsSm != 0)
			      {   for (i = 0; i < B3SOINSRCS; i++)
				  {    data->outpVector[data->outNumber++]
					     = here->B3SOInVar[OUTNOIZ][i];
			               data->outpVector[data->outNumber++]
					     = here->B3SOInVar[INNOIZ][i];
			          }
		              }
		              break;
		      }
		      break;
	         case N_CLOSE:
		      /* do nothing, the main calling routine will close */
		      return (OK);
		      break;   /* the plots */
	      }       /* switch (operation) */
	 }    /* for here */
    }    /* for model */

    return(OK);
}



