#include "hp2graph.h"
#include "format.h"
#include "output.h"

static double xOffset = 30;
static double yOffset = 30;
static double mifscale = 1;
static int landscape = 1;
static double MifPosX,MifPosY;
static double MifStartX;
static double MifStartY;
static int MifFirst;
static Kind MifKind;

/*
 *      Print a string s in width w, escaping characters where necessary.
 */

static void EscapePrint(char* s)
{
  for ( ; *s; s++) {
    switch(*s) {
    case '>': case '<':  case '\'': case '`':              /* escape required */
      fputc('\\', outFile);
    }
    fputc(*s, outFile);
  }
}

#define XSize 792.0
#define YSize 612.0

#define PTCM(x) ((x)/28.4)

static double fixX(double x,double y)
{
  if(landscape)
    return mifscale*PTCM(x+xOffset);
  else
    return mifscale*PTCM(y+xOffset);
}

static double fixY(double x,double y)
{
  if(landscape)
    return mifscale*PTCM(YSize - y-2*yOffset);
  else
    return mifscale*PTCM(XSize - x-2*yOffset);
}

static void MifScale(double fscale)
{
  mifscale = fscale;
}

static void MifLandscape(void)
{
  landscape = 1;
}

static void MifPortrait(void)
{
  landscape = 0;
}

static void MifPrelude(double scale,int embedded)
{
  fprintf(outFile,"<MIFFile 3.00> # Generated by hp2fm\n");
  fprintf(outFile,"<Units Ucm >\n");
  fprintf(outFile,"<Page \n");
  fprintf(outFile," <PageType BodyPage >\n");
  fprintf(outFile," <PageNum `1'>\n");
  fprintf(outFile," <PageSize  %f cm %f cm>\n",PTCM(XSize),PTCM(YSize));
  fprintf(outFile," <PageOrientation %s >\n",landscape?"Landscape":"Portrait");
  fprintf(outFile," <PageBackground `Default'>\n");
}

static void MifFonts(void)
{
  return;
}

static void MifText(Justify just,double x,double y,int font,char *str)
{
  fprintf(outFile, "  <TextLine \n");
  switch(just) {
    case JustifyLeft:
      break;
    case JustifyCenter:
      x -= stringSize(str)/2;
      break;
    case JustifyRight:
      x -= stringSize(str);
      break;
    case JustifyVertical:
      y -= stringSize(str);
      break;
  }
  fprintf(outFile,"   <TLOrigin  %f cm %f cm>\n",fixX(x,y),fixY(x,y));
  fprintf(outFile,"   <Angle %d>\n",just == JustifyVertical?90:0);
  fprintf(outFile,"   <Font \n");
  fprintf(outFile,"    <FFamily `AvantGarde'>\n");
  fprintf(outFile,"    <FSize  %f pt>\n",mifscale*FontSize(font));
  fprintf(outFile,"    > # end of Font\n");
  fprintf(outFile,"   <String `");
  EscapePrint(str);
  fprintf(outFile,"'>\n");
  fprintf(outFile,"  > # end of TextLine\n");
}

static void MifPrologue(void)
{
  fprintf(outFile, "> # end of Page\n");
  fprintf(outFile, "# End of MIFFile\n");
}

static void MifPathNew(Kind kind,int size)
{
  if(kind == Closed)
    size++;
  fprintf(outFile, "  <PolyLine \n");
  fprintf(outFile, "   <Pen 0>\n");
  fprintf(outFile, "   <NumPoints %d>\n",size);
  MifPosX = MifPosY = 0;
  MifFirst = 1;
}

static void MifStart(double x,double y)
{
  if(MifFirst) {
    MifFirst = 0;
    MifStartX = x;
    MifStartY = y;
  }
}

static void MifPathMoveTo(double x, double y)
{
  MifPosX = x;
  MifPosY = y;
  MifStart(x,y);
  fprintf(outFile, "   <Point  %f cm %f cm>\n",fixX(x,y),fixY(x,y));
}

static void MifPathLineTo(double x, double y)
{
  MifPosX = x;
  MifPosY = y;
  MifStart(x,y);
  fprintf(outFile, "   <Point  %f cm %f cm>\n",fixX(x,y),fixY(x,y));
}

static void MifPathLine(double x, double y)
{
  MifPosX += x;
  MifPosY += y;
  MifStart(MifPosX,MifPosY);
  fprintf(outFile, "   <Point  %f cm %f cm>\n",fixX(MifPosX,MifPosY),fixY(MifPosX,MifPosY));
}

static int colours[] =
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9
 , 10, 11, 12,  0,  1,  2,  3,  4,  5,  6
 ,  7,  8
 };

static void MifPathFill(int fill)
{
    fprintf(outFile, "   <Fill %d>\n",colours[fill%22]);
}

static void MifPathWidth(double width)
{
    fprintf(outFile, "   <PenWidth %f>\n",width);
}

static void MifPathStroke(void)
{
  if(MifKind == Closed) {
    fprintf(outFile, "   <Point  %f cm %f cm>\n",fixX(MifStartX,MifStartY)
                                              ,fixY(MifStartX,MifStartY));
  }
  fprintf(outFile, "  > # end of PolyLine\n");
}

Format MifOutput =
 {".mif"
 ,MifPrelude
 ,MifPrologue
 ,MifScale
 ,MifLandscape
 ,MifPortrait
 ,MifFonts
 ,MifText

 ,MifPathNew
 ,MifPathMoveTo
 ,MifPathLineTo
 ,MifPathLine
 ,MifPathFill
 ,MifPathWidth
 ,MifPathStroke
 };
