/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import bossa.modules.Package;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.InternalError;
import bossa.util.Located;
import bossa.util.Location;

public final class Internal {
    public static void printStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            dispatch._printStackTraceWithSourceInfo(e);
            return;
        }
    }

    public static void warning(Located loc, String message) {
        Location l = loc.location();
        if (l == null) {
            Internal.warning(message);
        } else {
            Internal.warning(l + ":\n" + message);
        }
    }

    public static void warning(String message) {
        if (Debug.powerUser) {
            if (Debug.alwaysDumpStack) {
                Internal.printStackTrace();
            }
            if (Package.currentCompilation != null) {
                Package.currentCompilation.warning(null, "[Internal warning] " + message);
            } else {
                System.err.println("[Internal warning] " + message);
            }
        }
    }

    public static Error error(Located loc, String message, String dbgMsg) {
        if (Debug.powerUser) {
            return Internal.error(loc, message + dbgMsg);
        }
        return Internal.error(loc, message);
    }

    public static Error error(Located loc, String message) {
        Location l = loc.location();
        if (l == null) {
            return Internal.error(message);
        }
        return Internal.error(l + ":\n" + message);
    }

    public static Error error(String message, String dbgMsg) {
        if (Debug.powerUser) {
            return Internal.error(message + dbgMsg);
        }
        return Internal.error(message);
    }

    public static Error error(String message) {
        throw new InternalError(message);
    }

    public static Error error(Throwable e) {
        String msg;
        if (e instanceof ExceptionInInitializerError) {
            System.out.println("Exception in initializer");
            e.printStackTrace();
            e = ((ExceptionInInitializerError)e).getException();
        }
        if ((msg = e.getMessage()) == null) {
            msg = "";
        }
        System.out.println("[Internal error]\n" + msg);
        System.out.println("Upstream error:\n");
        e.printStackTrace();
        System.out.println("Internal error:\n");
        Internal.printStackTrace();
        System.exit(1);
        return null;
    }
}

