/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Chronometer {
    private static List chronometers = new LinkedList();
    private String name;
    private long total = 0L;
    private long startTime = -1L;
    private long stopTime = -1L;
    private boolean running = false;

    public static Chronometer make(String name) {
        Chronometer res = new Chronometer(name);
        chronometers.add(res);
        return res;
    }

    public static void printAll() {
        Iterator i = chronometers.iterator();
        while (i.hasNext()) {
            System.out.println(((Chronometer)i.next()).toString());
        }
    }

    private Chronometer(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name + ": " + this.getTotalTime() + " ms";
    }

    public void start() {
        if (this.running) {
            throw new Error("Already running");
        }
        this.running = true;
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        if (!this.running) {
            throw new Error("Not running");
        }
        this.running = false;
        this.total += this.stopTime - this.startTime;
    }

    public long getTotalTime() {
        if (this.running) {
            throw new Error("Running");
        }
        return this.total;
    }
}

