/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Values;

public class SimpleIfExp
extends IfExp {
    public SimpleIfExp(Expression i, Expression t, Expression e) {
        super(i, t, e);
    }

    public static Expression make(Expression i, Expression t, Expression e) {
        if (i == QuoteExp.trueExp) {
            return t;
        }
        if (i == QuoteExp.falseExp) {
            return e;
        }
        return new SimpleIfExp(i, t, e);
    }

    @Override
    public void compile(Compilation comp, Target target) {
        SimpleIfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, comp, target);
    }

    public static void compile(Expression test2, Expression then_clause, Expression else_clause, Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Label elseLabel = new Label(code);
        Branchable branchOp = test2.getBranchable();
        if (branchOp != null) {
            branchOp.compileJumpNot(comp, ((ApplyExp)test2).getArgs(), elseLabel);
        } else {
            StackTarget stack = new StackTarget(Type.boolean_type);
            test2.compile(comp, stack);
            code.emitGotoIfIntEqZero(elseLabel);
        }
        code.emitIfThen();
        then_clause.compileWithPosition(comp, target);
        if (else_clause instanceof QuoteExp && ((QuoteExp)else_clause).getValue() == Values.empty) {
            code.setUnreachable();
            elseLabel.define(code);
        } else {
            code.emitElse();
            elseLabel.define(code);
            else_clause.compileWithPosition(comp, target);
        }
        code.emitFi();
    }
}

