/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Future;
import gnu.mapping.LogWriter;
import gnu.mapping.Printable;
import gnu.mapping.SFormat;
import gnu.text.PrettyWriter;
import gnu.text.WriterManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;

public class OutPort
extends PrintWriter
implements Printable,
Consumer {
    String name;
    private Writer base;
    PrettyWriter bout;
    protected int index;
    public boolean printReadable;
    private static OutPort outInitial;
    private static OutPort out;
    private static OutPort errInitial;
    private static OutPort err;
    static Writer logFile;
    protected static final int WORD = -2;
    protected int prev = 10;
    NumberFormat numberFormat;
    public FormatToConsumer objectFormat;

    OutPort(Writer base, PrettyWriter out, boolean autoflush) {
        super((Writer)out, autoflush);
        this.bout = out;
        this.base = base;
        this.index = WriterManager.instance.register(out);
    }

    public OutPort(Writer base, boolean printPretty, boolean autoflush) {
        this(base, new PrettyWriter(base, printPretty), autoflush);
    }

    public OutPort(Writer base, boolean printPretty, boolean autoflush, String name) {
        this(base, new PrettyWriter(base, printPretty), autoflush);
        this.name = name;
    }

    public OutPort(OutputStream out) {
        this(out, null);
    }

    public OutPort(OutputStream out, String name) {
        this((Writer)new OutputStreamWriter(out), true, name);
    }

    public OutPort(Writer out) {
        this(out, false, false);
    }

    public OutPort(Writer base, String name) {
        this(base, false, false);
        this.name = name;
    }

    public OutPort(Writer base, boolean autoflush, String name) {
        this(base, false, autoflush);
        this.name = name;
    }

    public static OutPort outDefault() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return ((Future)thread).out;
        }
        return out;
    }

    public static void setOutDefault(OutPort o) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            ((Future)thread).out = o;
        } else {
            out = o;
        }
    }

    public static OutPort errDefault() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return ((Future)thread).err;
        }
        return err;
    }

    public static void setErrDefault(OutPort e) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            ((Future)thread).err = e;
        } else {
            err = e;
        }
    }

    public void echo(char[] buf, int off, int len) throws IOException {
        if (this.base instanceof LogWriter) {
            ((LogWriter)this.base).echo(buf, off, len);
        }
    }

    public static void closeLogFile() throws IOException {
        if (logFile != null) {
            logFile.close();
            logFile = null;
        }
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile((Writer)null);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile((Writer)null);
        }
    }

    public static void setLogFile(String name) throws IOException {
        if (logFile != null) {
            OutPort.closeLogFile();
        }
        logFile = new PrintWriter(new BufferedWriter(new FileWriter(name)));
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile(logFile);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile(logFile);
        }
    }

    protected static final boolean isWordChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-' || ch == '+';
    }

    private void startWord() {
        this.prev = -2;
    }

    @Override
    public void write(int c) {
        super.write(c);
        this.prev = c;
    }

    @Override
    public void write(char[] buffer, int start, int count) {
        if (count > 0) {
            super.write(buffer, start, count);
            this.prev = buffer[start + count - 1];
        }
    }

    @Override
    public void write(String v) {
        int len = v.length();
        if (len == 0) {
            return;
        }
        this.prev = v.charAt(len - 1);
        super.write(v);
    }

    @Override
    public void writeChar(int i) {
        this.write(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSchemeObject(Object obj, boolean readable) {
        boolean saveReadable = this.printReadable;
        try {
            this.printReadable = readable;
            SFormat.print(obj, this);
        }
        finally {
            this.printReadable = saveReadable;
        }
    }

    @Override
    public void print(char v) {
        super.print(v);
        this.prev = v;
    }

    @Override
    public void print(int v) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(long v) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(double v) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(float v) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(v);
        } else {
            this.print(this.numberFormat.format(v));
        }
    }

    @Override
    public void print(String v) {
        this.write(v == null ? "(null)" : v);
    }

    @Override
    public void print(Object v) {
        this.startWord();
        if (this.objectFormat != null) {
            this.objectFormat.writeObject(v, this);
        } else if (v instanceof Consumable) {
            ((Consumable)v).consume(this);
        } else {
            super.print(v == null ? "null" : v);
        }
    }

    @Override
    public void print(PrintWriter ps) {
        ps.print("#<output-port");
        if (this.name != null) {
            ps.print(' ');
            ps.print(this.name);
        }
        ps.print('>');
    }

    @Override
    public void writeBoolean(boolean v) {
        this.print(v);
    }

    @Override
    public void writeFloat(float v) {
        this.print(v);
    }

    @Override
    public void writeDouble(double v) {
        this.print(v);
    }

    @Override
    public void writeInt(int v) {
        this.print(v);
    }

    @Override
    public void writeLong(long v) {
        this.print(v);
    }

    @Override
    public void beginGroup(String typeName, Object type) {
        if (this.objectFormat != null) {
            this.objectFormat.beginGroup(typeName, type, this);
        } else {
            this.print('(');
            this.print(typeName);
        }
    }

    @Override
    public void endGroup(String typeName) {
        if (this.objectFormat != null) {
            this.objectFormat.endGroup(typeName, this);
        } else {
            out.print(')');
        }
        this.prev = 41;
    }

    @Override
    public void beginAttribute(String attrName, Object attrType) {
        this.print(' ');
        this.print(attrName);
        this.print(": ");
        this.prev = -2;
    }

    @Override
    public void endAttribute() {
        this.prev = -2;
        this.print(' ');
    }

    @Override
    public void writeObject(Object v) {
        this.print(v);
    }

    @Override
    public boolean ignoring() {
        return false;
    }

    @Override
    public void writeChars(String str) {
        this.print(str);
    }

    public void freshLine() {
        int col = this.bout.getColumnNumber();
        if (col != 0) {
            this.println();
        }
    }

    public int getColumnNumber() {
        return this.bout.getColumnNumber();
    }

    public void setColumnNumber(int column) {
        this.bout.setColumnNumber(column);
    }

    public void clearBuffer() {
        this.bout.clearBuffer();
    }

    @Override
    public void close() {
        super.close();
        WriterManager.instance.unregister(this.index);
    }

    public static void runCleanups() {
        WriterManager.instance.run();
    }

    public void startLogicalBlock(String prefix, boolean perLine, String suffix) {
        this.bout.startLogicalBlock(prefix, perLine, suffix);
    }

    public void startLogicalBlock(String prefix, String suffix, int indent) {
        this.bout.startLogicalBlock(prefix, false, suffix);
        this.bout.addIndentation(prefix == null ? indent : indent - prefix.length(), false);
    }

    public void endLogicalBlock(String suffix) {
        this.bout.endLogicalBlock(suffix);
    }

    public void writeBreak(int kind) {
        this.bout.writeBreak(kind);
    }

    public void writeSpaceLinear() {
        this.write(32);
        this.writeBreak(78);
    }

    public void writeBreakLinear() {
        this.writeBreak(78);
    }

    public void writeSpaceFill() {
        this.write(32);
        this.writeBreak(70);
    }

    public void writeBreakFill() {
        this.writeBreak(70);
    }

    public void setIndentation(int amount, boolean current) {
        this.bout.addIndentation(amount, current);
    }

    static {
        out = outInitial = new OutPort(new LogWriter(new BufferedWriter(new OutputStreamWriter(System.out))), true, true, "<stdout>");
        err = errInitial = new OutPort(new LogWriter(new OutputStreamWriter(System.err)), true, true, "<stderr>");
    }
}

