/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;

public class Assert
extends ProcedureN
implements Inlineable {
    private boolean assertEnableCheck;
    private static final Assert instance = new Assert(true);
    private static final Assert contractInstance = new Assert(false);
    private static final ClassType errorClass = ClassType.make("nice.lang.AssertionFailed");
    private static Method errorInit;
    private static Method errorInitString;
    private static Method errorToString;

    public Assert(boolean assertEnableCheck) {
        this.assertEnableCheck = assertEnableCheck;
    }

    public static Assert create(String param) {
        if (param == null) {
            return instance;
        }
        return contractInstance;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Branchable branchOp;
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        Label end = new Label(code);
        if (this.assertEnableCheck && args[0] != QuoteExp.falseExp) {
            code.ifAssertionsDisabledGoto(((ClassExp)comp.topLambda).getAssertionEnabledField(), end);
        }
        if ((branchOp = args[0].getBranchable()) != null) {
            branchOp.compileJump(comp, ((ApplyExp)args[0]).getArgs(), end);
        } else if (args[0] != QuoteExp.falseExp) {
            args[0].compile(comp, Type.boolean_type);
            code.emitGotoIfIntNeZero(end);
        }
        code.emitNew(errorClass);
        code.emitDup();
        Assert.prepare();
        if (args.length == 1) {
            code.emitInvokeSpecial(errorInit);
        } else {
            args[1].compile(comp, Target.pushObject);
            if (args[1].getType().getName().equals(Type.string_type.getName())) {
                code.emitInvokeSpecial(errorInitString);
            } else {
                code.emitInvokeVirtual(errorToString);
                code.emitInvokeSpecial(errorInitString);
            }
        }
        code.emitThrow();
        target.compileFromStack(comp, Type.void_type);
        end.define(code);
    }

    private static void prepare() {
        if (errorInit != null) {
            return;
        }
        errorInit = errorClass.addMethod("<init>", 1, new Type[0], Type.void_type);
        errorInitString = errorClass.addMethod("<init>", 1, new Type[]{Type.string_type}, Type.void_type);
        errorToString = Type.pointer_type.addMethod("toString", 1, new Type[0], Type.string_type);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.void_type;
    }

    @Override
    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

