/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.util;

import java.lang.reflect.InvocationTargetException;

public class JDK {
    public static String replaceAll(String source, String what, String with) {
        int index = source.indexOf(what);
        if (index == -1) {
            return source;
        }
        int len = what.length();
        int last = 0;
        StringBuffer res = new StringBuffer(source.length() * 2);
        while (index != -1) {
            res.append(source.substring(last, index));
            res.append(with);
            last = index + len;
            index = source.indexOf(what, last);
        }
        res.append(source.substring(last));
        return res.toString();
    }

    public static void setDefaultAssertionStatus(ClassLoader loader, boolean st) throws InvocationTargetException {
        try {
            ClassLoader.class.getDeclaredMethod("setDefaultAssertionStatus", Boolean.TYPE).invoke((Object)loader, new Boolean(st));
        }
        catch (NoSuchMethodException e) {
            System.setProperty("assertions", new Boolean(st).toString());
        }
        catch (IllegalAccessException e) {
            throw new Error("ClassLoader.setDefaultAssertionStatus must be public");
        }
    }

    public static Object[] getStackTrace(Throwable t) throws InvocationTargetException {
        try {
            return (Object[])Throwable.class.getMethod("getStackTrace", null).invoke((Object)t, null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new Error("Throwable.getStackTrace must be public");
        }
    }

    private static Object call(Object o, String method) throws InvocationTargetException {
        try {
            return o.getClass().getDeclaredMethod(method, null).invoke(o, null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new Error("" + o.getClass() + "." + method + " must be public");
        }
    }

    public static String stackFileName(Object stackTraceElement) throws InvocationTargetException {
        return (String)JDK.call(stackTraceElement, "getFileName");
    }

    public static String stackMethodName(Object stackTraceElement) throws InvocationTargetException {
        return (String)JDK.call(stackTraceElement, "getMethodName");
    }

    public static String stackClassName(Object stackTraceElement) throws InvocationTargetException {
        return (String)JDK.call(stackTraceElement, "getClassName");
    }

    public static int stackLineNumber(Object stackTraceElement) throws InvocationTargetException {
        return (Integer)JDK.call(stackTraceElement, "getLineNumber");
    }
}

