/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import bossa.syntax.StringConstantExp;
import bossa.syntax.TypeConstantExp;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.expr.QuoteExp;
import java.math.BigInteger;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import nice.tools.code.Types;

public class ConstantExp
extends Expression {
    protected LocatedString className = null;
    public Object value;
    private String representation;
    public TypeConstructor tc;

    ConstantExp() {
    }

    ConstantExp(Polytype type, TypeConstructor tc, Object value, String representation, Location location) {
        this.type = type;
        this.tc = tc;
        this.value = value;
        this.representation = representation;
        this.setLocation(location);
    }

    ConstantExp(TypeConstructor tc, Object value, String representation, Location location) {
        this(new Polytype(Monotype.sure(new MonotypeConstructor(tc, null))), tc, value, representation, location);
    }

    ConstantExp(TypeConstructor tc, String representation, Location location) {
        this(tc, null, representation, location);
    }

    public ConstantExp(Object value) {
        this.value = value;
        this.representation = value.toString();
    }

    boolean isZero() {
        return ((Number)this.value).intValue() == 0;
    }

    public boolean isNumber() {
        return this.value instanceof Number && !(this.value instanceof Character);
    }

    void computeType() {
    }

    protected gnu.expr.Expression compile() {
        if (this.value == null) {
            Internal.warning(this + "[" + this.getClass() + " has no value");
        }
        if (this.value instanceof VarSymbol) {
            return ((VarSymbol)this.value).compile();
        }
        return new QuoteExp(this.value, Types.javaType(this.type));
    }

    public String toString() {
        return this.representation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConstantExp makeChar(LocatedString value) {
        int c;
        String s = value.toString();
        if (s.length() != 0 && s.charAt(0) == '\\') {
            if (s.length() == 2) {
                char c2 = s.charAt(1);
                switch (c2) {
                    case 'b': {
                        c = 8;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case 't': {
                        c = 9;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case 'n': {
                        c = 10;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case 'f': {
                        c = 12;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case 'r': {
                        c = 13;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case '\"': {
                        c = 34;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case '\'': {
                        c = 39;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                    case '\\': {
                        c = 92;
                        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
                    }
                }
            }
            try {
                int code = Integer.parseInt(s.substring(1), 8);
                if (code < 0) throw new NumberFormatException();
                if (code > 255) {
                    throw new NumberFormatException();
                }
                c = (char)code;
                return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
            }
            catch (NumberFormatException e) {
                throw User.error((Located)value, "Invalid escape sequence: " + value);
            }
        }
        if (s.length() != 1) {
            User.error((Located)value, "Invalid character constant: " + value);
        }
        c = s.charAt(0);
        return new ConstantExp(PrimitiveType.charTC, new Character((char)c), "'" + s + "'", value.location());
    }

    private static ConstantExp makeInt(long value, boolean isLong, Location location) {
        Number object;
        TypeConstructor tc;
        Polytype type;
        if (value >= -128L && value <= 127L && !isLong) {
            type = PrimitiveType.bytePolytype;
            tc = PrimitiveType.byteTC;
            object = new Byte((byte)value);
        } else if (value >= -32768L && value <= 32767L && !isLong) {
            type = PrimitiveType.shortPolytype;
            tc = PrimitiveType.shortTC;
            object = new Short((short)value);
        } else if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE && !isLong) {
            type = PrimitiveType.intPolytype;
            tc = PrimitiveType.intTC;
            object = new Integer((int)value);
        } else {
            type = PrimitiveType.longPolytype;
            tc = PrimitiveType.longTC;
            object = new Long(value);
        }
        return new ConstantExp(type, tc, object, "" + value + (isLong ? "L" : ""), location);
    }

    public static ConstantExp makeNumber(LocatedString representation) {
        boolean isLong;
        int lastCharIndex;
        String rep = representation.toString();
        char last = rep.charAt(lastCharIndex = rep.length() - 1);
        boolean bl = isLong = last == 'l' || last == 'L';
        if (isLong) {
            rep = rep.substring(0, lastCharIndex);
        }
        try {
            long value = ConstantExp.parse(rep);
            return ConstantExp.makeInt(value, isLong, representation.location());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            User.error((Located)representation, rep + " is not a valid number");
            return null;
        }
    }

    public ConstantExp makeNegative() {
        LocatedString newRepres = new LocatedString("-" + this.representation, this.location());
        if (this.value instanceof Float || this.value instanceof Double) {
            return ConstantExp.makeFloating(newRepres);
        }
        return ConstantExp.makeNumber(newRepres);
    }

    private static long parse(String rep) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (rep.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (rep.startsWith("0x", index) || rep.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (rep.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (rep.startsWith("0", index) && rep.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (rep.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        long result = new BigInteger(rep.substring(index), radix).longValue();
        if (negative) {
            result = -result;
        }
        return result;
    }

    public static ConstantExp makeFloating(LocatedString representation) {
        String repres = representation.toString();
        if (repres.endsWith("F") || repres.endsWith("f")) {
            float value = Float.parseFloat(repres);
            return new ConstantExp(PrimitiveType.floatTC, new Float(value), value + "f", representation.location());
        }
        double value = Double.parseDouble(repres);
        return new ConstantExp(PrimitiveType.doubleTC, new Double(value), value + "", representation.location());
    }

    public static ConstantExp makeString(LocatedString representation) {
        StringConstantExp res = new StringConstantExp(representation.toString());
        res.setLocation(representation.location());
        return res;
    }

    public static ConstantExp makeType(LocatedString representation) {
        return new TypeConstantExp(representation);
    }

    public static ConstantExp makeBoolean(boolean value, Location location) {
        return new Boolean(value, location);
    }

    public long longValue() {
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        return ((Number)this.value).longValue();
    }

    public boolean equals(Object other) {
        return other instanceof ConstantExp && this.value.equals(((ConstantExp)other).value);
    }

    private static class Boolean
    extends ConstantExp {
        private QuoteExp compiledValue;

        Boolean(boolean value, Location location) {
            super(PrimitiveType.boolTC, value ? "true" : "false", location);
            this.compiledValue = value ? QuoteExp.trueExp : QuoteExp.falseExp;
        }

        boolean isFalse() {
            return this.compiledValue == QuoteExp.falseExp;
        }

        boolean isTrue() {
            return this.compiledValue == QuoteExp.trueExp;
        }

        protected gnu.expr.Expression compile() {
            return this.compiledValue;
        }
    }
}

