/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.IdentExp;
import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Located;
import bossa.util.Location;
import gnu.expr.CheckContract;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Monotype;
import nice.tools.typing.Types;

public class Contract {
    private static final String assertName = "alwaysAssert";
    private List pre = new LinkedList();
    private List post = new LinkedList();
    private StringBuffer requireRepr = new StringBuffer("requires ");
    private StringBuffer ensureRepr = new StringBuffer("ensures ");
    private Expression[] preExp;
    private Expression[] postExp;
    private MonoSymbol result;
    public static final Contract noContract = new Contract(){

        void resolve(VarScope scope, TypeScope typeScope) {
        }

        void typecheck() {
        }

        public gnu.expr.Expression compile(gnu.expr.Expression body) {
            return body;
        }

        public String toString() {
            return "";
        }
    };

    public void addRequire(Expression condition) {
        this.pre.add(CallExp.create(this.symbol(assertName, condition), condition));
        this.requireRepr.append(condition).append(',');
    }

    public void addRequire(Expression condition, Expression name) {
        this.pre.add(CallExp.create(this.symbol(assertName, condition), condition, name));
        this.requireRepr.append(condition).append(':').append(name).append(',');
    }

    public void addEnsure(Expression condition) {
        this.post.add(CallExp.create(this.symbol(assertName, condition), condition));
        this.ensureRepr.append(condition);
    }

    public void addEnsure(Expression condition, Expression name) {
        this.post.add(CallExp.create(this.symbol(assertName, condition), condition, name));
        this.ensureRepr.append(condition).append(':').append(name).append(',');
    }

    private Expression symbol(String name, Located loc) {
        return new IdentExp(new LocatedString(name, loc.location()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(VarScope scope, TypeScope typeScope, Monotype resultType, Location location) {
        this.preExp = new Expression[this.pre.size()];
        int n = 0;
        Iterator i = this.pre.iterator();
        while (i.hasNext()) {
            this.preExp[n++] = dispatch.analyse((Expression)i.next(), scope, typeScope);
        }
        if (this.post.size() == 0) {
            this.postExp = Expression.noExpressions;
            return;
        }
        if (!Types.isVoid(resultType)) {
            this.result = new MonoSymbol(new LocatedString("result", location), resultType){

                boolean isAssignable() {
                    return false;
                }

                gnu.expr.Expression compile() {
                    return CheckContract.result;
                }
            };
        }
        try {
            if (this.result != null) {
                scope.addSymbol(this.result);
            }
            this.postExp = new Expression[this.post.size()];
            n = 0;
            i = this.post.iterator();
            while (i.hasNext()) {
                this.postExp[n++] = dispatch.analyse((Expression)i.next(), scope, typeScope);
            }
            Object var8_7 = null;
            if (this.result != null) {
                scope.removeSymbol(this.result);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (this.result != null) {
                scope.removeSymbol(this.result);
            }
            throw throwable;
        }
    }

    void typecheck() {
        int i;
        for (i = 0; i < this.preExp.length; ++i) {
            dispatch.typecheck(this.preExp[i]);
        }
        for (i = 0; i < this.postExp.length; ++i) {
            dispatch.typecheck(this.postExp[i]);
        }
    }

    public gnu.expr.Expression compile(gnu.expr.Expression body) {
        return new CheckContract(Expression.compile(this.preExp), Expression.compile(this.postExp), body);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        if (this.preExp != null && this.preExp.length > 0) {
            res.append(this.requireRepr.toString());
        }
        if (this.postExp != null && this.postExp.length > 0) {
            res.append(this.ensureRepr.toString());
        }
        return res.toString();
    }
}

