/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.VoidConstantExp;
import gnu.expr.BeginExp;
import gnu.expr.QuoteExp;
import gnu.expr.SimpleIfExp;
import mlsub.typing.Polytype;
import nice.tools.code.SpecialTypes;

public class IfExp
extends Expression {
    Expression condition;
    Expression thenExp;
    Expression elseExp;
    boolean thenUnreachable;
    boolean elseUnreachable;

    public IfExp(Expression condition, Expression thenExp, Expression elseExp) {
        if (elseExp == null) {
            elseExp = new VoidConstantExp();
        }
        this.condition = condition;
        this.thenExp = thenExp;
        this.elseExp = elseExp;
    }

    void computeType() {
        this.type = Polytype.union(this.thenExp.getType(), this.elseExp.getType());
    }

    public gnu.expr.Expression compile() {
        gnu.expr.Expression thenCode = this.thenExp.generateCode();
        gnu.expr.Expression elseCode = this.elseExp.generateCode();
        if (elseCode.getType() == SpecialTypes.voidType) {
            thenCode = IfExp.voidify(thenCode);
        } else if (thenCode.getType() == SpecialTypes.voidType) {
            elseCode = IfExp.voidify(elseCode);
        }
        return new SimpleIfExp(this.condition.generateCode(), thenCode, elseCode);
    }

    private static gnu.expr.Expression voidify(gnu.expr.Expression e) {
        if (e.getType().isVoid()) {
            return e;
        }
        return new BeginExp(e, QuoteExp.voidExp);
    }

    public String toString() {
        return "if(" + String.valueOf(this.condition) + ")\n" + String.valueOf(this.thenExp) + "\nelse\n" + String.valueOf(this.elseExp) + "\n";
    }
}

