/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.LocatedString;
import bossa.syntax.Macro;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.util.Located;
import bossa.util.User;
import gnu.expr.Inlineable;
import gnu.expr.QuoteExp;
import gnu.mapping.Procedure;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nice.tools.code.Gen;
import nice.tools.util.DirectoryClassLoader;

public class InlinedMethod
extends MethodDeclaration {
    static ClassLoader loader;
    private static Class[] string1;
    private LocatedString inlineProcedure;
    private String parameter;
    private Procedure procedure;

    public InlinedMethod(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters, LocatedString inlineProcedure, String parameter) {
        super(name, constraint, returnType, parameters);
        this.inlineProcedure = inlineProcedure;
        this.parameter = parameter;
    }

    void typecheck() {
        super.typecheck();
        this.getProcedure();
    }

    private Procedure getProcedure() {
        if (this.procedure != null) {
            return this.procedure;
        }
        Class refClass = null;
        try {
            refClass = this.findClass(this.inlineProcedure.toString());
        }
        catch (ClassNotFoundException e) {
            User.error((Located)this.inlineProcedure, "Inlined method " + this.inlineProcedure + " was not found");
        }
        Method m = null;
        try {
            m = refClass.getMethod("create", string1);
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException e) {
            User.error((Located)this.inlineProcedure, "Inlined method " + this.inlineProcedure + " has no static create(String)");
        }
        Object o = null;
        try {
            o = m.invoke(null, this.parameter);
        }
        catch (InvocationTargetException e) {
            Throwable realEx = e.getTargetException();
            User.error((Located)this.inlineProcedure, "Inlined method " + this.inlineProcedure + ": " + realEx);
        }
        catch (IllegalAccessException e) {
            User.error((Located)this.inlineProcedure, "Inlined method " + this.inlineProcedure + ": could not call create method", e.getMessage());
        }
        if (!(o instanceof Procedure)) {
            User.error((Located)this.inlineProcedure, "Inlined method " + this.inlineProcedure + " should be a subclass of gnu.mapping.Procedure");
        }
        if (!(o instanceof Inlineable)) {
            User.warning(this.inlineProcedure, "Inlined method " + this.inlineProcedure + " cannot be inlined, but will be called anyway");
        }
        this.procedure = (Procedure)o;
        return this.procedure;
    }

    private Class findClass(String name) throws ClassNotFoundException {
        if (loader == null) {
            return Class.forName(name);
        }
        return loader.loadClass(name);
    }

    protected gnu.expr.Expression computeCode() {
        return new QuoteExp(this.getProcedure());
    }

    gnu.expr.Expression getCode() {
        return Gen.wrapInLambda(this.getProcedure());
    }

    void checkSpecialRequirements(Expression[] arguments) {
        if (this.getProcedure() instanceof Macro) {
            ((Macro)((Object)this.procedure)).checkSpecialRequirements(arguments);
        }
    }

    public void printInterface(PrintWriter s) {
        s.print(super.toString() + " = inline " + this.inlineProcedure + (this.parameter != null ? "(\"" + this.parameter + "\");\n" : ";\n"));
    }

    static {
        String inlinedMethodsRepository = System.getProperty("nice.inlined");
        if (inlinedMethodsRepository != null) {
            loader = new DirectoryClassLoader(new File[]{new File(inlinedMethodsRepository)}, null){

                protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> res = this.findLoadedClass(name);
                    if (res == null) {
                        try {
                            res = this.findClass(name);
                        }
                        catch (ClassNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    if (res == null) {
                        ClassLoader parent = this.getParent();
                        if (parent == null) {
                            parent = ClassLoader.getSystemClassLoader();
                        }
                        res = parent.loadClass(name);
                    }
                    if (resolve && res != null) {
                        this.resolveClass(res);
                    }
                    return res;
                }
            };
        }
        string1 = new Class[]{"".getClass()};
    }
}

