/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Dispatch;
import bossa.modules.Compilation;
import bossa.syntax.JavaFieldAccess;
import bossa.syntax.JavaMethod;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Node;
import bossa.syntax.RetypedJavaMethod;
import bossa.syntax.TypeConstructors;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.Variance;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;
import nice.tools.code.TypeImport;
import nice.tools.code.Types;

public final class JavaClasses {
    private static final Type[] blackListClass = new Type[]{ClassType.make("java.lang.Object")};
    private static final Type[] blackListInterface = new Type[]{ClassType.make("java.io.Serializable"), ClassType.make("java.lang.Cloneable"), ClassType.make("java.lang.Comparable")};
    private static Map retyped;
    private static JavaMethod objectConstructor;
    private static Map knownMethods;
    static Compilation compilation;

    private JavaClasses() {
    }

    static TypeConstructor make(Compilation compilation, String name, Type javaType) {
        Object o = compilation.javaTypeConstructors.get(javaType);
        if (o != null) {
            return (TypeConstructor)o;
        }
        return JavaClasses.create(compilation, name, javaType);
    }

    static TypeConstructor setTypeConstructorForJavaClass(Compilation compilation, TypeConstructor tc, Type type) {
        TypeConstructor old = compilation.javaTypeConstructors.put(type, tc);
        return old;
    }

    private static boolean excluded(Type[] blackList, Type classType) {
        for (int i = 0; i < blackList.length; ++i) {
            if (classType != blackList[i]) continue;
            return true;
        }
        return false;
    }

    static boolean excludedInterface(TypeConstructor itf) {
        Type t = Types.get(itf);
        return JavaClasses.excluded(blackListInterface, t);
    }

    private static TypeConstructor create(Compilation compilation, String className, Type javaType) {
        boolean instantiable;
        TypeConstructor res;
        Type old;
        if (Debug.javaTypes) {
            Debug.println("Registering java class " + className);
        }
        if ((old = (Type)((Object)compilation.javaTypeConstructors.put(javaType, res = new TypeConstructor(className, null, instantiable = !Typing.isInRigidContext() && JavaClasses.instantiable(javaType), true)))) != null) {
            User.error(old + " was already associated with the Nice class " + old);
        }
        Types.set(res, javaType);
        if (Typing.isInRigidContext()) {
            Internal.warning(className + " added late");
            JavaClasses.setArity(res, 0);
            return res;
        }
        Typing.introduce(res);
        if (javaType instanceof ClassType) {
            ClassType superClass;
            ClassType classType = (ClassType)javaType;
            int arity = classType.getArity();
            if (arity != -1) {
                JavaClasses.setArity(res, classType.getArity());
            }
            if ((superClass = classType.getSuperclass()) != null && !JavaClasses.excluded(blackListClass, superClass)) {
                try {
                    TypeConstructor superTC = Types.typeConstructor(superClass);
                    Typing.initialLeq(res, superTC);
                }
                catch (TypingEx e) {
                    Internal.warning("Invalid java super-class " + superClass + " for " + className);
                }
                catch (Types.NotIntroducedClassException e) {
                    Internal.warning(res + " extends " + superClass + ", which is not usable");
                }
            }
            ClassType[] itfs = null;
            try {
                itfs = classType.getInterfaces();
            }
            catch (NoClassDefFoundError ex) {
                User.warning("Interface " + ex.getMessage() + " implemented by " + classType.getName() + " was not found in classpath");
            }
            if (itfs != null) {
                for (int i = 0; i < itfs.length; ++i) {
                    if (JavaClasses.excluded(blackListInterface, itfs[i])) continue;
                    try {
                        TypeConstructor superTC = Types.typeConstructor(itfs[i]);
                        Typing.initialLeq(res, superTC);
                        continue;
                    }
                    catch (TypingEx e) {
                        Internal.warning(res + " cannot implement " + itfs[i]);
                        continue;
                    }
                    catch (Types.NotIntroducedClassException e) {
                        Internal.warning(res + " implements " + itfs[i] + ", which is not usable");
                    }
                }
            }
            if (res.getKind() == null) {
                JavaClasses.setArity(res, 0);
            }
            if (classType.isFinal()) {
                res.setMinimal();
            }
        }
        if (javaType instanceof ClassType) {
            JavaClasses.fetchMethods(res, (ClassType)javaType);
        }
        return res;
    }

    private static void setArity(TypeConstructor tc, int arity) {
        try {
            Variance variance = arity == 0 ? Variance.empty() : Variance.make(new int[arity]);
            Engine.setKind(tc, variance.getConstraint());
        }
        catch (Unsatisfiable ex) {
            User.error("Java class " + tc + " cannot have arity " + arity);
        }
    }

    public static void reset() {
        retyped = new HashMap();
        knownMethods = new HashMap();
        objectConstructor = null;
    }

    static void registerNativeMethod(RetypedJavaMethod m, Method reflectMethod) {
        MethodDeclaration auto = retyped.put(reflectMethod, m);
        if (auto != null && !(auto instanceof RetypedJavaMethod)) {
            JavaClasses.removeFromScope(auto);
        }
    }

    static void registerNativeConstructor(RetypedJavaMethod m, Method reflectMethod, TypeConstructor classe) {
        MethodDeclaration auto = retyped.put(reflectMethod, m);
        if (auto != null && !(auto instanceof RetypedJavaMethod)) {
            TypeConstructors.removeConstructor(classe, auto);
        }
    }

    static void registerNativeField(JavaFieldAccess f, Field reflectField) {
        MethodDeclaration auto = retyped.put(reflectField, f);
        if (auto != null) {
            JavaClasses.removeFromScope(auto);
        }
    }

    private static void removeFromScope(MethodDeclaration m) {
        Node.getGlobalScope().removeSymbol(m.getSymbol());
        Dispatch.unregister(m);
    }

    static List findJavaMethods(ClassType declaringClass, String funName) {
        return JavaClasses.findJavaMethods(declaringClass, funName, -1);
    }

    static List findJavaMethods(ClassType declaringClass, String funName, int arity) {
        LinkedList<MethodDeclaration.Symbol> possibilities = new LinkedList<MethodDeclaration.Symbol>();
        declaringClass.addMethods();
        for (Method method = declaringClass.getMethods(); method != null; method = method.getNext()) {
            if (!method.getName().equals(funName) || (arity != -1 || !method.getStaticFlag()) && method.arg_types.length + (method.getStaticFlag() ? 0 : 1) != arity) continue;
            JavaMethod md = (JavaMethod)retyped.get(method);
            if (md == null) {
                md = JavaMethod.make(method, false);
            }
            if (md != null) {
                possibilities.add(md.getSymbol());
                continue;
            }
            if (!Debug.javaTypes) continue;
            Debug.println("Method " + method + " ignored");
        }
        if (arity <= 0) {
            JavaClasses.findStaticJavaFields(declaringClass, funName, possibilities);
        }
        return possibilities;
    }

    static JavaMethod getObjectConstructor() {
        if (objectConstructor == null) {
            objectConstructor = JavaMethod.make(Type.pointer_type.getDeclaredMethod("<init>", 0), true);
        }
        return objectConstructor;
    }

    private static void findStaticJavaFields(ClassType declaringClass, String fieldName, List possibilities) {
        ClassType[] interfaces;
        ClassType superClass;
        declaringClass.addMethods();
        Field field = declaringClass.getField(fieldName);
        if (field != null && field.getStaticFlag()) {
            MethodDeclaration md = (JavaFieldAccess)retyped.get(field);
            if (md == null) {
                md = JavaFieldAccess.make(field);
            }
            if (md != null) {
                if (!possibilities.contains(md.getSymbol())) {
                    possibilities.add(md.getSymbol());
                    return;
                }
            } else if (Debug.javaTypes) {
                Debug.println("Field " + field + " ignored");
            }
        }
        if ((superClass = declaringClass.getSuperclass()) != null) {
            JavaClasses.findStaticJavaFields(superClass, fieldName, possibilities);
        }
        if ((interfaces = declaringClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                JavaClasses.findStaticJavaFields(interfaces[i], fieldName, possibilities);
            }
        }
    }

    static void fetchMethods(TypeConstructor tc, ClassType classType) {
        try {
            classType.addMethods();
            for (Field f = classType.getFields(); f != null; f = f.getNext()) {
                if (retyped.get(f) != null) continue;
                JavaClasses.addSymbol(f, JavaFieldAccess.make(f));
            }
            for (Method m = classType.getMethods(); m != null; m = m.getNext()) {
                if (retyped.get(m) != null) continue;
                JavaClasses.fetch(m, tc, classType);
            }
        }
        catch (NoClassDefFoundError e) {
            User.warning("Class " + e.getMessage().replace('/', '.') + " was not found.\n" + "It is refered to in class " + classType.getName() + "\nYou probably need to install the corresponding package.");
        }
        catch (ClassFormatError e) {
            User.warning("Class " + classType.getName() + " has an invalid bytecode format");
        }
    }

    private static void fetch(Method m, TypeConstructor tc, ClassType classType) {
        if (m.isConstructor()) {
            JavaMethod res = JavaMethod.make(m, true);
            if (res != null) {
                TypeConstructors.addConstructor(tc, res);
                retyped.put(m, res);
            } else if (Debug.javaTypes) {
                Debug.println("Constructor " + m + " ignored");
            }
        } else {
            if (m.getStaticFlag()) {
                return;
            }
            Method base = JavaClasses.baseMethod(classType, m);
            if (base != null) {
                return;
            }
            JavaClasses.registerMethod(m);
        }
    }

    private static void registerMethod(Method m) {
        ArrayList<Method> methods = (ArrayList<Method>)knownMethods.get(m.getName());
        if (methods == null) {
            methods = new ArrayList<Method>();
            knownMethods.put(m.getName(), methods);
        }
        methods.add(m);
    }

    static void nameRequired(String name) {
        List methods = (List)knownMethods.get(name);
        if (methods == null) {
            return;
        }
        knownMethods.remove(name);
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            JavaClasses.loadMethod(m);
        }
    }

    private static void loadMethod(Method m) {
        if (Debug.javaTypes) {
            Debug.println("Loaded native method " + m);
        }
        if (retyped.get(m) != null) {
            return;
        }
        JavaClasses.addSymbol(m, JavaMethod.make(m, false));
    }

    private static Method baseMethod(ClassType classType, Method m) {
        Method res = null;
        ClassType superClass = classType.getSuperclass();
        if (superClass == null) {
            superClass = Type.pointer_type;
        }
        if ((res = JavaClasses.alreadyHasMethod(superClass, m)) != null) {
            return res;
        }
        ClassType[] itfs = classType.getInterfaces();
        if (itfs != null) {
            for (int i = 0; i < itfs.length; ++i) {
                res = JavaClasses.alreadyHasMethod(itfs[i], m);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private static void addSymbol(Object key, MethodDeclaration def) {
        if (def == null || Node.getGlobalScope() == null) {
            return;
        }
        Node.getGlobalScope().addSymbol(def.getSymbol());
        retyped.put(key, def);
    }

    private static Method alreadyHasMethod(ClassType c, Method m) {
        return c.getMethod(m.getName(), m.getParameterTypes());
    }

    static boolean instantiable(Type javaType) {
        if (!(javaType instanceof ClassType)) {
            return false;
        }
        return (((ClassType)javaType).getModifiers() & 0x600) == 0;
    }

    public static TypeConstructor lookup(String className, Location loc) {
        Type classType = TypeImport.lookup(className, loc);
        if (classType == null) {
            return null;
        }
        if (JavaClasses.compilation.javaTypeConstructors.containsKey(classType)) {
            return (TypeConstructor)JavaClasses.compilation.javaTypeConstructors.get(classType);
        }
        return JavaClasses.create(compilation, classType.getName(), classType);
    }
}

