/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.FieldAccess;
import bossa.syntax.FormalParameters;
import bossa.syntax.JavaClasses;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.util.Debug;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.expr.Declaration;
import java.io.PrintWriter;
import nice.tools.code.Types;

public class JavaFieldAccess
extends FieldAccess {
    private Field field;
    LocatedString className;
    String fieldName;

    public JavaFieldAccess(LocatedString className, String fieldName, LocatedString name, Constraint cst, Monotype returnType, FormalParameters parameters) {
        super(name, cst, parameters, returnType);
        this.className = className;
        this.fieldName = fieldName;
    }

    private JavaFieldAccess(Field field, mlsub.typing.Monotype[] parameters) throws Types.ParametricClassException, Types.NotIntroducedClassException {
        super(new LocatedString(field.getName(), Location.nowhere()), null, parameters, Types.monotype(field.getType(), field.isFinal()));
        this.field = field;
        this.className = new LocatedString(field.getDeclaringClass().getName(), Location.nowhere());
        this.fieldName = field.getName();
        this.fieldDecl = new Declaration(this.fieldName, field);
    }

    static MethodDeclaration make(Field f) {
        try {
            mlsub.typing.Monotype[] params = !f.getStaticFlag() ? new mlsub.typing.Monotype[]{Types.monotype(f.getDeclaringClass(), true)} : null;
            JavaFieldAccess res = new JavaFieldAccess(f, params);
            if (Debug.javaTypes) {
                Debug.println("Loaded field " + res);
            }
            return res;
        }
        catch (Types.ParametricClassException e) {
            return null;
        }
        catch (Types.NotIntroducedClassException e) {
            return null;
        }
    }

    public boolean isFinal() {
        return this.field.isFinal();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    void buildScope(VarScope outer, TypeScope typeOuter) {
        super.buildScope(outer, typeOuter);
        if (this.field == null) {
            this.field = this.getField(this.className, this.fieldName);
            if (this.field == null) {
                User.error((Located)this, "Field " + this.fieldName + " not found in class " + this.className);
            }
            if (this.field.getStaticFlag()) {
                if (this.arity != 0) {
                    User.error((Located)this.name, this.name + " should have no parameters");
                }
            } else if (this.arity != 1) {
                User.error((Located)this.name, this.name + " should have exactly one parameter");
            }
            JavaClasses.registerNativeField(this, this.field);
        }
        this.fieldDecl = new Declaration(this.fieldName, this.field);
    }

    Field getField(LocatedString javaClass, String name) {
        ClassType c = null;
        try {
            c = (ClassType)Types.type(javaClass);
            if (c == null) {
                User.error((Located)javaClass, "Class " + javaClass + " not found");
            }
        }
        catch (ClassCastException e) {
            User.error((Located)javaClass, javaClass + " is a primitive type, it has no field");
        }
        this.className.content = c.getName();
        for (Field f = c.getFields(); f != null; f = f.getNext()) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public void printInterface(PrintWriter s) {
        s.print(this.interfaceString() + "\n");
    }

    private String interfaceString() {
        return super.toString() + " = native " + this.className + "." + (this.field == null ? this.fieldName : this.field.getName()) + ";";
    }

    public String toString() {
        if (this.getType() == null) {
            return "JavaFieldAccess " + this.name;
        }
        return this.interfaceString();
    }
}

