/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.FormalParameters;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MethodImplementation;
import bossa.syntax.MonoSymbol;
import bossa.syntax.NiceClass;
import bossa.syntax.NiceMethod;
import bossa.syntax.Node;
import bossa.syntax.OverloadedSymbolExp;
import bossa.syntax.Pattern;
import bossa.syntax.PrimitiveType;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeScope;
import bossa.syntax.VarSymbol;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.UserError;
import bossa.util.Util;
import gnu.bytecode.Type;
import gnu.expr.Expression;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Constraint;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.SpecialArray;
import nice.tools.code.Types;

public class MethodBodyDefinition
extends MethodImplementation {
    private List symbols;
    Collection binders;

    public MethodBodyDefinition(NiceClass container, LocatedString name, Collection binders, List formals, Statement body) {
        super(name, body, MethodBodyDefinition.makeFormals(formals, container, name.location()));
        this.binders = binders;
        this.declaration = null;
    }

    boolean hasThis() {
        return this.formals != null && this.formals.length >= 1 && String.valueOf(this.formals[0].name).equals("this");
    }

    private static Pattern[] makeFormals(List formals, NiceClass container, Location loc) {
        if (container == null) {
            return formals.toArray(new Pattern[formals.size()]);
        }
        Pattern[] res = new Pattern[formals.size() + 1];
        res[0] = new Pattern(new LocatedString("this", loc), new TypeIdent(container.definition.getName()));
        int n = 1;
        Iterator f = formals.iterator();
        while (f.hasNext()) {
            res[n] = (Pattern)f.next();
            ++n;
        }
        return res;
    }

    final TypeConstructor firstArgument() {
        if (this.formals[0].tc != null) {
            return this.formals[0].tc;
        }
        return nice.tools.typing.Types.equivalent(this.declaration.getArgTypes()[0]).head();
    }

    private void setDeclaration(MethodDeclaration d) {
        if (d == null) {
            User.error((Located)this, "Method " + this.name + " is not declared");
        }
        this.declaration = d;
        if (d instanceof JavaMethod) {
            ((JavaMethod)d).registerForDispatch();
            if (TypeConstructors.isInterface(this.formals[0].tc)) {
                User.error((Located)this, this.name + " is a native method. Dispatch can only occur if the first argument is not a interface.");
            }
        } else if (!(d instanceof NiceMethod)) {
            User.error((Located)this, "Implementations can only be made for methods, but " + d.getName() + " is a function.\nIt was defined at:\n" + d.location());
        }
        this.buildSymbols();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VarSymbol findSymbol(List symbols) {
        if (symbols.size() == 0) {
            return null;
        }
        TypeConstructor[] tags = Pattern.getTC(this.formals);
        TypeConstructor[] additionalTags = Pattern.getAdditionalTC(this.formals);
        boolean hasAdditionalTags = false;
        for (int i = 0; i < tags.length; ++i) {
            if (additionalTags[i] == null) continue;
            hasAdditionalTags = true;
        }
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            if (s.getMethodDeclaration() == null) {
                i.remove();
                continue;
            }
            MethodDeclaration m = s.getMethodDeclaration();
            if (m.isIgnored()) {
                i.remove();
                continue;
            }
            if (m.getArity() != this.formals.length || !(m instanceof NiceMethod) && !(m instanceof JavaMethod)) {
                i.remove();
                continue;
            }
            try {
                int level = Debug.overloading ? Typing.enter("Trying declaration " + m + " for method body " + this.name) : Typing.enter();
                try {
                    Polytype t = m.getType();
                    Constraint.enter(t.getConstraint());
                    Pattern.inDomain(this.formals, t.domain());
                }
                finally {
                    if (Typing.leave() == level) continue;
                    Internal.error("Enter/Leave error");
                }
            }
            catch (TypingEx e) {
                if (Debug.overloading) {
                    Debug.println("Not the right choice :" + e);
                }
                i.remove();
            }
            catch (BadSizeEx e) {
                i.remove();
            }
        }
        if (symbols.size() > 1 && hasAdditionalTags) {
            MethodDeclaration.Symbol[] tempSymbols = new MethodDeclaration.Symbol[symbols.size()];
            symbols.toArray(tempSymbols);
            int size = symbols.size();
            symbols = new LinkedList<MethodDeclaration.Symbol>();
            int len = this.formals.length;
            boolean[] removed = new boolean[size];
            for (int m1 = 0; m1 < size; ++m1) {
                Monotype[] dom1 = tempSymbols[m1].getMethodDeclaration().getType().domain();
                for (int m2 = 0; m2 < size; ++m2) {
                    if (m1 == m2) continue;
                    boolean remove = true;
                    boolean additionalsEqual = true;
                    Monotype[] dom2 = tempSymbols[m2].getMethodDeclaration().getType().domain();
                    for (int i2 = 0; i2 < len; ++i2) {
                        if (additionalTags[i2] == null) continue;
                        try {
                            this.domainMonotypeLeq(dom2[i2], dom1[i2]);
                            try {
                                this.domainMonotypeLeq(dom1[i2], dom2[i2]);
                            }
                            catch (TypingEx e) {
                                additionalsEqual = false;
                            }
                            continue;
                        }
                        catch (TypingEx e) {
                            remove = false;
                            break;
                        }
                    }
                    boolean bl = removed[m1] = remove && !additionalsEqual;
                    if (removed[m1]) break;
                }
                if (removed[m1]) continue;
                symbols.add(tempSymbols[m1]);
            }
        }
        Iterator it = symbols.iterator();
        block15: while (it.hasNext()) {
            int i3;
            MethodDeclaration m = ((MethodDeclaration.Symbol)it.next()).getMethodDeclaration();
            if (!(m instanceof NiceMethod)) continue;
            FormalParameters params = m.formalParameters();
            int n = i3 = params.hasThis() ? 1 : 0;
            while (i3 < this.formals.length) {
                if (this.formals[i3].atAny() && this.formals[i3].name != null && params.getName(i3) != null && !this.formals[i3].name.toString().equals(params.getName(i3).toString())) {
                    it.remove();
                    continue block15;
                }
                ++i3;
            }
        }
        OverloadedSymbolExp.removeNonMinimal(symbols);
        if (symbols.size() == 1) {
            return (VarSymbol)symbols.get(0);
        }
        if (symbols.size() == 0) {
            User.error((Located)this, "No method called " + this.name + " is compatible with these patterns");
        }
        String methods = "";
        Iterator i4 = symbols.iterator();
        while (i4.hasNext()) {
            MethodDeclaration m = ((MethodDeclaration.Symbol)i4.next()).getMethodDeclaration();
            methods = methods + m + " defined " + m.location() + "\n";
        }
        throw User.error((Located)this, "There is an ambiguity about which version  of the overloaded method \"" + this.name + "\" this alternative belongs to.\n" + "Try to use more patterns.\n\n" + "Possible methods:\n" + methods);
    }

    private void domainMonotypeLeq(Monotype m1, Monotype m2) throws TypingEx {
        if (m1 == m2) {
            return;
        }
        nice.tools.typing.Types.setMarkedKind(m1);
        nice.tools.typing.Types.setMarkedKind(m2);
        Typing.leq(nice.tools.typing.Types.rawType(m1), nice.tools.typing.Types.rawType(m2));
    }

    void doResolve() {
        Pattern.resolve(this.typeScope, MethodBodyDefinition.getGlobalScope(), this.formals);
        this.symbols = this.scope.lookup(this.name);
    }

    void lateBuildScope() {
        Pattern.resolveValues(this.formals);
        VarSymbol s = this.findSymbol(this.symbols);
        this.symbols = null;
        if (s == null) {
            User.error((Located)this, this.name + " is not declared");
        }
        if (s.getMethodDeclaration() == null) {
            User.error((Located)this, this.name + " is not a method");
        }
        MethodDeclaration decl = s.getMethodDeclaration();
        this.setDeclaration(decl);
        if (this.binders != null) {
            Constraint cst = this.declaration.getType().getConstraint();
            if (!Constraint.hasBinders(cst)) {
                User.error((Located)this.name, "Method " + this.name + " has no type parameters");
            }
            try {
                this.typeScope.addMappingsLS(this.binders, cst.binders());
            }
            catch (BadSizeEx e) {
                User.error((Located)this.name, "Method " + this.name + " expects " + e.expected + " type parameters");
            }
            catch (TypeScope.DuplicateName e) {
                User.error((Located)this, e);
            }
        }
        try {
            for (int n = 0; n < this.formals.length; ++n) {
                TypeConstructor tc = this.formals[n].getRuntimeTC();
                if (tc == null) continue;
                this.typeScope.addSymbol(tc);
            }
        }
        catch (TypeScope.DuplicateName e) {
            User.error((Located)this, e);
        }
        if (!this.declaration.specializesMethods()) {
            this.removeUnnecessaryDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnnecessaryDispatch() {
        boolean entered = false;
        if (Constraint.hasBinders(this.declaration.getType().getConstraint())) {
            Typing.enter();
            entered = true;
        }
        try {
            try {
                Constraint.enter(this.declaration.getType().getConstraint());
                Typing.implies();
                Monotype[] domain = this.declaration.getType().domain();
                for (int n = 0; n < this.formals.length; ++n) {
                    TypeConstructor tc = nice.tools.typing.Types.rawType(domain[n]).head();
                    if (this.formals[n].tc == null) continue;
                    this.formals[n].setDomainEq(tc != null && nice.tools.typing.Types.isSure(domain[n]) && Typing.testLeq(tc, this.formals[n].tc));
                }
            }
            finally {
                if (entered) {
                    Typing.leave();
                }
            }
        }
        catch (TypingEx ex) {
            Internal.warning(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void typecheck() {
        boolean errorFound = false;
        int level = Debug.typing ? Typing.enter("METHOD BODY " + this + "\n\n") : Typing.enter();
        try {
            try {
                try {
                    Constraint.enter(this.declaration.getType().getConstraint());
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "the constraint will never be satisfied", ": " + e.getMessage());
                }
                Monotype[] monotypes = MonoSymbol.getMonotype(this.parameters);
                for (int n = 0; n < this.formals.length; ++n) {
                    TypeConstructor runtimeTC = this.formals[n].getRuntimeTC();
                    if (runtimeTC == null) {
                        Typing.introduce(monotypes[n]);
                        continue;
                    }
                    Typing.introduce(runtimeTC);
                }
                Monotype[] domain = this.declaration.getType().domain();
                for (int n = 0; n < this.formals.length; ++n) {
                    TypeConstructor tc = nice.tools.typing.Types.rawType(domain[n]).head();
                    if (this.formals[n].tc == null) continue;
                    this.formals[n].setDomainTC(tc);
                }
                try {
                    Pattern.in(monotypes, this.formals);
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "The patterns are not correct", e);
                }
                for (int i = 0; i < monotypes.length; ++i) {
                    try {
                        Typing.leq(monotypes[i], domain[i]);
                        continue;
                    }
                    catch (TypingEx e) {
                        throw User.error((Located)this.formals[i], "Pattern " + this.formals[i] + " is incompatible with type " + domain[i]);
                    }
                }
                try {
                    Types.setBytecodeType(monotypes);
                    Typing.implies();
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "Type error in method body \"" + this.name + "\":\n" + e);
                }
                Node.currentFunction = this;
                if (this.hasThis()) {
                    Node.thisExp = new SymbolExp(this.parameters[0], this.location());
                }
                dispatch.typecheck(this.body);
            }
            catch (UserError ex) {
                this.module.compilation().error(ex);
                errorFound = true;
            }
            Object var8_14 = null;
            Node.currentFunction = null;
            Node.thisExp = null;
        }
        catch (Throwable throwable) {
            block25: {
                Object var8_15 = null;
                Node.currentFunction = null;
                Node.thisExp = null;
                try {
                    if (Typing.leave() != level) {
                        Internal.error("Unmatching enter/leave");
                    }
                }
                catch (TypingEx e) {
                    if (errorFound) break block25;
                    User.error((Located)this, "Type error in method " + this.name, ": " + e);
                }
            }
            throw throwable;
        }
        try {
            if (Typing.leave() != level) {
                Internal.error("Unmatching enter/leave");
            }
        }
        catch (TypingEx e) {
            if (!errorFound) {
                User.error((Located)this, "Type error in method " + this.name, ": " + e);
            }
        }
        if (this.declaration.specializesMethods()) {
            this.addPatterns();
        }
    }

    public void printInterface(PrintWriter s) {
    }

    protected Type[] javaArgTypes() {
        Type[] res = new Type[this.parameters.length];
        for (int n = 0; n < this.parameters.length; ++n) {
            res[n] = this.formals[n].atNull() ? Types.javaType(PrimitiveType.nullTC) : (this.formals[n].tc == PrimitiveType.arrayTC ? SpecialArray.unknownTypeArray() : Types.javaType(this.parameters[n].getMonotype()));
        }
        return res;
    }

    Expression[] compiledArguments() {
        return VarSymbol.compile(this.parameters);
    }

    public String toString() {
        return this.name + "(" + Util.map("", ", ", "", this.formals) + ")";
    }
}

