/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.CallExp;
import bossa.syntax.ClassDefinition;
import bossa.syntax.JavaClasses;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.OverloadedSymbolExp;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeMap;
import bossa.util.Located;
import bossa.util.User;
import java.util.LinkedList;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;

public class NewExp
extends CallExp {
    private TypeIdent ti;
    TypeConstructor tc = null;

    public NewExp(TypeIdent ti, Arguments arguments) {
        super(null, arguments);
        this.ti = ti;
    }

    void resolve(TypeMap typeScope) {
        TypeSymbol sym = this.ti.resolveToTypeSymbol(typeScope);
        if (sym == TopMonotype.instance) {
            this.setObject();
        } else if (sym instanceof TypeConstructor) {
            this.setTC((TypeConstructor)sym);
        } else {
            throw User.error((Located)this.ti, this.ti + " is not a class" + sym.getClass());
        }
    }

    private void setTC(TypeConstructor tc) {
        LinkedList constructors;
        this.tc = tc;
        if (!TypeConstructors.instantiable(tc)) {
            String message = TypeConstructors.isInterface(tc) ? tc + " is an interface, it can't be instantiated" : (TypeConstructors.isClass(tc) ? tc + " is an abstract class, it can't be instantiated" : tc + " is a type variable, it can't be instantiated");
            throw User.error((Located)this, message);
        }
        ClassDefinition definition = ClassDefinition.get(tc);
        if (definition != null) {
            definition.resolve();
        }
        if ((constructors = TypeConstructors.getConstructors(tc)) == null) {
            if (tc.arity() > 0) {
                User.error((Located)this, "Class " + tc + " has no constructor with " + tc.arity() + " type parameters.\n" + "A retyping is needed to use this constructor.");
            } else {
                User.error((Located)this, "Class " + tc + " has no constructor");
            }
        }
        constructors = (LinkedList)constructors.clone();
        this.function = new OverloadedSymbolExp(constructors, new LocatedString("new " + tc, this.location()));
    }

    private void setObject() {
        JavaMethod method = JavaClasses.getObjectConstructor();
        this.function = new SymbolExp(method.getSymbol(), this.ti.location());
    }

    public String toString() {
        String cl = this.ti.toString();
        return "new " + cl + this.arguments;
    }
}

