/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.ConstantExp;
import bossa.syntax.Constructor;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.NiceFieldAccess;
import bossa.syntax.Node;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.ClassExp;
import gnu.expr.Declaration;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.Interface;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;
import nice.tools.code.GetFieldProc;
import nice.tools.code.Inline;
import nice.tools.code.SetFieldProc;
import nice.tools.code.SpecialTypes;
import nice.tools.typing.Types;

public class NiceClass
extends ClassDefinition.ClassImplementation {
    ClassDefinition definition;
    private static NewField[] noFields = new NewField[0];
    private static OverridenField[] noOverrides = new OverridenField[0];
    private ArrayList constructors = new ArrayList(10);
    private TypeScope localScope;
    private Statement[] initializers = Statement.noStatements;
    private MonoSymbol thisSymbol;
    private gnu.expr.Expression thisExp;
    private boolean entered = false;
    static Method cloneMethod = Type.pointer_type.getDeclaredMethod("clone", 0);
    ClassExp classe;
    private Constructor[] constructorMethod;
    private NewField[] fields;
    private OverridenField[] overrides;
    private Long serialVersionUIDValue;

    public NiceClass(ClassDefinition definition) {
        this.definition = definition;
        this.prepareCodeGeneration();
    }

    public String getName() {
        return this.definition.getName().toString();
    }

    public void setFields(List fields) {
        if (fields == null || fields.size() == 0) {
            this.fields = noFields;
        } else {
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                if (!field.isFinal() || !field.sym.getName().toString().equals("serialVersionUID")) continue;
                it.remove();
                if (field.value instanceof ConstantExp && ((ConstantExp)field.value).value instanceof Long) {
                    this.serialVersionUIDValue = (Long)((ConstantExp)field.value).value;
                    continue;
                }
                User.error((Located)field.sym, "the value of an serialVersionUID should a constant of type long");
            }
            this.fields = fields.toArray(new NewField[fields.size()]);
        }
    }

    public void setOverrides(List overrides) {
        this.overrides = overrides == null || overrides.size() == 0 ? noOverrides : overrides.toArray(new OverridenField[overrides.size()]);
    }

    public boolean isInterface() {
        return this.definition instanceof ClassDefinition.Interface;
    }

    static NiceClass get(TypeConstructor tc) {
        ClassDefinition res = ClassDefinition.get(tc);
        if (res != null && res.implementation instanceof NiceClass) {
            return (NiceClass)res.implementation;
        }
        return null;
    }

    public static NiceClass get(mlsub.typing.Monotype type) {
        if (!Types.isSure(type)) {
            return null;
        }
        return NiceClass.get(Types.constructor(type));
    }

    NiceClass getParent() {
        return NiceClass.get(this.definition.getSuperClass());
    }

    void addConstructorCallSymbol(MethodDeclaration.Symbol sym) {
        this.constructors.add(sym);
    }

    List getConstructorCallSymbols() {
        return (List)this.constructors.clone();
    }

    public Field makeField(MonoSymbol sym, Expression value, boolean isFinal, boolean isTransient, boolean isVolatile, String docString) {
        if (this.isInterface()) {
            User.error((Located)sym, "An interface cannot have a field.");
        }
        return new NewField(sym, value, isFinal, isTransient, isVolatile, docString);
    }

    public Field makeOverride(MonoSymbol sym, Expression value) {
        if (this.isInterface()) {
            User.error((Located)sym, "An interface cannot have a field.");
        }
        return new OverridenField(sym, value);
    }

    void resolveClass() {
        this.classe.supers = this.computeSupers();
        this.localScope = this.definition.getLocalScope();
        this.definition.setJavaType(this.classe.getType());
        this.resolveFields();
        this.resolveIntitializers();
        this.createDefaultConstructors();
        this.addPublicCloneMethod();
    }

    private void resolveFields() {
        int i;
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i].resolve(this.definition.scope, this.localScope);
        }
        for (i = 0; i < this.overrides.length; ++i) {
            this.overrides[i].resolve(this.definition.scope, this.localScope);
        }
    }

    private void createFields() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].createField();
        }
    }

    private Declaration getOverridenField(OverridenField field, boolean checkValue) {
        int i;
        String name = field.sym.getName().toString();
        for (i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].sym.getName().toString().equals(name)) continue;
            if (!this.fields[i].isFinal) {
                User.error((Located)field.sym, "The original field in class " + this + " is not final, so its type cannot be overriden");
            }
            checkValue = field.checkOverride(this.fields[i], checkValue);
            return this.fields[i].method.fieldDecl;
        }
        for (i = 0; i < this.overrides.length; ++i) {
            if (!this.overrides[i].sym.getName().toString().equals(name)) continue;
            checkValue = field.checkOverride(this.overrides[i], checkValue);
        }
        NiceClass parent = this.getParent();
        if (parent != null) {
            return parent.getOverridenField(field, checkValue);
        }
        return null;
    }

    public void setInitializers(List inits) {
        this.initializers = inits.toArray(new Statement[inits.size()]);
    }

    public int nbInitializers() {
        return this.initializers.length;
    }

    private void resolveIntitializers() {
        if (this.initializers.length == 0) {
            return;
        }
        VarScope scope = this.definition.scope;
        mlsub.typing.Monotype thisType = Monotype.sure(new MonotypeConstructor(this.definition.tc, this.definition.getTypeParameters()));
        this.thisSymbol = new MonoSymbol(FormalParameters.thisName, thisType){

            gnu.expr.Expression compile() {
                return NiceClass.this.thisExp;
            }
        };
        Node.thisExp = new SymbolExp(this.thisSymbol, this.definition.location());
        scope.addSymbol(this.thisSymbol);
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i] = dispatch.analyse(this.initializers[i], this.definition.scope, this.localScope, false);
        }
        Node.thisExp = null;
        scope.removeSymbol(this.thisSymbol);
    }

    void setThisExp(gnu.expr.Expression thisExp) {
        this.thisExp = thisExp;
    }

    gnu.expr.Expression compileInitializer(int index) {
        return this.initializers[index].generateCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void typecheck() {
        block10: {
            try {
                int i;
                for (i = 0; i < this.fields.length; ++i) {
                    this.fields[i].typecheck();
                }
                for (i = 0; i < this.overrides.length; ++i) {
                    this.overrides[i].typecheck();
                }
                if (this.initializers.length != 0) {
                    this.enterTypingContext();
                    Node.thisExp = new SymbolExp(this.thisSymbol, this.definition.location());
                    for (i = 0; i < this.initializers.length; ++i) {
                        dispatch.typecheck(this.initializers[i]);
                    }
                }
                Object var3_2 = null;
                if (!this.entered) break block10;
                this.entered = false;
                Node.thisExp = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.entered) {
                    this.entered = false;
                    Node.thisExp = null;
                    try {
                        Typing.leave();
                    }
                    catch (TypingEx ex) {
                        User.error((Located)this.definition, "Type error in field declarations");
                    }
                }
                throw throwable;
            }
            try {
                Typing.leave();
            }
            catch (TypingEx ex) {
                User.error((Located)this.definition, "Type error in field declarations");
            }
        }
    }

    private void enterTypingContext() {
        if (this.entered || this.definition.classConstraint == null) {
            return;
        }
        Typing.enter();
        this.entered = true;
        Typing.introduce(this.definition.classConstraint.typeParameters);
        try {
            Typing.implies();
        }
        catch (TypingEx ex) {
            Internal.error(ex);
        }
    }

    public void printInterface(PrintWriter s) {
        s.print(" {\n" + Util.map("", ";\n", ";\n", this.fields) + this.serialUIDFieldString() + Util.map("", ";\n", ";\n", this.overrides) + "}\n\n");
    }

    String serialUIDFieldString() {
        if (this.serialVersionUIDValue == null) {
            return "";
        }
        return "final long serialVersionUID = " + this.serialVersionUIDValue + "L;\n";
    }

    private void prepareCodeGeneration() {
        this.classe = this.definition.module.getClassExp(this);
    }

    private void addPublicCloneMethod() {
        if (!this.definition.implementsJavaInterface("java.lang.Cloneable")) {
            return;
        }
        gnu.expr.Expression[] params = new gnu.expr.Expression[1];
        LambdaExp lambda2 = this.createJavaMethod("clone", cloneMethod, params);
        Gen.setMethodBody(lambda2, new ApplyExp(new QuoteExp(PrimProcedure.specialCall(cloneMethod)), params));
        this.addJavaMethod(lambda2);
    }

    public ClassExp createClassExp() {
        ClassExp res = new ClassExp();
        res.setName(this.definition.name.toString());
        this.definition.location().write(res);
        res.setSimple(true);
        res.setAccessFlags(this.definition.getBytecodeFlags());
        this.definition.module.addUserClass(res);
        return res;
    }

    public ClassExp getClassExp() {
        return this.classe;
    }

    private TypeScope translationScope(NiceClass other) {
        TypeSymbol[] binders = other.definition.getBinders();
        TypeSymbol[] ourBinders = this.definition.getBinders();
        TypeScope scope = Node.getGlobalTypeScope();
        if (binders != null) {
            scope = new TypeScope(scope);
            for (int i = 0; i < binders.length; ++i) {
                try {
                    scope.addMapping(ourBinders[i].toString(), binders[i]);
                    continue;
                }
                catch (TypeScope.DuplicateName e) {
                    // empty catch block
                }
            }
        }
        return scope;
    }

    private static List getNativeConstructorParameters(TypeConstructor tc, List constraints) {
        LinkedList constructors = TypeConstructors.getConstructors(tc);
        if (constructors == null) {
            ArrayList res = new ArrayList(10);
            ArrayList<Object> params = new ArrayList<Object>(10);
            params.add(null);
            res.add(params);
            return res;
        }
        ArrayList res = new ArrayList(constructors.size());
        int n = 0;
        Iterator i = constructors.iterator();
        while (i.hasNext()) {
            MethodDeclaration.Symbol m = (MethodDeclaration.Symbol)i.next();
            ArrayList<Object> params = new ArrayList<Object>(10);
            params.add(m.getMethodDeclaration());
            res.add(params);
            mlsub.typing.Monotype[] args = m.getMethodDeclaration().getArgTypes();
            for (int j = 0; j < args.length; ++j) {
                params.add(new FormalParameters.Parameter(Monotype.create(args[j])));
            }
            ++n;
        }
        return res;
    }

    private List getParentConstructorParameters(List constraints, mlsub.typing.Monotype[] typeParameters) {
        AtomicConstraint[] newAtoms;
        TypeScope scope = Node.getGlobalTypeScope();
        HashMap<TypeSymbol, TypeSymbol> map2 = null;
        if (typeParameters != null) {
            scope = new TypeScope(scope);
            map2 = new HashMap<TypeSymbol, TypeSymbol>();
            mlsub.typing.Monotype[] ourTypeParameters = this.definition.getTypeParameters();
            for (int i = 0; i < ourTypeParameters.length; ++i) {
                try {
                    TypeSymbol ourSym = this.asTypeSymbol(ourTypeParameters[i]);
                    TypeSymbol sym = this.asTypeSymbol(typeParameters[i]);
                    scope.addMapping(ourSym.toString(), sym);
                    map2.put(ourSym, sym);
                    continue;
                }
                catch (TypeScope.DuplicateName e) {
                    // empty catch block
                }
            }
        }
        ArrayList res = new ArrayList(this.constructors.size());
        Iterator i = this.constructors.iterator();
        while (i.hasNext()) {
            MethodDeclaration decl = ((MethodDeclaration.Symbol)i.next()).getMethodDeclaration();
            ArrayList<MethodDeclaration> params = new ArrayList<MethodDeclaration>(1 + decl.arity);
            params.add(decl);
            if (decl.arity > 0) {
                params.addAll(decl.formalParameters().getParameters(scope));
            }
            res.add(params);
        }
        if (this.definition.classConstraint != null && (newAtoms = AtomicConstraint.substitute(map2, this.definition.resolvedConstraints)) != null) {
            for (int i2 = 0; i2 < newAtoms.length; ++i2) {
                constraints.add(newAtoms[i2]);
            }
        }
        return res;
    }

    private TypeSymbol asTypeSymbol(mlsub.typing.Monotype type) {
        if (type instanceof TypeSymbol) {
            return (TypeSymbol)((Object)type);
        }
        return ((MonotypeConstructor)type).getTC();
    }

    private List getConstructorParameters(List constraints, mlsub.typing.Monotype[] typeParameters) {
        TypeConstructor supTC = this.definition.getSuperClass();
        NiceClass sup = NiceClass.get(supTC);
        List res = sup == null ? NiceClass.getNativeConstructorParameters(supTC, constraints) : sup.getParentConstructorParameters(constraints, typeParameters);
        if (this.overrides.length > 0) {
            Iterator i = res.iterator();
            while (i.hasNext()) {
                this.updateConstructorParameters((List)i.next());
            }
        }
        if (this.fields.length > 0) {
            for (int j = 0; j < res.size(); ++j) {
                List params = (List)res.get(j);
                for (int i = 0; i < this.fields.length; ++i) {
                    params.add(this.fields[i].asParameter());
                }
            }
        }
        if (this.definition.resolvedConstraints != null) {
            constraints.addAll(Arrays.asList(this.definition.resolvedConstraints));
        }
        return res;
    }

    private void updateConstructorParameters(List inherited) {
        for (int f = 0; f < this.overrides.length; ++f) {
            this.overrides[f].updateConstructorParameter(inherited);
        }
    }

    private void checkFields(FormalParameters.Parameter[] allFields) {
        for (int f = 0; f < this.fields.length; ++f) {
            this.fields[f].checkNoDuplicate(allFields, f);
        }
        for (int i = 0; i < this.overrides.length; ++i) {
            for (int k = i + 1; k < this.overrides.length; ++k) {
                if (!this.overrides[i].sym.hasName(this.overrides[k].sym.getName())) continue;
                User.error((Located)this.overrides[k].sym, "A field override of the same field exists in this class");
            }
        }
    }

    private void createDefaultConstructors() {
        if (this.definition.inInterfaceFile()) {
            return;
        }
        if (this.isInterface()) {
            return;
        }
        TypeSymbol[] binders = this.definition.getBinders();
        LinkedList constraints = binders == null ? null : new LinkedList();
        mlsub.typing.Monotype[] typeParameters = this.definition.getTypeParameters();
        List allConstructorParams = this.getConstructorParameters(constraints, typeParameters);
        Constraint cst = binders != null ? new Constraint(binders, constraints.toArray(new AtomicConstraint[constraints.size()])) : Constraint.True;
        this.constructorMethod = new Constructor[allConstructorParams.size()];
        for (int i = 0; i < allConstructorParams.size(); ++i) {
            List argList = (List)allConstructorParams.get(i);
            MethodDeclaration parent = (MethodDeclaration)argList.get(0);
            argList = argList.subList(1, argList.size());
            FormalParameters.Parameter[] args = argList.toArray(new FormalParameters.Parameter[argList.size()]);
            if (i == 0) {
                this.checkFields(args);
            }
            FormalParameters values = new FormalParameters(args);
            this.constructorMethod[i] = new Constructor(this, this.fields, parent, this.definition.location(), values, cst, Monotype.resolve(this.definition.getLocalScope(), values.types()), Monotype.sure(new MonotypeConstructor(this.definition.tc, this.definition.getTypeParameters())));
            TypeConstructors.addConstructor(this.definition.tc, this.constructorMethod[i]);
        }
    }

    public void precompile() {
        this.createFields();
    }

    public void compile() {
        this.recompile();
        this.createSerialUIDField();
    }

    public void recompile() {
        if (this.constructorMethod != null) {
            for (int i = 0; i < this.constructorMethod.length; ++i) {
                this.constructorMethod[i].getCode();
            }
        }
        this.classe.supers = this.computeSupers();
        this.classe.recomputeInterfaces();
    }

    private gnu.expr.Expression typeExpression(TypeConstructor tc) {
        ClassDefinition c = ClassDefinition.get(tc);
        if (c != null && c.implementation instanceof NiceClass) {
            return ((NiceClass)c.implementation).classe;
        }
        return new QuoteExp(nice.tools.code.Types.javaType(tc));
    }

    private gnu.expr.Expression[] computeSupers() {
        int i;
        int len;
        TypeConstructor superClass = this.definition.getSuperClass();
        Interface[] interfaces = this.definition.getInterfaces();
        int n = len = superClass == null ? 0 : 1;
        if (interfaces != null) {
            len += interfaces.length;
        }
        if (this.definition.javaInterfaces != null) {
            len += this.definition.javaInterfaces.length;
        }
        if (len == 0) {
            return null;
        }
        gnu.expr.Expression[] res = new gnu.expr.Expression[len];
        if (interfaces != null) {
            for (i = 0; i < interfaces.length; ++i) {
                TypeConstructor assocTC = interfaces[i].associatedTC();
                if (assocTC == null) continue;
                res[--len] = this.typeExpression(assocTC);
            }
        }
        if (this.definition.javaInterfaces != null) {
            for (i = 0; i < this.definition.javaInterfaces.length; ++i) {
                res[--len] = this.typeExpression(this.definition.javaInterfaces[i]);
            }
        }
        if (superClass != null) {
            res[--len] = this.typeExpression(superClass);
        }
        if (len != 0) {
            gnu.expr.Expression[] tmp = new gnu.expr.Expression[res.length - len];
            System.arraycopy(res, len, tmp, 0, tmp.length);
            res = tmp;
        }
        return res;
    }

    public gnu.expr.Expression addJavaMethod(LambdaExp method) {
        return this.classe.addMethod(method);
    }

    public LambdaExp createJavaMethod(String name, Method likeMethod, gnu.expr.Expression[] params) {
        LambdaExp lambda2 = Gen.createMemberMethod(name, this.getClassExp().getType(), likeMethod.getParameterTypes(), likeMethod.getReturnType(), params);
        return lambda2;
    }

    gnu.expr.Expression callSuperMethod(Method superMethod) {
        gnu.expr.Expression[] params = new gnu.expr.Expression[superMethod.getParameterTypes().length + 1];
        LambdaExp lambda2 = this.createJavaMethod("$super$" + superMethod.getName(), superMethod, params);
        Gen.setMethodBody(lambda2, new ApplyExp(new QuoteExp(PrimProcedure.specialCall(superMethod)), params));
        return this.addJavaMethod(lambda2);
    }

    void createSerialUIDField() {
        if (this.serialVersionUIDValue == null) {
            return;
        }
        Declaration fieldDecl = this.classe.addDeclaration("serialVersionUID", SpecialTypes.longType);
        fieldDecl.setSimple(false);
        fieldDecl.setCanRead(true);
        fieldDecl.setFlag(16384);
        fieldDecl.setSpecifiedPrivate(true);
        fieldDecl.setFlag(2048);
        fieldDecl.setFlag(8192);
        fieldDecl.noteValue(new QuoteExp(this.serialVersionUIDValue, SpecialTypes.longType));
    }

    public String toString() {
        return this.definition.toString();
    }

    final class OverridenField
    extends Field {
        private OverridenField(MonoSymbol sym, Expression value) {
            super(sym, value);
        }

        boolean isFinal() {
            return true;
        }

        void updateConstructorParameter(List inherited) {
            String name = this.sym.getName().toString();
            Monotype type = this.sym.syntacticType;
            for (int i = 1; i < inherited.size(); ++i) {
                FormalParameters.Parameter param = (FormalParameters.Parameter)inherited.get(i);
                if (!param.match(name)) continue;
                if (this.value != null) {
                    inherited.set(i, new FormalParameters.OptionalParameter(type, this.sym.getName(), true, this.value, param.value() == null || param.isOverriden()));
                    continue;
                }
                param.resetType(type);
            }
        }

        void typecheck() {
            Declaration decl = null;
            NiceClass parent = NiceClass.this.getParent();
            if (parent != null) {
                decl = parent.getOverridenField(this, this.value == null);
            }
            if (decl == null) {
                throw User.error((Located)this.sym, "No field with this name exists in a super-class");
            }
            this.method.fieldDecl = decl;
            super.typecheck();
        }

        boolean checkOverride(Field original, boolean checkValue) {
            NiceClass.this.enterTypingContext();
            mlsub.typing.Monotype originalType = original.sym.syntacticType.resolve(original.getDeclaringClass().translationScope(NiceClass.this));
            try {
                Typing.leq(this.sym.type, originalType);
            }
            catch (TypingEx ex) {
                User.error((Located)this.sym, "The new type must be a subtype of the original type declared in " + original.getDeclaringClass() + ".\n" + "Original type: " + originalType);
            }
            if (checkValue && original.value != null) {
                try {
                    Typing.leq(original.value.getType(), this.sym.getType());
                }
                catch (TypingEx ex) {
                    User.error((Located)this.sym, "The default value declared in " + original.getDeclaringClass() + "\nis not compatible with the overriden type");
                }
                return false;
            }
            return checkValue;
        }

        public String toString() {
            return "override " + super.toString();
        }
    }

    final class NewField
    extends Field {
        boolean isFinal;
        boolean isTransient;
        boolean isVolatile;
        public String docString;

        private NewField(MonoSymbol sym, Expression value, boolean isFinal, boolean isTransient, boolean isVolatile, String docString) {
            super(sym, value);
            this.isFinal = isFinal;
            this.isTransient = isTransient;
            this.isVolatile = isVolatile;
            this.docString = docString;
            if (isFinal && isVolatile) {
                throw User.error((Located)sym, "A field cannot be final and volatile");
            }
        }

        boolean isFinal() {
            return this.isFinal;
        }

        void createField() {
            this.method.fieldDecl = NiceClass.this.classe.addField(this.sym.name.toString(), nice.tools.code.Types.javaType(this.sym.type));
            this.method.fieldDecl.setFlag(this.isTransient, 524288);
            this.method.fieldDecl.setFlag(this.isVolatile, 0x100000);
            if (!NiceClass.this.definition.inInterfaceFile()) {
                String fname = this.sym.getName().toString();
                String suffix = Character.toUpperCase(fname.charAt(0)) + fname.substring(1);
                this.createGetter(suffix);
                if (!this.isFinal) {
                    this.createSetter(suffix);
                }
            }
        }

        void createGetter(String nameSuffix) {
            gnu.expr.Expression[] params = new gnu.expr.Expression[1];
            LambdaExp getter = Gen.createMemberMethod("get" + nameSuffix, NiceClass.this.classe.getType(), null, this.method.fieldDecl.getType(), params);
            Gen.setMethodBody(getter, Inline.inline(new GetFieldProc(this.method.fieldDecl), params[0]));
            NiceClass.this.classe.addMethod(getter);
        }

        void createSetter(String nameSuffix) {
            gnu.expr.Expression[] params = new gnu.expr.Expression[2];
            Type[] argTypes = new Type[]{this.method.fieldDecl.getType()};
            LambdaExp setter = Gen.createMemberMethod("set" + nameSuffix, NiceClass.this.classe.getType(), argTypes, this.method.fieldDecl.getType(), params);
            Gen.setMethodBody(setter, Inline.inline(new SetFieldProc(this.method.fieldDecl), params[0], params[1]));
            NiceClass.this.classe.addMethod(setter);
        }

        void checkNoDuplicate(FormalParameters.Parameter[] fields, int rankInThisClass) {
            int max = fields.length - NiceClass.this.fields.length + rankInThisClass;
            String name = this.sym.getName().toString();
            for (int i = 0; i < max; ++i) {
                if (!fields[i].match(name)) continue;
                User.error((Located)this.sym, max - i >= NiceClass.this.fields.length ? "A field with the same name exists in a super-class" : "A field with the same name exists in this class");
            }
        }

        public String toString() {
            return (this.isFinal ? "final " : "") + super.toString();
        }
    }

    abstract class Field {
        MonoSymbol sym;
        Expression value;
        NiceFieldAccess method;

        private Field(MonoSymbol sym, Expression value) {
            this.sym = sym;
            this.value = value;
            sym.propagate = 4;
            this.method = new NiceFieldAccess(NiceClass.this, this);
            NiceClass.this.definition.addChild(this.method);
        }

        NiceClass getDeclaringClass() {
            return NiceClass.this;
        }

        abstract boolean isFinal();

        void resolve(VarScope scope, TypeScope typeScope) {
            this.sym.type = this.sym.syntacticType.resolve(typeScope);
            if (Types.isVoid(this.sym.type)) {
                User.error((Located)this.sym, "A field cannot have void type");
            }
            this.value = dispatch.analyse(this.value, scope, typeScope);
        }

        FormalParameters.Parameter asParameter() {
            Monotype type = this.sym.syntacticType;
            if (this.value == null) {
                return new FormalParameters.NamedParameter(type, this.sym.getName(), true);
            }
            return new FormalParameters.OptionalParameter(type, this.sym.getName(), true, this.value);
        }

        void typecheck() {
            if (this.value != null) {
                NiceClass.this.enterTypingContext();
                Polytype declaredType = this.sym.getType();
                this.value = this.value.resolveOverloading(declaredType);
                dispatch.typecheck(this.value);
                try {
                    Typing.leq(this.value.getType(), declaredType);
                }
                catch (TypingEx ex) {
                    throw dispatch.assignmentError(this.value, this.sym.getName().toString(), this.sym.getType().toString(), this.value);
                }
            }
        }

        public String toString() {
            return this.sym + (this.value == null ? "" : " = " + this.value);
        }
    }
}

