/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.ConstantExp;
import bossa.syntax.EnumDefinition;
import bossa.syntax.Expression;
import bossa.syntax.GlobalVarDeclaration;
import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.NewExp;
import bossa.syntax.Node;
import bossa.syntax.NullExp;
import bossa.syntax.PrimitiveType;
import bossa.syntax.StringConstantExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.Type;
import gnu.expr.QuoteExp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Constraint;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;
import nice.tools.code.Types;

public class Pattern
implements Located {
    LocatedString name;
    LocatedString refName;
    private TypeIdent typeConstructor;
    private TypeIdent additional;
    TypeConstructor tc;
    TypeConstructor tc2;
    private TypeConstructor runtimeTC;
    private Constraint constraint;
    private Monotype patternType;
    private boolean exactlyAt;
    public ConstantExp atValue;
    public int compareKind = 0;
    public static final int NONE = 0;
    public static final int LT = 1;
    public static final int LE = 2;
    public static final int GT = 4;
    public static final int GE = 5;
    private Location location;

    public Pattern(LocatedString name, TypeIdent tc, ConstantExp atValue, LocatedString refName, boolean exactlyAt, int kind, TypeIdent additional, TypeConstructor runtimeTC, Location location) {
        this.name = name;
        this.typeConstructor = tc;
        this.additional = additional;
        this.runtimeTC = runtimeTC;
        this.atValue = atValue;
        this.exactlyAt = exactlyAt;
        this.compareKind = kind;
        this.refName = refName;
        this.location = location;
        if (atValue != null) {
            if (atValue instanceof StringConstantExp) {
                this.typeConstructor = new TypeIdent(new LocatedString("java.lang.String", atValue.location()));
            } else {
                this.tc = atValue.tc;
            }
        }
    }

    Pattern(LocatedString name, TypeIdent tc) {
        this(name, tc, null, null, false, 0, null, null, name.location());
    }

    Pattern(TypeConstructor tc, boolean exactlyAt) {
        this.tc = tc;
        this.exactlyAt = exactlyAt;
    }

    Pattern(ConstantExp atValue) {
        this(null, null, atValue, null, false, 0, null, null, atValue != null ? atValue.location() : Location.nowhere());
    }

    Pattern(int kind, ConstantExp atValue) {
        this(null, null, atValue, null, false, kind, null, null, atValue.location());
    }

    Pattern(LocatedString name) {
        this(name, null, null, null, false, 0, null, null, name.location());
    }

    static Pattern any(LocatedString name) {
        Pattern res = new Pattern(name);
        return res;
    }

    public final TypeConstructor getTC() {
        return this.tc;
    }

    final TypeConstructor getRuntimeTC() {
        return this.runtimeTC;
    }

    void resolveTC(TypeScope scope) {
        ClassDefinition def;
        if (this.typeConstructor != null) {
            TypeSymbol sym = this.typeConstructor.resolveToTypeSymbol(scope);
            if (sym != TopMonotype.instance) {
                if (sym instanceof TypeConstructor) {
                    this.tc = (TypeConstructor)sym;
                } else {
                    throw User.error((Located)this, this.typeConstructor + " is not a declared class or interface");
                }
            }
            if (this.exactlyAt && !TypeConstructors.instantiable(this.tc)) {
                User.error((Located)this.typeConstructor.location(), "Pattern #" + this.typeConstructor + " cannot be matched because interfaces and abstract classes do not have direct instances.");
            }
            this.typeConstructor = null;
        }
        if (this.additional != null) {
            this.tc2 = this.additional.resolveToTC(scope);
            this.additional = null;
        }
        if ((def = ClassDefinition.get(this.tc)) == null) {
            return;
        }
        Polytype classType = def.getConstrainedType();
        if (classType != null) {
            this.constraint = classType.getConstraint();
            this.patternType = classType.getMonotype();
        }
    }

    private static VarSymbol findRefSymbol(LocatedString refName) {
        VarSymbol symbol = null;
        Iterator it = Node.getGlobalScope().lookup(refName).iterator();
        while (it.hasNext()) {
            Object sym = it.next();
            if (!(sym instanceof GlobalVarDeclaration.GlobalVarSymbol) && !(sym instanceof EnumDefinition.EnumSymbol)) continue;
            symbol = (VarSymbol)sym;
        }
        return symbol;
    }

    void resolveGlobalConstants() {
        Expression val;
        MonoSymbol symbol;
        VarSymbol sym;
        if (this.refName != null) {
            sym = Pattern.findRefSymbol(this.refName);
            if (sym instanceof GlobalVarDeclaration.GlobalVarSymbol && ((GlobalVarDeclaration.GlobalVarSymbol)(symbol = (GlobalVarDeclaration.GlobalVarSymbol)sym)).getValue() instanceof ConstantExp && ((GlobalVarDeclaration.GlobalVarSymbol)symbol).constant) {
                val = (ConstantExp)((GlobalVarDeclaration.GlobalVarSymbol)symbol).getValue();
                if (Typing.testRigidLeq(((ConstantExp)val).tc, PrimitiveType.longTC)) {
                    this.tc = ((ConstantExp)val).tc;
                    this.atValue = val;
                    return;
                }
            }
            User.error((Located)this.refName, this.refName.toString() + " is not a global constant with an integer value.");
        }
        if (this.name == null) {
            return;
        }
        sym = Pattern.findRefSymbol(this.name);
        if (sym == null) {
            return;
        }
        if (sym instanceof EnumDefinition.EnumSymbol) {
            symbol = (EnumDefinition.EnumSymbol)sym;
            val = (NewExp)((EnumDefinition.EnumSymbol)symbol).getValue();
            this.tc = val.tc;
            this.atValue = new ConstantExp(null, this.tc, symbol, this.name.toString(), this.location);
            return;
        }
        symbol = (GlobalVarDeclaration.GlobalVarSymbol)sym;
        if (((GlobalVarDeclaration.GlobalVarSymbol)symbol).getValue() instanceof ConstantExp) {
            if (!((GlobalVarDeclaration.GlobalVarSymbol)symbol).constant) {
                User.error((Located)this.name, "" + this.name + " is not constant");
            }
            val = (ConstantExp)((GlobalVarDeclaration.GlobalVarSymbol)symbol).getValue();
            if (((ConstantExp)val).tc == PrimitiveType.floatTC) {
                return;
            }
            if (val instanceof StringConstantExp) {
                this.typeConstructor = new TypeIdent(new LocatedString("java.lang.String", this.location));
            }
            this.tc = ((ConstantExp)val).tc;
            this.atValue = val;
        } else if (((GlobalVarDeclaration.GlobalVarSymbol)symbol).getValue() instanceof NewExp) {
            val = (NewExp)((GlobalVarDeclaration.GlobalVarSymbol)symbol).getValue();
            this.tc = val.tc;
            this.atValue = new ConstantExp(null, this.tc, symbol, this.name.toString(), this.location);
        } else {
            User.error((Located)this.name, "The value of " + this.name + " can't be used as pattern");
        }
    }

    static void resolve(TypeScope tscope, VarScope vscope, Pattern[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i].resolveTC(tscope);
        }
    }

    static void resolveValues(Pattern[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i].resolveGlobalConstants();
        }
    }

    static void in(Monotype[] monotypes, Pattern[] patterns) throws TypingEx {
        for (int i = 0; i < monotypes.length; ++i) {
            patterns[i].leq(monotypes[i]);
        }
    }

    private void leq(Monotype m) throws TypingEx {
        nice.tools.typing.Types.setMarkedKind(m);
        m = m.equivalent();
        if (!(m instanceof MonotypeConstructor)) {
            Internal.error("Nullness check");
        }
        MonotypeConstructor mc = (MonotypeConstructor)m;
        if (this.atNull()) {
            Typing.leq(PrimitiveType.maybeTC, mc.getTC());
        }
        if (this.tc == null) {
            return;
        }
        Typing.leq(mc.getTC(), PrimitiveType.sureTC);
        Monotype type = nice.tools.typing.Types.rawType(mc);
        if (this.constraint != null) {
            this.constraint.enter();
            Typing.leq(type, this.patternType);
            if (this.exactlyAt) {
                Typing.leq(this.patternType, type);
                MonotypeConstructor inner = (MonotypeConstructor)type.equivalent();
                inner.getTC().setMinimal();
            }
        } else {
            Typing.leq(type, this.tc);
            if (this.exactlyAt) {
                Typing.leq(this.tc, type);
                MonotypeConstructor inner = (MonotypeConstructor)type.equivalent();
                inner.getTC().setMinimal();
            }
        }
    }

    static void inDomain(Pattern[] patterns, Monotype[] types) throws TypingEx {
        int i;
        for (i = 0; i < patterns.length; ++i) {
            nice.tools.typing.Types.setMarkedKind(types[i]);
        }
        for (i = 0; i < patterns.length; ++i) {
            patterns[i].inDomain(nice.tools.typing.Types.rawType(types[i]));
        }
    }

    private void inDomain(Monotype type) throws TypingEx {
        if (this.constraint != null) {
            this.constraint.enter();
            Typing.leq(this.patternType, type);
        } else {
            Typing.leq(this.tc, type);
        }
        if (this.tc2 != null) {
            Typing.leq(this.tc2, type);
        }
    }

    static TypeConstructor[] getTC(Pattern[] patterns) {
        TypeConstructor[] res = new TypeConstructor[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            res[i] = patterns[i].tc;
        }
        return res;
    }

    static TypeConstructor[] getAdditionalTC(Pattern[] patterns) {
        TypeConstructor[] res = new TypeConstructor[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            res[i] = patterns[i].tc2;
        }
        return res;
    }

    public boolean leq(Pattern that) {
        if (that.atAny() || this == that) {
            return true;
        }
        if (this.atAny()) {
            return false;
        }
        if (that.atNull() && this.atNull()) {
            return true;
        }
        if (that.atNull() || this.atNull()) {
            return false;
        }
        if (that.atNonNull()) {
            return true;
        }
        if (this.atNonNull()) {
            return false;
        }
        if (that.atBool()) {
            return this.atBool() && this.atTrue() == that.atTrue();
        }
        if (this.atBool()) {
            return that.tc == PrimitiveType.boolTC;
        }
        if (this.atEnum() && that.atEnum()) {
            return false;
        }
        if (this.atIntCompare() && that.atIntCompare()) {
            if (this.atLess() != that.atLess()) {
                return false;
            }
            long val = this.atValue.longValue();
            if (this.compareKind == 1) {
                --val;
            }
            if (this.compareKind == 4) {
                ++val;
            }
            return that.matchesCompareValue(val);
        }
        if (that.atIntCompare()) {
            return this.atIntValue() && that.matchesCompareValue(this.atValue.longValue());
        }
        if (that.atNonBoolValue()) {
            return this.atNonBoolValue() && this.atValue.equals(that.atValue);
        }
        if (this.tc == that.tc) {
            return this.exactlyAt || !that.exactlyAt;
        }
        return Typing.testRigidLeq(this.tc, that.tc);
    }

    public boolean matches(TypeConstructor tag) {
        if (this.atAny()) {
            return true;
        }
        if (this.atNull()) {
            return tag == PrimitiveType.nullTC;
        }
        if (this.atNonNull()) {
            return tag != PrimitiveType.nullTC;
        }
        if (tag == null) {
            return false;
        }
        if (this.atNonBoolValue() && !this.atEnum()) {
            return false;
        }
        if (this.atIntCompare()) {
            return Typing.testRigidLeq(tag, PrimitiveType.longTC);
        }
        if (tag == PrimitiveType.trueBoolTC) {
            if (this.atBool()) {
                return this.atTrue();
            }
            return this.tc == PrimitiveType.boolTC;
        }
        if (tag == PrimitiveType.falseBoolTC) {
            if (this.atBool()) {
                return this.atFalse();
            }
            return this.tc == PrimitiveType.boolTC;
        }
        if (this.exactlyAt) {
            return Typing.testRigidLeq(tag, this.tc) && Typing.testRigidLeq(this.tc, tag);
        }
        return Typing.testRigidLeq(tag, this.tc);
    }

    public boolean matchesValue(ConstantExp val) {
        if (this.atAny()) {
            return true;
        }
        if (this.atIntCompare()) {
            return val.value instanceof Number && this.matchesCompareValue(val.longValue());
        }
        return this.atNonBoolValue() && this.atValue.equals(val);
    }

    private boolean matchesCompareValue(long val) {
        if (this.compareKind == 1) {
            return val < this.atValue.longValue();
        }
        if (this.compareKind == 2) {
            return val <= this.atValue.longValue();
        }
        if (this.compareKind == 5) {
            return val >= this.atValue.longValue();
        }
        if (this.compareKind == 4) {
            return val > this.atValue.longValue();
        }
        return false;
    }

    public void setDomainEq(boolean equal) {
        if (equal && this.atValue == null && !this.exactlyAt) {
            this.tc = null;
        }
        if (!equal && this.atValue == null && Typing.testRigidLeq(this.tc, PrimitiveType.longTC)) {
            User.error((Located)this.location, "A pattern cannot have a primitive type that is different from the declaration.");
        }
    }

    public void setDomainTC(TypeConstructor domaintc) {
        if (this.atIntValue()) {
            if (domaintc != null) {
                if (Typing.testRigidLeq(domaintc, PrimitiveType.intTC)) {
                    this.tc = PrimitiveType.intTC;
                    return;
                }
                if (Typing.testRigidLeq(domaintc, PrimitiveType.longTC)) {
                    this.tc = PrimitiveType.longTC;
                    return;
                }
                if (Typing.testRigidLeq(domaintc, PrimitiveType.charTC)) {
                    return;
                }
            }
            User.error((Located)this.location, "Integer value patterns are not allowed for methods where the declared parameter isn't a primitive type.");
        }
    }

    public List getEnumValues() {
        LinkedList<ConstantExp> res = new LinkedList<ConstantExp>();
        if (!this.atEnum()) {
            return res;
        }
        List symbols = ((EnumDefinition)((EnumDefinition.EnumSymbol)this.atValue.value).getDefinition()).symbols;
        Iterator it = symbols.iterator();
        while (it.hasNext()) {
            EnumDefinition.EnumSymbol sym = (EnumDefinition.EnumSymbol)it.next();
            res.add(new ConstantExp(null, this.tc, sym, sym.name.toString(), this.location));
        }
        return res;
    }

    public String toString() {
        if (this.atIntCompare()) {
            String prefix = "";
            if (this.compareKind == 1) {
                prefix = "<";
            }
            if (this.compareKind == 2) {
                prefix = "<=";
            }
            if (this.compareKind == 4) {
                prefix = ">";
            }
            if (this.compareKind == 5) {
                prefix = ">=";
            }
            return (this.name != null ? this.name.toString() : "") + prefix + this.atValue;
        }
        if (this.atValue != null) {
            return this.atValue.toString();
        }
        if (this.atAny()) {
            return this.name != null ? this.name.toString() : "Any";
        }
        StringBuffer res = new StringBuffer();
        res.append(this.exactlyAt ? "#" : (this.name != null ? "" : "@"));
        if (this.typeConstructor != null) {
            res.append(this.typeConstructor);
        } else if (this.tc != null) {
            res.append(this.tc);
        }
        if (this.name != null) {
            res.append(" " + this.name);
        }
        return res.toString();
    }

    public Location location() {
        return this.location;
    }

    public String bytecodeRepresentation() {
        if (this.atAny()) {
            return "@_";
        }
        if (this.atNull()) {
            return "@NULL";
        }
        if (this.atValue != null) {
            if (this.atIntCompare()) {
                String prefix = "";
                if (this.compareKind == 1) {
                    prefix = "<";
                }
                if (this.compareKind == 2) {
                    prefix = "<=";
                }
                if (this.compareKind == 4) {
                    prefix = ">";
                }
                if (this.compareKind == 5) {
                    prefix = ">=";
                }
                return "@" + prefix + this.atValue;
            }
            if (this.atValue.value instanceof Number) {
                return "@" + (this.atValue.longValue() >= 0L ? "+" : "") + this.atValue;
            }
            if (this.atValue.value instanceof Character) {
                return "@'" + this.atValue.value + "'";
            }
            if (this.atReference()) {
                return "@=" + this.name;
            }
            if (this.atString()) {
                return "@\"" + ((StringConstantExp)this.atValue).escapedValue + "\"";
            }
            return "@" + this.atValue;
        }
        return (this.exactlyAt ? "#" : "@") + this.tc.toString().replace('$', '.');
    }

    public static String bytecodeRepresentation(Pattern[] patterns) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < patterns.length; ++i) {
            res.append(patterns[i].bytecodeRepresentation());
        }
        return res.toString();
    }

    public static Pattern read(String rep, int[] pos, String methodName) {
        if (pos[0] >= rep.length()) {
            return null;
        }
        if (rep.charAt(pos[0]) != '@' && rep.charAt(pos[0]) != '#') {
            Internal.error("Invalid pattern representation at character " + pos[0] + ": " + rep);
        }
        boolean exact = rep.charAt(pos[0]) == '#';
        int start = pos[0] = pos[0] + 1;
        int len = rep.length();
        if (rep.charAt(pos[0]) == '\'') {
            pos[0] = pos[0] + 3;
        } else if (rep.charAt(pos[0]) == '\"') {
            pos[0] = pos[0] + 2;
            while (pos[0] < len && (rep.charAt(pos[0]) != '@' && rep.charAt(pos[0]) == '#' || rep.charAt(pos[0] - 1) != '\"' || rep.charAt(pos[0] - 2) == '\\')) {
                pos[0] = pos[0] + 1;
            }
        } else {
            while (pos[0] < len && rep.charAt(pos[0]) != '@' && rep.charAt(pos[0]) != '#') {
                pos[0] = pos[0] + 1;
            }
        }
        String name = rep.substring(start, pos[0]);
        if (name.length() > 1) {
            if (name.charAt(0) == '\'') {
                return new Pattern(new ConstantExp(PrimitiveType.charTC, new Character(name.charAt(1)), name, Location.nowhere()));
            }
            if (name.charAt(0) == '-') {
                return new Pattern(ConstantExp.makeNumber(new LocatedString(name, Location.nowhere())));
            }
            if (name.charAt(0) == '+') {
                return new Pattern(ConstantExp.makeNumber(new LocatedString(name.substring(1), Location.nowhere())));
            }
            if (name.charAt(0) == '\"') {
                return new Pattern(ConstantExp.makeString(new LocatedString(name.substring(1, name.length() - 1), Location.nowhere())));
            }
            if (name.charAt(0) == '<') {
                if (name.charAt(1) == '=') {
                    return new Pattern(2, ConstantExp.makeNumber(new LocatedString(name.substring(2), Location.nowhere())));
                }
                return new Pattern(1, ConstantExp.makeNumber(new LocatedString(name.substring(1), Location.nowhere())));
            }
            if (name.charAt(0) == '>') {
                if (name.charAt(1) == '=') {
                    return new Pattern(5, ConstantExp.makeNumber(new LocatedString(name.substring(2), Location.nowhere())));
                }
                return new Pattern(4, ConstantExp.makeNumber(new LocatedString(name.substring(1), Location.nowhere())));
            }
            if (name.charAt(0) == '=') {
                NewExp val;
                LocatedString refName = new LocatedString(name.substring(1), Location.nowhere());
                VarSymbol sym = Pattern.findRefSymbol(refName);
                if (sym instanceof GlobalVarDeclaration.GlobalVarSymbol) {
                    GlobalVarDeclaration.GlobalVarSymbol symbol = (GlobalVarDeclaration.GlobalVarSymbol)sym;
                    val = (NewExp)symbol.getValue();
                } else {
                    EnumDefinition.EnumSymbol symbol = (EnumDefinition.EnumSymbol)sym;
                    val = (NewExp)symbol.getValue();
                }
                return new Pattern(new ConstantExp(null, val.tc, sym, refName.toString(), refName.location()));
            }
        }
        if (name.equals("_")) {
            return new Pattern((ConstantExp)null);
        }
        if (name.equals("NULL")) {
            return new Pattern(NullExp.create(Location.nowhere()));
        }
        if (name.equals("true") || name.equals("false")) {
            return new Pattern(ConstantExp.makeBoolean(name.equals("true"), Location.nowhere()));
        }
        TypeSymbol sym = Node.getGlobalTypeScope().lookup(name);
        if (sym == null) {
            throw new Unknown();
        }
        return new Pattern((TypeConstructor)sym, exact);
    }

    public gnu.expr.Expression matchTest(gnu.expr.Expression parameter, boolean dispatchMade) {
        if (this.atAny() || dispatchMade && !this.exactlyAt) {
            return QuoteExp.trueExp;
        }
        if (this.atNull()) {
            return Gen.isNullExp(parameter);
        }
        if (this.atBool()) {
            if (this.atFalse()) {
                return Gen.boolNotExp(parameter);
            }
            return parameter;
        }
        if (this.atIntValue()) {
            String kind = this.compareKind == 1 ? "Lt" : (this.compareKind == 2 ? "Le" : (this.compareKind == 5 ? "Ge" : (this.compareKind == 4 ? "Gt" : "Eq")));
            return Gen.integerComparison(kind, parameter, this.atValue.longValue());
        }
        if (this.atString()) {
            return Gen.stringEquals((String)this.atValue.value, parameter);
        }
        if (this.atReference()) {
            return Gen.referenceEqualsExp(this.atValue.compile(), parameter);
        }
        Type ct = Types.javaType(this.tc);
        if (this.exactlyAt) {
            return Gen.isOfClass(parameter, ct);
        }
        return Gen.instanceOfExp(parameter, ct);
    }

    public boolean atIntValue() {
        return this.atValue != null && (this.atValue.value instanceof Number || this.atValue.value instanceof Character);
    }

    public boolean atNonBoolValue() {
        return this.atValue != null && !this.atBool() && !this.atNull() && !this.atIntCompare();
    }

    public boolean atNull() {
        return this.atValue instanceof NullExp;
    }

    public boolean atNonNull() {
        return this.tc == PrimitiveType.sureTC;
    }

    public boolean atAny() {
        return this.atValue == null && this.tc == null;
    }

    public boolean atBool() {
        return this.atValue != null && this.tc == PrimitiveType.boolTC;
    }

    public boolean atTrue() {
        return this.atValue != null && this.atValue.isTrue();
    }

    public boolean atFalse() {
        return this.atValue != null && this.atValue.isFalse();
    }

    public boolean atString() {
        return this.atValue instanceof StringConstantExp;
    }

    public boolean atReference() {
        return this.atValue != null && this.atValue.value instanceof VarSymbol;
    }

    public boolean atEnum() {
        return this.atReference() && this.atValue.value instanceof EnumDefinition.EnumSymbol;
    }

    public boolean atIntCompare() {
        return this.compareKind > 0;
    }

    public boolean atLess() {
        return this.compareKind == 1 || this.compareKind == 2;
    }

    public boolean atTypeMatchingValue() {
        return this.atEnum() || this.atIntCompare();
    }

    public static class Unknown
    extends RuntimeException {
    }
}

