/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.MethodDeclaration;
import gnu.bytecode.ClassType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.TypeConstructor;
import nice.tools.code.Types;

public final class TypeConstructors {
    private static HashMap constructors;

    static LinkedList getConstructors(TypeConstructor tc) {
        return (LinkedList)constructors.get(tc);
    }

    static void addConstructor(TypeConstructor tc, MethodDeclaration m) {
        LinkedList<MethodDeclaration.Symbol> l = (LinkedList<MethodDeclaration.Symbol>)constructors.get(tc);
        if (l == null) {
            l = new LinkedList<MethodDeclaration.Symbol>();
            constructors.put(tc, l);
        }
        l.add(m.getSymbol());
    }

    static void removeConstructor(TypeConstructor tc, MethodDeclaration m) {
        List l = (List)constructors.get(tc);
        if (l == null) {
            return;
        }
        l.remove(m.getSymbol());
    }

    public static void reset() {
        constructors = new HashMap();
    }

    static boolean instantiable(TypeConstructor tc) {
        if (tc.isConcrete()) {
            return true;
        }
        ClassDefinition definition = ClassDefinition.get(tc);
        return definition != null && definition.isConcrete();
    }

    static boolean isInterface(TypeConstructor tc) {
        ClassDefinition def = ClassDefinition.get(tc);
        if (def instanceof ClassDefinition.Interface) {
            return true;
        }
        if (def != null) {
            return false;
        }
        ClassType c = (ClassType)Types.get(tc);
        return c != null && c.isInterface();
    }

    static boolean isClass(TypeConstructor tc) {
        return Types.get(tc) != null;
    }
}

