/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

public class ArrayClassLoader
extends ClassLoader {
    byte[][] classBytes;
    int size;
    Class[] loadedClasses;
    String[] classNames;

    public ArrayClassLoader(byte[][] classBytes) {
        this.classBytes = classBytes;
        this.size = classBytes.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.classNames[i] = "lambda" + i;
        }
    }

    public ArrayClassLoader(String[] classNames, byte[][] classBytes) {
        this.classBytes = classBytes;
        this.size = classBytes.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = classNames;
    }

    private void reserve(int count) {
        int newLength;
        if (count <= 0) {
            return;
        }
        int n = newLength = this.size < count ? this.size + count : 2 * this.size;
        if (this.loadedClasses == null) {
            this.loadedClasses = new Class[newLength];
        } else if (this.size + count > this.loadedClasses.length) {
            Class[] loadedClassesNew = new Class[newLength];
            System.arraycopy(this.loadedClasses, 0, loadedClassesNew, 0, this.size);
            this.loadedClasses = loadedClassesNew;
        }
        if (this.classBytes == null) {
            this.classBytes = new byte[newLength][];
        } else if (this.size + count > this.classBytes.length) {
            byte[][] classBytesNew = new byte[newLength][];
            System.arraycopy(this.classBytes, 0, classBytesNew, 0, this.size);
            this.classBytes = classBytesNew;
        }
        if (this.classNames == null) {
            this.classNames = new String[newLength];
        } else if (this.size + count > this.classNames.length) {
            String[] classNamesNew = new String[newLength];
            System.arraycopy(this.classNames, 0, classNamesNew, 0, this.size);
            this.classNames = classNamesNew;
        }
    }

    public void addClass(String name, byte[] bytes) {
        this.reserve(1);
        this.classNames[this.size] = name == null ? "lambda" + this.size : name;
        this.classBytes[this.size] = bytes;
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        void var3_4;
        int index = 0;
        while (true) {
            Class<?> clas;
            if (index >= this.size) {
                clas = Class.forName(name);
                break;
            }
            if (name.equals(this.classNames[index])) {
                clas = this.loadedClasses[index];
                if (clas != null) break;
                byte[] bytes = this.classBytes[index];
                this.loadedClasses[index] = clas = this.defineClass(name, bytes, 0, bytes.length);
                this.classBytes[index] = null;
                break;
            }
            ++index;
        }
        if (resolve) {
            this.resolveClass((Class<?>)var3_4);
        }
        return var3_4;
    }
}

