/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.CpsMethodContainer;
import gnu.mapping.CpsMethodProc;
import gnu.mapping.CpsProcedure;
import gnu.mapping.Procedure;

public abstract class CallFrame
extends CpsProcedure
implements Cloneable,
CpsMethodContainer {
    public Object[] args;
    public Procedure proc;
    protected Procedure caller;
    protected int saved_pc;
    protected int numArgs;

    public int numArgs() {
        return this.numArgs;
    }

    public void apply(CpsMethodProc proc, CallContext context) {
        context.pc = proc.selector;
        this.step(context);
    }

    public void apply(CallContext stack) {
        Object[] args = stack.values;
        Procedure.checkArgCount(this, args.length);
        try {
            CallFrame frame = (CallFrame)this.clone();
            frame.args = args;
            frame.caller = stack.proc;
            frame.saved_pc = stack.pc;
            frame.proc = this;
            stack.proc = frame;
            stack.pc = this.saved_pc;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public abstract void step(CallContext var1);
}

