/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;

public abstract class RealNum
extends Complex {
    public final RealNum re() {
        return this;
    }

    public final RealNum im() {
        return IntNum.zero();
    }

    public abstract boolean isNegative();

    public abstract int sign();

    public RealNum max(RealNum x) {
        RealNum result;
        boolean exact = this.isExact() && x.isExact();
        RealNum realNum = result = this.grt(x) ? this : x;
        if (!exact && result.isExact()) {
            result = new DFloNum(result.doubleValue());
        }
        return result;
    }

    public RealNum min(RealNum x) {
        RealNum result;
        boolean exact = this.isExact() && x.isExact();
        RealNum realNum = result = this.grt(x) ? x : this;
        if (!exact && result.isExact()) {
            result = new DFloNum(result.doubleValue());
        }
        return result;
    }

    public static RealNum add(RealNum x, RealNum y, int k) {
        return (RealNum)x.add(y, k);
    }

    public static RealNum mul(RealNum x, RealNum y) {
        return (RealNum)x.mul(y);
    }

    public static RealNum div(RealNum x, RealNum y) {
        return (RealNum)x.div(y);
    }

    public abstract Numeric add(Object var1, int var2);

    public abstract Numeric mul(Object var1);

    public abstract Numeric div(Object var1);

    public RealNum angle() {
        return IntNum.zero();
    }

    public Numeric abs() {
        return this.isNegative() ? this.neg() : this;
    }

    public final RealNum rneg() {
        return (RealNum)this.neg();
    }

    public boolean isZero() {
        return this.sign() == 0;
    }

    public RatNum toExact() {
        return DFloNum.toExact(this.doubleValue());
    }

    public static double toInt(double d, int rounding_mode) {
        switch (rounding_mode) {
            case 1: {
                return Math.floor(d);
            }
            case 2: {
                return Math.ceil(d);
            }
            case 3: {
                return d < 0.0 ? Math.ceil(d) : Math.floor(d);
            }
            case 4: {
                return Math.rint(d);
            }
        }
        return d;
    }

    public RealNum toInt(int rounding_mode) {
        return new DFloNum(RealNum.toInt(this.doubleValue(), rounding_mode));
    }

    public IntNum toExactInt(int rounding_mode) {
        return RealNum.toExactInt(this.doubleValue(), rounding_mode);
    }

    public static IntNum toExactInt(double value, int rounding_mode) {
        return RealNum.toExactInt(RealNum.toInt(value, rounding_mode));
    }

    public static IntNum toExactInt(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new ArithmeticException("cannot convert " + value + " to exact integer");
        }
        long bits = Double.doubleToLongBits(value);
        boolean neg = bits < 0L;
        int exp = (int)(bits >> 52) & 0x7FF;
        bits &= 0xFFFFFFFFFFFFFL;
        bits = exp == 0 ? (bits <<= 1) : (bits |= 0x10000000000000L);
        if (exp <= 1075) {
            int rshift = 1075 - exp;
            if (rshift > 53) {
                return IntNum.zero();
            }
            return IntNum.make(neg ? -bits : (bits >>= rshift));
        }
        return IntNum.shift(IntNum.make(neg ? -bits : bits), exp - 1075);
    }

    public Complex exp() {
        return new DFloNum(Math.exp(this.doubleValue()));
    }

    public Complex log() {
        double x = this.doubleValue();
        if (x < 0.0) {
            return DComplex.log(x, 0.0);
        }
        return new DFloNum(Math.log(x));
    }

    public final Complex sin() {
        return new DFloNum(Math.sin(this.doubleValue()));
    }

    public final Complex sqrt() {
        double d = this.doubleValue();
        if (d >= 0.0) {
            return new DFloNum(Math.sqrt(d));
        }
        return DComplex.sqrt(d, 0.0);
    }

    public static IntNum toScaledInt(double f, int k) {
        return RealNum.toScaledInt(DFloNum.toExact(f), k);
    }

    public static IntNum toScaledInt(RatNum r, int k) {
        if (k != 0) {
            IntNum power = IntNum.power(IntNum.ten(), k < 0 ? -k : k);
            IntNum num = r.numerator();
            IntNum den = r.denominator();
            if (k >= 0) {
                num = IntNum.times(num, power);
            } else {
                den = IntNum.times(den, power);
            }
            r = RatNum.make(num, den);
        }
        return r.toExactInt(4);
    }

    public IntNum toScaledInt(int k) {
        return RealNum.toScaledInt(this.toExact(), k);
    }
}

