/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.ArrayList;
import java.util.HashMap;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.Domain;
import mlsub.typing.FunType;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeLeqCst;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;

public final class Polytype {
    private boolean simplified = true;
    private Constraint constraint;
    private Monotype monotype;
    public static boolean noSimplify;

    public Polytype(Constraint constraint, Monotype monotype) {
        this.constraint = constraint;
        this.monotype = monotype;
    }

    public Polytype(Monotype monotype) {
        this.constraint = null;
        this.monotype = monotype;
    }

    public final boolean isMonomorphic() {
        return !Constraint.hasBinders(this.constraint);
    }

    public Polytype cloneType() {
        if (this.isMonomorphic()) {
            return this;
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>();
        TypeSymbol[] binders = this.constraint.binders();
        TypeSymbol[] newBinders = new TypeSymbol[binders.length];
        for (int i = 0; i < binders.length; ++i) {
            newBinders[i] = binders[i].cloneTypeSymbol();
            map2.put(binders[i], newBinders[i]);
            if (!(binders[i] instanceof MonotypeVar) || ((MonotypeVar)binders[i]).persistentKind == null) continue;
            MonotypeConstructor mc = (MonotypeConstructor)((MonotypeVar)binders[i]).equivalent();
            MonotypeConstructor nmc = (MonotypeConstructor)((MonotypeVar)newBinders[i]).equivalent();
            map2.put(mc.getTC(), nmc.getTC());
            map2.put(mc.getTP()[0], nmc.getTP()[0]);
        }
        return new Polytype(new Constraint(newBinders, AtomicConstraint.substitute(map2, this.constraint.atoms())), this.monotype.substitute(map2));
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public static Constraint[] getConstraint(Polytype[] p) {
        Constraint[] res = new Constraint[p.length];
        for (int i = 0; i < p.length; ++i) {
            res[i] = p[i].getConstraint();
        }
        return res;
    }

    public Monotype getMonotype() {
        return this.monotype;
    }

    public static Monotype[] getMonotype(Polytype[] p) {
        Monotype[] res = new Monotype[p.length];
        for (int i = 0; i < p.length; ++i) {
            res[i] = p[i].getMonotype();
        }
        return res;
    }

    public static final Polytype bottom() {
        MonotypeVar alpha = new MonotypeVar();
        return new Polytype(new Constraint(new TypeSymbol[]{alpha}, null), alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkWellFormedness() throws TypingEx {
        if (!Constraint.hasBinders(this.constraint)) {
            return;
        }
        Typing.enter();
        try {
            this.constraint.enter();
        }
        finally {
            Typing.leave();
        }
    }

    public static Polytype apply(Polytype funt, Polytype[] parameters) {
        return Polytype.apply(funt.constraint, (FunType)funt.monotype, parameters);
    }

    public static Polytype apply(Constraint cst, FunType type, Polytype[] parameters) {
        Monotype codom = type.codomain();
        if (codom.isRigid()) {
            return new Polytype(Constraint.True, codom);
        }
        Monotype[] dom = type.domain();
        cst = Constraint.and(Polytype.getConstraint(parameters), cst, MonotypeLeqCst.constraint(Polytype.getMonotype(parameters), dom));
        Polytype res = new Polytype(cst, codom);
        res.simplified = false;
        return res;
    }

    public static Polytype union(Polytype t1, Polytype t2) {
        if (t1 == t2) {
            return t1;
        }
        MonotypeVar t = new MonotypeVar();
        Constraint c = Constraint.and(t, t1.constraint, t2.constraint, (AtomicConstraint)new MonotypeLeqCst(t1.monotype, t), (AtomicConstraint)new MonotypeLeqCst(t2.monotype, t));
        Polytype res = new Polytype(c, t);
        res.simplified = false;
        return res;
    }

    public static Polytype union(Polytype[] types) {
        if (types.length == 0) {
            return Polytype.bottom();
        }
        MonotypeVar t = new MonotypeVar();
        Constraint c = new Constraint(new TypeSymbol[]{t}, null);
        for (int i = 0; i < types.length; ++i) {
            c = Constraint.and(c, types[i].constraint, new MonotypeLeqCst(types[i].monotype, t));
        }
        Polytype res = new Polytype(c, t);
        res.simplified = false;
        return res;
    }

    public Monotype[] domain() {
        Monotype m = this.monotype.equivalent();
        if (!(m instanceof FunType)) {
            return null;
        }
        return ((FunType)m).domain();
    }

    public Monotype codomain() {
        Monotype m = this.monotype.equivalent();
        if (!(m instanceof FunType)) {
            return null;
        }
        return ((FunType)m).codomain();
    }

    public Domain getDomain() {
        Monotype[] domains = this.domain();
        if (domains == null) {
            throw new InternalError("getDomain on non functional polytype " + this);
        }
        return new Domain(this.constraint, domains);
    }

    public void setNotSimplified() {
        this.simplified = false;
    }

    public void simplify() {
        if (!Constraint.hasBinders(this.constraint) || this.simplified || noSimplify) {
            return;
        }
        ArrayList binders = new ArrayList();
        ArrayList atoms = new ArrayList();
        Engine.startSimplify();
        try {
            Constraint.enter(this.constraint);
            Engine.satisfy();
            this.monotype.tag(1);
            Engine.simplify(binders, atoms);
        }
        catch (Unsatisfiable e) {
            this.simplified = true;
            throw new InternalError("Simplifying ill-formed polytype: " + this);
        }
        catch (TypingEx e) {
            this.simplified = true;
            throw new InternalError("Simplifying ill-formed polytype: " + this);
        }
        finally {
            Engine.stopSimplify();
        }
        int nbinders = binders.size();
        int natoms = atoms.size();
        if (nbinders >= this.constraint.binders().length) {
            this.simplified = true;
            return;
        }
        this.monotype = this.monotype.canonify();
        this.constraint = Constraint.create(nbinders == 0 ? null : binders.toArray(new TypeSymbol[nbinders]), natoms == 0 ? null : atoms.toArray(new AtomicConstraint[natoms]));
        this.simplified = true;
    }

    public boolean trySimplify() {
        try {
            this.simplify();
            return true;
        }
        catch (InternalError e) {
            return false;
        }
    }

    public String toString() {
        try {
            this.simplify();
        }
        catch (InternalError e) {
            return Constraint.toString(this.constraint) + this.monotype.toString() + " (Ill-formed type)";
        }
        return Constraint.toString(this.constraint) + String.valueOf(this.monotype);
    }

    public String toStringNoSimplify() {
        return Constraint.toString(this.constraint) + String.valueOf(this.monotype);
    }
}

