/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.util;

import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nice.tools.util.System;

public class ClassLoader {
    private final Object[] locations;
    private final Registrar registrar;

    public ClassLoader(String classpath, Registrar registrar) {
        this.registrar = registrar;
        this.locations = ClassLoader.splitPath(classpath);
    }

    public ClassType load(String className) {
        String filesystemName = className.replace('.', File.separatorChar) + ".class";
        String jarName = className.replace('.', '/') + ".class";
        for (int i = 0; i < this.locations.length; ++i) {
            InputStream input = null;
            if (this.locations[i] instanceof File) {
                File dir = (File)this.locations[i];
                File file = new File(dir, filesystemName);
                try {
                    input = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {}
            } else {
                JarFile jar = (JarFile)this.locations[i];
                JarEntry e = jar.getJarEntry(jarName);
                if (e != null) {
                    try {
                        input = jar.getInputStream(e);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (input == null) continue;
            ClassType res = new ClassType();
            this.registrar.register(className, res);
            try {
                new ClassFileInput(res, input);
                return res;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object[] splitPath(String path) {
        int start;
        LinkedList<Object> res = new LinkedList<Object>();
        for (start = 0; start < path.length() && path.charAt(start) == File.pathSeparatorChar; ++start) {
        }
        while (start < path.length()) {
            File f;
            String pathComponent;
            int end = path.indexOf(File.pathSeparatorChar, start);
            if (end == -1) {
                end = path.length();
            }
            if ((pathComponent = path.substring(start, end)).length() > 0 && (f = System.getFile(pathComponent)).exists()) {
                if (pathComponent.endsWith(".jar")) {
                    try {
                        res.add(new JarFile(f));
                    }
                    catch (IOException e) {}
                } else {
                    res.add(f);
                }
            }
            start = end + 1;
        }
        return res.toArray(new Object[res.size()]);
    }

    public static abstract class Registrar {
        public abstract void register(String var1, ClassType var2);
    }
}

