# -*- coding: utf-8 -*-

from pynicotine.pluginsystem import BasePlugin

class Plugin(BasePlugin):
    __name__ = "Anti-SHOUT"
    __version__ = "2008-11-18r00"
    __MAXSCORE__ = 0.6
    __MINLENGTH__ = 10
    def capitalize(self, text):
        # Dont alter words that look like protocol links (fe http://, ftp://)
        if text.find('://') > -1:
            return text
        return text.capitalize()
    def IncomingPrivateChatEvent(self, nick, line):
        return (nick, self.antishout(line))
    def IncomingPublicChatEvent(self, room, nick, line):
        return (room, nick, self.antishout(line))
    def antishout(self, line):
        lowers = len([x for x in line if x.islower()])
        uppers = len([x for x in line if x.isupper()])
        score = -2 # unknown state (could be: no letters at all)
        if (uppers > 0):
            score = -1 # We have at least some upper letters
        if (lowers > 0):
            score = uppers/float(lowers)
        newline = line
        if len(line) > self.__MINLENGTH__ and (score == -1 or score > self.__MAXSCORE__):
            newline = '. '.join([self.capitalize(x) for x in line.split('. ')])
        if newline == line:
            return newline
        else:
            return newline + " [as]"
