/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Motion controllers
*/

#ifndef __MOTION_H_INCLUDED__
#define __MOTION_H_INCLUDED__

#define GRAVITY		0.5f

struct MotionController
{
	Object		*obj;
	float		x, y;
	float		vx, vy;
	float		mx, my;
	float		gravity;
	float		bounce;
	bool		bouncing;
	bool		onGround;
	bool		solid;
	bool		disableTileCollision;
	
	MotionController(Object *obj);
	~MotionController();
	
	Tile *collides();
	void step();
	
	void applyForce(float fx, float fy);
};

#endif

