/* an input slider ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
slider_done_cb( iWindow *iwnd, void *client, iWindowNotifyFn nfn, void *sys )
{
	Slider *slider = SLIDER( client );
	Stringset *ss = STRINGSET( iwnd );

	StringsetChild *from = stringset_child_get( ss, _( "Minimum" ) );
	StringsetChild *to = stringset_child_get( ss, _( "Maximum" ) );
	StringsetChild *value = stringset_child_get( ss, _( "Value" ) );

	if( !get_geditable_double( from->entry, &slider->from ) ||
		!get_geditable_double( to->entry, &slider->to ) ||
		!get_geditable_double( value->entry, &slider->value ) ) {
		nfn( sys, IWINDOW_ERROR );
		return;
	}
	slider->value = IM_CLIP( slider->from, slider->value, slider->to );

	classmodel_update( CLASSMODEL( slider ) );
	symbol_recalculate_all();

	nfn( sys, IWINDOW_TRUE );
}

static void 
slider_edit( GtkWidget *parent, Model *model )
{
	Slider *slider = SLIDER( model );
	GtkWidget *ss = stringset_new();
	char txt[256];
	BufInfo buf;

	im_snprintf( txt, 256, "%g", slider->from );
	stringset_child_new( STRINGSET( ss ), 
		_( "Minimum" ), txt, _( "Lower slider value" ) );
	im_snprintf( txt, 256, "%g", slider->to );
	stringset_child_new( STRINGSET( ss ), 
		_( "Maximum" ), txt, _( "Upper slider value" ) );
	im_snprintf( txt, 256, "%g", slider->value );
	stringset_child_new( STRINGSET( ss ), 
		_( "Value" ), txt, _( "Set slider value here" ) );

	buf_init_static( &buf, txt, 100 );
	row_qualified_name( HEAPMODEL( slider )->row, &buf );
	iwindow_set_title( IWINDOW( ss ), 
		_( "Edit Slider \"%s\"" ), buf_all( &buf ) );
	idialog_set_callbacks( IDIALOG( ss ), 
		iwindow_true_cb, NULL, NULL, slider );
	idialog_add_ok( IDIALOG( ss ), 
		slider_done_cb, _( "Set Slider" ) );
	idialog_set_parent( IDIALOG( ss ), GTK_WIDGET( parent ) );
	idialog_set_iobject( IDIALOG( ss ), IOBJECT( model ) );
	iwindow_build( IWINDOW( ss ) );

	gtk_widget_show( ss );
}

static xmlNode *
slider_save( Model *model, xmlNode *xnode )
{
	Slider *slider = SLIDER( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "from", "%g", slider->from ) ||
			!set_prop( xthis, "to", "%g", slider->to ) ||
			!set_prop( xthis, "value", "%g", slider->value ) ) 
			return( NULL );
	}

	return( xthis );
}

static gboolean
slider_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Slider *slider = SLIDER( model );

#ifdef DEBUG
	printf( "slider_load: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( "\n" );
#endif /*DEBUG*/

	assert( IS_RHS( parent ) );

	if( get_dprop( xnode, "from", &slider->from ) &&
		get_dprop( xnode, "to", &slider->to ) &&
		get_dprop( xnode, "value", &slider->value ) )
		classmodel_set_edited( CLASSMODEL( model ), TRUE );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Slider from heap.
 */
static gboolean
slider_class_get( Classmodel *classmodel, PElement *root )
{
	Slider *slider = SLIDER( classmodel );

	if( !class_get_member_real( root, MEMBER_FROM, &slider->from ) ||
		!class_get_member_real( root, MEMBER_TO, &slider->to ) ||
		!class_get_member_real( root, MEMBER_VALUE, &slider->value ) )
		return( FALSE );

#ifdef DEBUG
	printf( "slider_class_get: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( " from=%g, to=%g, value=%g\n", 
		slider->from, slider->to, slider->value );
#endif /*DEBUG*/

	return( TRUE );
}

/* Make a new "fn from to value" application.
 */
static gboolean
slider_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	Slider *slider = SLIDER( classmodel );

	PElement rhs;

#ifdef DEBUG
	printf( "slider_class_new: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( " from=%g, to=%g, value=%g\n", 
		slider->from, slider->to, slider->value );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_real_new( heap, slider->from, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_real_new( heap, slider->to, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_real_new( heap, slider->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
slider_class_init( SliderClass *class )
{
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = sliderview_new;
	model_class->edit = slider_edit;
	model_class->save = slider_save;
	model_class->load = slider_load;

	classmodel_class->class_get = slider_class_get;
	classmodel_class->class_new = slider_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
slider_init( Slider *slider )
{
	/* Overridden later. Just something sensible.
	 */
        slider->from = 0;
	slider->to = 255;
	slider->value = 128;

	iobject_set( IOBJECT( slider ), CLASS_SLIDER, NULL );
}

GType
slider_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( SliderClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) slider_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Slider ),
			32,             /* n_preallocs */
			(GInstanceInitFunc) slider_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"Slider", &info, 0 );
	}

	return( type );
}

Classmodel *
slider_new( Rhs *rhs )
{
	Slider *slider;

	slider = SLIDER( g_object_new( TYPE_SLIDER, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( slider ), -1 );

	return( CLASSMODEL( slider ) );
}
