/**
 * @file user_chunk.h
 *
 * Macros supporting the user pointer
 */
#ifndef __NJ_LIB_USER_CHUNK_H__
#define __NJ_LIB_USER_CHUNK_H__
#include <config.h>

#include <unistd.h>

/**@{ @name Fencepost macros
 *
 * These macros return the fencepost for each allocation type.
 * They can be lvalues or rvalues.
 */
#define NJ_PROT_NONE_GET_FENCEPOST(user_chunk, len)			\
		*(u_int *)(user_chunk + NJ_ALIGN_UP(len, NJ_INT_ALIGNMENT))

#define NJ_PROT_OVER_GET_FENCEPOST(user_chunk, len)			\
		*(u_int *)(NJ_ALIGN_DOWN(user_chunk - sizeof(nj_entry_index_t), NJ_INT_ALIGNMENT))

#define NJ_PROT_UNDER_GET_FENCEPOST(user_chunk, len)		\
		*(u_int *)(user_chunk + NJ_ALIGN_UP(len + sizeof(nj_entry_index_t), NJ_INT_ALIGNMENT))

#define NJ_PROT_SUNDER_GET_FENCEPOST(user_chunk, len)		\
		*(u_int *)(user_chunk + NJ_ALIGN_UP(len, NJ_INT_ALIGNMENT))
/*@}*/
struct nj_heap_entry *__nj_user_chunk_find_entry(nj_addr_t, struct nj_entry_pool *, nj_entry_index_t *);
struct nj_heap_entry *__nj_user_chunk_get_entry(nj_addr_t, struct nj_entry_pool *, int, nj_entry_index_t *);
void __nj_user_chunk_set_fencepost(nj_addr_t, size_t, struct nj_dynamic_prefs);


#endif /* user_chunk.h */
// vim:ts=4
