# Change Log
All notable changes to this project will be documented in this file. This project adheres to [Semantic Versioning](http://semver.org/).

## [v2.0.3](https://github.com/nlohmann/json/releases/tag/v2.0.3) (2016-08-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.2...v2.0.3)

- Support for iterator-range parsing [\#290](https://github.com/nlohmann/json/issues/290)

- warning C4706: assignment within conditional expression [\#295](https://github.com/nlohmann/json/issues/295)
- Horribly inconsistent behavior between const/non-const reference in operator \[\] \(\) [\#289](https://github.com/nlohmann/json/issues/289)

- unit-constructor1.cpp: Fix floating point truncation warning [\#300](https://github.com/nlohmann/json/pull/300) ([t-b](https://github.com/t-b))

## [v2.0.2](https://github.com/nlohmann/json/releases/tag/v2.0.2) (2016-07-31)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.1...v2.0.2)

- value\(\) does not work with \_json\_pointer types [\#283](https://github.com/nlohmann/json/issues/283)
- Easy serialization of classes [\#280](https://github.com/nlohmann/json/issues/280)

- Build error for std::int64 [\#282](https://github.com/nlohmann/json/issues/282)

- hexify\(\) function emits conversion warning [\#270](https://github.com/nlohmann/json/issues/270)

- let the makefile choose the correct sed [\#279](https://github.com/nlohmann/json/pull/279) ([murinicanor](https://github.com/murinicanor))
- Update hexify to use array lookup instead of ternary \(\#270\) [\#275](https://github.com/nlohmann/json/pull/275) ([dtoma](https://github.com/dtoma))

## [v2.0.1](https://github.com/nlohmann/json/releases/tag/v2.0.1) (2016-06-28)
[Full Changelog](https://github.com/nlohmann/json/compare/v2.0.0...v2.0.1)

- dump\(\) performance degradation in v2 [\#272](https://github.com/nlohmann/json/issues/272)

- fixed a tiny typo [\#271](https://github.com/nlohmann/json/pull/271) ([thelostt](https://github.com/thelostt))

## [v2.0.0](https://github.com/nlohmann/json/releases/tag/v2.0.0) (2016-06-23)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.1.0...v2.0.0)

- concatenate objects [\#252](https://github.com/nlohmann/json/issues/252)
- Unit test fails when doing a CMake out-of-tree build [\#241](https://github.com/nlohmann/json/issues/241)
- Additional integration options [\#237](https://github.com/nlohmann/json/issues/237)
- Can't use basic\_json::iterator as a base iterator for std::move\_iterator [\#233](https://github.com/nlohmann/json/issues/233)
- Provide a FAQ [\#163](https://github.com/nlohmann/json/issues/163)
- Create PULL\_REQUEST\_TEMPLATE.md [\#213](https://github.com/nlohmann/json/pull/213) ([whackashoe](https://github.com/whackashoe))
- fixed noexcept; added constexpr [\#208](https://github.com/nlohmann/json/pull/208) ([nlohmann](https://github.com/nlohmann))
- Add support for afl-fuzz testing [\#207](https://github.com/nlohmann/json/pull/207) ([mykter](https://github.com/mykter))
- Issue \#178 - Extending support to full uint64\_t/int64\_t range and unsigned type \(updated\) [\#193](https://github.com/nlohmann/json/pull/193) ([twelsby](https://github.com/twelsby))

- json::diff generates incorrect patch when removing multiple array elements. [\#269](https://github.com/nlohmann/json/issues/269)
- -Wconversion warning [\#259](https://github.com/nlohmann/json/issues/259)
- Maybe a bug [\#258](https://github.com/nlohmann/json/issues/258)
- -Wconversion warnings [\#239](https://github.com/nlohmann/json/issues/239)
- ambiguous overload for 'push\_back' and 'operator+=' [\#235](https://github.com/nlohmann/json/issues/235)
- Incorrect dumping of parsed numbers with exponents, but without decimal places [\#230](https://github.com/nlohmann/json/issues/230)
- double values are serialized with commas as decimal points [\#228](https://github.com/nlohmann/json/issues/228)
- Move semantics with std::initializer\_list [\#225](https://github.com/nlohmann/json/issues/225)
- abort during getline in yyfill [\#223](https://github.com/nlohmann/json/issues/223)
- Wrong link in the README.md [\#217](https://github.com/nlohmann/json/issues/217)
- Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#199](https://github.com/nlohmann/json/issues/199)
- GCC/clang floating point parsing bug in strtod\(\) [\#195](https://github.com/nlohmann/json/issues/195)
- Bugs in miloyip/nativejson-benchmark: roundtrips [\#187](https://github.com/nlohmann/json/issues/187)
- Floating point exceptions [\#181](https://github.com/nlohmann/json/issues/181)
- In basic\_json::basic\_json\(const CompatibleArrayType& val\), the requirement of CompatibleArrayType is not strict enough. [\#174](https://github.com/nlohmann/json/issues/174)
- Implicit assignment to std::string fails [\#144](https://github.com/nlohmann/json/issues/144)
- Fix Issue \#265 [\#266](https://github.com/nlohmann/json/pull/266) ([06needhamt](https://github.com/06needhamt))
- Issue \#195 - update Travis to Trusty due to gcc/clang strtod\(\) bug [\#196](https://github.com/nlohmann/json/pull/196) ([twelsby](https://github.com/twelsby))

- Compiler Errors With JSON.hpp [\#265](https://github.com/nlohmann/json/issues/265)
- VS2015 compile fail [\#260](https://github.com/nlohmann/json/issues/260)
- Error when using json in g++ [\#254](https://github.com/nlohmann/json/issues/254)
- Update long-term goals [\#246](https://github.com/nlohmann/json/issues/246)
- Error compile Android NDK  error: 'strtof' is not a member of 'std' [\#219](https://github.com/nlohmann/json/issues/219)
- Conflicting typedef of ssize\_t on Windows 32 bit when using Boost.Python [\#204](https://github.com/nlohmann/json/issues/204)
- Integer conversion to unsigned [\#178](https://github.com/nlohmann/json/issues/178)

- Define CMake/CTest tests [\#247](https://github.com/nlohmann/json/pull/247) ([robertmrk](https://github.com/robertmrk))
- Out of tree builds and a few other miscellaneous CMake cleanups. [\#242](https://github.com/nlohmann/json/pull/242) ([ChrisKitching](https://github.com/ChrisKitching))
- Implement additional integration options [\#238](https://github.com/nlohmann/json/pull/238) ([robertmrk](https://github.com/robertmrk))
- make serialization locale-independent [\#232](https://github.com/nlohmann/json/pull/232) ([nlohmann](https://github.com/nlohmann))
- fixes \#223 by updating README.md [\#227](https://github.com/nlohmann/json/pull/227) ([kevin--](https://github.com/kevin--))
- Use namespace std for int64\_t and uint64\_t [\#226](https://github.com/nlohmann/json/pull/226) ([lv-zheng](https://github.com/lv-zheng))
- Added missing cerrno header to fix ERANGE compile error on android [\#222](https://github.com/nlohmann/json/pull/222) ([Teemperor](https://github.com/Teemperor))
- Corrected readme [\#218](https://github.com/nlohmann/json/pull/218) ([Annihil](https://github.com/Annihil))
- replaced ssize\_t occurrences with auto \(addresses \#204\) [\#205](https://github.com/nlohmann/json/pull/205) ([nlohmann](https://github.com/nlohmann))
- Fixed issue \#199 - Small bugs in json.hpp \(get\_number\) and unit.cpp \(non-standard integer type test\) [\#200](https://github.com/nlohmann/json/pull/200) ([twelsby](https://github.com/twelsby))
- Fix broken link [\#197](https://github.com/nlohmann/json/pull/197) ([vog](https://github.com/vog))

## [v1.1.0](https://github.com/nlohmann/json/releases/tag/v1.1.0) (2016-01-24)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0...v1.1.0)

- JSON performance benchmark comparision [\#177](https://github.com/nlohmann/json/issues/177)
- Since re2c is often ignored in pull requests, it may make sense to make a contributing.md file [\#175](https://github.com/nlohmann/json/issues/175)
- Add assertions [\#168](https://github.com/nlohmann/json/issues/168)
- range based for loop for objects [\#83](https://github.com/nlohmann/json/issues/83)
- Implementation of get\_ref\(\) [\#184](https://github.com/nlohmann/json/pull/184) ([dariomt](https://github.com/dariomt))

- Small error in pull \#185 [\#194](https://github.com/nlohmann/json/issues/194)
- Bugs in miloyip/nativejson-benchmark: floating-point parsing [\#186](https://github.com/nlohmann/json/issues/186)
- Cannot index by key of type static constexpr const char\* [\#171](https://github.com/nlohmann/json/issues/171)
- Fixed Issue \#171 - added two extra template overloads of operator\[\] for T\* arguments [\#189](https://github.com/nlohmann/json/pull/189) ([twelsby](https://github.com/twelsby))
- Fixed issue \#167 - removed operator ValueType\(\) condition for VS2015 [\#188](https://github.com/nlohmann/json/pull/188) ([twelsby](https://github.com/twelsby))

- Floating point equality [\#185](https://github.com/nlohmann/json/issues/185)
- Unused variables in catch [\#180](https://github.com/nlohmann/json/issues/180)
- Typo in documentation [\#179](https://github.com/nlohmann/json/issues/179)
- Android? [\#172](https://github.com/nlohmann/json/issues/172)
- MSVC 2015 build fails when attempting to compare object\_t [\#167](https://github.com/nlohmann/json/issues/167)
- Member detector is not portable [\#166](https://github.com/nlohmann/json/issues/166)
- Unnecessary const\_cast [\#162](https://github.com/nlohmann/json/issues/162)
- Consider submitting this to the Boost Library Incubator [\#66](https://github.com/nlohmann/json/issues/66)

- Fixed Issue \#186 - add strto\(f|d|ld\) overload wrappers, "-0.0" special case and FP trailing zero [\#191](https://github.com/nlohmann/json/pull/191) ([twelsby](https://github.com/twelsby))
- Issue \#185 - remove approx\(\) and use \#pragma to kill warnings [\#190](https://github.com/nlohmann/json/pull/190) ([twelsby](https://github.com/twelsby))
- Fixed some typos in CONTRIBUTING.md [\#182](https://github.com/nlohmann/json/pull/182) ([nibroc](https://github.com/nibroc))

## [v1.0.0](https://github.com/nlohmann/json/releases/tag/v1.0.0) (2015-12-27)
[Full Changelog](https://github.com/nlohmann/json/compare/v1.0.0-rc1...v1.0.0)

- add key name to exception [\#160](https://github.com/nlohmann/json/issues/160)
- prevent json.hpp from emitting compiler warnings [\#154](https://github.com/nlohmann/json/issues/154)
- json::parse\(string\) does not check utf8 bom [\#152](https://github.com/nlohmann/json/issues/152)
- unsigned 64bit values output as signed [\#151](https://github.com/nlohmann/json/issues/151)
- Wish feature: json5 [\#150](https://github.com/nlohmann/json/issues/150)
- overload of at\(\) with default value [\#133](https://github.com/nlohmann/json/issues/133)
- Memory leak in face of exceptions [\#118](https://github.com/nlohmann/json/issues/118)
- Find and Count for arrays [\#117](https://github.com/nlohmann/json/issues/117)
- dynamically constructing an arbitrarily nested object [\#114](https://github.com/nlohmann/json/issues/114)
- object field accessors [\#103](https://github.com/nlohmann/json/issues/103)
- v8pp and json [\#95](https://github.com/nlohmann/json/issues/95)
- Wishlist [\#65](https://github.com/nlohmann/json/issues/65)
- Windows/Visual Studio \(through 2013\) is unsupported [\#62](https://github.com/nlohmann/json/issues/62)

- Bug in basic\_json::operator\[\] const overload [\#135](https://github.com/nlohmann/json/issues/135)
- wrong enable\_if for const pointer \(instead of pointer-to-const\) [\#134](https://github.com/nlohmann/json/issues/134)
- Visual Studio 14 Debug assertion failed [\#125](https://github.com/nlohmann/json/issues/125)
- Compile error with g++ 4.9.3 cygwin 64-bit [\#112](https://github.com/nlohmann/json/issues/112)
- error: unterminated raw string [\#109](https://github.com/nlohmann/json/issues/109)
- \[clang-3.6.2\] string/sstream with number to json issue [\#107](https://github.com/nlohmann/json/issues/107)

- Getting member discarding qualifyer [\#159](https://github.com/nlohmann/json/issues/159)
- basic\_json::iterator::value\(\) output includes quotes while basic\_json::iterator::key\(\) doesn't [\#158](https://github.com/nlohmann/json/issues/158)
- Indexing `const basic\_json\<\>` with `const basic\_string\<char\>` [\#157](https://github.com/nlohmann/json/issues/157)
- token\_type\_name\(token\_type t\): not all control paths return a value [\#156](https://github.com/nlohmann/json/issues/156)
- Unable to compile on MSVC 2015 with SDL checking enabled: This function or variable may be unsafe. [\#149](https://github.com/nlohmann/json/issues/149)
- dump\(\)  convert strings encoded by utf-8 to shift-jis on windows 10.  [\#147](https://github.com/nlohmann/json/issues/147)
- Unable to get field names in a json object [\#145](https://github.com/nlohmann/json/issues/145)
- json.hpp:5746:32: error: 'to\_string' is not a member of 'std' [\#136](https://github.com/nlohmann/json/issues/136)
- Returning any data type [\#113](https://github.com/nlohmann/json/issues/113)
- vector\<json\> copy constructor really weird [\#108](https://github.com/nlohmann/json/issues/108)
- maintaining order of keys during iteration [\#106](https://github.com/nlohmann/json/issues/106)

- Replace sprintf with hex function, this fixes \#149 [\#153](https://github.com/nlohmann/json/pull/153) ([whackashoe](https://github.com/whackashoe))
- Fix character skipping after a surrogate pair [\#146](https://github.com/nlohmann/json/pull/146) ([robertmrk](https://github.com/robertmrk))
- Detect correctly pointer-to-const [\#137](https://github.com/nlohmann/json/pull/137) ([dariomt](https://github.com/dariomt))
- disabled "CopyAssignable" test for MSVC in Debug mode, see \#125 [\#131](https://github.com/nlohmann/json/pull/131) ([dariomt](https://github.com/dariomt))
- removed stream operator for iterator, resolution for \#125 [\#130](https://github.com/nlohmann/json/pull/130) ([dariomt](https://github.com/dariomt))
- fixed typos in comments for examples [\#129](https://github.com/nlohmann/json/pull/129) ([dariomt](https://github.com/dariomt))
- Remove superfluous inefficiency [\#126](https://github.com/nlohmann/json/pull/126) ([d-frey](https://github.com/d-frey))
- remove invalid parameter '-stdlib=libc++' in CMakeLists.txt [\#124](https://github.com/nlohmann/json/pull/124) ([emvivre](https://github.com/emvivre))
- exception-safe object creation, fixes \#118 [\#122](https://github.com/nlohmann/json/pull/122) ([d-frey](https://github.com/d-frey))
- Fix small oversight. [\#121](https://github.com/nlohmann/json/pull/121) ([ColinH](https://github.com/ColinH))
- Overload parse\(\) to accept an rvalue reference [\#120](https://github.com/nlohmann/json/pull/120) ([silverweed](https://github.com/silverweed))
- Use the right variable name in doc string [\#115](https://github.com/nlohmann/json/pull/115) ([whoshuu](https://github.com/whoshuu))

## [v1.0.0-rc1](https://github.com/nlohmann/json/releases/tag/v1.0.0-rc1) (2015-07-26)
- Adjust wording to JSON RFC [\#97](https://github.com/nlohmann/json/issues/97)
- access by \(const\) reference [\#91](https://github.com/nlohmann/json/issues/91)
- is\_integer and is\_float tests [\#90](https://github.com/nlohmann/json/issues/90)
- MinGW have no std::to\_string [\#80](https://github.com/nlohmann/json/issues/80)
- erase elements using iterators [\#57](https://github.com/nlohmann/json/issues/57)
- Removing item from array [\#56](https://github.com/nlohmann/json/issues/56)
- Serialize/Deserialize like PHP? [\#55](https://github.com/nlohmann/json/issues/55)
- Document erase, count, and iterators key and value [\#52](https://github.com/nlohmann/json/issues/52)
- Supported compilers [\#50](https://github.com/nlohmann/json/issues/50)
- Use non-member begin/end [\#48](https://github.com/nlohmann/json/issues/48)
- Erase key [\#47](https://github.com/nlohmann/json/issues/47)
- Key iterator [\#46](https://github.com/nlohmann/json/issues/46)
- Add count member function [\#45](https://github.com/nlohmann/json/issues/45)
- Printing attribute names [\#39](https://github.com/nlohmann/json/issues/39)
- Avoid using spaces when encoding without pretty print [\#31](https://github.com/nlohmann/json/issues/31)
- Cannot encode long numbers [\#30](https://github.com/nlohmann/json/issues/30)
- Creating an empty array [\#27](https://github.com/nlohmann/json/issues/27)
- Custom allocator support [\#25](https://github.com/nlohmann/json/issues/25)
- create a header-only version [\#16](https://github.com/nlohmann/json/issues/16)
- Add to\_string overload for indentation [\#13](https://github.com/nlohmann/json/issues/13)
- move code into namespace [\#9](https://github.com/nlohmann/json/issues/9)
- free functions for explicit objects and arrays in initializer lists [\#8](https://github.com/nlohmann/json/issues/8)
- Test case coverage [\#2](https://github.com/nlohmann/json/issues/2)
- Parse streams incrementally. [\#40](https://github.com/nlohmann/json/pull/40) ([aburgh](https://github.com/aburgh))

- Binary string causes numbers to be dumped as hex [\#101](https://github.com/nlohmann/json/issues/101)
- failed to iterator json object with reverse\_iterator [\#100](https://github.com/nlohmann/json/issues/100)
- static analysis warnings [\#94](https://github.com/nlohmann/json/issues/94)
- reverse\_iterator operator inheritance problem [\#93](https://github.com/nlohmann/json/issues/93)
- Nonstandard integer type [\#89](https://github.com/nlohmann/json/issues/89)
- lexer::get\_number return NAN [\#82](https://github.com/nlohmann/json/issues/82)
- Handle infinity and NaN cases [\#70](https://github.com/nlohmann/json/issues/70)
- errors in g++-4.8.1 [\#68](https://github.com/nlohmann/json/issues/68)
- Double quotation mark is not parsed correctly [\#60](https://github.com/nlohmann/json/issues/60)
- Do not use std::to\_string [\#51](https://github.com/nlohmann/json/issues/51)
- Confused about iterating through json objects [\#49](https://github.com/nlohmann/json/issues/49)
- Problem getting vector \(array\) of strings [\#44](https://github.com/nlohmann/json/issues/44)
- Compilation error due to assuming that private=public [\#43](https://github.com/nlohmann/json/issues/43)
- Use of deprecated implicit copy constructor [\#42](https://github.com/nlohmann/json/issues/42)
- dumping a small number\_float just outputs 0.000000 [\#37](https://github.com/nlohmann/json/issues/37)
- Avoid using spaces when encoding without pretty print [\#31](https://github.com/nlohmann/json/issues/31)
- Cannot encode long numbers [\#30](https://github.com/nlohmann/json/issues/30)
- segmentation fault when iterating over empty arrays/objects [\#28](https://github.com/nlohmann/json/issues/28)
- Improper parsing of JSON string "\\" [\#17](https://github.com/nlohmann/json/issues/17)
- Don't return "const values" [\#15](https://github.com/nlohmann/json/issues/15)
- string parser does not recognize uncompliant strings [\#12](https://github.com/nlohmann/json/issues/12)
- free functions for explicit objects and arrays in initializer lists [\#8](https://github.com/nlohmann/json/issues/8)
- Runtime error in Travis job [\#1](https://github.com/nlohmann/json/issues/1)
- Fix compilation of json\_unit with GCC 5 [\#59](https://github.com/nlohmann/json/pull/59) ([dkopecek](https://github.com/dkopecek))

- Finish documenting the public interface in Doxygen [\#102](https://github.com/nlohmann/json/issues/102)
- 'noexcept' : unknown override specifier [\#99](https://github.com/nlohmann/json/issues/99)
- Keys when iterating over objects [\#67](https://github.com/nlohmann/json/issues/67)
- Complete brief documentation [\#61](https://github.com/nlohmann/json/issues/61)
- Get coverage back to 100% [\#58](https://github.com/nlohmann/json/issues/58)
- possible double-free in find function [\#11](https://github.com/nlohmann/json/issues/11)
- UTF-8 encoding/deconding/testing [\#10](https://github.com/nlohmann/json/issues/10)
- Add unit tests [\#4](https://github.com/nlohmann/json/issues/4)
- Drop C++98 support [\#3](https://github.com/nlohmann/json/issues/3)

- Keyword 'inline' is useless when member functions are defined in headers [\#87](https://github.com/nlohmann/json/pull/87) ([ahamez](https://github.com/ahamez))
- Remove useless typename [\#86](https://github.com/nlohmann/json/pull/86) ([ahamez](https://github.com/ahamez))
- Avoid warning with Xcode's clang [\#85](https://github.com/nlohmann/json/pull/85) ([ahamez](https://github.com/ahamez))
-  Fix typos [\#73](https://github.com/nlohmann/json/pull/73) ([aqnouch](https://github.com/aqnouch))
- Replace `default\_callback` function with `nullptr` and check for null… [\#72](https://github.com/nlohmann/json/pull/72) ([aburgh](https://github.com/aburgh))
- support enum [\#71](https://github.com/nlohmann/json/pull/71) ([likebeta](https://github.com/likebeta))
- Fix performance regression introduced with the parsing callback feature. [\#69](https://github.com/nlohmann/json/pull/69) ([aburgh](https://github.com/aburgh))
- Improve the implementations of the comparission-operators [\#63](https://github.com/nlohmann/json/pull/63) ([Florianjw](https://github.com/Florianjw))
- Feature/small float serialization [\#38](https://github.com/nlohmann/json/pull/38) ([jrandall](https://github.com/jrandall))
- template version with re2c scanner [\#36](https://github.com/nlohmann/json/pull/36) ([nlohmann](https://github.com/nlohmann))
- more descriptive documentation in example [\#33](https://github.com/nlohmann/json/pull/33) ([luxe](https://github.com/luxe))
- Fix string conversion under Clang [\#26](https://github.com/nlohmann/json/pull/26) ([wancw](https://github.com/wancw))
- Fixed dumping of strings [\#24](https://github.com/nlohmann/json/pull/24) ([Teemperor](https://github.com/Teemperor))
- Added a remark to the readme that coverage is GCC only for now [\#23](https://github.com/nlohmann/json/pull/23) ([Teemperor](https://github.com/Teemperor))
- Unicode escaping [\#22](https://github.com/nlohmann/json/pull/22) ([Teemperor](https://github.com/Teemperor))
- Implemented the JSON spec for string parsing for everything but the \uXXXX escaping [\#21](https://github.com/nlohmann/json/pull/21) ([Teemperor](https://github.com/Teemperor))
- add the std iterator typedefs to iterator and const\_iterator [\#19](https://github.com/nlohmann/json/pull/19) ([kirkshoop](https://github.com/kirkshoop))
- Fixed escaped quotes [\#18](https://github.com/nlohmann/json/pull/18) ([Teemperor](https://github.com/Teemperor))
- Fix double delete on std::bad\_alloc exception [\#14](https://github.com/nlohmann/json/pull/14) ([elliotgoodrich](https://github.com/elliotgoodrich))
- Added CMake and lcov [\#6](https://github.com/nlohmann/json/pull/6) ([Teemperor](https://github.com/Teemperor))
- Version 2.0 [\#5](https://github.com/nlohmann/json/pull/5) ([nlohmann](https://github.com/nlohmann))



\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*