import fs from "fs";

const archivedSyntaxPkgs = JSON.parse(
  fs.readFileSync(new URL("./archived-syntax-pkgs.json", import.meta.url))
);
const root = new URL("../..", import.meta.url);

let output = `/* This file is automatically generated by scripts/generators/archived-libs-typings.js */
import { declare } from "@babel/helper-plugin-utils";

`;

for (const pkgName of archivedSyntaxPkgs) {
  output += `declare module "${pkgName}" {
  let plugin: ReturnType<typeof declare>;
  export = { default: plugin };
}
`;
}

fs.writeFileSync(new URL("./lib/archived-libs.d.ts", root), output);
