import interval from "./interval";
import {durationMinute} from "./duration";

var minute = interval(function(date) {
  date.setTime(Math.floor(date / durationMinute) * durationMinute);
}, function(date, step) {
  date.setTime(+date + step * durationMinute);
}, function(start, end) {
  return (end - start) / durationMinute;
}, function(date) {
  return date.getMinutes();
});

export default minute;
export var minutes = minute.range;
