import { nodeResolve } from '@rollup/plugin-node-resolve';
import commonjs from '@rollup/plugin-commonjs';
const file = process.env.DEST_FILE;

const config = {
	input: process.env.START_FILE,
	output: [{
		format: 'cjs',
		file: file,
		preferConst: true,
		interop: false,
		freeze: false,
		strict: false
	}],
	external: [
		...require('module').builtinModules,
	],
	plugins: [
        commonjs(),
        nodeResolve({
            moduleDirectories: ['node_modules'],
        }),
	]
}

export default config;
