## Bower

{%= include("install-bower", {save: true}) %}

## Notes

Inspired by the python lib [range-regex](https://github.com/dimka665/range-regex), it has never been easier to validate numbers and number ranges with regex!

The [unit tests generate 850,000 patterns](./test/test.js) to provide brute-force validation that the generated regex-ranges are correct.

## Usage

```js
var toRegexRange = require('{%= name %}');

var re = new RegExp(toRegexRange('1', '99'));
re.test('50');
//=> true
```

**Examples**

```js
toRegexRange('111', '555');
//=> '11[1-9]|1[2-9]\d|[2-4]\d{2}|5[0-4]\d|55[0-5]'
toRegexRange('5', '5');
//=> '5'
toRegexRange('5', '6');
//=> '[5-6]'
toRegexRange('51', '229');
//=> '5[1-9]|[6-9]\d|1\d{2}|2[0-2]\d'
```

When the `min` is larger than the `max`, a regex logical `or` is returned:

```js
toRegexRange('51', '29');
//=> '51|29'
```

Currently this does not support steps (increments) or zero-padding.
