'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

var LRParserGeneratorDefault = require(ROOT + 'lr/lr-parser-generator-default').default;
var JavaParserGeneratorTrait = require('../java-parser-generator-trait');

/**
 * Generic Java template for all LR parsers.
 */
var JAVA_LR_PARSER_TEMPLATE = _fs2.default.readFileSync(__dirname + '/../templates/lr.template.java', 'utf-8');

/**
 * LR parser generator for Java.
 */

var LRParserGeneratorJava = function (_LRParserGeneratorDef) {
  _inherits(LRParserGeneratorJava, _LRParserGeneratorDef);

  /**
   * Instance constructor.
   */
  function LRParserGeneratorJava(_ref) {
    var _this;

    var grammar = _ref.grammar,
        outputFile = _ref.outputFile,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    _classCallCheck(this, LRParserGeneratorJava);

    (_this = _possibleConstructorReturn(this, (LRParserGeneratorJava.__proto__ || Object.getPrototypeOf(LRParserGeneratorJava)).call(this, { grammar: grammar, outputFile: outputFile, options: options })), _this).setTemplate(JAVA_LR_PARSER_TEMPLATE);

    _this._lexHandlers = [];
    _this._productionHandlers = [];

    _this._parserClassName = _path2.default.basename(outputFile, _path2.default.extname(outputFile));

    // Trait provides methods for lex and production handlers.
    Object.assign(_this, JavaParserGeneratorTrait);
    return _this;
  }

  /**
   * Generates parser code.
   */


  _createClass(LRParserGeneratorJava, [{
    key: 'generateParserData',
    value: function generateParserData() {
      this.generateParserClassName(this._parserClassName);

      // Lexical grammar.
      this.generateTokenizer();

      // Syntactic grammar.
      this.generateProductions();

      // Tables.
      this.generateTokensTable();
      this.generateParseTable();

      this.generateLexHandlers();
      this.generateProductionHandlers();

      this.generateModuleInclude();
    }
  }]);

  return LRParserGeneratorJava;
}(LRParserGeneratorDefault);

exports.default = LRParserGeneratorJava;
;