// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var assert = require('assert');
var path = require('path');
var common = require('../common');

if (process.platform === 'win32') {
  var file = path.join(common.fixturesDir, 'a.js');
  var resolvedFile = path.resolve(file);

  assert.equal('\\\\?\\' + resolvedFile, path._makeLong(file));
  assert.equal('\\\\?\\' + resolvedFile, path._makeLong('\\\\?\\' + file));
  assert.equal('\\\\?\\UNC\\someserver\\someshare\\somefile',
               path._makeLong('\\\\someserver\\someshare\\somefile'));
  assert.equal('\\\\?\\UNC\\someserver\\someshare\\somefile',
               path._makeLong('\\\\?\\UNC\\someserver\\someshare\\somefile'));
  assert.equal('\\\\.\\pipe\\somepipe',
               path._makeLong('\\\\.\\pipe\\somepipe'));
}

assert.equal(path._makeLong(null), null);
assert.equal(path._makeLong(100), 100);
assert.equal(path._makeLong(path), path);
assert.equal(path._makeLong(false), false);
assert.equal(path._makeLong(true), true);
