# Node Foundation TSC Meeting 2015-09-16

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-09-16
* **GitHub Issue**: https://github.com/nodejs/node/issues/2898
* **Minutes Google Doc**: https://docs.google.com/document/d/1RCR2pGOc2d80NNusaX5DZaktWvHEsDUqfEZP-tvexBk
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1rXBdtsD9PJTExNXgzNZ9bez9oOjW45kLPjun4zdt0dY>_

## Present

* Rod Vagg (TSC)
* Brian White (TSC)
* Steven R Loomis
* Fedor Indutny (TSC)
* Bert Belder (TSC)
* Colin Ihrig (TSC)
* Trevor Norris (TSC)
* Shigeki Ohtsu (TSC)
* Chris Dickinson (TSC)
* Jeremiah Senkpiel (TSC)
* Ben Noordhuis (TSC)
* Alexis Campailla (TSC)
* Domenic Denicola
* Michael Dawson

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node-v0.x-archive

* Deprecate Array#values() in 0.12.x [#25877](https://github.com/nodejs/node-v0.x-archive/issues/25877)
* Deprecate smalloc in v0.12 [#25784](https://github.com/nodejs/node-v0.x-archive/issues/25784)

### nodejs/node

* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)
* util: Remove p, has been deprecated for years [#2529](https://github.com/nodejs/node/pull/2529)

## Minutes

Due to IBM’s acquisition of StrongLoop, IBM is over the TSC 25% company limit rule. Michael Dawson and Steven Loomis have stepped down from TSC, but they are here as observers.

### Standup

* Rod Vagg: Released 4.0.0, also 3.3.1 maintenance release. Getting the build system ready for building/publishing 0.10 and 0.12 binaries.
* Brian White: not much, triaging issues and PRs, some work on dns parser
* Steven R Loomis: tsc resignation for IBM/SL merge, some issue triage, working on a more robust download for ICU (ICU server was overloaded, fixed to ICU again redirects to sourceforge, discussed longer term discussions) 
* Fedor Indutny: v8’s ArrayBuffer fixes, reviewing PRs, fixing issues
* Bert Belder: very few reviews/issue comments. Some libuv work on rwlocks.
* Colin Ihrig: not much, some issue tracker work
* Trevor Norris: Trying to make things (including Buffers) faster, some issue/PR review
* Shigeki Ohtsu: Just a few reviews of issues.
* Chris Dickinson: Working on shoving static npm analysis data into a database, slowly    
* Jeremiah Senkpiel: NodeConf.eu, issues and PRs, 4.1.0 release
* Ben Noordhuis: only PR review and responding to bug reports, a patch or two upstreamed to v8
* Alexis Campailla: ARM cross-compile for CI. Misc fixes for VS 2015 / Win10
* Domenic Denicola: some issue and PR review, talking with v8 team
* Michael Dawson: landed the build updated for AIX, also updating the tests for AIX where necessary. Looking into PPC failures. Working on getting us hooked into v8 security notifications.

### Previous meeting’s agenda

* Jenkins merge jobs always overwrites PR-URL and Reviewed-By [#179](https://github.com/nodejs/build/issues/179)
* doc: update COLLABORATOR_GUIDE [#2638](https://github.com/nodejs/node/pull/2638)
* deps: update v8 to 4.5.103.30 [#2632](https://github.com/nodejs/node/pull/2632)
* Node.js v4 Release Timeline [#2522](https://github.com/nodejs/node/issues/2522)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

### Deprecate Array#values() in 0.12.x [#25877](https://github.com/nodejs/node-v0.x-archive/issues/25877)

### Deprecate smalloc in v0.12 [#25784](https://github.com/nodejs/node-v0.x-archive/issues/25784)

Jeremiah: Are these things that we think we can do? Should we go ahead with that? Is it a good idea to deprecate these things?

Ben: How are we going to deprecate? Literal `util.deprecate`?

Jeremiah: Probably?

Trevor: They’re already floating a patch

Rod: I’m fine with deprecating smalloc

Trevor: Is there a deprecation cycle between LTS? I’m not sure how this would work? (i.e., if we deprecate now, LTS -> LTS upgraders will not see a deprecation warning.)

Rod: Maybe punt to LTS WG? It could be quite a lot — it could be that we decide between stable versions to remove things (or we’re forced to), do we backport the deprecation to LTS?

Jeremiah: I think it should be only for things we’re _forced_ to remove 

Action: Punt to LTS WG

### Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

Trevor: Have an 80% understanding of the work needed: WebSocket support in core (though not necessarily exposed publicly), API injection points. Are we ok with including web sockets support one way or another?

Rod, Domenic, others: +1

### util: Remove p, has been deprecated for years [#2529](https://github.com/nodejs/node/pull/2529)

Discussion of Buffer “raw{s,}” encoding as well — undocumented, deprecated, inconsistently implemented in core.

Action: Remove util.p (Jeremiah to respond.)

Bert: Perhaps we should bulk remove?

Rod: util.p is relatively trivial, has a deprecation warning, etc.

Jeremiah: Brought this up because these things have been deprecated forever. util.exec has been deprecated for a while, as well.

Trevor: raw/raws are deprecated in name only, no warnings, but C++ layer does not know about them (falls back to utf8) — maybe should be removed as a bugfix, because it does not work consistently.

Action: Chris to list “least used stuff” (with apologies for how longs its taken!)

### Next Meeting

September 23
