// Code generated by github.com/varlink/go/cmd/varlink-go-interface-generator, DO NOT EDIT.

// Podman Service Interface and API description.  The master version of this document can be found
// in the [API.md](https://github.com/containers/libpod/blob/master/API.md) file in the upstream libpod repository.
package iopodman

import (
	"context"
	"encoding/json"
	"fmt"
	"github.com/varlink/go/varlink"
)

// Generated type declarations

type Volume struct {
	Name       string            `json:"name"`
	Labels     map[string]string `json:"labels"`
	MountPoint string            `json:"mountPoint"`
	Driver     string            `json:"driver"`
	Options    map[string]string `json:"options"`
}

type NotImplemented struct {
	Comment string `json:"comment"`
}

type StringResponse struct {
	Message string `json:"message"`
}

type LogLine struct {
	Device       string `json:"device"`
	ParseLogType string `json:"parseLogType"`
	Time         string `json:"time"`
	Msg          string `json:"msg"`
	Cid          string `json:"cid"`
}

// ContainerChanges describes the return struct for ListContainerChanges
type ContainerChanges struct {
	Changed []string `json:"changed"`
	Added   []string `json:"added"`
	Deleted []string `json:"deleted"`
}

type ImageSaveOptions struct {
	Name       string   `json:"name"`
	Format     string   `json:"format"`
	Output     string   `json:"output"`
	OutputType string   `json:"outputType"`
	MoreTags   []string `json:"moreTags"`
	Quiet      bool     `json:"quiet"`
	Compress   bool     `json:"compress"`
}

type VolumeCreateOpts struct {
	VolumeName string            `json:"volumeName"`
	Driver     string            `json:"driver"`
	Labels     map[string]string `json:"labels"`
	Options    map[string]string `json:"options"`
}

type VolumeRemoveOpts struct {
	Volumes []string `json:"volumes"`
	All     bool     `json:"all"`
	Force   bool     `json:"force"`
}

type Image struct {
	Id          string            `json:"id"`
	Digest      string            `json:"digest"`
	Digests     []string          `json:"digests"`
	ParentId    string            `json:"parentId"`
	RepoTags    []string          `json:"repoTags"`
	RepoDigests []string          `json:"repoDigests"`
	Created     string            `json:"created"`
	Size        int64             `json:"size"`
	VirtualSize int64             `json:"virtualSize"`
	Containers  int64             `json:"containers"`
	Labels      map[string]string `json:"labels"`
	IsParent    bool              `json:"isParent"`
	TopLayer    string            `json:"topLayer"`
	ReadOnly    bool              `json:"readOnly"`
}

// ImageHistory describes the returned structure from ImageHistory.
type ImageHistory struct {
	Id        string   `json:"id"`
	Created   string   `json:"created"`
	CreatedBy string   `json:"createdBy"`
	Tags      []string `json:"tags"`
	Size      int64    `json:"size"`
	Comment   string   `json:"comment"`
}

// Represents a single search result from SearchImages
type ImageSearchResult struct {
	Description  string `json:"description"`
	Is_official  bool   `json:"is_official"`
	Is_automated bool   `json:"is_automated"`
	Registry     string `json:"registry"`
	Name         string `json:"name"`
	Star_count   int64  `json:"star_count"`
}

type ImageSearchFilter struct {
	Is_official  *bool `json:"is_official,omitempty"`
	Is_automated *bool `json:"is_automated,omitempty"`
	Star_count   int64 `json:"star_count"`
}

type KubePodService struct {
	Pod     string `json:"pod"`
	Service string `json:"service"`
}

type Container struct {
	Id               string                  `json:"id"`
	Image            string                  `json:"image"`
	Imageid          string                  `json:"imageid"`
	Command          []string                `json:"command"`
	Createdat        string                  `json:"createdat"`
	Runningfor       string                  `json:"runningfor"`
	Status           string                  `json:"status"`
	Ports            []ContainerPortMappings `json:"ports"`
	Rootfssize       int64                   `json:"rootfssize"`
	Rwsize           int64                   `json:"rwsize"`
	Names            string                  `json:"names"`
	Labels           map[string]string       `json:"labels"`
	Mounts           []ContainerMount        `json:"mounts"`
	Containerrunning bool                    `json:"containerrunning"`
	Namespaces       ContainerNameSpace      `json:"namespaces"`
}

// ContainerStats is the return struct for the stats of a container
type ContainerStats struct {
	Id           string  `json:"id"`
	Name         string  `json:"name"`
	Cpu          float64 `json:"cpu"`
	Cpu_nano     int64   `json:"cpu_nano"`
	System_nano  int64   `json:"system_nano"`
	Mem_usage    int64   `json:"mem_usage"`
	Mem_limit    int64   `json:"mem_limit"`
	Mem_perc     float64 `json:"mem_perc"`
	Net_input    int64   `json:"net_input"`
	Net_output   int64   `json:"net_output"`
	Block_output int64   `json:"block_output"`
	Block_input  int64   `json:"block_input"`
	Pids         int64   `json:"pids"`
}

type PsOpts struct {
	All     bool      `json:"all"`
	Filters *[]string `json:"filters,omitempty"`
	Last    *int64    `json:"last,omitempty"`
	Latest  *bool     `json:"latest,omitempty"`
	NoTrunc *bool     `json:"noTrunc,omitempty"`
	Pod     *bool     `json:"pod,omitempty"`
	Quiet   *bool     `json:"quiet,omitempty"`
	Size    *bool     `json:"size,omitempty"`
	Sort    *string   `json:"sort,omitempty"`
	Sync    *bool     `json:"sync,omitempty"`
}

type PsContainer struct {
	Id         string            `json:"id"`
	Image      string            `json:"image"`
	Command    string            `json:"command"`
	Created    string            `json:"created"`
	Ports      string            `json:"ports"`
	Names      string            `json:"names"`
	IsInfra    bool              `json:"isInfra"`
	Status     string            `json:"status"`
	State      string            `json:"state"`
	PidNum     int64             `json:"pidNum"`
	RootFsSize int64             `json:"rootFsSize"`
	RwSize     int64             `json:"rwSize"`
	Pod        string            `json:"pod"`
	CreatedAt  string            `json:"createdAt"`
	ExitedAt   string            `json:"exitedAt"`
	StartedAt  string            `json:"startedAt"`
	Labels     map[string]string `json:"labels"`
	NsPid      string            `json:"nsPid"`
	Cgroup     string            `json:"cgroup"`
	Ipc        string            `json:"ipc"`
	Mnt        string            `json:"mnt"`
	Net        string            `json:"net"`
	PidNs      string            `json:"pidNs"`
	User       string            `json:"user"`
	Uts        string            `json:"uts"`
	Mounts     string            `json:"mounts"`
}

// ContainerMount describes the struct for mounts in a container
type ContainerMount struct {
	Destination string   `json:"destination"`
	Type        string   `json:"type"`
	Source      string   `json:"source"`
	Options     []string `json:"options"`
}

// ContainerPortMappings describes the struct for portmappings in an existing container
type ContainerPortMappings struct {
	Host_port      string `json:"host_port"`
	Host_ip        string `json:"host_ip"`
	Protocol       string `json:"protocol"`
	Container_port string `json:"container_port"`
}

// ContainerNamespace describes the namespace structure for an existing container
type ContainerNameSpace struct {
	User   string `json:"user"`
	Uts    string `json:"uts"`
	Pidns  string `json:"pidns"`
	Pid    string `json:"pid"`
	Cgroup string `json:"cgroup"`
	Net    string `json:"net"`
	Mnt    string `json:"mnt"`
	Ipc    string `json:"ipc"`
}

// InfoDistribution describes the host's distribution
type InfoDistribution struct {
	Distribution string `json:"distribution"`
	Version      string `json:"version"`
}

// InfoHost describes the host stats portion of PodmanInfo
type InfoHost struct {
	Buildah_version string           `json:"buildah_version"`
	Distribution    InfoDistribution `json:"distribution"`
	Mem_free        int64            `json:"mem_free"`
	Mem_total       int64            `json:"mem_total"`
	Swap_free       int64            `json:"swap_free"`
	Swap_total      int64            `json:"swap_total"`
	Arch            string           `json:"arch"`
	Cpus            int64            `json:"cpus"`
	Hostname        string           `json:"hostname"`
	Kernel          string           `json:"kernel"`
	Os              string           `json:"os"`
	Uptime          string           `json:"uptime"`
	Eventlogger     string           `json:"eventlogger"`
}

// InfoGraphStatus describes the detailed status of the storage driver
type InfoGraphStatus struct {
	Backing_filesystem  string `json:"backing_filesystem"`
	Native_overlay_diff string `json:"native_overlay_diff"`
	Supports_d_type     string `json:"supports_d_type"`
}

// InfoStore describes the host's storage informatoin
type InfoStore struct {
	Containers           int64           `json:"containers"`
	Images               int64           `json:"images"`
	Graph_driver_name    string          `json:"graph_driver_name"`
	Graph_driver_options string          `json:"graph_driver_options"`
	Graph_root           string          `json:"graph_root"`
	Graph_status         InfoGraphStatus `json:"graph_status"`
	Run_root             string          `json:"run_root"`
}

// InfoPodman provides details on the Podman binary
type InfoPodmanBinary struct {
	Compiler       string `json:"compiler"`
	Go_version     string `json:"go_version"`
	Podman_version string `json:"podman_version"`
	Git_commit     string `json:"git_commit"`
}

// PodmanInfo describes the Podman host and build
type PodmanInfo struct {
	Host                InfoHost         `json:"host"`
	Registries          []string         `json:"registries"`
	Insecure_registries []string         `json:"insecure_registries"`
	Store               InfoStore        `json:"store"`
	Podman              InfoPodmanBinary `json:"podman"`
}

// Sockets describes sockets location for a container
type Sockets struct {
	Container_id   string `json:"container_id"`
	Io_socket      string `json:"io_socket"`
	Control_socket string `json:"control_socket"`
}

// Create is an input structure for creating containers.
// args[0] is the image name or id
// args[1-] are the new commands if changed
type Create struct {
	Args                   []string  `json:"args"`
	AddHost                *[]string `json:"addHost,omitempty"`
	Annotation             *[]string `json:"annotation,omitempty"`
	Attach                 *[]string `json:"attach,omitempty"`
	BlkioWeight            *string   `json:"blkioWeight,omitempty"`
	BlkioWeightDevice      *[]string `json:"blkioWeightDevice,omitempty"`
	CapAdd                 *[]string `json:"capAdd,omitempty"`
	CapDrop                *[]string `json:"capDrop,omitempty"`
	CgroupParent           *string   `json:"cgroupParent,omitempty"`
	CidFile                *string   `json:"cidFile,omitempty"`
	ConmonPidfile          *string   `json:"conmonPidfile,omitempty"`
	Command                *[]string `json:"command,omitempty"`
	CpuPeriod              *int64    `json:"cpuPeriod,omitempty"`
	CpuQuota               *int64    `json:"cpuQuota,omitempty"`
	CpuRtPeriod            *int64    `json:"cpuRtPeriod,omitempty"`
	CpuRtRuntime           *int64    `json:"cpuRtRuntime,omitempty"`
	CpuShares              *int64    `json:"cpuShares,omitempty"`
	Cpus                   *float64  `json:"cpus,omitempty"`
	CpuSetCpus             *string   `json:"cpuSetCpus,omitempty"`
	CpuSetMems             *string   `json:"cpuSetMems,omitempty"`
	Detach                 *bool     `json:"detach,omitempty"`
	DetachKeys             *string   `json:"detachKeys,omitempty"`
	Device                 *[]string `json:"device,omitempty"`
	DeviceReadBps          *[]string `json:"deviceReadBps,omitempty"`
	DeviceReadIops         *[]string `json:"deviceReadIops,omitempty"`
	DeviceWriteBps         *[]string `json:"deviceWriteBps,omitempty"`
	DeviceWriteIops        *[]string `json:"deviceWriteIops,omitempty"`
	Dns                    *[]string `json:"dns,omitempty"`
	DnsOpt                 *[]string `json:"dnsOpt,omitempty"`
	DnsSearch              *[]string `json:"dnsSearch,omitempty"`
	DnsServers             *[]string `json:"dnsServers,omitempty"`
	Entrypoint             *string   `json:"entrypoint,omitempty"`
	Env                    *[]string `json:"env,omitempty"`
	EnvFile                *[]string `json:"envFile,omitempty"`
	Expose                 *[]string `json:"expose,omitempty"`
	Gidmap                 *[]string `json:"gidmap,omitempty"`
	Groupadd               *[]string `json:"groupadd,omitempty"`
	HealthcheckCommand     *string   `json:"healthcheckCommand,omitempty"`
	HealthcheckInterval    *string   `json:"healthcheckInterval,omitempty"`
	HealthcheckRetries     *int64    `json:"healthcheckRetries,omitempty"`
	HealthcheckStartPeriod *string   `json:"healthcheckStartPeriod,omitempty"`
	HealthcheckTimeout     *string   `json:"healthcheckTimeout,omitempty"`
	Hostname               *string   `json:"hostname,omitempty"`
	ImageVolume            *string   `json:"imageVolume,omitempty"`
	Init                   *bool     `json:"init,omitempty"`
	InitPath               *string   `json:"initPath,omitempty"`
	Interactive            *bool     `json:"interactive,omitempty"`
	Ip                     *string   `json:"ip,omitempty"`
	Ipc                    *string   `json:"ipc,omitempty"`
	KernelMemory           *string   `json:"kernelMemory,omitempty"`
	Label                  *[]string `json:"label,omitempty"`
	LabelFile              *[]string `json:"labelFile,omitempty"`
	LogDriver              *string   `json:"logDriver,omitempty"`
	LogOpt                 *[]string `json:"logOpt,omitempty"`
	MacAddress             *string   `json:"macAddress,omitempty"`
	Memory                 *string   `json:"memory,omitempty"`
	MemoryReservation      *string   `json:"memoryReservation,omitempty"`
	MemorySwap             *string   `json:"memorySwap,omitempty"`
	MemorySwappiness       *int64    `json:"memorySwappiness,omitempty"`
	Name                   *string   `json:"name,omitempty"`
	Net                    *string   `json:"net,omitempty"`
	Network                *string   `json:"network,omitempty"`
	NoHosts                *bool     `json:"noHosts,omitempty"`
	OomKillDisable         *bool     `json:"oomKillDisable,omitempty"`
	OomScoreAdj            *int64    `json:"oomScoreAdj,omitempty"`
	OverrideArch           *string   `json:"overrideArch,omitempty"`
	OverrideOS             *string   `json:"overrideOS,omitempty"`
	Pid                    *string   `json:"pid,omitempty"`
	PidsLimit              *int64    `json:"pidsLimit,omitempty"`
	Pod                    *string   `json:"pod,omitempty"`
	Privileged             *bool     `json:"privileged,omitempty"`
	Publish                *[]string `json:"publish,omitempty"`
	PublishAll             *bool     `json:"publishAll,omitempty"`
	Pull                   *string   `json:"pull,omitempty"`
	Quiet                  *bool     `json:"quiet,omitempty"`
	Readonly               *bool     `json:"readonly,omitempty"`
	Readonlytmpfs          *bool     `json:"readonlytmpfs,omitempty"`
	Restart                *string   `json:"restart,omitempty"`
	Rm                     *bool     `json:"rm,omitempty"`
	Rootfs                 *bool     `json:"rootfs,omitempty"`
	SecurityOpt            *[]string `json:"securityOpt,omitempty"`
	ShmSize                *string   `json:"shmSize,omitempty"`
	StopSignal             *string   `json:"stopSignal,omitempty"`
	StopTimeout            *int64    `json:"stopTimeout,omitempty"`
	StorageOpt             *[]string `json:"storageOpt,omitempty"`
	Subuidname             *string   `json:"subuidname,omitempty"`
	Subgidname             *string   `json:"subgidname,omitempty"`
	Sysctl                 *[]string `json:"sysctl,omitempty"`
	Systemd                *string   `json:"systemd,omitempty"`
	Tmpfs                  *[]string `json:"tmpfs,omitempty"`
	Tty                    *bool     `json:"tty,omitempty"`
	Uidmap                 *[]string `json:"uidmap,omitempty"`
	Ulimit                 *[]string `json:"ulimit,omitempty"`
	User                   *string   `json:"user,omitempty"`
	Userns                 *string   `json:"userns,omitempty"`
	Uts                    *string   `json:"uts,omitempty"`
	Mount                  *[]string `json:"mount,omitempty"`
	Volume                 *[]string `json:"volume,omitempty"`
	VolumesFrom            *[]string `json:"volumesFrom,omitempty"`
	WorkDir                *string   `json:"workDir,omitempty"`
}

// BuildOptions are are used to describe describe physical attributes of the build
type BuildOptions struct {
	AddHosts     []string `json:"addHosts"`
	CgroupParent string   `json:"cgroupParent"`
	CpuPeriod    int64    `json:"cpuPeriod"`
	CpuQuota     int64    `json:"cpuQuota"`
	CpuShares    int64    `json:"cpuShares"`
	CpusetCpus   string   `json:"cpusetCpus"`
	CpusetMems   string   `json:"cpusetMems"`
	Memory       int64    `json:"memory"`
	MemorySwap   int64    `json:"memorySwap"`
	ShmSize      string   `json:"shmSize"`
	Ulimit       []string `json:"ulimit"`
	Volume       []string `json:"volume"`
}

// BuildInfo is used to describe user input for building images
type BuildInfo struct {
	AdditionalTags          []string          `json:"additionalTags"`
	Annotations             []string          `json:"annotations"`
	BuildArgs               map[string]string `json:"buildArgs"`
	BuildOptions            BuildOptions      `json:"buildOptions"`
	CniConfigDir            string            `json:"cniConfigDir"`
	CniPluginDir            string            `json:"cniPluginDir"`
	Compression             string            `json:"compression"`
	ContextDir              string            `json:"contextDir"`
	DefaultsMountFilePath   string            `json:"defaultsMountFilePath"`
	Dockerfiles             []string          `json:"dockerfiles"`
	Err                     string            `json:"err"`
	ForceRmIntermediateCtrs bool              `json:"forceRmIntermediateCtrs"`
	Iidfile                 string            `json:"iidfile"`
	Label                   []string          `json:"label"`
	Layers                  bool              `json:"layers"`
	Nocache                 bool              `json:"nocache"`
	Out                     string            `json:"out"`
	Output                  string            `json:"output"`
	OutputFormat            string            `json:"outputFormat"`
	PullPolicy              string            `json:"pullPolicy"`
	Quiet                   bool              `json:"quiet"`
	RemoteIntermediateCtrs  bool              `json:"remoteIntermediateCtrs"`
	ReportWriter            string            `json:"reportWriter"`
	RuntimeArgs             []string          `json:"runtimeArgs"`
	Squash                  bool              `json:"squash"`
}

// MoreResponse is a struct for when responses from varlink requires longer output
type MoreResponse struct {
	Logs []string `json:"logs"`
	Id   string   `json:"id"`
}

// ListPodContainerInfo is a returned struct for describing containers
// in a pod.
type ListPodContainerInfo struct {
	Name   string `json:"name"`
	Id     string `json:"id"`
	Status string `json:"status"`
}

// PodCreate is an input structure for creating pods.
// It emulates options to podman pod create. The infraCommand and
// infraImage options are currently NotSupported.
type PodCreate struct {
	Name         string            `json:"name"`
	CgroupParent string            `json:"cgroupParent"`
	Labels       map[string]string `json:"labels"`
	Share        []string          `json:"share"`
	Infra        bool              `json:"infra"`
	InfraCommand string            `json:"infraCommand"`
	InfraImage   string            `json:"infraImage"`
	Publish      []string          `json:"publish"`
}

// ListPodData is the returned struct for an individual pod
type ListPodData struct {
	Id                 string                 `json:"id"`
	Name               string                 `json:"name"`
	Createdat          string                 `json:"createdat"`
	Cgroup             string                 `json:"cgroup"`
	Status             string                 `json:"status"`
	Labels             map[string]string      `json:"labels"`
	Numberofcontainers string                 `json:"numberofcontainers"`
	Containersinfo     []ListPodContainerInfo `json:"containersinfo"`
}

type PodContainerErrorData struct {
	Containerid string `json:"containerid"`
	Reason      string `json:"reason"`
}

// Runlabel describes the required input for container runlabel
type Runlabel struct {
	Image     string            `json:"image"`
	Authfile  string            `json:"authfile"`
	Display   bool              `json:"display"`
	Name      string            `json:"name"`
	Pull      bool              `json:"pull"`
	Label     string            `json:"label"`
	ExtraArgs []string          `json:"extraArgs"`
	Opts      map[string]string `json:"opts"`
}

// Event describes a libpod struct
type Event struct {
	Id     string `json:"id"`
	Image  string `json:"image"`
	Name   string `json:"name"`
	Status string `json:"status"`
	Time   string `json:"time"`
	Type   string `json:"type"`
}

type DiffInfo struct {
	Path       string `json:"path"`
	ChangeType string `json:"changeType"`
}

type ExecOpts struct {
	Name       string    `json:"name"`
	Tty        bool      `json:"tty"`
	Privileged bool      `json:"privileged"`
	Cmd        []string  `json:"cmd"`
	User       *string   `json:"user,omitempty"`
	Workdir    *string   `json:"workdir,omitempty"`
	Env        *[]string `json:"env,omitempty"`
	DetachKeys *string   `json:"detachKeys,omitempty"`
}

// ImageNotFound means the image could not be found by the provided name or ID in local storage.
type ImageNotFound struct {
	Id     string `json:"id"`
	Reason string `json:"reason"`
}

func (e ImageNotFound) Error() string {
	s := "io.podman.ImageNotFound"
	s += fmt.Sprintf("(Id: %v, Reason: %v)", e.Id, e.Reason)
	return s
}

// ContainerNotFound means the container could not be found by the provided name or ID in local storage.
type ContainerNotFound struct {
	Id     string `json:"id"`
	Reason string `json:"reason"`
}

func (e ContainerNotFound) Error() string {
	s := "io.podman.ContainerNotFound"
	s += fmt.Sprintf("(Id: %v, Reason: %v)", e.Id, e.Reason)
	return s
}

// NoContainerRunning means none of the containers requested are running in a command that requires a running container.
type NoContainerRunning struct{}

func (e NoContainerRunning) Error() string {
	s := "io.podman.NoContainerRunning"
	return s
}

// PodNotFound means the pod could not be found by the provided name or ID in local storage.
type PodNotFound struct {
	Name   string `json:"name"`
	Reason string `json:"reason"`
}

func (e PodNotFound) Error() string {
	s := "io.podman.PodNotFound"
	s += fmt.Sprintf("(Name: %v, Reason: %v)", e.Name, e.Reason)
	return s
}

// VolumeNotFound means the volume could not be found by the name or ID in local storage.
type VolumeNotFound struct {
	Id     string `json:"id"`
	Reason string `json:"reason"`
}

func (e VolumeNotFound) Error() string {
	s := "io.podman.VolumeNotFound"
	s += fmt.Sprintf("(Id: %v, Reason: %v)", e.Id, e.Reason)
	return s
}

// PodContainerError means a container associated with a pod failed to perform an operation. It contains
// a container ID of the container that failed.
type PodContainerError struct {
	Podname string                  `json:"podname"`
	Errors  []PodContainerErrorData `json:"errors"`
}

func (e PodContainerError) Error() string {
	s := "io.podman.PodContainerError"
	s += fmt.Sprintf("(Podname: %v, Errors: %v)", e.Podname, e.Errors)
	return s
}

// NoContainersInPod means a pod has no containers on which to perform the operation. It contains
// the pod ID.
type NoContainersInPod struct {
	Name string `json:"name"`
}

func (e NoContainersInPod) Error() string {
	s := "io.podman.NoContainersInPod"
	s += fmt.Sprintf("(Name: %v)", e.Name)
	return s
}

// InvalidState indicates that a container or pod was in an improper state for the requested operation
type InvalidState struct {
	Id     string `json:"id"`
	Reason string `json:"reason"`
}

func (e InvalidState) Error() string {
	s := "io.podman.InvalidState"
	s += fmt.Sprintf("(Id: %v, Reason: %v)", e.Id, e.Reason)
	return s
}

// ErrorOccurred is a generic error for an error that occurs during the execution.  The actual error message
// is includes as part of the error's text.
type ErrorOccurred struct {
	Reason string `json:"reason"`
}

func (e ErrorOccurred) Error() string {
	s := "io.podman.ErrorOccurred"
	s += fmt.Sprintf("(Reason: %v)", e.Reason)
	return s
}

// RuntimeErrors generally means a runtime could not be found or gotten.
type RuntimeError struct {
	Reason string `json:"reason"`
}

func (e RuntimeError) Error() string {
	s := "io.podman.RuntimeError"
	s += fmt.Sprintf("(Reason: %v)", e.Reason)
	return s
}

// The Podman endpoint requires that you use a streaming connection.
type WantsMoreRequired struct {
	Reason string `json:"reason"`
}

func (e WantsMoreRequired) Error() string {
	s := "io.podman.WantsMoreRequired"
	s += fmt.Sprintf("(Reason: %v)", e.Reason)
	return s
}

// Container is already stopped
type ErrCtrStopped struct {
	Id string `json:"id"`
}

func (e ErrCtrStopped) Error() string {
	s := "io.podman.ErrCtrStopped"
	s += fmt.Sprintf("(Id: %v)", e.Id)
	return s
}

// This function requires CGroupsV2 to run in rootless mode.
type ErrRequiresCgroupsV2ForRootless struct {
	Reason string `json:"reason"`
}

func (e ErrRequiresCgroupsV2ForRootless) Error() string {
	s := "io.podman.ErrRequiresCgroupsV2ForRootless"
	s += fmt.Sprintf("(Reason: %v)", e.Reason)
	return s
}

func Dispatch_Error(err error) error {
	if e, ok := err.(*varlink.Error); ok {
		switch e.Name {
		case "io.podman.ImageNotFound":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param ImageNotFound
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.ContainerNotFound":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param ContainerNotFound
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.NoContainerRunning":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param NoContainerRunning
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.PodNotFound":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param PodNotFound
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.VolumeNotFound":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param VolumeNotFound
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.PodContainerError":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param PodContainerError
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.NoContainersInPod":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param NoContainersInPod
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.InvalidState":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param InvalidState
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.ErrorOccurred":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param ErrorOccurred
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.RuntimeError":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param RuntimeError
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.WantsMoreRequired":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param WantsMoreRequired
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.ErrCtrStopped":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param ErrCtrStopped
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		case "io.podman.ErrRequiresCgroupsV2ForRootless":
			errorRawParameters := e.Parameters.(*json.RawMessage)
			if errorRawParameters == nil {
				return e
			}
			var param ErrRequiresCgroupsV2ForRootless
			err := json.Unmarshal(*errorRawParameters, &param)
			if err != nil {
				return e
			}
			return &param
		}
	}
	return err
}

// Generated client method calls

// GetVersion returns version and build information of the podman service
type GetVersion_methods struct{}

func GetVersion() GetVersion_methods { return GetVersion_methods{} }

func (m GetVersion_methods) Call(ctx context.Context, c *varlink.Connection) (version_out_ string, go_version_out_ string, git_commit_out_ string, built_out_ string, os_arch_out_ string, remote_api_version_out_ int64, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	version_out_, go_version_out_, git_commit_out_, built_out_, os_arch_out_, remote_api_version_out_, _, err_ = receive(ctx)
	return
}

func (m GetVersion_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) (string, string, string, string, string, int64, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.GetVersion", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (version_out_ string, go_version_out_ string, git_commit_out_ string, built_out_ string, os_arch_out_ string, remote_api_version_out_ int64, flags uint64, err error) {
		var out struct {
			Version            string `json:"version"`
			Go_version         string `json:"go_version"`
			Git_commit         string `json:"git_commit"`
			Built              string `json:"built"`
			Os_arch            string `json:"os_arch"`
			Remote_api_version int64  `json:"remote_api_version"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		version_out_ = out.Version
		go_version_out_ = out.Go_version
		git_commit_out_ = out.Git_commit
		built_out_ = out.Built
		os_arch_out_ = out.Os_arch
		remote_api_version_out_ = out.Remote_api_version
		return
	}, nil
}

func (m GetVersion_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (version_out_ string, go_version_out_ string, git_commit_out_ string, built_out_ string, os_arch_out_ string, remote_api_version_out_ int64, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.GetVersion", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (version_out_ string, go_version_out_ string, git_commit_out_ string, built_out_ string, os_arch_out_ string, remote_api_version_out_ int64, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Version            string `json:"version"`
			Go_version         string `json:"go_version"`
			Git_commit         string `json:"git_commit"`
			Built              string `json:"built"`
			Os_arch            string `json:"os_arch"`
			Remote_api_version int64  `json:"remote_api_version"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		version_out_ = out.Version
		go_version_out_ = out.Go_version
		git_commit_out_ = out.Git_commit
		built_out_ = out.Built
		os_arch_out_ = out.Os_arch
		remote_api_version_out_ = out.Remote_api_version
		return
	}, nil
}

// GetInfo returns a [PodmanInfo](#PodmanInfo) struct that describes podman and its host such as storage stats,
// build information of Podman, and system-wide registries.
type GetInfo_methods struct{}

func GetInfo() GetInfo_methods { return GetInfo_methods{} }

func (m GetInfo_methods) Call(ctx context.Context, c *varlink.Connection) (info_out_ PodmanInfo, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	info_out_, _, err_ = receive(ctx)
	return
}

func (m GetInfo_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) (PodmanInfo, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.GetInfo", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (info_out_ PodmanInfo, flags uint64, err error) {
		var out struct {
			Info PodmanInfo `json:"info"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		info_out_ = out.Info
		return
	}, nil
}

func (m GetInfo_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (info_out_ PodmanInfo, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.GetInfo", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (info_out_ PodmanInfo, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Info PodmanInfo `json:"info"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		info_out_ = out.Info
		return
	}, nil
}

// ListContainers returns information about all containers.
// See also [GetContainer](#GetContainer).
type ListContainers_methods struct{}

func ListContainers() ListContainers_methods { return ListContainers_methods{} }

func (m ListContainers_methods) Call(ctx context.Context, c *varlink.Connection) (containers_out_ []Container, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	containers_out_, _, err_ = receive(ctx)
	return
}

func (m ListContainers_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]Container, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.ListContainers", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []Container, flags uint64, err error) {
		var out struct {
			Containers []Container `json:"containers"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []Container(out.Containers)
		return
	}, nil
}

func (m ListContainers_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (containers_out_ []Container, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.ListContainers", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []Container, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Containers []Container `json:"containers"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []Container(out.Containers)
		return
	}, nil
}

type Ps_methods struct{}

func Ps() Ps_methods { return Ps_methods{} }

func (m Ps_methods) Call(ctx context.Context, c *varlink.Connection, opts_in_ PsOpts) (containers_out_ []PsContainer, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, opts_in_)
	if err_ != nil {
		return
	}
	containers_out_, _, err_ = receive(ctx)
	return
}

func (m Ps_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, opts_in_ PsOpts) (func(ctx context.Context) ([]PsContainer, uint64, error), error) {
	var in struct {
		Opts PsOpts `json:"opts"`
	}
	in.Opts = opts_in_
	receive, err := c.Send(ctx, "io.podman.Ps", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []PsContainer, flags uint64, err error) {
		var out struct {
			Containers []PsContainer `json:"containers"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []PsContainer(out.Containers)
		return
	}, nil
}

func (m Ps_methods) Upgrade(ctx context.Context, c *varlink.Connection, opts_in_ PsOpts) (func(ctx context.Context) (containers_out_ []PsContainer, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Opts PsOpts `json:"opts"`
	}
	in.Opts = opts_in_
	receive, err := c.Upgrade(ctx, "io.podman.Ps", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []PsContainer, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Containers []PsContainer `json:"containers"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []PsContainer(out.Containers)
		return
	}, nil
}

type GetContainersByStatus_methods struct{}

func GetContainersByStatus() GetContainersByStatus_methods { return GetContainersByStatus_methods{} }

func (m GetContainersByStatus_methods) Call(ctx context.Context, c *varlink.Connection, status_in_ []string) (containerS_out_ []Container, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, status_in_)
	if err_ != nil {
		return
	}
	containerS_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainersByStatus_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, status_in_ []string) (func(ctx context.Context) ([]Container, uint64, error), error) {
	var in struct {
		Status []string `json:"status"`
	}
	in.Status = []string(status_in_)
	receive, err := c.Send(ctx, "io.podman.GetContainersByStatus", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containerS_out_ []Container, flags uint64, err error) {
		var out struct {
			ContainerS []Container `json:"containerS"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containerS_out_ = []Container(out.ContainerS)
		return
	}, nil
}

func (m GetContainersByStatus_methods) Upgrade(ctx context.Context, c *varlink.Connection, status_in_ []string) (func(ctx context.Context) (containerS_out_ []Container, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Status []string `json:"status"`
	}
	in.Status = []string(status_in_)
	receive, err := c.Upgrade(ctx, "io.podman.GetContainersByStatus", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containerS_out_ []Container, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			ContainerS []Container `json:"containerS"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containerS_out_ = []Container(out.ContainerS)
		return
	}, nil
}

type Top_methods struct{}

func Top() Top_methods { return Top_methods{} }

func (m Top_methods) Call(ctx context.Context, c *varlink.Connection, nameOrID_in_ string, descriptors_in_ []string) (top_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, nameOrID_in_, descriptors_in_)
	if err_ != nil {
		return
	}
	top_out_, _, err_ = receive(ctx)
	return
}

func (m Top_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, nameOrID_in_ string, descriptors_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		NameOrID    string   `json:"nameOrID"`
		Descriptors []string `json:"descriptors"`
	}
	in.NameOrID = nameOrID_in_
	in.Descriptors = []string(descriptors_in_)
	receive, err := c.Send(ctx, "io.podman.Top", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (top_out_ []string, flags uint64, err error) {
		var out struct {
			Top []string `json:"top"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		top_out_ = []string(out.Top)
		return
	}, nil
}

func (m Top_methods) Upgrade(ctx context.Context, c *varlink.Connection, nameOrID_in_ string, descriptors_in_ []string) (func(ctx context.Context) (top_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		NameOrID    string   `json:"nameOrID"`
		Descriptors []string `json:"descriptors"`
	}
	in.NameOrID = nameOrID_in_
	in.Descriptors = []string(descriptors_in_)
	receive, err := c.Upgrade(ctx, "io.podman.Top", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (top_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Top []string `json:"top"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		top_out_ = []string(out.Top)
		return
	}, nil
}

// HealthCheckRun executes defined container's healthcheck command
// and returns the container's health status.
type HealthCheckRun_methods struct{}

func HealthCheckRun() HealthCheckRun_methods { return HealthCheckRun_methods{} }

func (m HealthCheckRun_methods) Call(ctx context.Context, c *varlink.Connection, nameOrID_in_ string) (healthCheckStatus_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, nameOrID_in_)
	if err_ != nil {
		return
	}
	healthCheckStatus_out_, _, err_ = receive(ctx)
	return
}

func (m HealthCheckRun_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, nameOrID_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		NameOrID string `json:"nameOrID"`
	}
	in.NameOrID = nameOrID_in_
	receive, err := c.Send(ctx, "io.podman.HealthCheckRun", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (healthCheckStatus_out_ string, flags uint64, err error) {
		var out struct {
			HealthCheckStatus string `json:"healthCheckStatus"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		healthCheckStatus_out_ = out.HealthCheckStatus
		return
	}, nil
}

func (m HealthCheckRun_methods) Upgrade(ctx context.Context, c *varlink.Connection, nameOrID_in_ string) (func(ctx context.Context) (healthCheckStatus_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		NameOrID string `json:"nameOrID"`
	}
	in.NameOrID = nameOrID_in_
	receive, err := c.Upgrade(ctx, "io.podman.HealthCheckRun", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (healthCheckStatus_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			HealthCheckStatus string `json:"healthCheckStatus"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		healthCheckStatus_out_ = out.HealthCheckStatus
		return
	}, nil
}

// GetContainer returns information about a single container.  If a container
// with the given id doesn't exist, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.  See also [ListContainers](ListContainers) and
// [InspectContainer](#InspectContainer).
type GetContainer_methods struct{}

func GetContainer() GetContainer_methods { return GetContainer_methods{} }

func (m GetContainer_methods) Call(ctx context.Context, c *varlink.Connection, id_in_ string) (container_out_ Container, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, id_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, id_in_ string) (func(ctx context.Context) (Container, uint64, error), error) {
	var in struct {
		Id string `json:"id"`
	}
	in.Id = id_in_
	receive, err := c.Send(ctx, "io.podman.GetContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ Container, flags uint64, err error) {
		var out struct {
			Container Container `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m GetContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, id_in_ string) (func(ctx context.Context) (container_out_ Container, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Id string `json:"id"`
	}
	in.Id = id_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ Container, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container Container `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// GetContainersByContext allows you to get a list of container ids depending on all, latest, or a list of
// container names.  The definition of latest container means the latest by creation date.  In a multi-
// user environment, results might differ from what you expect.
type GetContainersByContext_methods struct{}

func GetContainersByContext() GetContainersByContext_methods { return GetContainersByContext_methods{} }

func (m GetContainersByContext_methods) Call(ctx context.Context, c *varlink.Connection, all_in_ bool, latest_in_ bool, args_in_ []string) (containers_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, all_in_, latest_in_, args_in_)
	if err_ != nil {
		return
	}
	containers_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainersByContext_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, all_in_ bool, latest_in_ bool, args_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		All    bool     `json:"all"`
		Latest bool     `json:"latest"`
		Args   []string `json:"args"`
	}
	in.All = all_in_
	in.Latest = latest_in_
	in.Args = []string(args_in_)
	receive, err := c.Send(ctx, "io.podman.GetContainersByContext", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []string, flags uint64, err error) {
		var out struct {
			Containers []string `json:"containers"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []string(out.Containers)
		return
	}, nil
}

func (m GetContainersByContext_methods) Upgrade(ctx context.Context, c *varlink.Connection, all_in_ bool, latest_in_ bool, args_in_ []string) (func(ctx context.Context) (containers_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		All    bool     `json:"all"`
		Latest bool     `json:"latest"`
		Args   []string `json:"args"`
	}
	in.All = all_in_
	in.Latest = latest_in_
	in.Args = []string(args_in_)
	receive, err := c.Upgrade(ctx, "io.podman.GetContainersByContext", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Containers []string `json:"containers"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []string(out.Containers)
		return
	}, nil
}

// CreateContainer creates a new container from an image.  It uses a [Create](#Create) type for input.
type CreateContainer_methods struct{}

func CreateContainer() CreateContainer_methods { return CreateContainer_methods{} }

func (m CreateContainer_methods) Call(ctx context.Context, c *varlink.Connection, create_in_ Create) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, create_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m CreateContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, create_in_ Create) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Create Create `json:"create"`
	}
	in.Create = create_in_
	receive, err := c.Send(ctx, "io.podman.CreateContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m CreateContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, create_in_ Create) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Create Create `json:"create"`
	}
	in.Create = create_in_
	receive, err := c.Upgrade(ctx, "io.podman.CreateContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// InspectContainer data takes a name or ID of a container returns the inspection
// data in string format.  You can then serialize the string into JSON.  A [ContainerNotFound](#ContainerNotFound)
// error will be returned if the container cannot be found. See also [InspectImage](#InspectImage).
type InspectContainer_methods struct{}

func InspectContainer() InspectContainer_methods { return InspectContainer_methods{} }

func (m InspectContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m InspectContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.InspectContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m InspectContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.InspectContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// ListContainerProcesses takes a name or ID of a container and returns the processes
// running inside the container as array of strings.  It will accept an array of string
// arguments that represent ps options.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ListContainerProcesses '{"name": "135d71b9495f", "opts": []}'
// {
//   "container": [
//     "  UID   PID  PPID  C STIME TTY          TIME CMD",
//     "    0 21220 21210  0 09:05 pts/0    00:00:00 /bin/sh",
//     "    0 21232 21220  0 09:05 pts/0    00:00:00 top",
//     "    0 21284 21220  0 09:05 pts/0    00:00:00 vi /etc/hosts"
//   ]
// }
// ~~~
type ListContainerProcesses_methods struct{}

func ListContainerProcesses() ListContainerProcesses_methods { return ListContainerProcesses_methods{} }

func (m ListContainerProcesses_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, opts_in_ []string) (container_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, opts_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m ListContainerProcesses_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, opts_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		Name string   `json:"name"`
		Opts []string `json:"opts"`
	}
	in.Name = name_in_
	in.Opts = []string(opts_in_)
	receive, err := c.Send(ctx, "io.podman.ListContainerProcesses", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ []string, flags uint64, err error) {
		var out struct {
			Container []string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = []string(out.Container)
		return
	}, nil
}

func (m ListContainerProcesses_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, opts_in_ []string) (func(ctx context.Context) (container_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string   `json:"name"`
		Opts []string `json:"opts"`
	}
	in.Name = name_in_
	in.Opts = []string(opts_in_)
	receive, err := c.Upgrade(ctx, "io.podman.ListContainerProcesses", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container []string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = []string(out.Container)
		return
	}, nil
}

// GetContainerLogs takes a name or ID of a container and returns the logs of that container.
// If the container cannot be found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// The container logs are returned as an array of strings.  GetContainerLogs will honor the streaming
// capability of varlink if the client invokes it.
type GetContainerLogs_methods struct{}

func GetContainerLogs() GetContainerLogs_methods { return GetContainerLogs_methods{} }

func (m GetContainerLogs_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainerLogs_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.GetContainerLogs", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ []string, flags uint64, err error) {
		var out struct {
			Container []string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = []string(out.Container)
		return
	}, nil
}

func (m GetContainerLogs_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetContainerLogs", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container []string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = []string(out.Container)
		return
	}, nil
}

type GetContainersLogs_methods struct{}

func GetContainersLogs() GetContainersLogs_methods { return GetContainersLogs_methods{} }

func (m GetContainersLogs_methods) Call(ctx context.Context, c *varlink.Connection, names_in_ []string, follow_in_ bool, latest_in_ bool, since_in_ string, tail_in_ int64, timestamps_in_ bool) (log_out_ LogLine, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, names_in_, follow_in_, latest_in_, since_in_, tail_in_, timestamps_in_)
	if err_ != nil {
		return
	}
	log_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainersLogs_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, names_in_ []string, follow_in_ bool, latest_in_ bool, since_in_ string, tail_in_ int64, timestamps_in_ bool) (func(ctx context.Context) (LogLine, uint64, error), error) {
	var in struct {
		Names      []string `json:"names"`
		Follow     bool     `json:"follow"`
		Latest     bool     `json:"latest"`
		Since      string   `json:"since"`
		Tail       int64    `json:"tail"`
		Timestamps bool     `json:"timestamps"`
	}
	in.Names = []string(names_in_)
	in.Follow = follow_in_
	in.Latest = latest_in_
	in.Since = since_in_
	in.Tail = tail_in_
	in.Timestamps = timestamps_in_
	receive, err := c.Send(ctx, "io.podman.GetContainersLogs", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (log_out_ LogLine, flags uint64, err error) {
		var out struct {
			Log LogLine `json:"log"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		log_out_ = out.Log
		return
	}, nil
}

func (m GetContainersLogs_methods) Upgrade(ctx context.Context, c *varlink.Connection, names_in_ []string, follow_in_ bool, latest_in_ bool, since_in_ string, tail_in_ int64, timestamps_in_ bool) (func(ctx context.Context) (log_out_ LogLine, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Names      []string `json:"names"`
		Follow     bool     `json:"follow"`
		Latest     bool     `json:"latest"`
		Since      string   `json:"since"`
		Tail       int64    `json:"tail"`
		Timestamps bool     `json:"timestamps"`
	}
	in.Names = []string(names_in_)
	in.Follow = follow_in_
	in.Latest = latest_in_
	in.Since = since_in_
	in.Tail = tail_in_
	in.Timestamps = timestamps_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetContainersLogs", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (log_out_ LogLine, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Log LogLine `json:"log"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		log_out_ = out.Log
		return
	}, nil
}

// ListContainerChanges takes a name or ID of a container and returns changes between the container and
// its base image. It returns a struct of changed, deleted, and added path names.
type ListContainerChanges_methods struct{}

func ListContainerChanges() ListContainerChanges_methods { return ListContainerChanges_methods{} }

func (m ListContainerChanges_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ ContainerChanges, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m ListContainerChanges_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (ContainerChanges, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.ListContainerChanges", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerChanges, flags uint64, err error) {
		var out struct {
			Container ContainerChanges `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m ListContainerChanges_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ ContainerChanges, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.ListContainerChanges", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerChanges, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container ContainerChanges `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// ExportContainer creates an image from a container.  It takes the name or ID of a container and a
// path representing the target tarfile.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.
// The return value is the written tarfile.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ExportContainer '{"name": "flamboyant_payne", "path": "/tmp/payne.tar" }'
// {
//   "tarfile": "/tmp/payne.tar"
// }
// ~~~
type ExportContainer_methods struct{}

func ExportContainer() ExportContainer_methods { return ExportContainer_methods{} }

func (m ExportContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, path_in_ string) (tarfile_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, path_in_)
	if err_ != nil {
		return
	}
	tarfile_out_, _, err_ = receive(ctx)
	return
}

func (m ExportContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, path_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
		Path string `json:"path"`
	}
	in.Name = name_in_
	in.Path = path_in_
	receive, err := c.Send(ctx, "io.podman.ExportContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (tarfile_out_ string, flags uint64, err error) {
		var out struct {
			Tarfile string `json:"tarfile"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		tarfile_out_ = out.Tarfile
		return
	}, nil
}

func (m ExportContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, path_in_ string) (func(ctx context.Context) (tarfile_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
		Path string `json:"path"`
	}
	in.Name = name_in_
	in.Path = path_in_
	receive, err := c.Upgrade(ctx, "io.podman.ExportContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (tarfile_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Tarfile string `json:"tarfile"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		tarfile_out_ = out.Tarfile
		return
	}, nil
}

// GetContainerStats takes the name or ID of a container and returns a single ContainerStats structure which
// contains attributes like memory and cpu usage.  If the container cannot be found, a
// [ContainerNotFound](#ContainerNotFound) error will be returned. If the container is not running, a [NoContainerRunning](#NoContainerRunning)
// error will be returned
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.GetContainerStats '{"name": "c33e4164f384"}'
// {
//   "container": {
//     "block_input": 0,
//     "block_output": 0,
//     "cpu": 2.571123918839990154678e-08,
//     "cpu_nano": 49037378,
//     "id": "c33e4164f384aa9d979072a63319d66b74fd7a128be71fa68ede24f33ec6cfee",
//     "mem_limit": 33080606720,
//     "mem_perc": 2.166828456524753747370e-03,
//     "mem_usage": 716800,
//     "name": "competent_wozniak",
//     "net_input": 768,
//     "net_output": 5910,
//     "pids": 1,
//     "system_nano": 10000000
//   }
// }
// ~~~
type GetContainerStats_methods struct{}

func GetContainerStats() GetContainerStats_methods { return GetContainerStats_methods{} }

func (m GetContainerStats_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ ContainerStats, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainerStats_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (ContainerStats, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.GetContainerStats", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerStats, flags uint64, err error) {
		var out struct {
			Container ContainerStats `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m GetContainerStats_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ ContainerStats, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetContainerStats", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerStats, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container ContainerStats `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// GetContainerStatsWithHistory takes a previous set of container statistics and uses libpod functions
// to calculate the containers statistics based on current and previous measurements.
type GetContainerStatsWithHistory_methods struct{}

func GetContainerStatsWithHistory() GetContainerStatsWithHistory_methods {
	return GetContainerStatsWithHistory_methods{}
}

func (m GetContainerStatsWithHistory_methods) Call(ctx context.Context, c *varlink.Connection, previousStats_in_ ContainerStats) (container_out_ ContainerStats, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, previousStats_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m GetContainerStatsWithHistory_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, previousStats_in_ ContainerStats) (func(ctx context.Context) (ContainerStats, uint64, error), error) {
	var in struct {
		PreviousStats ContainerStats `json:"previousStats"`
	}
	in.PreviousStats = previousStats_in_
	receive, err := c.Send(ctx, "io.podman.GetContainerStatsWithHistory", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerStats, flags uint64, err error) {
		var out struct {
			Container ContainerStats `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m GetContainerStatsWithHistory_methods) Upgrade(ctx context.Context, c *varlink.Connection, previousStats_in_ ContainerStats) (func(ctx context.Context) (container_out_ ContainerStats, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		PreviousStats ContainerStats `json:"previousStats"`
	}
	in.PreviousStats = previousStats_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetContainerStatsWithHistory", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ ContainerStats, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container ContainerStats `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// StartContainer starts a created or stopped container. It takes the name or ID of container.  It returns
// the container ID once started.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.  See also [CreateContainer](#CreateContainer).
type StartContainer_methods struct{}

func StartContainer() StartContainer_methods { return StartContainer_methods{} }

func (m StartContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m StartContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.StartContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m StartContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.StartContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// StopContainer stops a container given a timeout.  It takes the name or ID of a container as well as a
// timeout value.  The timeout value the time before a forcible stop to the container is applied.  It
// returns the container ID once stopped. If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned instead. See also [KillContainer](KillContainer).
// #### Error
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StopContainer '{"name": "135d71b9495f", "timeout": 5}'
// {
//   "container": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
type StopContainer_methods struct{}

func StopContainer() StopContainer_methods { return StopContainer_methods{} }

func (m StopContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, timeout_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m StopContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Send(ctx, "io.podman.StopContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m StopContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Upgrade(ctx, "io.podman.StopContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// InitContainer initializes the given container. It accepts a container name or
// ID, and will initialize the container matching that ID if possible, and error
// if not. Containers can only be initialized when they are in the Created or
// Exited states. Initialization prepares a container to be started, but does not
// start the container. It is intended to be used to debug a container's state
// prior to starting it.
type InitContainer_methods struct{}

func InitContainer() InitContainer_methods { return InitContainer_methods{} }

func (m InitContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m InitContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.InitContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m InitContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.InitContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// RestartContainer will restart a running container given a container name or ID and timeout value. The timeout
// value is the time before a forcible stop is used to stop the container.  If the container cannot be found by
// name or ID, a [ContainerNotFound](#ContainerNotFound)  error will be returned; otherwise, the ID of the
// container will be returned.
type RestartContainer_methods struct{}

func RestartContainer() RestartContainer_methods { return RestartContainer_methods{} }

func (m RestartContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, timeout_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m RestartContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Send(ctx, "io.podman.RestartContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m RestartContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Upgrade(ctx, "io.podman.RestartContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// KillContainer takes the name or ID of a container as well as a signal to be applied to the container.  Once the
// container has been killed, the container's ID is returned.  If the container cannot be found, a
// [ContainerNotFound](#ContainerNotFound) error is returned. See also [StopContainer](StopContainer).
type KillContainer_methods struct{}

func KillContainer() KillContainer_methods { return KillContainer_methods{} }

func (m KillContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, signal_in_ int64) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, signal_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m KillContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, signal_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name   string `json:"name"`
		Signal int64  `json:"signal"`
	}
	in.Name = name_in_
	in.Signal = signal_in_
	receive, err := c.Send(ctx, "io.podman.KillContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m KillContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, signal_in_ int64) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name   string `json:"name"`
		Signal int64  `json:"signal"`
	}
	in.Name = name_in_
	in.Signal = signal_in_
	receive, err := c.Upgrade(ctx, "io.podman.KillContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// PauseContainer takes the name or ID of container and pauses it.  If the container cannot be found,
// a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
// See also [UnpauseContainer](#UnpauseContainer).
type PauseContainer_methods struct{}

func PauseContainer() PauseContainer_methods { return PauseContainer_methods{} }

func (m PauseContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m PauseContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.PauseContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m PauseContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.PauseContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// UnpauseContainer takes the name or ID of container and unpauses a paused container.  If the container cannot be
// found, a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
// See also [PauseContainer](#PauseContainer).
type UnpauseContainer_methods struct{}

func UnpauseContainer() UnpauseContainer_methods { return UnpauseContainer_methods{} }

func (m UnpauseContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m UnpauseContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.UnpauseContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m UnpauseContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.UnpauseContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// Attach takes the name or ID of a container and sets up the ability to remotely attach to its console. The start
// bool is whether you wish to start the container in question first.
type Attach_methods struct{}

func Attach() Attach_methods { return Attach_methods{} }

func (m Attach_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, detachKeys_in_ string, start_in_ bool) (err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, detachKeys_in_, start_in_)
	if err_ != nil {
		return
	}
	_, err_ = receive(ctx)
	return
}

func (m Attach_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, detachKeys_in_ string, start_in_ bool) (func(ctx context.Context) (uint64, error), error) {
	var in struct {
		Name       string `json:"name"`
		DetachKeys string `json:"detachKeys"`
		Start      bool   `json:"start"`
	}
	in.Name = name_in_
	in.DetachKeys = detachKeys_in_
	in.Start = start_in_
	receive, err := c.Send(ctx, "io.podman.Attach", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, err error) {
		flags, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

func (m Attach_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, detachKeys_in_ string, start_in_ bool) (func(ctx context.Context) (flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name       string `json:"name"`
		DetachKeys string `json:"detachKeys"`
		Start      bool   `json:"start"`
	}
	in.Name = name_in_
	in.DetachKeys = detachKeys_in_
	in.Start = start_in_
	receive, err := c.Upgrade(ctx, "io.podman.Attach", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, conn varlink.ReadWriterContext, err error) {
		flags, conn, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

type AttachControl_methods struct{}

func AttachControl() AttachControl_methods { return AttachControl_methods{} }

func (m AttachControl_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	_, err_ = receive(ctx)
	return
}

func (m AttachControl_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.AttachControl", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, err error) {
		flags, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

func (m AttachControl_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.AttachControl", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, conn varlink.ReadWriterContext, err error) {
		flags, conn, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

// GetAttachSockets takes the name or ID of an existing container.  It returns file paths for two sockets needed
// to properly communicate with a container.  The first is the actual I/O socket that the container uses.  The
// second is a "control" socket where things like resizing the TTY events are sent. If the container cannot be
// found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/io.podman/io.podman.GetAttachSockets '{"name": "b7624e775431219161"}'
// {
//   "sockets": {
//     "container_id": "b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca",
//     "control_socket": "/var/lib/containers/storage/overlay-containers/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/userdata/ctl",
//     "io_socket": "/var/run/libpod/socket/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/attach"
//   }
// }
// ~~~
type GetAttachSockets_methods struct{}

func GetAttachSockets() GetAttachSockets_methods { return GetAttachSockets_methods{} }

func (m GetAttachSockets_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (sockets_out_ Sockets, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	sockets_out_, _, err_ = receive(ctx)
	return
}

func (m GetAttachSockets_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (Sockets, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.GetAttachSockets", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (sockets_out_ Sockets, flags uint64, err error) {
		var out struct {
			Sockets Sockets `json:"sockets"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		sockets_out_ = out.Sockets
		return
	}, nil
}

func (m GetAttachSockets_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (sockets_out_ Sockets, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetAttachSockets", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (sockets_out_ Sockets, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Sockets Sockets `json:"sockets"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		sockets_out_ = out.Sockets
		return
	}, nil
}

// WaitContainer takes the name or ID of a container and waits the given interval in milliseconds until the container
// stops.  Upon stopping, the return code of the container is returned. If the container container cannot be found by ID
// or name, a [ContainerNotFound](#ContainerNotFound) error is returned.
type WaitContainer_methods struct{}

func WaitContainer() WaitContainer_methods { return WaitContainer_methods{} }

func (m WaitContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, interval_in_ int64) (exitcode_out_ int64, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, interval_in_)
	if err_ != nil {
		return
	}
	exitcode_out_, _, err_ = receive(ctx)
	return
}

func (m WaitContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, interval_in_ int64) (func(ctx context.Context) (int64, uint64, error), error) {
	var in struct {
		Name     string `json:"name"`
		Interval int64  `json:"interval"`
	}
	in.Name = name_in_
	in.Interval = interval_in_
	receive, err := c.Send(ctx, "io.podman.WaitContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exitcode_out_ int64, flags uint64, err error) {
		var out struct {
			Exitcode int64 `json:"exitcode"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exitcode_out_ = out.Exitcode
		return
	}, nil
}

func (m WaitContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, interval_in_ int64) (func(ctx context.Context) (exitcode_out_ int64, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name     string `json:"name"`
		Interval int64  `json:"interval"`
	}
	in.Name = name_in_
	in.Interval = interval_in_
	receive, err := c.Upgrade(ctx, "io.podman.WaitContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exitcode_out_ int64, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Exitcode int64 `json:"exitcode"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exitcode_out_ = out.Exitcode
		return
	}, nil
}

// RemoveContainer requires the name or ID of a container as well as a boolean that
// indicates whether a container should be forcefully removed (e.g., by stopping it), and a boolean
// indicating whether to remove builtin volumes. Upon successful removal of the
// container, its ID is returned.  If the
// container cannot be found by name or ID, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// See also [EvictContainer](EvictContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RemoveContainer '{"name": "62f4fd98cb57"}'
// {
//   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
type RemoveContainer_methods struct{}

func RemoveContainer() RemoveContainer_methods { return RemoveContainer_methods{} }

func (m RemoveContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool, removeVolumes_in_ bool) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, force_in_, removeVolumes_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m RemoveContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, force_in_ bool, removeVolumes_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name          string `json:"name"`
		Force         bool   `json:"force"`
		RemoveVolumes bool   `json:"removeVolumes"`
	}
	in.Name = name_in_
	in.Force = force_in_
	in.RemoveVolumes = removeVolumes_in_
	receive, err := c.Send(ctx, "io.podman.RemoveContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m RemoveContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool, removeVolumes_in_ bool) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name          string `json:"name"`
		Force         bool   `json:"force"`
		RemoveVolumes bool   `json:"removeVolumes"`
	}
	in.Name = name_in_
	in.Force = force_in_
	in.RemoveVolumes = removeVolumes_in_
	receive, err := c.Upgrade(ctx, "io.podman.RemoveContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// EvictContainer requires the name or ID of a container as well as a boolean that
// indicates to remove builtin volumes. Upon successful eviction of the container,
// its ID is returned.  If the container cannot be found by name or ID,
// a [ContainerNotFound](#ContainerNotFound) error will be returned.
// See also [RemoveContainer](RemoveContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.EvictContainer '{"name": "62f4fd98cb57"}'
// {
//   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
type EvictContainer_methods struct{}

func EvictContainer() EvictContainer_methods { return EvictContainer_methods{} }

func (m EvictContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, removeVolumes_in_ bool) (container_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, removeVolumes_in_)
	if err_ != nil {
		return
	}
	container_out_, _, err_ = receive(ctx)
	return
}

func (m EvictContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, removeVolumes_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name          string `json:"name"`
		RemoveVolumes bool   `json:"removeVolumes"`
	}
	in.Name = name_in_
	in.RemoveVolumes = removeVolumes_in_
	receive, err := c.Send(ctx, "io.podman.EvictContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

func (m EvictContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, removeVolumes_in_ bool) (func(ctx context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name          string `json:"name"`
		RemoveVolumes bool   `json:"removeVolumes"`
	}
	in.Name = name_in_
	in.RemoveVolumes = removeVolumes_in_
	receive, err := c.Upgrade(ctx, "io.podman.EvictContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (container_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Container string `json:"container"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		container_out_ = out.Container
		return
	}, nil
}

// DeleteStoppedContainers will delete all containers that are not running. It will return a list the deleted
// container IDs.  See also [RemoveContainer](RemoveContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteStoppedContainers
// {
//   "containers": [
//     "451410b931d00def8aa9b4f8084e4d4a39e5e04ea61f358cf53a5cf95afcdcee",
//     "8b60f754a3e01389494a9581ade97d35c2765b6e2f19acd2d3040c82a32d1bc0",
//     "cf2e99d4d3cad6073df199ed32bbe64b124f3e1aba6d78821aa8460e70d30084",
//     "db901a329587312366e5ecff583d08f0875b4b79294322df67d90fc6eed08fc1"
//   ]
// }
// ~~~
type DeleteStoppedContainers_methods struct{}

func DeleteStoppedContainers() DeleteStoppedContainers_methods {
	return DeleteStoppedContainers_methods{}
}

func (m DeleteStoppedContainers_methods) Call(ctx context.Context, c *varlink.Connection) (containers_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	containers_out_, _, err_ = receive(ctx)
	return
}

func (m DeleteStoppedContainers_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]string, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.DeleteStoppedContainers", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []string, flags uint64, err error) {
		var out struct {
			Containers []string `json:"containers"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []string(out.Containers)
		return
	}, nil
}

func (m DeleteStoppedContainers_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (containers_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.DeleteStoppedContainers", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (containers_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Containers []string `json:"containers"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		containers_out_ = []string(out.Containers)
		return
	}, nil
}

// ListImages returns information about the images that are currently in storage.
// See also [InspectImage](#InspectImage).
type ListImages_methods struct{}

func ListImages() ListImages_methods { return ListImages_methods{} }

func (m ListImages_methods) Call(ctx context.Context, c *varlink.Connection) (images_out_ []Image, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	images_out_, _, err_ = receive(ctx)
	return
}

func (m ListImages_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]Image, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.ListImages", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (images_out_ []Image, flags uint64, err error) {
		var out struct {
			Images []Image `json:"images"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		images_out_ = []Image(out.Images)
		return
	}, nil
}

func (m ListImages_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (images_out_ []Image, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.ListImages", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (images_out_ []Image, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Images []Image `json:"images"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		images_out_ = []Image(out.Images)
		return
	}, nil
}

// GetImage returns information about a single image in storage.
// If the image caGetImage returns be found, [ImageNotFound](#ImageNotFound) will be returned.
type GetImage_methods struct{}

func GetImage() GetImage_methods { return GetImage_methods{} }

func (m GetImage_methods) Call(ctx context.Context, c *varlink.Connection, id_in_ string) (image_out_ Image, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, id_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m GetImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, id_in_ string) (func(ctx context.Context) (Image, uint64, error), error) {
	var in struct {
		Id string `json:"id"`
	}
	in.Id = id_in_
	receive, err := c.Send(ctx, "io.podman.GetImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ Image, flags uint64, err error) {
		var out struct {
			Image Image `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m GetImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, id_in_ string) (func(ctx context.Context) (image_out_ Image, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Id string `json:"id"`
	}
	in.Id = id_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ Image, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image Image `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// BuildImage takes a [BuildInfo](#BuildInfo) structure and builds an image.  At a minimum, you must provide the
// contextDir tarball path, the 'dockerfiles' path, and 'output' option in the BuildInfo structure.  The 'output'
// options is the name of the of the resulting build. It will return a [MoreResponse](#MoreResponse) structure
// that contains the build logs and resulting image ID.
// #### Example
// ~~~
// $ sudo varlink call -m unix:///run/podman/io.podman/io.podman.BuildImage '{"build":{"contextDir":"/tmp/t/context.tar","dockerfiles":["Dockerfile"], "output":"foobar"}}'
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "STEP 1: FROM alpine\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "STEP 2: COMMIT foobar\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9",
//    "logs": []
//  }
// }
// ~~~
type BuildImage_methods struct{}

func BuildImage() BuildImage_methods { return BuildImage_methods{} }

func (m BuildImage_methods) Call(ctx context.Context, c *varlink.Connection, build_in_ BuildInfo) (image_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, build_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m BuildImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, build_in_ BuildInfo) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Build BuildInfo `json:"build"`
	}
	in.Build = build_in_
	receive, err := c.Send(ctx, "io.podman.BuildImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Image MoreResponse `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m BuildImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, build_in_ BuildInfo) (func(ctx context.Context) (image_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Build BuildInfo `json:"build"`
	}
	in.Build = build_in_
	receive, err := c.Upgrade(ctx, "io.podman.BuildImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image MoreResponse `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// InspectImage takes the name or ID of an image and returns a string representation of data associated with the
// mage.  You must serialize the string into JSON to use it further.  An [ImageNotFound](#ImageNotFound) error will
// be returned if the image cannot be found.
type InspectImage_methods struct{}

func InspectImage() InspectImage_methods { return InspectImage_methods{} }

func (m InspectImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (image_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m InspectImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.InspectImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m InspectImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.InspectImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// HistoryImage takes the name or ID of an image and returns information about its history and layers.  The returned
// history is in the form of an array of ImageHistory structures.  If the image cannot be found, an
// [ImageNotFound](#ImageNotFound) error is returned.
type HistoryImage_methods struct{}

func HistoryImage() HistoryImage_methods { return HistoryImage_methods{} }

func (m HistoryImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (history_out_ []ImageHistory, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	history_out_, _, err_ = receive(ctx)
	return
}

func (m HistoryImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) ([]ImageHistory, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.HistoryImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (history_out_ []ImageHistory, flags uint64, err error) {
		var out struct {
			History []ImageHistory `json:"history"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		history_out_ = []ImageHistory(out.History)
		return
	}, nil
}

func (m HistoryImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (history_out_ []ImageHistory, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.HistoryImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (history_out_ []ImageHistory, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			History []ImageHistory `json:"history"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		history_out_ = []ImageHistory(out.History)
		return
	}, nil
}

// PushImage takes two input arguments: the name or ID of an image, the fully-qualified destination name of the image,
// It will return an [ImageNotFound](#ImageNotFound) error if
// the image cannot be found in local storage; otherwise it will return a [MoreResponse](#MoreResponse)
type PushImage_methods struct{}

func PushImage() PushImage_methods { return PushImage_methods{} }

func (m PushImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, tag_in_ string, compress_in_ bool, format_in_ string, removeSignatures_in_ bool, signBy_in_ string) (reply_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, tag_in_, compress_in_, format_in_, removeSignatures_in_, signBy_in_)
	if err_ != nil {
		return
	}
	reply_out_, _, err_ = receive(ctx)
	return
}

func (m PushImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, tag_in_ string, compress_in_ bool, format_in_ string, removeSignatures_in_ bool, signBy_in_ string) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Name             string `json:"name"`
		Tag              string `json:"tag"`
		Compress         bool   `json:"compress"`
		Format           string `json:"format"`
		RemoveSignatures bool   `json:"removeSignatures"`
		SignBy           string `json:"signBy"`
	}
	in.Name = name_in_
	in.Tag = tag_in_
	in.Compress = compress_in_
	in.Format = format_in_
	in.RemoveSignatures = removeSignatures_in_
	in.SignBy = signBy_in_
	receive, err := c.Send(ctx, "io.podman.PushImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

func (m PushImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, tag_in_ string, compress_in_ bool, format_in_ string, removeSignatures_in_ bool, signBy_in_ string) (func(ctx context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name             string `json:"name"`
		Tag              string `json:"tag"`
		Compress         bool   `json:"compress"`
		Format           string `json:"format"`
		RemoveSignatures bool   `json:"removeSignatures"`
		SignBy           string `json:"signBy"`
	}
	in.Name = name_in_
	in.Tag = tag_in_
	in.Compress = compress_in_
	in.Format = format_in_
	in.RemoveSignatures = removeSignatures_in_
	in.SignBy = signBy_in_
	receive, err := c.Upgrade(ctx, "io.podman.PushImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

// TagImage takes the name or ID of an image in local storage as well as the desired tag name.  If the image cannot
// be found, an [ImageNotFound](#ImageNotFound) error will be returned; otherwise, the ID of the image is returned on success.
type TagImage_methods struct{}

func TagImage() TagImage_methods { return TagImage_methods{} }

func (m TagImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, tagged_in_ string) (image_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, tagged_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m TagImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, tagged_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name   string `json:"name"`
		Tagged string `json:"tagged"`
	}
	in.Name = name_in_
	in.Tagged = tagged_in_
	receive, err := c.Send(ctx, "io.podman.TagImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m TagImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, tagged_in_ string) (func(ctx context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name   string `json:"name"`
		Tagged string `json:"tagged"`
	}
	in.Name = name_in_
	in.Tagged = tagged_in_
	receive, err := c.Upgrade(ctx, "io.podman.TagImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// RemoveImage takes the name or ID of an image as well as a boolean that determines if containers using that image
// should be deleted.  If the image cannot be found, an [ImageNotFound](#ImageNotFound) error will be returned.  The
// ID of the removed image is returned when complete.  See also [DeleteUnusedImages](DeleteUnusedImages).
// #### Example
// ~~~
// varlink call -m unix:/run/podman/io.podman/io.podman.RemoveImage '{"name": "registry.fedoraproject.org/fedora", "force": true}'
// {
//   "image": "426866d6fa419873f97e5cbd320eeb22778244c1dfffa01c944db3114f55772e"
// }
// ~~~
type RemoveImage_methods struct{}

func RemoveImage() RemoveImage_methods { return RemoveImage_methods{} }

func (m RemoveImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (image_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, force_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m RemoveImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, force_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Send(ctx, "io.podman.RemoveImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m RemoveImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (func(ctx context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Upgrade(ctx, "io.podman.RemoveImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// SearchImages searches available registries for images that contain the
// contents of "query" in their name. If "limit" is given, limits the amount of
// search results per registry.
type SearchImages_methods struct{}

func SearchImages() SearchImages_methods { return SearchImages_methods{} }

func (m SearchImages_methods) Call(ctx context.Context, c *varlink.Connection, query_in_ string, limit_in_ *int64, filter_in_ ImageSearchFilter) (results_out_ []ImageSearchResult, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, query_in_, limit_in_, filter_in_)
	if err_ != nil {
		return
	}
	results_out_, _, err_ = receive(ctx)
	return
}

func (m SearchImages_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, query_in_ string, limit_in_ *int64, filter_in_ ImageSearchFilter) (func(ctx context.Context) ([]ImageSearchResult, uint64, error), error) {
	var in struct {
		Query  string            `json:"query"`
		Limit  *int64            `json:"limit,omitempty"`
		Filter ImageSearchFilter `json:"filter"`
	}
	in.Query = query_in_
	in.Limit = limit_in_
	in.Filter = filter_in_
	receive, err := c.Send(ctx, "io.podman.SearchImages", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (results_out_ []ImageSearchResult, flags uint64, err error) {
		var out struct {
			Results []ImageSearchResult `json:"results"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		results_out_ = []ImageSearchResult(out.Results)
		return
	}, nil
}

func (m SearchImages_methods) Upgrade(ctx context.Context, c *varlink.Connection, query_in_ string, limit_in_ *int64, filter_in_ ImageSearchFilter) (func(ctx context.Context) (results_out_ []ImageSearchResult, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Query  string            `json:"query"`
		Limit  *int64            `json:"limit,omitempty"`
		Filter ImageSearchFilter `json:"filter"`
	}
	in.Query = query_in_
	in.Limit = limit_in_
	in.Filter = filter_in_
	receive, err := c.Upgrade(ctx, "io.podman.SearchImages", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (results_out_ []ImageSearchResult, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Results []ImageSearchResult `json:"results"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		results_out_ = []ImageSearchResult(out.Results)
		return
	}, nil
}

// DeleteUnusedImages deletes any images not associated with a container.  The IDs of the deleted images are returned
// in a string array.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteUnusedImages
// {
//   "images": [
//     "166ea6588079559c724c15223f52927f514f73dd5c5cf2ae2d143e3b2e6e9b52",
//     "da86e6ba6ca197bf6bc5e9d900febd906b133eaa4750e6bed647b0fbe50ed43e",
//     "3ef70f7291f47dfe2b82931a993e16f5a44a0e7a68034c3e0e086d77f5829adc",
//     "59788edf1f3e78cd0ebe6ce1446e9d10788225db3dedcfd1a59f764bad2b2690"
//   ]
// }
// ~~~
type DeleteUnusedImages_methods struct{}

func DeleteUnusedImages() DeleteUnusedImages_methods { return DeleteUnusedImages_methods{} }

func (m DeleteUnusedImages_methods) Call(ctx context.Context, c *varlink.Connection) (images_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	images_out_, _, err_ = receive(ctx)
	return
}

func (m DeleteUnusedImages_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]string, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.DeleteUnusedImages", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (images_out_ []string, flags uint64, err error) {
		var out struct {
			Images []string `json:"images"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		images_out_ = []string(out.Images)
		return
	}, nil
}

func (m DeleteUnusedImages_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (images_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.DeleteUnusedImages", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (images_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Images []string `json:"images"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		images_out_ = []string(out.Images)
		return
	}, nil
}

// Commit, creates an image from an existing container. It requires the name or
// ID of the container as well as the resulting image name.  Optionally, you can define an author and message
// to be added to the resulting image.  You can also define changes to the resulting image for the following
// attributes: _CMD, ENTRYPOINT, ENV, EXPOSE, LABEL, ONBUILD, STOPSIGNAL, USER, VOLUME, and WORKDIR_.  To pause the
// container while it is being committed, pass a _true_ bool for the pause argument.  If the container cannot
// be found by the ID or name provided, a (ContainerNotFound)[#ContainerNotFound] error will be returned; otherwise,
// the resulting image's ID will be returned as a string inside a MoreResponse.
type Commit_methods struct{}

func Commit() Commit_methods { return Commit_methods{} }

func (m Commit_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, image_name_in_ string, changes_in_ []string, author_in_ string, message_in_ string, pause_in_ bool, manifestType_in_ string) (reply_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, image_name_in_, changes_in_, author_in_, message_in_, pause_in_, manifestType_in_)
	if err_ != nil {
		return
	}
	reply_out_, _, err_ = receive(ctx)
	return
}

func (m Commit_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, image_name_in_ string, changes_in_ []string, author_in_ string, message_in_ string, pause_in_ bool, manifestType_in_ string) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Name         string   `json:"name"`
		Image_name   string   `json:"image_name"`
		Changes      []string `json:"changes"`
		Author       string   `json:"author"`
		Message      string   `json:"message"`
		Pause        bool     `json:"pause"`
		ManifestType string   `json:"manifestType"`
	}
	in.Name = name_in_
	in.Image_name = image_name_in_
	in.Changes = []string(changes_in_)
	in.Author = author_in_
	in.Message = message_in_
	in.Pause = pause_in_
	in.ManifestType = manifestType_in_
	receive, err := c.Send(ctx, "io.podman.Commit", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

func (m Commit_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, image_name_in_ string, changes_in_ []string, author_in_ string, message_in_ string, pause_in_ bool, manifestType_in_ string) (func(ctx context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name         string   `json:"name"`
		Image_name   string   `json:"image_name"`
		Changes      []string `json:"changes"`
		Author       string   `json:"author"`
		Message      string   `json:"message"`
		Pause        bool     `json:"pause"`
		ManifestType string   `json:"manifestType"`
	}
	in.Name = name_in_
	in.Image_name = image_name_in_
	in.Changes = []string(changes_in_)
	in.Author = author_in_
	in.Message = message_in_
	in.Pause = pause_in_
	in.ManifestType = manifestType_in_
	receive, err := c.Upgrade(ctx, "io.podman.Commit", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

// ImportImage imports an image from a source (like tarball) into local storage.  The image can have additional
// descriptions added to it using the message and changes options. See also [ExportImage](ExportImage).
type ImportImage_methods struct{}

func ImportImage() ImportImage_methods { return ImportImage_methods{} }

func (m ImportImage_methods) Call(ctx context.Context, c *varlink.Connection, source_in_ string, reference_in_ string, message_in_ string, changes_in_ []string, delete_in_ bool) (image_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, source_in_, reference_in_, message_in_, changes_in_, delete_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m ImportImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, source_in_ string, reference_in_ string, message_in_ string, changes_in_ []string, delete_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Source    string   `json:"source"`
		Reference string   `json:"reference"`
		Message   string   `json:"message"`
		Changes   []string `json:"changes"`
		Delete    bool     `json:"delete"`
	}
	in.Source = source_in_
	in.Reference = reference_in_
	in.Message = message_in_
	in.Changes = []string(changes_in_)
	in.Delete = delete_in_
	receive, err := c.Send(ctx, "io.podman.ImportImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m ImportImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, source_in_ string, reference_in_ string, message_in_ string, changes_in_ []string, delete_in_ bool) (func(ctx context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Source    string   `json:"source"`
		Reference string   `json:"reference"`
		Message   string   `json:"message"`
		Changes   []string `json:"changes"`
		Delete    bool     `json:"delete"`
	}
	in.Source = source_in_
	in.Reference = reference_in_
	in.Message = message_in_
	in.Changes = []string(changes_in_)
	in.Delete = delete_in_
	receive, err := c.Upgrade(ctx, "io.podman.ImportImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// ExportImage takes the name or ID of an image and exports it to a destination like a tarball.  There is also
// a boolean option to force compression.  It also takes in a string array of tags to be able to save multiple
// tags of the same image to a tarball (each tag should be of the form <image>:<tag>).  Upon completion, the ID
// of the image is returned. If the image cannot be found in local storage, an [ImageNotFound](#ImageNotFound)
// error will be returned. See also [ImportImage](ImportImage).
type ExportImage_methods struct{}

func ExportImage() ExportImage_methods { return ExportImage_methods{} }

func (m ExportImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, destination_in_ string, compress_in_ bool, tags_in_ []string) (image_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, destination_in_, compress_in_, tags_in_)
	if err_ != nil {
		return
	}
	image_out_, _, err_ = receive(ctx)
	return
}

func (m ExportImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, destination_in_ string, compress_in_ bool, tags_in_ []string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name        string   `json:"name"`
		Destination string   `json:"destination"`
		Compress    bool     `json:"compress"`
		Tags        []string `json:"tags"`
	}
	in.Name = name_in_
	in.Destination = destination_in_
	in.Compress = compress_in_
	in.Tags = []string(tags_in_)
	receive, err := c.Send(ctx, "io.podman.ExportImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

func (m ExportImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, destination_in_ string, compress_in_ bool, tags_in_ []string) (func(ctx context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name        string   `json:"name"`
		Destination string   `json:"destination"`
		Compress    bool     `json:"compress"`
		Tags        []string `json:"tags"`
	}
	in.Name = name_in_
	in.Destination = destination_in_
	in.Compress = compress_in_
	in.Tags = []string(tags_in_)
	receive, err := c.Upgrade(ctx, "io.podman.ExportImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (image_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Image string `json:"image"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		image_out_ = out.Image
		return
	}, nil
}

// PullImage pulls an image from a repository to local storage.  After a successful pull, the image id and logs
// are returned as a [MoreResponse](#MoreResponse).  This connection also will handle a WantsMores request to send
// status as it occurs.
type PullImage_methods struct{}

func PullImage() PullImage_methods { return PullImage_methods{} }

func (m PullImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (reply_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	reply_out_, _, err_ = receive(ctx)
	return
}

func (m PullImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.PullImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

func (m PullImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.PullImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

// CreatePod creates a new empty pod.  It uses a [PodCreate](#PodCreate) type for input.
// On success, the ID of the newly created pod will be returned.
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"name": "test"}}'
// {
//   "pod": "b05dee7bd4ccfee688099fe1588a7a898d6ddd6897de9251d4671c9b0feacb2a"
// }
// # $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"infra": true, "share": ["ipc", "net", "uts"]}}'
// {
//   "pod": "d7697449a8035f613c1a8891286502aca68fff7d5d49a85279b3bda229af3b28"
// }
// ~~~
type CreatePod_methods struct{}

func CreatePod() CreatePod_methods { return CreatePod_methods{} }

func (m CreatePod_methods) Call(ctx context.Context, c *varlink.Connection, create_in_ PodCreate) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, create_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m CreatePod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, create_in_ PodCreate) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Create PodCreate `json:"create"`
	}
	in.Create = create_in_
	receive, err := c.Send(ctx, "io.podman.CreatePod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m CreatePod_methods) Upgrade(ctx context.Context, c *varlink.Connection, create_in_ PodCreate) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Create PodCreate `json:"create"`
	}
	in.Create = create_in_
	receive, err := c.Upgrade(ctx, "io.podman.CreatePod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// ListPods returns a list of pods in no particular order.  They are
// returned as an array of ListPodData structs.  See also [GetPod](#GetPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ListPods
// {
//   "pods": [
//     {
//       "cgroup": "machine.slice",
//       "containersinfo": [
//         {
//           "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
//           "name": "1840835294cf-infra",
//           "status": "running"
//         },
//         {
//           "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
//           "name": "upbeat_murdock",
//           "status": "running"
//         }
//       ],
//       "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
//       "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
//       "name": "foobar",
//       "numberofcontainers": "2",
//       "status": "Running"
//     },
//     {
//       "cgroup": "machine.slice",
//       "containersinfo": [
//         {
//           "id": "1ca4b7bbba14a75ba00072d4b705c77f3df87db0109afaa44d50cb37c04a477e",
//           "name": "784306f655c6-infra",
//           "status": "running"
//         }
//       ],
//       "createdat": "2018-12-07 13:09:57.105112457 -0600 CST",
//       "id": "784306f655c6200aea321dd430ba685e9b2cc1f7d7528a72f3ff74ffb29485a2",
//       "name": "nostalgic_pike",
//       "numberofcontainers": "1",
//       "status": "Running"
//     }
//   ]
// }
// ~~~
type ListPods_methods struct{}

func ListPods() ListPods_methods { return ListPods_methods{} }

func (m ListPods_methods) Call(ctx context.Context, c *varlink.Connection) (pods_out_ []ListPodData, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	pods_out_, _, err_ = receive(ctx)
	return
}

func (m ListPods_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]ListPodData, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.ListPods", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []ListPodData, flags uint64, err error) {
		var out struct {
			Pods []ListPodData `json:"pods"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []ListPodData(out.Pods)
		return
	}, nil
}

func (m ListPods_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (pods_out_ []ListPodData, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.ListPods", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []ListPodData, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pods []ListPodData `json:"pods"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []ListPodData(out.Pods)
		return
	}, nil
}

// GetPod takes a name or ID of a pod and returns single [ListPodData](#ListPodData)
// structure.  A [PodNotFound](#PodNotFound) error will be returned if the pod cannot be found.
// See also [ListPods](ListPods).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.GetPod '{"name": "foobar"}'
// {
//   "pod": {
//     "cgroup": "machine.slice",
//     "containersinfo": [
//       {
//         "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
//         "name": "1840835294cf-infra",
//         "status": "running"
//       },
//       {
//         "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
//         "name": "upbeat_murdock",
//         "status": "running"
//       }
//     ],
//     "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
//     "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
//     "name": "foobar",
//     "numberofcontainers": "2",
//     "status": "Running"
//   }
// }
// ~~~
type GetPod_methods struct{}

func GetPod() GetPod_methods { return GetPod_methods{} }

func (m GetPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ ListPodData, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m GetPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (ListPodData, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.GetPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ ListPodData, flags uint64, err error) {
		var out struct {
			Pod ListPodData `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m GetPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ ListPodData, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ ListPodData, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod ListPodData `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// InspectPod takes the name or ID of an image and returns a string representation of data associated with the
// pod.  You must serialize the string into JSON to use it further.  A [PodNotFound](#PodNotFound) error will
// be returned if the pod cannot be found.
type InspectPod_methods struct{}

func InspectPod() InspectPod_methods { return InspectPod_methods{} }

func (m InspectPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m InspectPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.InspectPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m InspectPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.InspectPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// StartPod starts containers in a pod.  It takes the name or ID of pod.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
// error will be returned.  Containers in a pod are started independently. If there is an error starting one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was started with no errors, the pod ID is returned.
// See also [CreatePod](#CreatePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StartPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6",
// }
// ~~~
type StartPod_methods struct{}

func StartPod() StartPod_methods { return StartPod_methods{} }

func (m StartPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m StartPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.StartPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m StartPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.StartPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// StopPod stops containers in a pod.  It takes the name or ID of a pod and a timeout.
// If the pod cannot be found, a [PodNotFound](#PodNotFound) error will be returned instead.
// Containers in a pod are stopped independently. If there is an error stopping one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was stopped with no errors, the pod ID is returned.
// See also [KillPod](KillPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StopPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
type StopPod_methods struct{}

func StopPod() StopPod_methods { return StopPod_methods{} }

func (m StopPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, timeout_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m StopPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Send(ctx, "io.podman.StopPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m StopPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, timeout_in_ int64) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name    string `json:"name"`
		Timeout int64  `json:"timeout"`
	}
	in.Name = name_in_
	in.Timeout = timeout_in_
	receive, err := c.Upgrade(ctx, "io.podman.StopPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// RestartPod will restart containers in a pod given a pod name or ID. Containers in
// the pod that are running will be stopped, then all stopped containers will be run.
// If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are restarted independently. If there is an error restarting one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was restarted with no errors, the pod ID is returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RestartPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
type RestartPod_methods struct{}

func RestartPod() RestartPod_methods { return RestartPod_methods{} }

func (m RestartPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m RestartPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.RestartPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m RestartPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.RestartPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// KillPod takes the name or ID of a pod as well as a signal to be applied to the pod.  If the pod cannot be found, a
// [PodNotFound](#PodNotFound) error is returned.
// Containers in a pod are killed independently. If there is an error killing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was killed with no errors, the pod ID is returned.
// See also [StopPod](StopPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.KillPod '{"name": "foobar", "signal": 15}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
type KillPod_methods struct{}

func KillPod() KillPod_methods { return KillPod_methods{} }

func (m KillPod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, signal_in_ int64) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, signal_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m KillPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, signal_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name   string `json:"name"`
		Signal int64  `json:"signal"`
	}
	in.Name = name_in_
	in.Signal = signal_in_
	receive, err := c.Send(ctx, "io.podman.KillPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m KillPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, signal_in_ int64) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name   string `json:"name"`
		Signal int64  `json:"signal"`
	}
	in.Name = name_in_
	in.Signal = signal_in_
	receive, err := c.Upgrade(ctx, "io.podman.KillPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// PausePod takes the name or ID of a pod and pauses the running containers associated with it.  If the pod cannot be found,
// a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are paused independently. If there is an error pausing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was paused with no errors, the pod ID is returned.
// See also [UnpausePod](#UnpausePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.PausePod '{"name": "foobar"}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
type PausePod_methods struct{}

func PausePod() PausePod_methods { return PausePod_methods{} }

func (m PausePod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m PausePod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.PausePod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m PausePod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.PausePod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// UnpausePod takes the name or ID of a pod and unpauses the paused containers associated with it.  If the pod cannot be
// found, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are unpaused independently. If there is an error unpausing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was unpaused with no errors, the pod ID is returned.
// See also [PausePod](#PausePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.UnpausePod '{"name": "foobar"}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
type UnpausePod_methods struct{}

func UnpausePod() UnpausePod_methods { return UnpausePod_methods{} }

func (m UnpausePod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m UnpausePod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.UnpausePod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m UnpausePod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.UnpausePod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// RemovePod takes the name or ID of a pod as well a boolean representing whether a running
// container in the pod can be stopped and removed.  If a pod has containers associated with it, and force is not true,
// an error will occur.
// If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are removed independently. If there is an error removing any container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was removed with no errors, the pod ID is returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RemovePod '{"name": "62f4fd98cb57", "force": "true"}'
// {
//   "pod": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
type RemovePod_methods struct{}

func RemovePod() RemovePod_methods { return RemovePod_methods{} }

func (m RemovePod_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (pod_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, force_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m RemovePod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, force_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Send(ctx, "io.podman.RemovePod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m RemovePod_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (func(ctx context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Upgrade(ctx, "io.podman.RemovePod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod string `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

type TopPod_methods struct{}

func TopPod() TopPod_methods { return TopPod_methods{} }

func (m TopPod_methods) Call(ctx context.Context, c *varlink.Connection, pod_in_ string, latest_in_ bool, descriptors_in_ []string) (stats_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, pod_in_, latest_in_, descriptors_in_)
	if err_ != nil {
		return
	}
	stats_out_, _, err_ = receive(ctx)
	return
}

func (m TopPod_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, pod_in_ string, latest_in_ bool, descriptors_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		Pod         string   `json:"pod"`
		Latest      bool     `json:"latest"`
		Descriptors []string `json:"descriptors"`
	}
	in.Pod = pod_in_
	in.Latest = latest_in_
	in.Descriptors = []string(descriptors_in_)
	receive, err := c.Send(ctx, "io.podman.TopPod", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (stats_out_ []string, flags uint64, err error) {
		var out struct {
			Stats []string `json:"stats"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		stats_out_ = []string(out.Stats)
		return
	}, nil
}

func (m TopPod_methods) Upgrade(ctx context.Context, c *varlink.Connection, pod_in_ string, latest_in_ bool, descriptors_in_ []string) (func(ctx context.Context) (stats_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Pod         string   `json:"pod"`
		Latest      bool     `json:"latest"`
		Descriptors []string `json:"descriptors"`
	}
	in.Pod = pod_in_
	in.Latest = latest_in_
	in.Descriptors = []string(descriptors_in_)
	receive, err := c.Upgrade(ctx, "io.podman.TopPod", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (stats_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Stats []string `json:"stats"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		stats_out_ = []string(out.Stats)
		return
	}, nil
}

// GetPodStats takes the name or ID of a pod and returns a pod name and slice of ContainerStats structure which
// contains attributes like memory and cpu usage.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
// error will be returned.  If the pod has no running containers associated with it, a [NoContainerRunning](#NoContainerRunning)
// error will be returned.
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.GetPodStats '{"name": "7f62b508b6f12b11d8fe02e"}'
// {
//   "containers": [
//     {
//       "block_input": 0,
//       "block_output": 0,
//       "cpu": 2.833470544016107524276e-08,
//       "cpu_nano": 54363072,
//       "id": "a64b51f805121fe2c5a3dc5112eb61d6ed139e3d1c99110360d08b58d48e4a93",
//       "mem_limit": 12276146176,
//       "mem_perc": 7.974359265237864966003e-03,
//       "mem_usage": 978944,
//       "name": "quirky_heisenberg",
//       "net_input": 866,
//       "net_output": 7388,
//       "pids": 1,
//       "system_nano": 20000000
//     }
//   ],
//   "pod": "7f62b508b6f12b11d8fe02e0db4de6b9e43a7d7699b33a4fc0d574f6e82b4ebd"
// }
// ~~~
type GetPodStats_methods struct{}

func GetPodStats() GetPodStats_methods { return GetPodStats_methods{} }

func (m GetPodStats_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (pod_out_ string, containers_out_ []ContainerStats, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	pod_out_, containers_out_, _, err_ = receive(ctx)
	return
}

func (m GetPodStats_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, []ContainerStats, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.GetPodStats", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, containers_out_ []ContainerStats, flags uint64, err error) {
		var out struct {
			Pod        string           `json:"pod"`
			Containers []ContainerStats `json:"containers"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		containers_out_ = []ContainerStats(out.Containers)
		return
	}, nil
}

func (m GetPodStats_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (pod_out_ string, containers_out_ []ContainerStats, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetPodStats", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ string, containers_out_ []ContainerStats, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod        string           `json:"pod"`
			Containers []ContainerStats `json:"containers"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		containers_out_ = []ContainerStats(out.Containers)
		return
	}, nil
}

// GetPodsByStatus searches for pods whose status is included in statuses
type GetPodsByStatus_methods struct{}

func GetPodsByStatus() GetPodsByStatus_methods { return GetPodsByStatus_methods{} }

func (m GetPodsByStatus_methods) Call(ctx context.Context, c *varlink.Connection, statuses_in_ []string) (pods_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, statuses_in_)
	if err_ != nil {
		return
	}
	pods_out_, _, err_ = receive(ctx)
	return
}

func (m GetPodsByStatus_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, statuses_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		Statuses []string `json:"statuses"`
	}
	in.Statuses = []string(statuses_in_)
	receive, err := c.Send(ctx, "io.podman.GetPodsByStatus", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []string, flags uint64, err error) {
		var out struct {
			Pods []string `json:"pods"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []string(out.Pods)
		return
	}, nil
}

func (m GetPodsByStatus_methods) Upgrade(ctx context.Context, c *varlink.Connection, statuses_in_ []string) (func(ctx context.Context) (pods_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Statuses []string `json:"statuses"`
	}
	in.Statuses = []string(statuses_in_)
	receive, err := c.Upgrade(ctx, "io.podman.GetPodsByStatus", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pods []string `json:"pods"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []string(out.Pods)
		return
	}, nil
}

// ImageExists talks a full or partial image ID or name and returns an int as to whether
// the image exists in local storage. An int result of 0 means the image does exist in
// local storage; whereas 1 indicates the image does not exists in local storage.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ImageExists '{"name": "imageddoesntexist"}'
// {
//   "exists": 1
// }
// ~~~
type ImageExists_methods struct{}

func ImageExists() ImageExists_methods { return ImageExists_methods{} }

func (m ImageExists_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (exists_out_ int64, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	exists_out_, _, err_ = receive(ctx)
	return
}

func (m ImageExists_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (int64, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.ImageExists", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exists_out_ int64, flags uint64, err error) {
		var out struct {
			Exists int64 `json:"exists"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exists_out_ = out.Exists
		return
	}, nil
}

func (m ImageExists_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (exists_out_ int64, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.ImageExists", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exists_out_ int64, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Exists int64 `json:"exists"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exists_out_ = out.Exists
		return
	}, nil
}

// ContainerExists takes a full or partial container ID or name and returns an int as to
// whether the container exists in local storage.  A result of 0 means the container does
// exists; whereas a result of 1 means it could not be found.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ContainerExists '{"name": "flamboyant_payne"}'{
//   "exists": 0
// }
// ~~~
type ContainerExists_methods struct{}

func ContainerExists() ContainerExists_methods { return ContainerExists_methods{} }

func (m ContainerExists_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (exists_out_ int64, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	exists_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerExists_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (int64, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.ContainerExists", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exists_out_ int64, flags uint64, err error) {
		var out struct {
			Exists int64 `json:"exists"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exists_out_ = out.Exists
		return
	}, nil
}

func (m ContainerExists_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (exists_out_ int64, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerExists", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (exists_out_ int64, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Exists int64 `json:"exists"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		exists_out_ = out.Exists
		return
	}, nil
}

// ContainerCheckPoint performs a checkpopint on a container by its name or full/partial container
// ID.  On successful checkpoint, the id of the checkpointed container is returned.
type ContainerCheckpoint_methods struct{}

func ContainerCheckpoint() ContainerCheckpoint_methods { return ContainerCheckpoint_methods{} }

func (m ContainerCheckpoint_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, keep_in_ bool, leaveRunning_in_ bool, tcpEstablished_in_ bool) (id_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, keep_in_, leaveRunning_in_, tcpEstablished_in_)
	if err_ != nil {
		return
	}
	id_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerCheckpoint_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, keep_in_ bool, leaveRunning_in_ bool, tcpEstablished_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name           string `json:"name"`
		Keep           bool   `json:"keep"`
		LeaveRunning   bool   `json:"leaveRunning"`
		TcpEstablished bool   `json:"tcpEstablished"`
	}
	in.Name = name_in_
	in.Keep = keep_in_
	in.LeaveRunning = leaveRunning_in_
	in.TcpEstablished = tcpEstablished_in_
	receive, err := c.Send(ctx, "io.podman.ContainerCheckpoint", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

func (m ContainerCheckpoint_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, keep_in_ bool, leaveRunning_in_ bool, tcpEstablished_in_ bool) (func(ctx context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name           string `json:"name"`
		Keep           bool   `json:"keep"`
		LeaveRunning   bool   `json:"leaveRunning"`
		TcpEstablished bool   `json:"tcpEstablished"`
	}
	in.Name = name_in_
	in.Keep = keep_in_
	in.LeaveRunning = leaveRunning_in_
	in.TcpEstablished = tcpEstablished_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerCheckpoint", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

// ContainerRestore restores a container that has been checkpointed.  The container to be restored can
// be identified by its name or full/partial container ID.  A successful restore will result in the return
// of the container's ID.
type ContainerRestore_methods struct{}

func ContainerRestore() ContainerRestore_methods { return ContainerRestore_methods{} }

func (m ContainerRestore_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, keep_in_ bool, tcpEstablished_in_ bool) (id_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, keep_in_, tcpEstablished_in_)
	if err_ != nil {
		return
	}
	id_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerRestore_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, keep_in_ bool, tcpEstablished_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name           string `json:"name"`
		Keep           bool   `json:"keep"`
		TcpEstablished bool   `json:"tcpEstablished"`
	}
	in.Name = name_in_
	in.Keep = keep_in_
	in.TcpEstablished = tcpEstablished_in_
	receive, err := c.Send(ctx, "io.podman.ContainerRestore", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

func (m ContainerRestore_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, keep_in_ bool, tcpEstablished_in_ bool) (func(ctx context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name           string `json:"name"`
		Keep           bool   `json:"keep"`
		TcpEstablished bool   `json:"tcpEstablished"`
	}
	in.Name = name_in_
	in.Keep = keep_in_
	in.TcpEstablished = tcpEstablished_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerRestore", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

// ContainerRunlabel runs executes a command as described by a given container image label.
type ContainerRunlabel_methods struct{}

func ContainerRunlabel() ContainerRunlabel_methods { return ContainerRunlabel_methods{} }

func (m ContainerRunlabel_methods) Call(ctx context.Context, c *varlink.Connection, runlabel_in_ Runlabel) (err_ error) {
	receive, err_ := m.Send(ctx, c, 0, runlabel_in_)
	if err_ != nil {
		return
	}
	_, err_ = receive(ctx)
	return
}

func (m ContainerRunlabel_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, runlabel_in_ Runlabel) (func(ctx context.Context) (uint64, error), error) {
	var in struct {
		Runlabel Runlabel `json:"runlabel"`
	}
	in.Runlabel = runlabel_in_
	receive, err := c.Send(ctx, "io.podman.ContainerRunlabel", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, err error) {
		flags, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

func (m ContainerRunlabel_methods) Upgrade(ctx context.Context, c *varlink.Connection, runlabel_in_ Runlabel) (func(ctx context.Context) (flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Runlabel Runlabel `json:"runlabel"`
	}
	in.Runlabel = runlabel_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerRunlabel", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, conn varlink.ReadWriterContext, err error) {
		flags, conn, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

// ExecContainer executes a command in the given container.
type ExecContainer_methods struct{}

func ExecContainer() ExecContainer_methods { return ExecContainer_methods{} }

func (m ExecContainer_methods) Call(ctx context.Context, c *varlink.Connection, opts_in_ ExecOpts) (err_ error) {
	receive, err_ := m.Send(ctx, c, 0, opts_in_)
	if err_ != nil {
		return
	}
	_, err_ = receive(ctx)
	return
}

func (m ExecContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, opts_in_ ExecOpts) (func(ctx context.Context) (uint64, error), error) {
	var in struct {
		Opts ExecOpts `json:"opts"`
	}
	in.Opts = opts_in_
	receive, err := c.Send(ctx, "io.podman.ExecContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, err error) {
		flags, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

func (m ExecContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, opts_in_ ExecOpts) (func(ctx context.Context) (flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Opts ExecOpts `json:"opts"`
	}
	in.Opts = opts_in_
	receive, err := c.Upgrade(ctx, "io.podman.ExecContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, conn varlink.ReadWriterContext, err error) {
		flags, conn, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

// ListContainerMounts gathers all the mounted container mount points and returns them as an array
// of strings
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.ListContainerMounts
// {
//   "mounts": {
//     "04e4c255269ed2545e7f8bd1395a75f7949c50c223415c00c1d54bfa20f3b3d9": "/var/lib/containers/storage/overlay/a078925828f57e20467ca31cfca8a849210d21ec7e5757332b72b6924f441c17/merged",
//     "1d58c319f9e881a644a5122ff84419dccf6d138f744469281446ab243ef38924": "/var/lib/containers/storage/overlay/948fcf93f8cb932f0f03fd52e3180a58627d547192ffe3b88e0013b98ddcd0d2/merged"
//   }
// }
// ~~~
type ListContainerMounts_methods struct{}

func ListContainerMounts() ListContainerMounts_methods { return ListContainerMounts_methods{} }

func (m ListContainerMounts_methods) Call(ctx context.Context, c *varlink.Connection) (mounts_out_ map[string]string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	mounts_out_, _, err_ = receive(ctx)
	return
}

func (m ListContainerMounts_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) (map[string]string, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.ListContainerMounts", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (mounts_out_ map[string]string, flags uint64, err error) {
		var out struct {
			Mounts map[string]string `json:"mounts"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		mounts_out_ = map[string]string(out.Mounts)
		return
	}, nil
}

func (m ListContainerMounts_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (mounts_out_ map[string]string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.ListContainerMounts", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (mounts_out_ map[string]string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Mounts map[string]string `json:"mounts"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		mounts_out_ = map[string]string(out.Mounts)
		return
	}, nil
}

// MountContainer mounts a container by name or full/partial ID.  Upon a successful mount, the destination
// mount is returned as a string.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.MountContainer '{"name": "jolly_shannon"}'{
//   "path": "/var/lib/containers/storage/overlay/419eeb04e783ea159149ced67d9fcfc15211084d65e894792a96bedfae0470ca/merged"
// }
// ~~~
type MountContainer_methods struct{}

func MountContainer() MountContainer_methods { return MountContainer_methods{} }

func (m MountContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (path_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	path_out_, _, err_ = receive(ctx)
	return
}

func (m MountContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.MountContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (path_out_ string, flags uint64, err error) {
		var out struct {
			Path string `json:"path"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		path_out_ = out.Path
		return
	}, nil
}

func (m MountContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (path_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.MountContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (path_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Path string `json:"path"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		path_out_ = out.Path
		return
	}, nil
}

// UnmountContainer umounts a container by its name or full/partial container ID.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.UnmountContainer '{"name": "jolly_shannon", "force": false}'
// {}
// ~~~
type UnmountContainer_methods struct{}

func UnmountContainer() UnmountContainer_methods { return UnmountContainer_methods{} }

func (m UnmountContainer_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, force_in_)
	if err_ != nil {
		return
	}
	_, err_ = receive(ctx)
	return
}

func (m UnmountContainer_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, force_in_ bool) (func(ctx context.Context) (uint64, error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Send(ctx, "io.podman.UnmountContainer", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, err error) {
		flags, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

func (m UnmountContainer_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, force_in_ bool) (func(ctx context.Context) (flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name  string `json:"name"`
		Force bool   `json:"force"`
	}
	in.Name = name_in_
	in.Force = force_in_
	receive, err := c.Upgrade(ctx, "io.podman.UnmountContainer", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (flags uint64, conn varlink.ReadWriterContext, err error) {
		flags, conn, err = receive(ctx, nil)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		return
	}, nil
}

// ImagesPrune removes all unused images from the local store.  Upon successful pruning,
// the IDs of the removed images are returned.
type ImagesPrune_methods struct{}

func ImagesPrune() ImagesPrune_methods { return ImagesPrune_methods{} }

func (m ImagesPrune_methods) Call(ctx context.Context, c *varlink.Connection, all_in_ bool) (pruned_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, all_in_)
	if err_ != nil {
		return
	}
	pruned_out_, _, err_ = receive(ctx)
	return
}

func (m ImagesPrune_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, all_in_ bool) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		All bool `json:"all"`
	}
	in.All = all_in_
	receive, err := c.Send(ctx, "io.podman.ImagesPrune", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pruned_out_ []string, flags uint64, err error) {
		var out struct {
			Pruned []string `json:"pruned"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pruned_out_ = []string(out.Pruned)
		return
	}, nil
}

func (m ImagesPrune_methods) Upgrade(ctx context.Context, c *varlink.Connection, all_in_ bool) (func(ctx context.Context) (pruned_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		All bool `json:"all"`
	}
	in.All = all_in_
	receive, err := c.Upgrade(ctx, "io.podman.ImagesPrune", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pruned_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pruned []string `json:"pruned"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pruned_out_ = []string(out.Pruned)
		return
	}, nil
}

// GenerateKube generates a Kubernetes v1 Pod description of a Podman container or pod
// and its containers. The description is in YAML.  See also [ReplayKube](ReplayKube).
type GenerateKube_methods struct{}

func GenerateKube() GenerateKube_methods { return GenerateKube_methods{} }

func (m GenerateKube_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, service_in_ bool) (pod_out_ KubePodService, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, service_in_)
	if err_ != nil {
		return
	}
	pod_out_, _, err_ = receive(ctx)
	return
}

func (m GenerateKube_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, service_in_ bool) (func(ctx context.Context) (KubePodService, uint64, error), error) {
	var in struct {
		Name    string `json:"name"`
		Service bool   `json:"service"`
	}
	in.Name = name_in_
	in.Service = service_in_
	receive, err := c.Send(ctx, "io.podman.GenerateKube", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ KubePodService, flags uint64, err error) {
		var out struct {
			Pod KubePodService `json:"pod"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

func (m GenerateKube_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, service_in_ bool) (func(ctx context.Context) (pod_out_ KubePodService, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name    string `json:"name"`
		Service bool   `json:"service"`
	}
	in.Name = name_in_
	in.Service = service_in_
	receive, err := c.Upgrade(ctx, "io.podman.GenerateKube", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pod_out_ KubePodService, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pod KubePodService `json:"pod"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pod_out_ = out.Pod
		return
	}, nil
}

// ContainerConfig returns a container's config in string form. This call is for
// development of Podman only and generally should not be used.
type ContainerConfig_methods struct{}

func ContainerConfig() ContainerConfig_methods { return ContainerConfig_methods{} }

func (m ContainerConfig_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerConfig_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.ContainerConfig", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m ContainerConfig_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerConfig", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// ContainerArtifacts returns a container's artifacts in string form.  This call is for
// development of Podman only and generally should not be used.
type ContainerArtifacts_methods struct{}

func ContainerArtifacts() ContainerArtifacts_methods { return ContainerArtifacts_methods{} }

func (m ContainerArtifacts_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, artifactName_in_ string) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, artifactName_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerArtifacts_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, artifactName_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name         string `json:"name"`
		ArtifactName string `json:"artifactName"`
	}
	in.Name = name_in_
	in.ArtifactName = artifactName_in_
	receive, err := c.Send(ctx, "io.podman.ContainerArtifacts", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m ContainerArtifacts_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, artifactName_in_ string) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name         string `json:"name"`
		ArtifactName string `json:"artifactName"`
	}
	in.Name = name_in_
	in.ArtifactName = artifactName_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerArtifacts", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// ContainerInspectData returns a container's inspect data in string form.  This call is for
// development of Podman only and generally should not be used.
type ContainerInspectData_methods struct{}

func ContainerInspectData() ContainerInspectData_methods { return ContainerInspectData_methods{} }

func (m ContainerInspectData_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, size_in_ bool) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, size_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerInspectData_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, size_in_ bool) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
		Size bool   `json:"size"`
	}
	in.Name = name_in_
	in.Size = size_in_
	receive, err := c.Send(ctx, "io.podman.ContainerInspectData", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m ContainerInspectData_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, size_in_ bool) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
		Size bool   `json:"size"`
	}
	in.Name = name_in_
	in.Size = size_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerInspectData", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// ContainerStateData returns a container's state config in string form.  This call is for
// development of Podman only and generally should not be used.
type ContainerStateData_methods struct{}

func ContainerStateData() ContainerStateData_methods { return ContainerStateData_methods{} }

func (m ContainerStateData_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m ContainerStateData_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.ContainerStateData", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m ContainerStateData_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.ContainerStateData", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// PodStateData returns inspectr level information of a given pod in string form.  This call is for
// development of Podman only and generally should not be used.
type PodStateData_methods struct{}

func PodStateData() PodStateData_methods { return PodStateData_methods{} }

func (m PodStateData_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m PodStateData_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.PodStateData", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m PodStateData_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.PodStateData", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// This call is for the development of Podman only and should not be used.
type CreateFromCC_methods struct{}

func CreateFromCC() CreateFromCC_methods { return CreateFromCC_methods{} }

func (m CreateFromCC_methods) Call(ctx context.Context, c *varlink.Connection, in_in_ []string) (id_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, in_in_)
	if err_ != nil {
		return
	}
	id_out_, _, err_ = receive(ctx)
	return
}

func (m CreateFromCC_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, in_in_ []string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		In []string `json:"in"`
	}
	in.In = []string(in_in_)
	receive, err := c.Send(ctx, "io.podman.CreateFromCC", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

func (m CreateFromCC_methods) Upgrade(ctx context.Context, c *varlink.Connection, in_in_ []string) (func(ctx context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		In []string `json:"in"`
	}
	in.In = []string(in_in_)
	receive, err := c.Upgrade(ctx, "io.podman.CreateFromCC", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (id_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Id string `json:"id"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		id_out_ = out.Id
		return
	}, nil
}

// Spec returns the oci spec for a container.  This call is for development of Podman only and generally should not be used.
type Spec_methods struct{}

func Spec() Spec_methods { return Spec_methods{} }

func (m Spec_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (config_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	config_out_, _, err_ = receive(ctx)
	return
}

func (m Spec_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.Spec", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

func (m Spec_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.Spec", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (config_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Config string `json:"config"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		config_out_ = out.Config
		return
	}, nil
}

// Sendfile allows a remote client to send a file to the host
type SendFile_methods struct{}

func SendFile() SendFile_methods { return SendFile_methods{} }

func (m SendFile_methods) Call(ctx context.Context, c *varlink.Connection, type_in_ string, length_in_ int64) (file_handle_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, type_in_, length_in_)
	if err_ != nil {
		return
	}
	file_handle_out_, _, err_ = receive(ctx)
	return
}

func (m SendFile_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, type_in_ string, length_in_ int64) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Type   string `json:"type"`
		Length int64  `json:"length"`
	}
	in.Type = type_in_
	in.Length = length_in_
	receive, err := c.Send(ctx, "io.podman.SendFile", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (file_handle_out_ string, flags uint64, err error) {
		var out struct {
			File_handle string `json:"file_handle"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		file_handle_out_ = out.File_handle
		return
	}, nil
}

func (m SendFile_methods) Upgrade(ctx context.Context, c *varlink.Connection, type_in_ string, length_in_ int64) (func(ctx context.Context) (file_handle_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Type   string `json:"type"`
		Length int64  `json:"length"`
	}
	in.Type = type_in_
	in.Length = length_in_
	receive, err := c.Upgrade(ctx, "io.podman.SendFile", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (file_handle_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			File_handle string `json:"file_handle"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		file_handle_out_ = out.File_handle
		return
	}, nil
}

// ReceiveFile allows the host to send a remote client a file
type ReceiveFile_methods struct{}

func ReceiveFile() ReceiveFile_methods { return ReceiveFile_methods{} }

func (m ReceiveFile_methods) Call(ctx context.Context, c *varlink.Connection, path_in_ string, delete_in_ bool) (len_out_ int64, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, path_in_, delete_in_)
	if err_ != nil {
		return
	}
	len_out_, _, err_ = receive(ctx)
	return
}

func (m ReceiveFile_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, path_in_ string, delete_in_ bool) (func(ctx context.Context) (int64, uint64, error), error) {
	var in struct {
		Path   string `json:"path"`
		Delete bool   `json:"delete"`
	}
	in.Path = path_in_
	in.Delete = delete_in_
	receive, err := c.Send(ctx, "io.podman.ReceiveFile", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (len_out_ int64, flags uint64, err error) {
		var out struct {
			Len int64 `json:"len"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		len_out_ = out.Len
		return
	}, nil
}

func (m ReceiveFile_methods) Upgrade(ctx context.Context, c *varlink.Connection, path_in_ string, delete_in_ bool) (func(ctx context.Context) (len_out_ int64, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Path   string `json:"path"`
		Delete bool   `json:"delete"`
	}
	in.Path = path_in_
	in.Delete = delete_in_
	receive, err := c.Upgrade(ctx, "io.podman.ReceiveFile", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (len_out_ int64, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Len int64 `json:"len"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		len_out_ = out.Len
		return
	}, nil
}

// VolumeCreate creates a volume on a remote host
type VolumeCreate_methods struct{}

func VolumeCreate() VolumeCreate_methods { return VolumeCreate_methods{} }

func (m VolumeCreate_methods) Call(ctx context.Context, c *varlink.Connection, options_in_ VolumeCreateOpts) (volumeName_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, options_in_)
	if err_ != nil {
		return
	}
	volumeName_out_, _, err_ = receive(ctx)
	return
}

func (m VolumeCreate_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, options_in_ VolumeCreateOpts) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Options VolumeCreateOpts `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Send(ctx, "io.podman.VolumeCreate", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volumeName_out_ string, flags uint64, err error) {
		var out struct {
			VolumeName string `json:"volumeName"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volumeName_out_ = out.VolumeName
		return
	}, nil
}

func (m VolumeCreate_methods) Upgrade(ctx context.Context, c *varlink.Connection, options_in_ VolumeCreateOpts) (func(ctx context.Context) (volumeName_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Options VolumeCreateOpts `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Upgrade(ctx, "io.podman.VolumeCreate", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volumeName_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			VolumeName string `json:"volumeName"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volumeName_out_ = out.VolumeName
		return
	}, nil
}

// VolumeRemove removes a volume on a remote host
type VolumeRemove_methods struct{}

func VolumeRemove() VolumeRemove_methods { return VolumeRemove_methods{} }

func (m VolumeRemove_methods) Call(ctx context.Context, c *varlink.Connection, options_in_ VolumeRemoveOpts) (successes_out_ []string, failures_out_ map[string]string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, options_in_)
	if err_ != nil {
		return
	}
	successes_out_, failures_out_, _, err_ = receive(ctx)
	return
}

func (m VolumeRemove_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, options_in_ VolumeRemoveOpts) (func(ctx context.Context) ([]string, map[string]string, uint64, error), error) {
	var in struct {
		Options VolumeRemoveOpts `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Send(ctx, "io.podman.VolumeRemove", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (successes_out_ []string, failures_out_ map[string]string, flags uint64, err error) {
		var out struct {
			Successes []string          `json:"successes"`
			Failures  map[string]string `json:"failures"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		successes_out_ = []string(out.Successes)
		failures_out_ = map[string]string(out.Failures)
		return
	}, nil
}

func (m VolumeRemove_methods) Upgrade(ctx context.Context, c *varlink.Connection, options_in_ VolumeRemoveOpts) (func(ctx context.Context) (successes_out_ []string, failures_out_ map[string]string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Options VolumeRemoveOpts `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Upgrade(ctx, "io.podman.VolumeRemove", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (successes_out_ []string, failures_out_ map[string]string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Successes []string          `json:"successes"`
			Failures  map[string]string `json:"failures"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		successes_out_ = []string(out.Successes)
		failures_out_ = map[string]string(out.Failures)
		return
	}, nil
}

// GetVolumes gets slice of the volumes on a remote host
type GetVolumes_methods struct{}

func GetVolumes() GetVolumes_methods { return GetVolumes_methods{} }

func (m GetVolumes_methods) Call(ctx context.Context, c *varlink.Connection, args_in_ []string, all_in_ bool) (volumes_out_ []Volume, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, args_in_, all_in_)
	if err_ != nil {
		return
	}
	volumes_out_, _, err_ = receive(ctx)
	return
}

func (m GetVolumes_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, args_in_ []string, all_in_ bool) (func(ctx context.Context) ([]Volume, uint64, error), error) {
	var in struct {
		Args []string `json:"args"`
		All  bool     `json:"all"`
	}
	in.Args = []string(args_in_)
	in.All = all_in_
	receive, err := c.Send(ctx, "io.podman.GetVolumes", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volumes_out_ []Volume, flags uint64, err error) {
		var out struct {
			Volumes []Volume `json:"volumes"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volumes_out_ = []Volume(out.Volumes)
		return
	}, nil
}

func (m GetVolumes_methods) Upgrade(ctx context.Context, c *varlink.Connection, args_in_ []string, all_in_ bool) (func(ctx context.Context) (volumes_out_ []Volume, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Args []string `json:"args"`
		All  bool     `json:"all"`
	}
	in.Args = []string(args_in_)
	in.All = all_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetVolumes", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volumes_out_ []Volume, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Volumes []Volume `json:"volumes"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volumes_out_ = []Volume(out.Volumes)
		return
	}, nil
}

// InspectVolume inspects a single volume. Returns inspect JSON in the form of a
// string.
type InspectVolume_methods struct{}

func InspectVolume() InspectVolume_methods { return InspectVolume_methods{} }

func (m InspectVolume_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (volume_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	volume_out_, _, err_ = receive(ctx)
	return
}

func (m InspectVolume_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.InspectVolume", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volume_out_ string, flags uint64, err error) {
		var out struct {
			Volume string `json:"volume"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volume_out_ = out.Volume
		return
	}, nil
}

func (m InspectVolume_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (volume_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.InspectVolume", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (volume_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Volume string `json:"volume"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		volume_out_ = out.Volume
		return
	}, nil
}

// VolumesPrune removes unused volumes on the host
type VolumesPrune_methods struct{}

func VolumesPrune() VolumesPrune_methods { return VolumesPrune_methods{} }

func (m VolumesPrune_methods) Call(ctx context.Context, c *varlink.Connection) (prunedNames_out_ []string, prunedErrors_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	prunedNames_out_, prunedErrors_out_, _, err_ = receive(ctx)
	return
}

func (m VolumesPrune_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) ([]string, []string, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.VolumesPrune", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (prunedNames_out_ []string, prunedErrors_out_ []string, flags uint64, err error) {
		var out struct {
			PrunedNames  []string `json:"prunedNames"`
			PrunedErrors []string `json:"prunedErrors"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		prunedNames_out_ = []string(out.PrunedNames)
		prunedErrors_out_ = []string(out.PrunedErrors)
		return
	}, nil
}

func (m VolumesPrune_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (prunedNames_out_ []string, prunedErrors_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.VolumesPrune", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (prunedNames_out_ []string, prunedErrors_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			PrunedNames  []string `json:"prunedNames"`
			PrunedErrors []string `json:"prunedErrors"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		prunedNames_out_ = []string(out.PrunedNames)
		prunedErrors_out_ = []string(out.PrunedErrors)
		return
	}, nil
}

// ImageSave allows you to save an image from the local image storage to a tarball
type ImageSave_methods struct{}

func ImageSave() ImageSave_methods { return ImageSave_methods{} }

func (m ImageSave_methods) Call(ctx context.Context, c *varlink.Connection, options_in_ ImageSaveOptions) (reply_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, options_in_)
	if err_ != nil {
		return
	}
	reply_out_, _, err_ = receive(ctx)
	return
}

func (m ImageSave_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, options_in_ ImageSaveOptions) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Options ImageSaveOptions `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Send(ctx, "io.podman.ImageSave", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

func (m ImageSave_methods) Upgrade(ctx context.Context, c *varlink.Connection, options_in_ ImageSaveOptions) (func(ctx context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Options ImageSaveOptions `json:"options"`
	}
	in.Options = options_in_
	receive, err := c.Upgrade(ctx, "io.podman.ImageSave", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

// GetPodsByContext allows you to get a list pod ids depending on all, latest, or a list of
// pod names.  The definition of latest pod means the latest by creation date.  In a multi-
// user environment, results might differ from what you expect.
type GetPodsByContext_methods struct{}

func GetPodsByContext() GetPodsByContext_methods { return GetPodsByContext_methods{} }

func (m GetPodsByContext_methods) Call(ctx context.Context, c *varlink.Connection, all_in_ bool, latest_in_ bool, args_in_ []string) (pods_out_ []string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, all_in_, latest_in_, args_in_)
	if err_ != nil {
		return
	}
	pods_out_, _, err_ = receive(ctx)
	return
}

func (m GetPodsByContext_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, all_in_ bool, latest_in_ bool, args_in_ []string) (func(ctx context.Context) ([]string, uint64, error), error) {
	var in struct {
		All    bool     `json:"all"`
		Latest bool     `json:"latest"`
		Args   []string `json:"args"`
	}
	in.All = all_in_
	in.Latest = latest_in_
	in.Args = []string(args_in_)
	receive, err := c.Send(ctx, "io.podman.GetPodsByContext", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []string, flags uint64, err error) {
		var out struct {
			Pods []string `json:"pods"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []string(out.Pods)
		return
	}, nil
}

func (m GetPodsByContext_methods) Upgrade(ctx context.Context, c *varlink.Connection, all_in_ bool, latest_in_ bool, args_in_ []string) (func(ctx context.Context) (pods_out_ []string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		All    bool     `json:"all"`
		Latest bool     `json:"latest"`
		Args   []string `json:"args"`
	}
	in.All = all_in_
	in.Latest = latest_in_
	in.Args = []string(args_in_)
	receive, err := c.Upgrade(ctx, "io.podman.GetPodsByContext", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (pods_out_ []string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Pods []string `json:"pods"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		pods_out_ = []string(out.Pods)
		return
	}, nil
}

// LoadImage allows you to load an image into local storage from a tarball.
type LoadImage_methods struct{}

func LoadImage() LoadImage_methods { return LoadImage_methods{} }

func (m LoadImage_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string, inputFile_in_ string, quiet_in_ bool, deleteFile_in_ bool) (reply_out_ MoreResponse, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_, inputFile_in_, quiet_in_, deleteFile_in_)
	if err_ != nil {
		return
	}
	reply_out_, _, err_ = receive(ctx)
	return
}

func (m LoadImage_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string, inputFile_in_ string, quiet_in_ bool, deleteFile_in_ bool) (func(ctx context.Context) (MoreResponse, uint64, error), error) {
	var in struct {
		Name       string `json:"name"`
		InputFile  string `json:"inputFile"`
		Quiet      bool   `json:"quiet"`
		DeleteFile bool   `json:"deleteFile"`
	}
	in.Name = name_in_
	in.InputFile = inputFile_in_
	in.Quiet = quiet_in_
	in.DeleteFile = deleteFile_in_
	receive, err := c.Send(ctx, "io.podman.LoadImage", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

func (m LoadImage_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string, inputFile_in_ string, quiet_in_ bool, deleteFile_in_ bool) (func(ctx context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name       string `json:"name"`
		InputFile  string `json:"inputFile"`
		Quiet      bool   `json:"quiet"`
		DeleteFile bool   `json:"deleteFile"`
	}
	in.Name = name_in_
	in.InputFile = inputFile_in_
	in.Quiet = quiet_in_
	in.DeleteFile = deleteFile_in_
	receive, err := c.Upgrade(ctx, "io.podman.LoadImage", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (reply_out_ MoreResponse, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Reply MoreResponse `json:"reply"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		reply_out_ = out.Reply
		return
	}, nil
}

// GetEvents returns known libpod events filtered by the options provided.
type GetEvents_methods struct{}

func GetEvents() GetEvents_methods { return GetEvents_methods{} }

func (m GetEvents_methods) Call(ctx context.Context, c *varlink.Connection, filter_in_ []string, since_in_ string, until_in_ string) (events_out_ Event, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, filter_in_, since_in_, until_in_)
	if err_ != nil {
		return
	}
	events_out_, _, err_ = receive(ctx)
	return
}

func (m GetEvents_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, filter_in_ []string, since_in_ string, until_in_ string) (func(ctx context.Context) (Event, uint64, error), error) {
	var in struct {
		Filter []string `json:"filter"`
		Since  string   `json:"since"`
		Until  string   `json:"until"`
	}
	in.Filter = []string(filter_in_)
	in.Since = since_in_
	in.Until = until_in_
	receive, err := c.Send(ctx, "io.podman.GetEvents", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (events_out_ Event, flags uint64, err error) {
		var out struct {
			Events Event `json:"events"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		events_out_ = out.Events
		return
	}, nil
}

func (m GetEvents_methods) Upgrade(ctx context.Context, c *varlink.Connection, filter_in_ []string, since_in_ string, until_in_ string) (func(ctx context.Context) (events_out_ Event, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Filter []string `json:"filter"`
		Since  string   `json:"since"`
		Until  string   `json:"until"`
	}
	in.Filter = []string(filter_in_)
	in.Since = since_in_
	in.Until = until_in_
	receive, err := c.Upgrade(ctx, "io.podman.GetEvents", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (events_out_ Event, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Events Event `json:"events"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		events_out_ = out.Events
		return
	}, nil
}

// Diff returns a diff between libpod objects
type Diff_methods struct{}

func Diff() Diff_methods { return Diff_methods{} }

func (m Diff_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (diffs_out_ []DiffInfo, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	diffs_out_, _, err_ = receive(ctx)
	return
}

func (m Diff_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) ([]DiffInfo, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.Diff", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (diffs_out_ []DiffInfo, flags uint64, err error) {
		var out struct {
			Diffs []DiffInfo `json:"diffs"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		diffs_out_ = []DiffInfo(out.Diffs)
		return
	}, nil
}

func (m Diff_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (diffs_out_ []DiffInfo, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.Diff", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (diffs_out_ []DiffInfo, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			Diffs []DiffInfo `json:"diffs"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		diffs_out_ = []DiffInfo(out.Diffs)
		return
	}, nil
}

// GetLayersMapWithImageInfo is for the development of Podman and should not be used.
type GetLayersMapWithImageInfo_methods struct{}

func GetLayersMapWithImageInfo() GetLayersMapWithImageInfo_methods {
	return GetLayersMapWithImageInfo_methods{}
}

func (m GetLayersMapWithImageInfo_methods) Call(ctx context.Context, c *varlink.Connection) (layerMap_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0)
	if err_ != nil {
		return
	}
	layerMap_out_, _, err_ = receive(ctx)
	return
}

func (m GetLayersMapWithImageInfo_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64) (func(ctx context.Context) (string, uint64, error), error) {
	receive, err := c.Send(ctx, "io.podman.GetLayersMapWithImageInfo", nil, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (layerMap_out_ string, flags uint64, err error) {
		var out struct {
			LayerMap string `json:"layerMap"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		layerMap_out_ = out.LayerMap
		return
	}, nil
}

func (m GetLayersMapWithImageInfo_methods) Upgrade(ctx context.Context, c *varlink.Connection) (func(ctx context.Context) (layerMap_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	receive, err := c.Upgrade(ctx, "io.podman.GetLayersMapWithImageInfo", nil)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (layerMap_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			LayerMap string `json:"layerMap"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		layerMap_out_ = out.LayerMap
		return
	}, nil
}

// BuildImageHierarchyMap is for the development of Podman and should not be used.
type BuildImageHierarchyMap_methods struct{}

func BuildImageHierarchyMap() BuildImageHierarchyMap_methods { return BuildImageHierarchyMap_methods{} }

func (m BuildImageHierarchyMap_methods) Call(ctx context.Context, c *varlink.Connection, name_in_ string) (imageInfo_out_ string, err_ error) {
	receive, err_ := m.Send(ctx, c, 0, name_in_)
	if err_ != nil {
		return
	}
	imageInfo_out_, _, err_ = receive(ctx)
	return
}

func (m BuildImageHierarchyMap_methods) Send(ctx context.Context, c *varlink.Connection, flags uint64, name_in_ string) (func(ctx context.Context) (string, uint64, error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Send(ctx, "io.podman.BuildImageHierarchyMap", in, flags)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (imageInfo_out_ string, flags uint64, err error) {
		var out struct {
			ImageInfo string `json:"imageInfo"`
		}
		flags, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		imageInfo_out_ = out.ImageInfo
		return
	}, nil
}

func (m BuildImageHierarchyMap_methods) Upgrade(ctx context.Context, c *varlink.Connection, name_in_ string) (func(ctx context.Context) (imageInfo_out_ string, flags uint64, conn varlink.ReadWriterContext, err_ error), error) {
	var in struct {
		Name string `json:"name"`
	}
	in.Name = name_in_
	receive, err := c.Upgrade(ctx, "io.podman.BuildImageHierarchyMap", in)
	if err != nil {
		return nil, err
	}
	return func(context.Context) (imageInfo_out_ string, flags uint64, conn varlink.ReadWriterContext, err error) {
		var out struct {
			ImageInfo string `json:"imageInfo"`
		}
		flags, conn, err = receive(ctx, &out)
		if err != nil {
			err = Dispatch_Error(err)
			return
		}
		imageInfo_out_ = out.ImageInfo
		return
	}, nil
}

// Generated service interface with all methods

type iopodmanInterface interface {
	GetVersion(ctx context.Context, c VarlinkCall) error
	GetInfo(ctx context.Context, c VarlinkCall) error
	ListContainers(ctx context.Context, c VarlinkCall) error
	Ps(ctx context.Context, c VarlinkCall, opts_ PsOpts) error
	GetContainersByStatus(ctx context.Context, c VarlinkCall, status_ []string) error
	Top(ctx context.Context, c VarlinkCall, nameOrID_ string, descriptors_ []string) error
	HealthCheckRun(ctx context.Context, c VarlinkCall, nameOrID_ string) error
	GetContainer(ctx context.Context, c VarlinkCall, id_ string) error
	GetContainersByContext(ctx context.Context, c VarlinkCall, all_ bool, latest_ bool, args_ []string) error
	CreateContainer(ctx context.Context, c VarlinkCall, create_ Create) error
	InspectContainer(ctx context.Context, c VarlinkCall, name_ string) error
	ListContainerProcesses(ctx context.Context, c VarlinkCall, name_ string, opts_ []string) error
	GetContainerLogs(ctx context.Context, c VarlinkCall, name_ string) error
	GetContainersLogs(ctx context.Context, c VarlinkCall, names_ []string, follow_ bool, latest_ bool, since_ string, tail_ int64, timestamps_ bool) error
	ListContainerChanges(ctx context.Context, c VarlinkCall, name_ string) error
	ExportContainer(ctx context.Context, c VarlinkCall, name_ string, path_ string) error
	GetContainerStats(ctx context.Context, c VarlinkCall, name_ string) error
	GetContainerStatsWithHistory(ctx context.Context, c VarlinkCall, previousStats_ ContainerStats) error
	StartContainer(ctx context.Context, c VarlinkCall, name_ string) error
	StopContainer(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error
	InitContainer(ctx context.Context, c VarlinkCall, name_ string) error
	RestartContainer(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error
	KillContainer(ctx context.Context, c VarlinkCall, name_ string, signal_ int64) error
	PauseContainer(ctx context.Context, c VarlinkCall, name_ string) error
	UnpauseContainer(ctx context.Context, c VarlinkCall, name_ string) error
	Attach(ctx context.Context, c VarlinkCall, name_ string, detachKeys_ string, start_ bool) error
	AttachControl(ctx context.Context, c VarlinkCall, name_ string) error
	GetAttachSockets(ctx context.Context, c VarlinkCall, name_ string) error
	WaitContainer(ctx context.Context, c VarlinkCall, name_ string, interval_ int64) error
	RemoveContainer(ctx context.Context, c VarlinkCall, name_ string, force_ bool, removeVolumes_ bool) error
	EvictContainer(ctx context.Context, c VarlinkCall, name_ string, removeVolumes_ bool) error
	DeleteStoppedContainers(ctx context.Context, c VarlinkCall) error
	ListImages(ctx context.Context, c VarlinkCall) error
	GetImage(ctx context.Context, c VarlinkCall, id_ string) error
	BuildImage(ctx context.Context, c VarlinkCall, build_ BuildInfo) error
	InspectImage(ctx context.Context, c VarlinkCall, name_ string) error
	HistoryImage(ctx context.Context, c VarlinkCall, name_ string) error
	PushImage(ctx context.Context, c VarlinkCall, name_ string, tag_ string, compress_ bool, format_ string, removeSignatures_ bool, signBy_ string) error
	TagImage(ctx context.Context, c VarlinkCall, name_ string, tagged_ string) error
	RemoveImage(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error
	SearchImages(ctx context.Context, c VarlinkCall, query_ string, limit_ *int64, filter_ ImageSearchFilter) error
	DeleteUnusedImages(ctx context.Context, c VarlinkCall) error
	Commit(ctx context.Context, c VarlinkCall, name_ string, image_name_ string, changes_ []string, author_ string, message_ string, pause_ bool, manifestType_ string) error
	ImportImage(ctx context.Context, c VarlinkCall, source_ string, reference_ string, message_ string, changes_ []string, delete_ bool) error
	ExportImage(ctx context.Context, c VarlinkCall, name_ string, destination_ string, compress_ bool, tags_ []string) error
	PullImage(ctx context.Context, c VarlinkCall, name_ string) error
	CreatePod(ctx context.Context, c VarlinkCall, create_ PodCreate) error
	ListPods(ctx context.Context, c VarlinkCall) error
	GetPod(ctx context.Context, c VarlinkCall, name_ string) error
	InspectPod(ctx context.Context, c VarlinkCall, name_ string) error
	StartPod(ctx context.Context, c VarlinkCall, name_ string) error
	StopPod(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error
	RestartPod(ctx context.Context, c VarlinkCall, name_ string) error
	KillPod(ctx context.Context, c VarlinkCall, name_ string, signal_ int64) error
	PausePod(ctx context.Context, c VarlinkCall, name_ string) error
	UnpausePod(ctx context.Context, c VarlinkCall, name_ string) error
	RemovePod(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error
	TopPod(ctx context.Context, c VarlinkCall, pod_ string, latest_ bool, descriptors_ []string) error
	GetPodStats(ctx context.Context, c VarlinkCall, name_ string) error
	GetPodsByStatus(ctx context.Context, c VarlinkCall, statuses_ []string) error
	ImageExists(ctx context.Context, c VarlinkCall, name_ string) error
	ContainerExists(ctx context.Context, c VarlinkCall, name_ string) error
	ContainerCheckpoint(ctx context.Context, c VarlinkCall, name_ string, keep_ bool, leaveRunning_ bool, tcpEstablished_ bool) error
	ContainerRestore(ctx context.Context, c VarlinkCall, name_ string, keep_ bool, tcpEstablished_ bool) error
	ContainerRunlabel(ctx context.Context, c VarlinkCall, runlabel_ Runlabel) error
	ExecContainer(ctx context.Context, c VarlinkCall, opts_ ExecOpts) error
	ListContainerMounts(ctx context.Context, c VarlinkCall) error
	MountContainer(ctx context.Context, c VarlinkCall, name_ string) error
	UnmountContainer(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error
	ImagesPrune(ctx context.Context, c VarlinkCall, all_ bool) error
	GenerateKube(ctx context.Context, c VarlinkCall, name_ string, service_ bool) error
	ContainerConfig(ctx context.Context, c VarlinkCall, name_ string) error
	ContainerArtifacts(ctx context.Context, c VarlinkCall, name_ string, artifactName_ string) error
	ContainerInspectData(ctx context.Context, c VarlinkCall, name_ string, size_ bool) error
	ContainerStateData(ctx context.Context, c VarlinkCall, name_ string) error
	PodStateData(ctx context.Context, c VarlinkCall, name_ string) error
	CreateFromCC(ctx context.Context, c VarlinkCall, in_ []string) error
	Spec(ctx context.Context, c VarlinkCall, name_ string) error
	SendFile(ctx context.Context, c VarlinkCall, type_ string, length_ int64) error
	ReceiveFile(ctx context.Context, c VarlinkCall, path_ string, delete_ bool) error
	VolumeCreate(ctx context.Context, c VarlinkCall, options_ VolumeCreateOpts) error
	VolumeRemove(ctx context.Context, c VarlinkCall, options_ VolumeRemoveOpts) error
	GetVolumes(ctx context.Context, c VarlinkCall, args_ []string, all_ bool) error
	InspectVolume(ctx context.Context, c VarlinkCall, name_ string) error
	VolumesPrune(ctx context.Context, c VarlinkCall) error
	ImageSave(ctx context.Context, c VarlinkCall, options_ ImageSaveOptions) error
	GetPodsByContext(ctx context.Context, c VarlinkCall, all_ bool, latest_ bool, args_ []string) error
	LoadImage(ctx context.Context, c VarlinkCall, name_ string, inputFile_ string, quiet_ bool, deleteFile_ bool) error
	GetEvents(ctx context.Context, c VarlinkCall, filter_ []string, since_ string, until_ string) error
	Diff(ctx context.Context, c VarlinkCall, name_ string) error
	GetLayersMapWithImageInfo(ctx context.Context, c VarlinkCall) error
	BuildImageHierarchyMap(ctx context.Context, c VarlinkCall, name_ string) error
}

// Generated service object with all methods

type VarlinkCall struct{ varlink.Call }

// Generated reply methods for all varlink errors

// ImageNotFound means the image could not be found by the provided name or ID in local storage.
func (c *VarlinkCall) ReplyImageNotFound(ctx context.Context, id_ string, reason_ string) error {
	var out ImageNotFound
	out.Id = id_
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.ImageNotFound", &out)
}

// ContainerNotFound means the container could not be found by the provided name or ID in local storage.
func (c *VarlinkCall) ReplyContainerNotFound(ctx context.Context, id_ string, reason_ string) error {
	var out ContainerNotFound
	out.Id = id_
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.ContainerNotFound", &out)
}

// NoContainerRunning means none of the containers requested are running in a command that requires a running container.
func (c *VarlinkCall) ReplyNoContainerRunning(ctx context.Context) error {
	var out NoContainerRunning
	return c.ReplyError(ctx, "io.podman.NoContainerRunning", &out)
}

// PodNotFound means the pod could not be found by the provided name or ID in local storage.
func (c *VarlinkCall) ReplyPodNotFound(ctx context.Context, name_ string, reason_ string) error {
	var out PodNotFound
	out.Name = name_
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.PodNotFound", &out)
}

// VolumeNotFound means the volume could not be found by the name or ID in local storage.
func (c *VarlinkCall) ReplyVolumeNotFound(ctx context.Context, id_ string, reason_ string) error {
	var out VolumeNotFound
	out.Id = id_
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.VolumeNotFound", &out)
}

// PodContainerError means a container associated with a pod failed to perform an operation. It contains
// a container ID of the container that failed.
func (c *VarlinkCall) ReplyPodContainerError(ctx context.Context, podname_ string, errors_ []PodContainerErrorData) error {
	var out PodContainerError
	out.Podname = podname_
	out.Errors = []PodContainerErrorData(errors_)
	return c.ReplyError(ctx, "io.podman.PodContainerError", &out)
}

// NoContainersInPod means a pod has no containers on which to perform the operation. It contains
// the pod ID.
func (c *VarlinkCall) ReplyNoContainersInPod(ctx context.Context, name_ string) error {
	var out NoContainersInPod
	out.Name = name_
	return c.ReplyError(ctx, "io.podman.NoContainersInPod", &out)
}

// InvalidState indicates that a container or pod was in an improper state for the requested operation
func (c *VarlinkCall) ReplyInvalidState(ctx context.Context, id_ string, reason_ string) error {
	var out InvalidState
	out.Id = id_
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.InvalidState", &out)
}

// ErrorOccurred is a generic error for an error that occurs during the execution.  The actual error message
// is includes as part of the error's text.
func (c *VarlinkCall) ReplyErrorOccurred(ctx context.Context, reason_ string) error {
	var out ErrorOccurred
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.ErrorOccurred", &out)
}

// RuntimeErrors generally means a runtime could not be found or gotten.
func (c *VarlinkCall) ReplyRuntimeError(ctx context.Context, reason_ string) error {
	var out RuntimeError
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.RuntimeError", &out)
}

// The Podman endpoint requires that you use a streaming connection.
func (c *VarlinkCall) ReplyWantsMoreRequired(ctx context.Context, reason_ string) error {
	var out WantsMoreRequired
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.WantsMoreRequired", &out)
}

// Container is already stopped
func (c *VarlinkCall) ReplyErrCtrStopped(ctx context.Context, id_ string) error {
	var out ErrCtrStopped
	out.Id = id_
	return c.ReplyError(ctx, "io.podman.ErrCtrStopped", &out)
}

// This function requires CGroupsV2 to run in rootless mode.
func (c *VarlinkCall) ReplyErrRequiresCgroupsV2ForRootless(ctx context.Context, reason_ string) error {
	var out ErrRequiresCgroupsV2ForRootless
	out.Reason = reason_
	return c.ReplyError(ctx, "io.podman.ErrRequiresCgroupsV2ForRootless", &out)
}

// Generated reply methods for all varlink methods

func (c *VarlinkCall) ReplyGetVersion(ctx context.Context, version_ string, go_version_ string, git_commit_ string, built_ string, os_arch_ string, remote_api_version_ int64) error {
	var out struct {
		Version            string `json:"version"`
		Go_version         string `json:"go_version"`
		Git_commit         string `json:"git_commit"`
		Built              string `json:"built"`
		Os_arch            string `json:"os_arch"`
		Remote_api_version int64  `json:"remote_api_version"`
	}
	out.Version = version_
	out.Go_version = go_version_
	out.Git_commit = git_commit_
	out.Built = built_
	out.Os_arch = os_arch_
	out.Remote_api_version = remote_api_version_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetInfo(ctx context.Context, info_ PodmanInfo) error {
	var out struct {
		Info PodmanInfo `json:"info"`
	}
	out.Info = info_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyListContainers(ctx context.Context, containers_ []Container) error {
	var out struct {
		Containers []Container `json:"containers"`
	}
	out.Containers = []Container(containers_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPs(ctx context.Context, containers_ []PsContainer) error {
	var out struct {
		Containers []PsContainer `json:"containers"`
	}
	out.Containers = []PsContainer(containers_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainersByStatus(ctx context.Context, containerS_ []Container) error {
	var out struct {
		ContainerS []Container `json:"containerS"`
	}
	out.ContainerS = []Container(containerS_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyTop(ctx context.Context, top_ []string) error {
	var out struct {
		Top []string `json:"top"`
	}
	out.Top = []string(top_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyHealthCheckRun(ctx context.Context, healthCheckStatus_ string) error {
	var out struct {
		HealthCheckStatus string `json:"healthCheckStatus"`
	}
	out.HealthCheckStatus = healthCheckStatus_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainer(ctx context.Context, container_ Container) error {
	var out struct {
		Container Container `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainersByContext(ctx context.Context, containers_ []string) error {
	var out struct {
		Containers []string `json:"containers"`
	}
	out.Containers = []string(containers_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyCreateContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyInspectContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyListContainerProcesses(ctx context.Context, container_ []string) error {
	var out struct {
		Container []string `json:"container"`
	}
	out.Container = []string(container_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainerLogs(ctx context.Context, container_ []string) error {
	var out struct {
		Container []string `json:"container"`
	}
	out.Container = []string(container_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainersLogs(ctx context.Context, log_ LogLine) error {
	var out struct {
		Log LogLine `json:"log"`
	}
	out.Log = log_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyListContainerChanges(ctx context.Context, container_ ContainerChanges) error {
	var out struct {
		Container ContainerChanges `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyExportContainer(ctx context.Context, tarfile_ string) error {
	var out struct {
		Tarfile string `json:"tarfile"`
	}
	out.Tarfile = tarfile_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainerStats(ctx context.Context, container_ ContainerStats) error {
	var out struct {
		Container ContainerStats `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetContainerStatsWithHistory(ctx context.Context, container_ ContainerStats) error {
	var out struct {
		Container ContainerStats `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyStartContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyStopContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyInitContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyRestartContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyKillContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPauseContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyUnpauseContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyAttach(ctx context.Context) error {
	return c.Reply(ctx, nil)
}

func (c *VarlinkCall) ReplyAttachControl(ctx context.Context) error {
	return c.Reply(ctx, nil)
}

func (c *VarlinkCall) ReplyGetAttachSockets(ctx context.Context, sockets_ Sockets) error {
	var out struct {
		Sockets Sockets `json:"sockets"`
	}
	out.Sockets = sockets_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyWaitContainer(ctx context.Context, exitcode_ int64) error {
	var out struct {
		Exitcode int64 `json:"exitcode"`
	}
	out.Exitcode = exitcode_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyRemoveContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyEvictContainer(ctx context.Context, container_ string) error {
	var out struct {
		Container string `json:"container"`
	}
	out.Container = container_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyDeleteStoppedContainers(ctx context.Context, containers_ []string) error {
	var out struct {
		Containers []string `json:"containers"`
	}
	out.Containers = []string(containers_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyListImages(ctx context.Context, images_ []Image) error {
	var out struct {
		Images []Image `json:"images"`
	}
	out.Images = []Image(images_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetImage(ctx context.Context, image_ Image) error {
	var out struct {
		Image Image `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyBuildImage(ctx context.Context, image_ MoreResponse) error {
	var out struct {
		Image MoreResponse `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyInspectImage(ctx context.Context, image_ string) error {
	var out struct {
		Image string `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyHistoryImage(ctx context.Context, history_ []ImageHistory) error {
	var out struct {
		History []ImageHistory `json:"history"`
	}
	out.History = []ImageHistory(history_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPushImage(ctx context.Context, reply_ MoreResponse) error {
	var out struct {
		Reply MoreResponse `json:"reply"`
	}
	out.Reply = reply_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyTagImage(ctx context.Context, image_ string) error {
	var out struct {
		Image string `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyRemoveImage(ctx context.Context, image_ string) error {
	var out struct {
		Image string `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplySearchImages(ctx context.Context, results_ []ImageSearchResult) error {
	var out struct {
		Results []ImageSearchResult `json:"results"`
	}
	out.Results = []ImageSearchResult(results_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyDeleteUnusedImages(ctx context.Context, images_ []string) error {
	var out struct {
		Images []string `json:"images"`
	}
	out.Images = []string(images_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyCommit(ctx context.Context, reply_ MoreResponse) error {
	var out struct {
		Reply MoreResponse `json:"reply"`
	}
	out.Reply = reply_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyImportImage(ctx context.Context, image_ string) error {
	var out struct {
		Image string `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyExportImage(ctx context.Context, image_ string) error {
	var out struct {
		Image string `json:"image"`
	}
	out.Image = image_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPullImage(ctx context.Context, reply_ MoreResponse) error {
	var out struct {
		Reply MoreResponse `json:"reply"`
	}
	out.Reply = reply_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyCreatePod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyListPods(ctx context.Context, pods_ []ListPodData) error {
	var out struct {
		Pods []ListPodData `json:"pods"`
	}
	out.Pods = []ListPodData(pods_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetPod(ctx context.Context, pod_ ListPodData) error {
	var out struct {
		Pod ListPodData `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyInspectPod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyStartPod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyStopPod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyRestartPod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyKillPod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPausePod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyUnpausePod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyRemovePod(ctx context.Context, pod_ string) error {
	var out struct {
		Pod string `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyTopPod(ctx context.Context, stats_ []string) error {
	var out struct {
		Stats []string `json:"stats"`
	}
	out.Stats = []string(stats_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetPodStats(ctx context.Context, pod_ string, containers_ []ContainerStats) error {
	var out struct {
		Pod        string           `json:"pod"`
		Containers []ContainerStats `json:"containers"`
	}
	out.Pod = pod_
	out.Containers = []ContainerStats(containers_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetPodsByStatus(ctx context.Context, pods_ []string) error {
	var out struct {
		Pods []string `json:"pods"`
	}
	out.Pods = []string(pods_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyImageExists(ctx context.Context, exists_ int64) error {
	var out struct {
		Exists int64 `json:"exists"`
	}
	out.Exists = exists_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerExists(ctx context.Context, exists_ int64) error {
	var out struct {
		Exists int64 `json:"exists"`
	}
	out.Exists = exists_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerCheckpoint(ctx context.Context, id_ string) error {
	var out struct {
		Id string `json:"id"`
	}
	out.Id = id_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerRestore(ctx context.Context, id_ string) error {
	var out struct {
		Id string `json:"id"`
	}
	out.Id = id_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerRunlabel(ctx context.Context) error {
	return c.Reply(ctx, nil)
}

func (c *VarlinkCall) ReplyExecContainer(ctx context.Context) error {
	return c.Reply(ctx, nil)
}

func (c *VarlinkCall) ReplyListContainerMounts(ctx context.Context, mounts_ map[string]string) error {
	var out struct {
		Mounts map[string]string `json:"mounts"`
	}
	out.Mounts = map[string]string(mounts_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyMountContainer(ctx context.Context, path_ string) error {
	var out struct {
		Path string `json:"path"`
	}
	out.Path = path_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyUnmountContainer(ctx context.Context) error {
	return c.Reply(ctx, nil)
}

func (c *VarlinkCall) ReplyImagesPrune(ctx context.Context, pruned_ []string) error {
	var out struct {
		Pruned []string `json:"pruned"`
	}
	out.Pruned = []string(pruned_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGenerateKube(ctx context.Context, pod_ KubePodService) error {
	var out struct {
		Pod KubePodService `json:"pod"`
	}
	out.Pod = pod_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerConfig(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerArtifacts(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerInspectData(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyContainerStateData(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyPodStateData(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyCreateFromCC(ctx context.Context, id_ string) error {
	var out struct {
		Id string `json:"id"`
	}
	out.Id = id_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplySpec(ctx context.Context, config_ string) error {
	var out struct {
		Config string `json:"config"`
	}
	out.Config = config_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplySendFile(ctx context.Context, file_handle_ string) error {
	var out struct {
		File_handle string `json:"file_handle"`
	}
	out.File_handle = file_handle_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyReceiveFile(ctx context.Context, len_ int64) error {
	var out struct {
		Len int64 `json:"len"`
	}
	out.Len = len_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyVolumeCreate(ctx context.Context, volumeName_ string) error {
	var out struct {
		VolumeName string `json:"volumeName"`
	}
	out.VolumeName = volumeName_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyVolumeRemove(ctx context.Context, successes_ []string, failures_ map[string]string) error {
	var out struct {
		Successes []string          `json:"successes"`
		Failures  map[string]string `json:"failures"`
	}
	out.Successes = []string(successes_)
	out.Failures = map[string]string(failures_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetVolumes(ctx context.Context, volumes_ []Volume) error {
	var out struct {
		Volumes []Volume `json:"volumes"`
	}
	out.Volumes = []Volume(volumes_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyInspectVolume(ctx context.Context, volume_ string) error {
	var out struct {
		Volume string `json:"volume"`
	}
	out.Volume = volume_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyVolumesPrune(ctx context.Context, prunedNames_ []string, prunedErrors_ []string) error {
	var out struct {
		PrunedNames  []string `json:"prunedNames"`
		PrunedErrors []string `json:"prunedErrors"`
	}
	out.PrunedNames = []string(prunedNames_)
	out.PrunedErrors = []string(prunedErrors_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyImageSave(ctx context.Context, reply_ MoreResponse) error {
	var out struct {
		Reply MoreResponse `json:"reply"`
	}
	out.Reply = reply_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetPodsByContext(ctx context.Context, pods_ []string) error {
	var out struct {
		Pods []string `json:"pods"`
	}
	out.Pods = []string(pods_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyLoadImage(ctx context.Context, reply_ MoreResponse) error {
	var out struct {
		Reply MoreResponse `json:"reply"`
	}
	out.Reply = reply_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetEvents(ctx context.Context, events_ Event) error {
	var out struct {
		Events Event `json:"events"`
	}
	out.Events = events_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyDiff(ctx context.Context, diffs_ []DiffInfo) error {
	var out struct {
		Diffs []DiffInfo `json:"diffs"`
	}
	out.Diffs = []DiffInfo(diffs_)
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyGetLayersMapWithImageInfo(ctx context.Context, layerMap_ string) error {
	var out struct {
		LayerMap string `json:"layerMap"`
	}
	out.LayerMap = layerMap_
	return c.Reply(ctx, &out)
}

func (c *VarlinkCall) ReplyBuildImageHierarchyMap(ctx context.Context, imageInfo_ string) error {
	var out struct {
		ImageInfo string `json:"imageInfo"`
	}
	out.ImageInfo = imageInfo_
	return c.Reply(ctx, &out)
}

// Generated dummy implementations for all varlink methods

// GetVersion returns version and build information of the podman service
func (s *VarlinkInterface) GetVersion(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetVersion")
}

// GetInfo returns a [PodmanInfo](#PodmanInfo) struct that describes podman and its host such as storage stats,
// build information of Podman, and system-wide registries.
func (s *VarlinkInterface) GetInfo(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetInfo")
}

// ListContainers returns information about all containers.
// See also [GetContainer](#GetContainer).
func (s *VarlinkInterface) ListContainers(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListContainers")
}

func (s *VarlinkInterface) Ps(ctx context.Context, c VarlinkCall, opts_ PsOpts) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Ps")
}

func (s *VarlinkInterface) GetContainersByStatus(ctx context.Context, c VarlinkCall, status_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainersByStatus")
}

func (s *VarlinkInterface) Top(ctx context.Context, c VarlinkCall, nameOrID_ string, descriptors_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Top")
}

// HealthCheckRun executes defined container's healthcheck command
// and returns the container's health status.
func (s *VarlinkInterface) HealthCheckRun(ctx context.Context, c VarlinkCall, nameOrID_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.HealthCheckRun")
}

// GetContainer returns information about a single container.  If a container
// with the given id doesn't exist, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.  See also [ListContainers](ListContainers) and
// [InspectContainer](#InspectContainer).
func (s *VarlinkInterface) GetContainer(ctx context.Context, c VarlinkCall, id_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainer")
}

// GetContainersByContext allows you to get a list of container ids depending on all, latest, or a list of
// container names.  The definition of latest container means the latest by creation date.  In a multi-
// user environment, results might differ from what you expect.
func (s *VarlinkInterface) GetContainersByContext(ctx context.Context, c VarlinkCall, all_ bool, latest_ bool, args_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainersByContext")
}

// CreateContainer creates a new container from an image.  It uses a [Create](#Create) type for input.
func (s *VarlinkInterface) CreateContainer(ctx context.Context, c VarlinkCall, create_ Create) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.CreateContainer")
}

// InspectContainer data takes a name or ID of a container returns the inspection
// data in string format.  You can then serialize the string into JSON.  A [ContainerNotFound](#ContainerNotFound)
// error will be returned if the container cannot be found. See also [InspectImage](#InspectImage).
func (s *VarlinkInterface) InspectContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.InspectContainer")
}

// ListContainerProcesses takes a name or ID of a container and returns the processes
// running inside the container as array of strings.  It will accept an array of string
// arguments that represent ps options.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ListContainerProcesses '{"name": "135d71b9495f", "opts": []}'
// {
//   "container": [
//     "  UID   PID  PPID  C STIME TTY          TIME CMD",
//     "    0 21220 21210  0 09:05 pts/0    00:00:00 /bin/sh",
//     "    0 21232 21220  0 09:05 pts/0    00:00:00 top",
//     "    0 21284 21220  0 09:05 pts/0    00:00:00 vi /etc/hosts"
//   ]
// }
// ~~~
func (s *VarlinkInterface) ListContainerProcesses(ctx context.Context, c VarlinkCall, name_ string, opts_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListContainerProcesses")
}

// GetContainerLogs takes a name or ID of a container and returns the logs of that container.
// If the container cannot be found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// The container logs are returned as an array of strings.  GetContainerLogs will honor the streaming
// capability of varlink if the client invokes it.
func (s *VarlinkInterface) GetContainerLogs(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainerLogs")
}

func (s *VarlinkInterface) GetContainersLogs(ctx context.Context, c VarlinkCall, names_ []string, follow_ bool, latest_ bool, since_ string, tail_ int64, timestamps_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainersLogs")
}

// ListContainerChanges takes a name or ID of a container and returns changes between the container and
// its base image. It returns a struct of changed, deleted, and added path names.
func (s *VarlinkInterface) ListContainerChanges(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListContainerChanges")
}

// ExportContainer creates an image from a container.  It takes the name or ID of a container and a
// path representing the target tarfile.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.
// The return value is the written tarfile.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ExportContainer '{"name": "flamboyant_payne", "path": "/tmp/payne.tar" }'
// {
//   "tarfile": "/tmp/payne.tar"
// }
// ~~~
func (s *VarlinkInterface) ExportContainer(ctx context.Context, c VarlinkCall, name_ string, path_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ExportContainer")
}

// GetContainerStats takes the name or ID of a container and returns a single ContainerStats structure which
// contains attributes like memory and cpu usage.  If the container cannot be found, a
// [ContainerNotFound](#ContainerNotFound) error will be returned. If the container is not running, a [NoContainerRunning](#NoContainerRunning)
// error will be returned
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.GetContainerStats '{"name": "c33e4164f384"}'
// {
//   "container": {
//     "block_input": 0,
//     "block_output": 0,
//     "cpu": 2.571123918839990154678e-08,
//     "cpu_nano": 49037378,
//     "id": "c33e4164f384aa9d979072a63319d66b74fd7a128be71fa68ede24f33ec6cfee",
//     "mem_limit": 33080606720,
//     "mem_perc": 2.166828456524753747370e-03,
//     "mem_usage": 716800,
//     "name": "competent_wozniak",
//     "net_input": 768,
//     "net_output": 5910,
//     "pids": 1,
//     "system_nano": 10000000
//   }
// }
// ~~~
func (s *VarlinkInterface) GetContainerStats(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainerStats")
}

// GetContainerStatsWithHistory takes a previous set of container statistics and uses libpod functions
// to calculate the containers statistics based on current and previous measurements.
func (s *VarlinkInterface) GetContainerStatsWithHistory(ctx context.Context, c VarlinkCall, previousStats_ ContainerStats) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetContainerStatsWithHistory")
}

// StartContainer starts a created or stopped container. It takes the name or ID of container.  It returns
// the container ID once started.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned.  See also [CreateContainer](#CreateContainer).
func (s *VarlinkInterface) StartContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.StartContainer")
}

// StopContainer stops a container given a timeout.  It takes the name or ID of a container as well as a
// timeout value.  The timeout value the time before a forcible stop to the container is applied.  It
// returns the container ID once stopped. If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
// error will be returned instead. See also [KillContainer](KillContainer).
// #### Error
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StopContainer '{"name": "135d71b9495f", "timeout": 5}'
// {
//   "container": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
func (s *VarlinkInterface) StopContainer(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.StopContainer")
}

// InitContainer initializes the given container. It accepts a container name or
// ID, and will initialize the container matching that ID if possible, and error
// if not. Containers can only be initialized when they are in the Created or
// Exited states. Initialization prepares a container to be started, but does not
// start the container. It is intended to be used to debug a container's state
// prior to starting it.
func (s *VarlinkInterface) InitContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.InitContainer")
}

// RestartContainer will restart a running container given a container name or ID and timeout value. The timeout
// value is the time before a forcible stop is used to stop the container.  If the container cannot be found by
// name or ID, a [ContainerNotFound](#ContainerNotFound)  error will be returned; otherwise, the ID of the
// container will be returned.
func (s *VarlinkInterface) RestartContainer(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.RestartContainer")
}

// KillContainer takes the name or ID of a container as well as a signal to be applied to the container.  Once the
// container has been killed, the container's ID is returned.  If the container cannot be found, a
// [ContainerNotFound](#ContainerNotFound) error is returned. See also [StopContainer](StopContainer).
func (s *VarlinkInterface) KillContainer(ctx context.Context, c VarlinkCall, name_ string, signal_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.KillContainer")
}

// PauseContainer takes the name or ID of container and pauses it.  If the container cannot be found,
// a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
// See also [UnpauseContainer](#UnpauseContainer).
func (s *VarlinkInterface) PauseContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.PauseContainer")
}

// UnpauseContainer takes the name or ID of container and unpauses a paused container.  If the container cannot be
// found, a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
// See also [PauseContainer](#PauseContainer).
func (s *VarlinkInterface) UnpauseContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.UnpauseContainer")
}

// Attach takes the name or ID of a container and sets up the ability to remotely attach to its console. The start
// bool is whether you wish to start the container in question first.
func (s *VarlinkInterface) Attach(ctx context.Context, c VarlinkCall, name_ string, detachKeys_ string, start_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Attach")
}

func (s *VarlinkInterface) AttachControl(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.AttachControl")
}

// GetAttachSockets takes the name or ID of an existing container.  It returns file paths for two sockets needed
// to properly communicate with a container.  The first is the actual I/O socket that the container uses.  The
// second is a "control" socket where things like resizing the TTY events are sent. If the container cannot be
// found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/io.podman/io.podman.GetAttachSockets '{"name": "b7624e775431219161"}'
// {
//   "sockets": {
//     "container_id": "b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca",
//     "control_socket": "/var/lib/containers/storage/overlay-containers/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/userdata/ctl",
//     "io_socket": "/var/run/libpod/socket/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/attach"
//   }
// }
// ~~~
func (s *VarlinkInterface) GetAttachSockets(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetAttachSockets")
}

// WaitContainer takes the name or ID of a container and waits the given interval in milliseconds until the container
// stops.  Upon stopping, the return code of the container is returned. If the container container cannot be found by ID
// or name, a [ContainerNotFound](#ContainerNotFound) error is returned.
func (s *VarlinkInterface) WaitContainer(ctx context.Context, c VarlinkCall, name_ string, interval_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.WaitContainer")
}

// RemoveContainer requires the name or ID of a container as well as a boolean that
// indicates whether a container should be forcefully removed (e.g., by stopping it), and a boolean
// indicating whether to remove builtin volumes. Upon successful removal of the
// container, its ID is returned.  If the
// container cannot be found by name or ID, a [ContainerNotFound](#ContainerNotFound) error will be returned.
// See also [EvictContainer](EvictContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RemoveContainer '{"name": "62f4fd98cb57"}'
// {
//   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
func (s *VarlinkInterface) RemoveContainer(ctx context.Context, c VarlinkCall, name_ string, force_ bool, removeVolumes_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.RemoveContainer")
}

// EvictContainer requires the name or ID of a container as well as a boolean that
// indicates to remove builtin volumes. Upon successful eviction of the container,
// its ID is returned.  If the container cannot be found by name or ID,
// a [ContainerNotFound](#ContainerNotFound) error will be returned.
// See also [RemoveContainer](RemoveContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.EvictContainer '{"name": "62f4fd98cb57"}'
// {
//   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
func (s *VarlinkInterface) EvictContainer(ctx context.Context, c VarlinkCall, name_ string, removeVolumes_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.EvictContainer")
}

// DeleteStoppedContainers will delete all containers that are not running. It will return a list the deleted
// container IDs.  See also [RemoveContainer](RemoveContainer).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteStoppedContainers
// {
//   "containers": [
//     "451410b931d00def8aa9b4f8084e4d4a39e5e04ea61f358cf53a5cf95afcdcee",
//     "8b60f754a3e01389494a9581ade97d35c2765b6e2f19acd2d3040c82a32d1bc0",
//     "cf2e99d4d3cad6073df199ed32bbe64b124f3e1aba6d78821aa8460e70d30084",
//     "db901a329587312366e5ecff583d08f0875b4b79294322df67d90fc6eed08fc1"
//   ]
// }
// ~~~
func (s *VarlinkInterface) DeleteStoppedContainers(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.DeleteStoppedContainers")
}

// ListImages returns information about the images that are currently in storage.
// See also [InspectImage](#InspectImage).
func (s *VarlinkInterface) ListImages(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListImages")
}

// GetImage returns information about a single image in storage.
// If the image caGetImage returns be found, [ImageNotFound](#ImageNotFound) will be returned.
func (s *VarlinkInterface) GetImage(ctx context.Context, c VarlinkCall, id_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetImage")
}

// BuildImage takes a [BuildInfo](#BuildInfo) structure and builds an image.  At a minimum, you must provide the
// contextDir tarball path, the 'dockerfiles' path, and 'output' option in the BuildInfo structure.  The 'output'
// options is the name of the of the resulting build. It will return a [MoreResponse](#MoreResponse) structure
// that contains the build logs and resulting image ID.
// #### Example
// ~~~
// $ sudo varlink call -m unix:///run/podman/io.podman/io.podman.BuildImage '{"build":{"contextDir":"/tmp/t/context.tar","dockerfiles":["Dockerfile"], "output":"foobar"}}'
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "STEP 1: FROM alpine\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "STEP 2: COMMIT foobar\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "",
//    "logs": [
//      "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9\n"
//    ]
//  }
// }
// {
//  "image": {
//    "id": "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9",
//    "logs": []
//  }
// }
// ~~~
func (s *VarlinkInterface) BuildImage(ctx context.Context, c VarlinkCall, build_ BuildInfo) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.BuildImage")
}

// InspectImage takes the name or ID of an image and returns a string representation of data associated with the
// mage.  You must serialize the string into JSON to use it further.  An [ImageNotFound](#ImageNotFound) error will
// be returned if the image cannot be found.
func (s *VarlinkInterface) InspectImage(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.InspectImage")
}

// HistoryImage takes the name or ID of an image and returns information about its history and layers.  The returned
// history is in the form of an array of ImageHistory structures.  If the image cannot be found, an
// [ImageNotFound](#ImageNotFound) error is returned.
func (s *VarlinkInterface) HistoryImage(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.HistoryImage")
}

// PushImage takes two input arguments: the name or ID of an image, the fully-qualified destination name of the image,
// It will return an [ImageNotFound](#ImageNotFound) error if
// the image cannot be found in local storage; otherwise it will return a [MoreResponse](#MoreResponse)
func (s *VarlinkInterface) PushImage(ctx context.Context, c VarlinkCall, name_ string, tag_ string, compress_ bool, format_ string, removeSignatures_ bool, signBy_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.PushImage")
}

// TagImage takes the name or ID of an image in local storage as well as the desired tag name.  If the image cannot
// be found, an [ImageNotFound](#ImageNotFound) error will be returned; otherwise, the ID of the image is returned on success.
func (s *VarlinkInterface) TagImage(ctx context.Context, c VarlinkCall, name_ string, tagged_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.TagImage")
}

// RemoveImage takes the name or ID of an image as well as a boolean that determines if containers using that image
// should be deleted.  If the image cannot be found, an [ImageNotFound](#ImageNotFound) error will be returned.  The
// ID of the removed image is returned when complete.  See also [DeleteUnusedImages](DeleteUnusedImages).
// #### Example
// ~~~
// varlink call -m unix:/run/podman/io.podman/io.podman.RemoveImage '{"name": "registry.fedoraproject.org/fedora", "force": true}'
// {
//   "image": "426866d6fa419873f97e5cbd320eeb22778244c1dfffa01c944db3114f55772e"
// }
// ~~~
func (s *VarlinkInterface) RemoveImage(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.RemoveImage")
}

// SearchImages searches available registries for images that contain the
// contents of "query" in their name. If "limit" is given, limits the amount of
// search results per registry.
func (s *VarlinkInterface) SearchImages(ctx context.Context, c VarlinkCall, query_ string, limit_ *int64, filter_ ImageSearchFilter) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.SearchImages")
}

// DeleteUnusedImages deletes any images not associated with a container.  The IDs of the deleted images are returned
// in a string array.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteUnusedImages
// {
//   "images": [
//     "166ea6588079559c724c15223f52927f514f73dd5c5cf2ae2d143e3b2e6e9b52",
//     "da86e6ba6ca197bf6bc5e9d900febd906b133eaa4750e6bed647b0fbe50ed43e",
//     "3ef70f7291f47dfe2b82931a993e16f5a44a0e7a68034c3e0e086d77f5829adc",
//     "59788edf1f3e78cd0ebe6ce1446e9d10788225db3dedcfd1a59f764bad2b2690"
//   ]
// }
// ~~~
func (s *VarlinkInterface) DeleteUnusedImages(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.DeleteUnusedImages")
}

// Commit, creates an image from an existing container. It requires the name or
// ID of the container as well as the resulting image name.  Optionally, you can define an author and message
// to be added to the resulting image.  You can also define changes to the resulting image for the following
// attributes: _CMD, ENTRYPOINT, ENV, EXPOSE, LABEL, ONBUILD, STOPSIGNAL, USER, VOLUME, and WORKDIR_.  To pause the
// container while it is being committed, pass a _true_ bool for the pause argument.  If the container cannot
// be found by the ID or name provided, a (ContainerNotFound)[#ContainerNotFound] error will be returned; otherwise,
// the resulting image's ID will be returned as a string inside a MoreResponse.
func (s *VarlinkInterface) Commit(ctx context.Context, c VarlinkCall, name_ string, image_name_ string, changes_ []string, author_ string, message_ string, pause_ bool, manifestType_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Commit")
}

// ImportImage imports an image from a source (like tarball) into local storage.  The image can have additional
// descriptions added to it using the message and changes options. See also [ExportImage](ExportImage).
func (s *VarlinkInterface) ImportImage(ctx context.Context, c VarlinkCall, source_ string, reference_ string, message_ string, changes_ []string, delete_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ImportImage")
}

// ExportImage takes the name or ID of an image and exports it to a destination like a tarball.  There is also
// a boolean option to force compression.  It also takes in a string array of tags to be able to save multiple
// tags of the same image to a tarball (each tag should be of the form <image>:<tag>).  Upon completion, the ID
// of the image is returned. If the image cannot be found in local storage, an [ImageNotFound](#ImageNotFound)
// error will be returned. See also [ImportImage](ImportImage).
func (s *VarlinkInterface) ExportImage(ctx context.Context, c VarlinkCall, name_ string, destination_ string, compress_ bool, tags_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ExportImage")
}

// PullImage pulls an image from a repository to local storage.  After a successful pull, the image id and logs
// are returned as a [MoreResponse](#MoreResponse).  This connection also will handle a WantsMores request to send
// status as it occurs.
func (s *VarlinkInterface) PullImage(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.PullImage")
}

// CreatePod creates a new empty pod.  It uses a [PodCreate](#PodCreate) type for input.
// On success, the ID of the newly created pod will be returned.
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"name": "test"}}'
// {
//   "pod": "b05dee7bd4ccfee688099fe1588a7a898d6ddd6897de9251d4671c9b0feacb2a"
// }
// # $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"infra": true, "share": ["ipc", "net", "uts"]}}'
// {
//   "pod": "d7697449a8035f613c1a8891286502aca68fff7d5d49a85279b3bda229af3b28"
// }
// ~~~
func (s *VarlinkInterface) CreatePod(ctx context.Context, c VarlinkCall, create_ PodCreate) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.CreatePod")
}

// ListPods returns a list of pods in no particular order.  They are
// returned as an array of ListPodData structs.  See also [GetPod](#GetPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ListPods
// {
//   "pods": [
//     {
//       "cgroup": "machine.slice",
//       "containersinfo": [
//         {
//           "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
//           "name": "1840835294cf-infra",
//           "status": "running"
//         },
//         {
//           "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
//           "name": "upbeat_murdock",
//           "status": "running"
//         }
//       ],
//       "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
//       "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
//       "name": "foobar",
//       "numberofcontainers": "2",
//       "status": "Running"
//     },
//     {
//       "cgroup": "machine.slice",
//       "containersinfo": [
//         {
//           "id": "1ca4b7bbba14a75ba00072d4b705c77f3df87db0109afaa44d50cb37c04a477e",
//           "name": "784306f655c6-infra",
//           "status": "running"
//         }
//       ],
//       "createdat": "2018-12-07 13:09:57.105112457 -0600 CST",
//       "id": "784306f655c6200aea321dd430ba685e9b2cc1f7d7528a72f3ff74ffb29485a2",
//       "name": "nostalgic_pike",
//       "numberofcontainers": "1",
//       "status": "Running"
//     }
//   ]
// }
// ~~~
func (s *VarlinkInterface) ListPods(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListPods")
}

// GetPod takes a name or ID of a pod and returns single [ListPodData](#ListPodData)
// structure.  A [PodNotFound](#PodNotFound) error will be returned if the pod cannot be found.
// See also [ListPods](ListPods).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.GetPod '{"name": "foobar"}'
// {
//   "pod": {
//     "cgroup": "machine.slice",
//     "containersinfo": [
//       {
//         "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
//         "name": "1840835294cf-infra",
//         "status": "running"
//       },
//       {
//         "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
//         "name": "upbeat_murdock",
//         "status": "running"
//       }
//     ],
//     "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
//     "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
//     "name": "foobar",
//     "numberofcontainers": "2",
//     "status": "Running"
//   }
// }
// ~~~
func (s *VarlinkInterface) GetPod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetPod")
}

// InspectPod takes the name or ID of an image and returns a string representation of data associated with the
// pod.  You must serialize the string into JSON to use it further.  A [PodNotFound](#PodNotFound) error will
// be returned if the pod cannot be found.
func (s *VarlinkInterface) InspectPod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.InspectPod")
}

// StartPod starts containers in a pod.  It takes the name or ID of pod.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
// error will be returned.  Containers in a pod are started independently. If there is an error starting one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was started with no errors, the pod ID is returned.
// See also [CreatePod](#CreatePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StartPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6",
// }
// ~~~
func (s *VarlinkInterface) StartPod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.StartPod")
}

// StopPod stops containers in a pod.  It takes the name or ID of a pod and a timeout.
// If the pod cannot be found, a [PodNotFound](#PodNotFound) error will be returned instead.
// Containers in a pod are stopped independently. If there is an error stopping one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was stopped with no errors, the pod ID is returned.
// See also [KillPod](KillPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.StopPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
func (s *VarlinkInterface) StopPod(ctx context.Context, c VarlinkCall, name_ string, timeout_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.StopPod")
}

// RestartPod will restart containers in a pod given a pod name or ID. Containers in
// the pod that are running will be stopped, then all stopped containers will be run.
// If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are restarted independently. If there is an error restarting one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was restarted with no errors, the pod ID is returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RestartPod '{"name": "135d71b9495f"}'
// {
//   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
// }
// ~~~
func (s *VarlinkInterface) RestartPod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.RestartPod")
}

// KillPod takes the name or ID of a pod as well as a signal to be applied to the pod.  If the pod cannot be found, a
// [PodNotFound](#PodNotFound) error is returned.
// Containers in a pod are killed independently. If there is an error killing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was killed with no errors, the pod ID is returned.
// See also [StopPod](StopPod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.KillPod '{"name": "foobar", "signal": 15}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
func (s *VarlinkInterface) KillPod(ctx context.Context, c VarlinkCall, name_ string, signal_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.KillPod")
}

// PausePod takes the name or ID of a pod and pauses the running containers associated with it.  If the pod cannot be found,
// a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are paused independently. If there is an error pausing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was paused with no errors, the pod ID is returned.
// See also [UnpausePod](#UnpausePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.PausePod '{"name": "foobar"}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
func (s *VarlinkInterface) PausePod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.PausePod")
}

// UnpausePod takes the name or ID of a pod and unpauses the paused containers associated with it.  If the pod cannot be
// found, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are unpaused independently. If there is an error unpausing one container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was unpaused with no errors, the pod ID is returned.
// See also [PausePod](#PausePod).
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.UnpausePod '{"name": "foobar"}'
// {
//   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
// }
// ~~~
func (s *VarlinkInterface) UnpausePod(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.UnpausePod")
}

// RemovePod takes the name or ID of a pod as well a boolean representing whether a running
// container in the pod can be stopped and removed.  If a pod has containers associated with it, and force is not true,
// an error will occur.
// If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
// Containers in a pod are removed independently. If there is an error removing any container, the ID of those containers
// will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
// If the pod was removed with no errors, the pod ID is returned.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.RemovePod '{"name": "62f4fd98cb57", "force": "true"}'
// {
//   "pod": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
// }
// ~~~
func (s *VarlinkInterface) RemovePod(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.RemovePod")
}

func (s *VarlinkInterface) TopPod(ctx context.Context, c VarlinkCall, pod_ string, latest_ bool, descriptors_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.TopPod")
}

// GetPodStats takes the name or ID of a pod and returns a pod name and slice of ContainerStats structure which
// contains attributes like memory and cpu usage.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
// error will be returned.  If the pod has no running containers associated with it, a [NoContainerRunning](#NoContainerRunning)
// error will be returned.
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.GetPodStats '{"name": "7f62b508b6f12b11d8fe02e"}'
// {
//   "containers": [
//     {
//       "block_input": 0,
//       "block_output": 0,
//       "cpu": 2.833470544016107524276e-08,
//       "cpu_nano": 54363072,
//       "id": "a64b51f805121fe2c5a3dc5112eb61d6ed139e3d1c99110360d08b58d48e4a93",
//       "mem_limit": 12276146176,
//       "mem_perc": 7.974359265237864966003e-03,
//       "mem_usage": 978944,
//       "name": "quirky_heisenberg",
//       "net_input": 866,
//       "net_output": 7388,
//       "pids": 1,
//       "system_nano": 20000000
//     }
//   ],
//   "pod": "7f62b508b6f12b11d8fe02e0db4de6b9e43a7d7699b33a4fc0d574f6e82b4ebd"
// }
// ~~~
func (s *VarlinkInterface) GetPodStats(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetPodStats")
}

// GetPodsByStatus searches for pods whose status is included in statuses
func (s *VarlinkInterface) GetPodsByStatus(ctx context.Context, c VarlinkCall, statuses_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetPodsByStatus")
}

// ImageExists talks a full or partial image ID or name and returns an int as to whether
// the image exists in local storage. An int result of 0 means the image does exist in
// local storage; whereas 1 indicates the image does not exists in local storage.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ImageExists '{"name": "imageddoesntexist"}'
// {
//   "exists": 1
// }
// ~~~
func (s *VarlinkInterface) ImageExists(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ImageExists")
}

// ContainerExists takes a full or partial container ID or name and returns an int as to
// whether the container exists in local storage.  A result of 0 means the container does
// exists; whereas a result of 1 means it could not be found.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.ContainerExists '{"name": "flamboyant_payne"}'{
//   "exists": 0
// }
// ~~~
func (s *VarlinkInterface) ContainerExists(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerExists")
}

// ContainerCheckPoint performs a checkpopint on a container by its name or full/partial container
// ID.  On successful checkpoint, the id of the checkpointed container is returned.
func (s *VarlinkInterface) ContainerCheckpoint(ctx context.Context, c VarlinkCall, name_ string, keep_ bool, leaveRunning_ bool, tcpEstablished_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerCheckpoint")
}

// ContainerRestore restores a container that has been checkpointed.  The container to be restored can
// be identified by its name or full/partial container ID.  A successful restore will result in the return
// of the container's ID.
func (s *VarlinkInterface) ContainerRestore(ctx context.Context, c VarlinkCall, name_ string, keep_ bool, tcpEstablished_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerRestore")
}

// ContainerRunlabel runs executes a command as described by a given container image label.
func (s *VarlinkInterface) ContainerRunlabel(ctx context.Context, c VarlinkCall, runlabel_ Runlabel) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerRunlabel")
}

// ExecContainer executes a command in the given container.
func (s *VarlinkInterface) ExecContainer(ctx context.Context, c VarlinkCall, opts_ ExecOpts) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ExecContainer")
}

// ListContainerMounts gathers all the mounted container mount points and returns them as an array
// of strings
// #### Example
// ~~~
// $ varlink call unix:/run/podman/io.podman/io.podman.ListContainerMounts
// {
//   "mounts": {
//     "04e4c255269ed2545e7f8bd1395a75f7949c50c223415c00c1d54bfa20f3b3d9": "/var/lib/containers/storage/overlay/a078925828f57e20467ca31cfca8a849210d21ec7e5757332b72b6924f441c17/merged",
//     "1d58c319f9e881a644a5122ff84419dccf6d138f744469281446ab243ef38924": "/var/lib/containers/storage/overlay/948fcf93f8cb932f0f03fd52e3180a58627d547192ffe3b88e0013b98ddcd0d2/merged"
//   }
// }
// ~~~
func (s *VarlinkInterface) ListContainerMounts(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ListContainerMounts")
}

// MountContainer mounts a container by name or full/partial ID.  Upon a successful mount, the destination
// mount is returned as a string.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.MountContainer '{"name": "jolly_shannon"}'{
//   "path": "/var/lib/containers/storage/overlay/419eeb04e783ea159149ced67d9fcfc15211084d65e894792a96bedfae0470ca/merged"
// }
// ~~~
func (s *VarlinkInterface) MountContainer(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.MountContainer")
}

// UnmountContainer umounts a container by its name or full/partial container ID.
// #### Example
// ~~~
// $ varlink call -m unix:/run/podman/io.podman/io.podman.UnmountContainer '{"name": "jolly_shannon", "force": false}'
// {}
// ~~~
func (s *VarlinkInterface) UnmountContainer(ctx context.Context, c VarlinkCall, name_ string, force_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.UnmountContainer")
}

// ImagesPrune removes all unused images from the local store.  Upon successful pruning,
// the IDs of the removed images are returned.
func (s *VarlinkInterface) ImagesPrune(ctx context.Context, c VarlinkCall, all_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ImagesPrune")
}

// GenerateKube generates a Kubernetes v1 Pod description of a Podman container or pod
// and its containers. The description is in YAML.  See also [ReplayKube](ReplayKube).
func (s *VarlinkInterface) GenerateKube(ctx context.Context, c VarlinkCall, name_ string, service_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GenerateKube")
}

// ContainerConfig returns a container's config in string form. This call is for
// development of Podman only and generally should not be used.
func (s *VarlinkInterface) ContainerConfig(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerConfig")
}

// ContainerArtifacts returns a container's artifacts in string form.  This call is for
// development of Podman only and generally should not be used.
func (s *VarlinkInterface) ContainerArtifacts(ctx context.Context, c VarlinkCall, name_ string, artifactName_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerArtifacts")
}

// ContainerInspectData returns a container's inspect data in string form.  This call is for
// development of Podman only and generally should not be used.
func (s *VarlinkInterface) ContainerInspectData(ctx context.Context, c VarlinkCall, name_ string, size_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerInspectData")
}

// ContainerStateData returns a container's state config in string form.  This call is for
// development of Podman only and generally should not be used.
func (s *VarlinkInterface) ContainerStateData(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ContainerStateData")
}

// PodStateData returns inspectr level information of a given pod in string form.  This call is for
// development of Podman only and generally should not be used.
func (s *VarlinkInterface) PodStateData(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.PodStateData")
}

// This call is for the development of Podman only and should not be used.
func (s *VarlinkInterface) CreateFromCC(ctx context.Context, c VarlinkCall, in_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.CreateFromCC")
}

// Spec returns the oci spec for a container.  This call is for development of Podman only and generally should not be used.
func (s *VarlinkInterface) Spec(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Spec")
}

// Sendfile allows a remote client to send a file to the host
func (s *VarlinkInterface) SendFile(ctx context.Context, c VarlinkCall, type_ string, length_ int64) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.SendFile")
}

// ReceiveFile allows the host to send a remote client a file
func (s *VarlinkInterface) ReceiveFile(ctx context.Context, c VarlinkCall, path_ string, delete_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ReceiveFile")
}

// VolumeCreate creates a volume on a remote host
func (s *VarlinkInterface) VolumeCreate(ctx context.Context, c VarlinkCall, options_ VolumeCreateOpts) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.VolumeCreate")
}

// VolumeRemove removes a volume on a remote host
func (s *VarlinkInterface) VolumeRemove(ctx context.Context, c VarlinkCall, options_ VolumeRemoveOpts) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.VolumeRemove")
}

// GetVolumes gets slice of the volumes on a remote host
func (s *VarlinkInterface) GetVolumes(ctx context.Context, c VarlinkCall, args_ []string, all_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetVolumes")
}

// InspectVolume inspects a single volume. Returns inspect JSON in the form of a
// string.
func (s *VarlinkInterface) InspectVolume(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.InspectVolume")
}

// VolumesPrune removes unused volumes on the host
func (s *VarlinkInterface) VolumesPrune(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.VolumesPrune")
}

// ImageSave allows you to save an image from the local image storage to a tarball
func (s *VarlinkInterface) ImageSave(ctx context.Context, c VarlinkCall, options_ ImageSaveOptions) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.ImageSave")
}

// GetPodsByContext allows you to get a list pod ids depending on all, latest, or a list of
// pod names.  The definition of latest pod means the latest by creation date.  In a multi-
// user environment, results might differ from what you expect.
func (s *VarlinkInterface) GetPodsByContext(ctx context.Context, c VarlinkCall, all_ bool, latest_ bool, args_ []string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetPodsByContext")
}

// LoadImage allows you to load an image into local storage from a tarball.
func (s *VarlinkInterface) LoadImage(ctx context.Context, c VarlinkCall, name_ string, inputFile_ string, quiet_ bool, deleteFile_ bool) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.LoadImage")
}

// GetEvents returns known libpod events filtered by the options provided.
func (s *VarlinkInterface) GetEvents(ctx context.Context, c VarlinkCall, filter_ []string, since_ string, until_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetEvents")
}

// Diff returns a diff between libpod objects
func (s *VarlinkInterface) Diff(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.Diff")
}

// GetLayersMapWithImageInfo is for the development of Podman and should not be used.
func (s *VarlinkInterface) GetLayersMapWithImageInfo(ctx context.Context, c VarlinkCall) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.GetLayersMapWithImageInfo")
}

// BuildImageHierarchyMap is for the development of Podman and should not be used.
func (s *VarlinkInterface) BuildImageHierarchyMap(ctx context.Context, c VarlinkCall, name_ string) error {
	return c.ReplyMethodNotImplemented(ctx, "io.podman.BuildImageHierarchyMap")
}

// Generated method call dispatcher

func (s *VarlinkInterface) VarlinkDispatch(ctx context.Context, call varlink.Call, methodname string) error {
	switch methodname {
	case "GetVersion":
		return s.iopodmanInterface.GetVersion(ctx, VarlinkCall{call})

	case "GetInfo":
		return s.iopodmanInterface.GetInfo(ctx, VarlinkCall{call})

	case "ListContainers":
		return s.iopodmanInterface.ListContainers(ctx, VarlinkCall{call})

	case "Ps":
		var in struct {
			Opts PsOpts `json:"opts"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Ps(ctx, VarlinkCall{call}, in.Opts)

	case "GetContainersByStatus":
		var in struct {
			Status []string `json:"status"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainersByStatus(ctx, VarlinkCall{call}, []string(in.Status))

	case "Top":
		var in struct {
			NameOrID    string   `json:"nameOrID"`
			Descriptors []string `json:"descriptors"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Top(ctx, VarlinkCall{call}, in.NameOrID, []string(in.Descriptors))

	case "HealthCheckRun":
		var in struct {
			NameOrID string `json:"nameOrID"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.HealthCheckRun(ctx, VarlinkCall{call}, in.NameOrID)

	case "GetContainer":
		var in struct {
			Id string `json:"id"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainer(ctx, VarlinkCall{call}, in.Id)

	case "GetContainersByContext":
		var in struct {
			All    bool     `json:"all"`
			Latest bool     `json:"latest"`
			Args   []string `json:"args"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainersByContext(ctx, VarlinkCall{call}, in.All, in.Latest, []string(in.Args))

	case "CreateContainer":
		var in struct {
			Create Create `json:"create"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.CreateContainer(ctx, VarlinkCall{call}, in.Create)

	case "InspectContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.InspectContainer(ctx, VarlinkCall{call}, in.Name)

	case "ListContainerProcesses":
		var in struct {
			Name string   `json:"name"`
			Opts []string `json:"opts"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ListContainerProcesses(ctx, VarlinkCall{call}, in.Name, []string(in.Opts))

	case "GetContainerLogs":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainerLogs(ctx, VarlinkCall{call}, in.Name)

	case "GetContainersLogs":
		var in struct {
			Names      []string `json:"names"`
			Follow     bool     `json:"follow"`
			Latest     bool     `json:"latest"`
			Since      string   `json:"since"`
			Tail       int64    `json:"tail"`
			Timestamps bool     `json:"timestamps"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainersLogs(ctx, VarlinkCall{call}, []string(in.Names), in.Follow, in.Latest, in.Since, in.Tail, in.Timestamps)

	case "ListContainerChanges":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ListContainerChanges(ctx, VarlinkCall{call}, in.Name)

	case "ExportContainer":
		var in struct {
			Name string `json:"name"`
			Path string `json:"path"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ExportContainer(ctx, VarlinkCall{call}, in.Name, in.Path)

	case "GetContainerStats":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainerStats(ctx, VarlinkCall{call}, in.Name)

	case "GetContainerStatsWithHistory":
		var in struct {
			PreviousStats ContainerStats `json:"previousStats"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetContainerStatsWithHistory(ctx, VarlinkCall{call}, in.PreviousStats)

	case "StartContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.StartContainer(ctx, VarlinkCall{call}, in.Name)

	case "StopContainer":
		var in struct {
			Name    string `json:"name"`
			Timeout int64  `json:"timeout"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.StopContainer(ctx, VarlinkCall{call}, in.Name, in.Timeout)

	case "InitContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.InitContainer(ctx, VarlinkCall{call}, in.Name)

	case "RestartContainer":
		var in struct {
			Name    string `json:"name"`
			Timeout int64  `json:"timeout"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.RestartContainer(ctx, VarlinkCall{call}, in.Name, in.Timeout)

	case "KillContainer":
		var in struct {
			Name   string `json:"name"`
			Signal int64  `json:"signal"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.KillContainer(ctx, VarlinkCall{call}, in.Name, in.Signal)

	case "PauseContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.PauseContainer(ctx, VarlinkCall{call}, in.Name)

	case "UnpauseContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.UnpauseContainer(ctx, VarlinkCall{call}, in.Name)

	case "Attach":
		var in struct {
			Name       string `json:"name"`
			DetachKeys string `json:"detachKeys"`
			Start      bool   `json:"start"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Attach(ctx, VarlinkCall{call}, in.Name, in.DetachKeys, in.Start)

	case "AttachControl":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.AttachControl(ctx, VarlinkCall{call}, in.Name)

	case "GetAttachSockets":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetAttachSockets(ctx, VarlinkCall{call}, in.Name)

	case "WaitContainer":
		var in struct {
			Name     string `json:"name"`
			Interval int64  `json:"interval"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.WaitContainer(ctx, VarlinkCall{call}, in.Name, in.Interval)

	case "RemoveContainer":
		var in struct {
			Name          string `json:"name"`
			Force         bool   `json:"force"`
			RemoveVolumes bool   `json:"removeVolumes"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.RemoveContainer(ctx, VarlinkCall{call}, in.Name, in.Force, in.RemoveVolumes)

	case "EvictContainer":
		var in struct {
			Name          string `json:"name"`
			RemoveVolumes bool   `json:"removeVolumes"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.EvictContainer(ctx, VarlinkCall{call}, in.Name, in.RemoveVolumes)

	case "DeleteStoppedContainers":
		return s.iopodmanInterface.DeleteStoppedContainers(ctx, VarlinkCall{call})

	case "ListImages":
		return s.iopodmanInterface.ListImages(ctx, VarlinkCall{call})

	case "GetImage":
		var in struct {
			Id string `json:"id"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetImage(ctx, VarlinkCall{call}, in.Id)

	case "BuildImage":
		var in struct {
			Build BuildInfo `json:"build"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.BuildImage(ctx, VarlinkCall{call}, in.Build)

	case "InspectImage":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.InspectImage(ctx, VarlinkCall{call}, in.Name)

	case "HistoryImage":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.HistoryImage(ctx, VarlinkCall{call}, in.Name)

	case "PushImage":
		var in struct {
			Name             string `json:"name"`
			Tag              string `json:"tag"`
			Compress         bool   `json:"compress"`
			Format           string `json:"format"`
			RemoveSignatures bool   `json:"removeSignatures"`
			SignBy           string `json:"signBy"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.PushImage(ctx, VarlinkCall{call}, in.Name, in.Tag, in.Compress, in.Format, in.RemoveSignatures, in.SignBy)

	case "TagImage":
		var in struct {
			Name   string `json:"name"`
			Tagged string `json:"tagged"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.TagImage(ctx, VarlinkCall{call}, in.Name, in.Tagged)

	case "RemoveImage":
		var in struct {
			Name  string `json:"name"`
			Force bool   `json:"force"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.RemoveImage(ctx, VarlinkCall{call}, in.Name, in.Force)

	case "SearchImages":
		var in struct {
			Query  string            `json:"query"`
			Limit  *int64            `json:"limit,omitempty"`
			Filter ImageSearchFilter `json:"filter"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.SearchImages(ctx, VarlinkCall{call}, in.Query, in.Limit, in.Filter)

	case "DeleteUnusedImages":
		return s.iopodmanInterface.DeleteUnusedImages(ctx, VarlinkCall{call})

	case "Commit":
		var in struct {
			Name         string   `json:"name"`
			Image_name   string   `json:"image_name"`
			Changes      []string `json:"changes"`
			Author       string   `json:"author"`
			Message      string   `json:"message"`
			Pause        bool     `json:"pause"`
			ManifestType string   `json:"manifestType"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Commit(ctx, VarlinkCall{call}, in.Name, in.Image_name, []string(in.Changes), in.Author, in.Message, in.Pause, in.ManifestType)

	case "ImportImage":
		var in struct {
			Source    string   `json:"source"`
			Reference string   `json:"reference"`
			Message   string   `json:"message"`
			Changes   []string `json:"changes"`
			Delete    bool     `json:"delete"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ImportImage(ctx, VarlinkCall{call}, in.Source, in.Reference, in.Message, []string(in.Changes), in.Delete)

	case "ExportImage":
		var in struct {
			Name        string   `json:"name"`
			Destination string   `json:"destination"`
			Compress    bool     `json:"compress"`
			Tags        []string `json:"tags"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ExportImage(ctx, VarlinkCall{call}, in.Name, in.Destination, in.Compress, []string(in.Tags))

	case "PullImage":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.PullImage(ctx, VarlinkCall{call}, in.Name)

	case "CreatePod":
		var in struct {
			Create PodCreate `json:"create"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.CreatePod(ctx, VarlinkCall{call}, in.Create)

	case "ListPods":
		return s.iopodmanInterface.ListPods(ctx, VarlinkCall{call})

	case "GetPod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetPod(ctx, VarlinkCall{call}, in.Name)

	case "InspectPod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.InspectPod(ctx, VarlinkCall{call}, in.Name)

	case "StartPod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.StartPod(ctx, VarlinkCall{call}, in.Name)

	case "StopPod":
		var in struct {
			Name    string `json:"name"`
			Timeout int64  `json:"timeout"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.StopPod(ctx, VarlinkCall{call}, in.Name, in.Timeout)

	case "RestartPod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.RestartPod(ctx, VarlinkCall{call}, in.Name)

	case "KillPod":
		var in struct {
			Name   string `json:"name"`
			Signal int64  `json:"signal"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.KillPod(ctx, VarlinkCall{call}, in.Name, in.Signal)

	case "PausePod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.PausePod(ctx, VarlinkCall{call}, in.Name)

	case "UnpausePod":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.UnpausePod(ctx, VarlinkCall{call}, in.Name)

	case "RemovePod":
		var in struct {
			Name  string `json:"name"`
			Force bool   `json:"force"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.RemovePod(ctx, VarlinkCall{call}, in.Name, in.Force)

	case "TopPod":
		var in struct {
			Pod         string   `json:"pod"`
			Latest      bool     `json:"latest"`
			Descriptors []string `json:"descriptors"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.TopPod(ctx, VarlinkCall{call}, in.Pod, in.Latest, []string(in.Descriptors))

	case "GetPodStats":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetPodStats(ctx, VarlinkCall{call}, in.Name)

	case "GetPodsByStatus":
		var in struct {
			Statuses []string `json:"statuses"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetPodsByStatus(ctx, VarlinkCall{call}, []string(in.Statuses))

	case "ImageExists":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ImageExists(ctx, VarlinkCall{call}, in.Name)

	case "ContainerExists":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerExists(ctx, VarlinkCall{call}, in.Name)

	case "ContainerCheckpoint":
		var in struct {
			Name           string `json:"name"`
			Keep           bool   `json:"keep"`
			LeaveRunning   bool   `json:"leaveRunning"`
			TcpEstablished bool   `json:"tcpEstablished"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerCheckpoint(ctx, VarlinkCall{call}, in.Name, in.Keep, in.LeaveRunning, in.TcpEstablished)

	case "ContainerRestore":
		var in struct {
			Name           string `json:"name"`
			Keep           bool   `json:"keep"`
			TcpEstablished bool   `json:"tcpEstablished"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerRestore(ctx, VarlinkCall{call}, in.Name, in.Keep, in.TcpEstablished)

	case "ContainerRunlabel":
		var in struct {
			Runlabel Runlabel `json:"runlabel"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerRunlabel(ctx, VarlinkCall{call}, in.Runlabel)

	case "ExecContainer":
		var in struct {
			Opts ExecOpts `json:"opts"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ExecContainer(ctx, VarlinkCall{call}, in.Opts)

	case "ListContainerMounts":
		return s.iopodmanInterface.ListContainerMounts(ctx, VarlinkCall{call})

	case "MountContainer":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.MountContainer(ctx, VarlinkCall{call}, in.Name)

	case "UnmountContainer":
		var in struct {
			Name  string `json:"name"`
			Force bool   `json:"force"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.UnmountContainer(ctx, VarlinkCall{call}, in.Name, in.Force)

	case "ImagesPrune":
		var in struct {
			All bool `json:"all"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ImagesPrune(ctx, VarlinkCall{call}, in.All)

	case "GenerateKube":
		var in struct {
			Name    string `json:"name"`
			Service bool   `json:"service"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GenerateKube(ctx, VarlinkCall{call}, in.Name, in.Service)

	case "ContainerConfig":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerConfig(ctx, VarlinkCall{call}, in.Name)

	case "ContainerArtifacts":
		var in struct {
			Name         string `json:"name"`
			ArtifactName string `json:"artifactName"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerArtifacts(ctx, VarlinkCall{call}, in.Name, in.ArtifactName)

	case "ContainerInspectData":
		var in struct {
			Name string `json:"name"`
			Size bool   `json:"size"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerInspectData(ctx, VarlinkCall{call}, in.Name, in.Size)

	case "ContainerStateData":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ContainerStateData(ctx, VarlinkCall{call}, in.Name)

	case "PodStateData":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.PodStateData(ctx, VarlinkCall{call}, in.Name)

	case "CreateFromCC":
		var in struct {
			In []string `json:"in"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.CreateFromCC(ctx, VarlinkCall{call}, []string(in.In))

	case "Spec":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Spec(ctx, VarlinkCall{call}, in.Name)

	case "SendFile":
		var in struct {
			Type   string `json:"type"`
			Length int64  `json:"length"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.SendFile(ctx, VarlinkCall{call}, in.Type, in.Length)

	case "ReceiveFile":
		var in struct {
			Path   string `json:"path"`
			Delete bool   `json:"delete"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ReceiveFile(ctx, VarlinkCall{call}, in.Path, in.Delete)

	case "VolumeCreate":
		var in struct {
			Options VolumeCreateOpts `json:"options"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.VolumeCreate(ctx, VarlinkCall{call}, in.Options)

	case "VolumeRemove":
		var in struct {
			Options VolumeRemoveOpts `json:"options"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.VolumeRemove(ctx, VarlinkCall{call}, in.Options)

	case "GetVolumes":
		var in struct {
			Args []string `json:"args"`
			All  bool     `json:"all"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetVolumes(ctx, VarlinkCall{call}, []string(in.Args), in.All)

	case "InspectVolume":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.InspectVolume(ctx, VarlinkCall{call}, in.Name)

	case "VolumesPrune":
		return s.iopodmanInterface.VolumesPrune(ctx, VarlinkCall{call})

	case "ImageSave":
		var in struct {
			Options ImageSaveOptions `json:"options"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.ImageSave(ctx, VarlinkCall{call}, in.Options)

	case "GetPodsByContext":
		var in struct {
			All    bool     `json:"all"`
			Latest bool     `json:"latest"`
			Args   []string `json:"args"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetPodsByContext(ctx, VarlinkCall{call}, in.All, in.Latest, []string(in.Args))

	case "LoadImage":
		var in struct {
			Name       string `json:"name"`
			InputFile  string `json:"inputFile"`
			Quiet      bool   `json:"quiet"`
			DeleteFile bool   `json:"deleteFile"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.LoadImage(ctx, VarlinkCall{call}, in.Name, in.InputFile, in.Quiet, in.DeleteFile)

	case "GetEvents":
		var in struct {
			Filter []string `json:"filter"`
			Since  string   `json:"since"`
			Until  string   `json:"until"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.GetEvents(ctx, VarlinkCall{call}, []string(in.Filter), in.Since, in.Until)

	case "Diff":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.Diff(ctx, VarlinkCall{call}, in.Name)

	case "GetLayersMapWithImageInfo":
		return s.iopodmanInterface.GetLayersMapWithImageInfo(ctx, VarlinkCall{call})

	case "BuildImageHierarchyMap":
		var in struct {
			Name string `json:"name"`
		}
		err := call.GetParameters(&in)
		if err != nil {
			return call.ReplyInvalidParameter(ctx, "parameters")
		}
		return s.iopodmanInterface.BuildImageHierarchyMap(ctx, VarlinkCall{call}, in.Name)

	default:
		return call.ReplyMethodNotFound(ctx, methodname)
	}
}

// Generated varlink interface name

func (s *VarlinkInterface) VarlinkGetName() string {
	return `io.podman`
}

// Generated varlink interface description

func (s *VarlinkInterface) VarlinkGetDescription() string {
	return `# Podman Service Interface and API description.  The master version of this document can be found
# in the [API.md](https://github.com/containers/libpod/blob/master/API.md) file in the upstream libpod repository.
interface io.podman

type Volume (
  name: string,
  labels: [string]string,
  mountPoint: string,
  driver: string,
  options: [string]string
)

type NotImplemented (
    comment: string
)

type StringResponse (
    message: string
)

type LogLine (
    device: string,
    parseLogType : string,
    time: string,
    msg: string,
    cid: string
)

# ContainerChanges describes the return struct for ListContainerChanges
type ContainerChanges (
   changed: []string,
   added: []string,
   deleted: []string
)

type ImageSaveOptions (
    name: string,
    format: string,
    output: string,
    outputType: string,
    moreTags: []string,
    quiet: bool,
    compress: bool
)

type VolumeCreateOpts (
   volumeName: string,
   driver: string,
   labels: [string]string,
   options: [string]string
)

type VolumeRemoveOpts (
   volumes: []string,
   all: bool,
   force: bool
)

type Image (
  id: string,
  digest: string,
  digests: []string,
  parentId: string,
  repoTags: []string,
  repoDigests: []string,
  created: string, # as RFC3339
  size: int,
  virtualSize: int,
  containers: int,
  labels: [string]string,
  isParent: bool,
  topLayer: string,
  readOnly: bool
)

# ImageHistory describes the returned structure from ImageHistory.
type ImageHistory (
    id: string,
    created: string, # as RFC3339
    createdBy: string,
    tags: []string,
    size: int,
    comment: string
)

# Represents a single search result from SearchImages
type ImageSearchResult (
    description: string,
    is_official: bool,
    is_automated: bool,
    registry: string,
    name: string,
    star_count: int
)

type ImageSearchFilter (
    is_official: ?bool,
    is_automated: ?bool,
    star_count: int
)

type KubePodService (
    pod: string,
    service: string
)

type Container (
    id: string,
    image: string,
    imageid: string,
    command: []string,
    createdat: string, # as RFC3339
    runningfor: string,
    status: string,
    ports: []ContainerPortMappings,
    rootfssize: int,
    rwsize: int,
    names: string,
    labels: [string]string,
    mounts: []ContainerMount,
    containerrunning: bool,
    namespaces: ContainerNameSpace
)

# ContainerStats is the return struct for the stats of a container
type ContainerStats (
    id: string,
    name: string,
    cpu: float,
    cpu_nano: int,
    system_nano: int,
    mem_usage: int,
    mem_limit: int,
    mem_perc: float,
    net_input: int,
    net_output: int,
    block_output: int,
    block_input: int,
    pids: int
)

type PsOpts (
    all: bool,
    filters: ?[]string,
    last: ?int,
    latest: ?bool,
    noTrunc: ?bool,
    pod: ?bool,
    quiet: ?bool,
    size: ?bool,
    sort: ?string,
    sync: ?bool
)

type PsContainer (
    id: string,
    image: string,
    command: string,
    created: string,
    ports: string,
    names: string,
    isInfra: bool,
    status: string,
    state: string,
    pidNum: int,
    rootFsSize: int,
    rwSize: int,
    pod: string,
    createdAt: string,
    exitedAt: string,
    startedAt: string,
    labels: [string]string,
    nsPid: string,
    cgroup: string,
    ipc: string,
    mnt: string,
    net: string,
    pidNs: string,
    user: string,
    uts: string,
    mounts: string
)

# ContainerMount describes the struct for mounts in a container
type ContainerMount (
    destination: string,
    type: string,
    source: string,
    options: []string
)

# ContainerPortMappings describes the struct for portmappings in an existing container
type ContainerPortMappings (
    host_port: string,
    host_ip: string,
    protocol: string,
    container_port: string
)

# ContainerNamespace describes the namespace structure for an existing container
type ContainerNameSpace (
    user: string,
    uts: string,
    pidns: string,
    pid: string,
    cgroup: string,
    net: string,
    mnt: string,
    ipc: string
)

# InfoDistribution describes the host's distribution
type InfoDistribution (
    distribution: string,
    version: string
)

# InfoHost describes the host stats portion of PodmanInfo
type InfoHost (
    buildah_version: string,
    distribution: InfoDistribution,
    mem_free: int,
    mem_total: int,
    swap_free: int,
    swap_total: int,
    arch: string,
    cpus: int,
    hostname: string,
    kernel: string,
    os: string,
    uptime: string,
    eventlogger: string
)

# InfoGraphStatus describes the detailed status of the storage driver
type InfoGraphStatus (
    backing_filesystem: string,
    native_overlay_diff: string,
    supports_d_type: string
)

# InfoStore describes the host's storage informatoin
type InfoStore (
    containers: int,
    images: int,
    graph_driver_name: string,
    graph_driver_options: string,
    graph_root: string,
    graph_status: InfoGraphStatus,
    run_root: string
)

# InfoPodman provides details on the Podman binary
type InfoPodmanBinary (
    compiler: string,
    go_version: string,
    podman_version: string,
    git_commit: string
)

# PodmanInfo describes the Podman host and build
type PodmanInfo (
    host: InfoHost,
    registries: []string,
    insecure_registries: []string,
    store: InfoStore,
    podman: InfoPodmanBinary
)

# Sockets describes sockets location for a container
type Sockets(
    container_id: string,
    io_socket: string,
    control_socket: string
)

# Create is an input structure for creating containers.
# args[0] is the image name or id
# args[1-] are the new commands if changed
type Create (
    args: []string,
    addHost: ?[]string,
    annotation: ?[]string,
    attach: ?[]string,
    blkioWeight: ?string,
    blkioWeightDevice: ?[]string,
    capAdd: ?[]string,
    capDrop: ?[]string,
    cgroupParent: ?string,
    cidFile: ?string,
    conmonPidfile: ?string,
    command: ?[]string,
    cpuPeriod: ?int,
    cpuQuota: ?int,
    cpuRtPeriod: ?int,
    cpuRtRuntime: ?int,
    cpuShares: ?int,
    cpus: ?float,
    cpuSetCpus: ?string,
    cpuSetMems: ?string,
    detach: ?bool,
    detachKeys: ?string,
    device: ?[]string,
    deviceReadBps: ?[]string,
    deviceReadIops: ?[]string,
    deviceWriteBps: ?[]string,
    deviceWriteIops: ?[]string,
    dns: ?[]string,
    dnsOpt: ?[]string,
    dnsSearch: ?[]string,
    dnsServers: ?[]string,
    entrypoint: ?string,
    env:  ?[]string,
    envFile: ?[]string,
    expose: ?[]string,
    gidmap: ?[]string,
    groupadd: ?[]string,
    healthcheckCommand: ?string,
    healthcheckInterval: ?string,
    healthcheckRetries: ?int,
    healthcheckStartPeriod: ?string,
    healthcheckTimeout:?string,
    hostname: ?string,
    imageVolume: ?string,
    init: ?bool,
    initPath: ?string,
    interactive: ?bool,
    ip: ?string,
    ipc: ?string,
    kernelMemory: ?string,
    label: ?[]string,
    labelFile: ?[]string,
    logDriver: ?string,
    logOpt: ?[]string,
    macAddress: ?string,
    memory: ?string,
    memoryReservation: ?string,
    memorySwap: ?string,
    memorySwappiness: ?int,
    name: ?string,
    net: ?string,
    network: ?string,
    noHosts: ?bool,
    oomKillDisable: ?bool,
    oomScoreAdj: ?int,
    overrideArch: ?string,
    overrideOS: ?string,
    pid: ?string,
    pidsLimit: ?int,
    pod: ?string,
    privileged: ?bool,
    publish: ?[]string,
    publishAll: ?bool,
    pull: ?string,
    quiet: ?bool,
    readonly: ?bool,
    readonlytmpfs: ?bool,
    restart: ?string,
    rm: ?bool,
    rootfs: ?bool,
    securityOpt: ?[]string,
    shmSize: ?string,
    stopSignal: ?string,
    stopTimeout: ?int,
    storageOpt: ?[]string,
    subuidname: ?string,
    subgidname: ?string,
    sysctl: ?[]string,
    systemd: ?string,
    tmpfs: ?[]string,
    tty: ?bool,
    uidmap: ?[]string,
    ulimit: ?[]string,
    user: ?string,
    userns: ?string,
    uts: ?string,
    mount: ?[]string,
    volume: ?[]string,
    volumesFrom: ?[]string,
    workDir: ?string
)

# BuildOptions are are used to describe describe physical attributes of the build
type BuildOptions (
    addHosts: []string,
    cgroupParent: string,
    cpuPeriod: int,
    cpuQuota: int,
    cpuShares: int,
    cpusetCpus: string,
    cpusetMems: string,
    memory: int,
    memorySwap: int,
    shmSize: string,
    ulimit: []string,
    volume: []string
)

# BuildInfo is used to describe user input for building images
type BuildInfo (
    additionalTags: []string,
    annotations: []string,
    buildArgs: [string]string,
    buildOptions: BuildOptions,
    cniConfigDir: string,
    cniPluginDir: string,
    compression: string,
    contextDir: string,
    defaultsMountFilePath: string,
    dockerfiles: []string,
    err: string,
    forceRmIntermediateCtrs: bool,
    iidfile: string,
    label: []string,
    layers: bool,
    nocache: bool,
    out: string,
    output: string,
    outputFormat: string,
    pullPolicy: string,
    quiet: bool,
    remoteIntermediateCtrs: bool,
    reportWriter: string,
    runtimeArgs: []string,
    squash: bool
)

# MoreResponse is a struct for when responses from varlink requires longer output
type MoreResponse (
    logs: []string,
    id: string
)

# ListPodContainerInfo is a returned struct for describing containers
# in a pod.
type ListPodContainerInfo (
    name: string,
    id: string,
    status: string
)

# PodCreate is an input structure for creating pods.
# It emulates options to podman pod create. The infraCommand and
# infraImage options are currently NotSupported.
type PodCreate (
    name: string,
    cgroupParent: string,
    labels: [string]string,
    share: []string,
    infra: bool,
    infraCommand: string,
    infraImage: string,
    publish: []string
)

# ListPodData is the returned struct for an individual pod
type ListPodData (
    id: string,
    name: string,
    createdat: string,
    cgroup: string,
    status: string,
    labels: [string]string,
    numberofcontainers: string,
    containersinfo: []ListPodContainerInfo
)

type PodContainerErrorData (
    containerid: string,
    reason: string
)

# Runlabel describes the required input for container runlabel
type Runlabel(
    image: string,
    authfile: string,
    display: bool,
    name: string,
    pull: bool,
    label: string,
    extraArgs: []string,
    opts: [string]string
)

# Event describes a libpod struct
type Event(
    # TODO: make status and type a enum at some point?
    # id is the container, volume, pod, image ID
    id: string,
    # image is the image name where applicable
    image: string,
    # name is the name of the pod, container, image
    name: string,
    # status describes the event that happened (i.e. create, remove, ...)
    status: string,
    # time the event happened
    time: string,
    # type describes object the event happened with (image, container...)
    type: string
)

type DiffInfo(
    # path that is different
    path: string,
    # Add, Delete, Modify
    changeType: string
)

type ExecOpts(
    # container name or id
    name: string,
    # Create pseudo tty
    tty: bool,
    # privileged access in container
    privileged: bool,
    # command to execute in container
    cmd: []string,
    # user to use in container
    user: ?string,
    # workdir to run command in container
    workdir: ?string,
    # slice of keyword=value environment variables
    env: ?[]string,
    # string of detach keys
    detachKeys: ?string
)

# GetVersion returns version and build information of the podman service
method GetVersion() -> (
    version: string,
    go_version: string,
    git_commit: string,
    built: string, # as RFC3339
    os_arch: string,
    remote_api_version: int
)

# GetInfo returns a [PodmanInfo](#PodmanInfo) struct that describes podman and its host such as storage stats,
# build information of Podman, and system-wide registries.
method GetInfo() -> (info: PodmanInfo)

# ListContainers returns information about all containers.
# See also [GetContainer](#GetContainer).
method ListContainers() -> (containers: []Container)

method Ps(opts: PsOpts) -> (containers: []PsContainer)

method GetContainersByStatus(status: []string) -> (containerS: []Container)

method Top (nameOrID: string, descriptors: []string) -> (top: []string)

# HealthCheckRun executes defined container's healthcheck command
# and returns the container's health status.
method HealthCheckRun (nameOrID: string) -> (healthCheckStatus: string)

# GetContainer returns information about a single container.  If a container
# with the given id doesn't exist, a [ContainerNotFound](#ContainerNotFound)
# error will be returned.  See also [ListContainers](ListContainers) and
# [InspectContainer](#InspectContainer).
method GetContainer(id: string) -> (container: Container)

# GetContainersByContext allows you to get a list of container ids depending on all, latest, or a list of
# container names.  The definition of latest container means the latest by creation date.  In a multi-
# user environment, results might differ from what you expect.
method GetContainersByContext(all: bool, latest: bool, args: []string) -> (containers: []string)

# CreateContainer creates a new container from an image.  It uses a [Create](#Create) type for input.
method CreateContainer(create: Create) -> (container: string)

# InspectContainer data takes a name or ID of a container returns the inspection
# data in string format.  You can then serialize the string into JSON.  A [ContainerNotFound](#ContainerNotFound)
# error will be returned if the container cannot be found. See also [InspectImage](#InspectImage).
method InspectContainer(name: string) -> (container: string)

# ListContainerProcesses takes a name or ID of a container and returns the processes
# running inside the container as array of strings.  It will accept an array of string
# arguments that represent ps options.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
# error will be returned.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.ListContainerProcesses '{"name": "135d71b9495f", "opts": []}'
# {
#   "container": [
#     "  UID   PID  PPID  C STIME TTY          TIME CMD",
#     "    0 21220 21210  0 09:05 pts/0    00:00:00 /bin/sh",
#     "    0 21232 21220  0 09:05 pts/0    00:00:00 top",
#     "    0 21284 21220  0 09:05 pts/0    00:00:00 vi /etc/hosts"
#   ]
# }
# ~~~
method ListContainerProcesses(name: string, opts: []string) -> (container: []string)

# GetContainerLogs takes a name or ID of a container and returns the logs of that container.
# If the container cannot be found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
# The container logs are returned as an array of strings.  GetContainerLogs will honor the streaming
# capability of varlink if the client invokes it.
method GetContainerLogs(name: string) -> (container: []string)

method GetContainersLogs(names: []string, follow: bool, latest: bool, since: string, tail: int, timestamps: bool) -> (log: LogLine)

# ListContainerChanges takes a name or ID of a container and returns changes between the container and
# its base image. It returns a struct of changed, deleted, and added path names.
method ListContainerChanges(name: string) -> (container: ContainerChanges)

# ExportContainer creates an image from a container.  It takes the name or ID of a container and a
# path representing the target tarfile.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
# error will be returned.
# The return value is the written tarfile.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.ExportContainer '{"name": "flamboyant_payne", "path": "/tmp/payne.tar" }'
# {
#   "tarfile": "/tmp/payne.tar"
# }
# ~~~
method ExportContainer(name: string, path: string) -> (tarfile: string)

# GetContainerStats takes the name or ID of a container and returns a single ContainerStats structure which
# contains attributes like memory and cpu usage.  If the container cannot be found, a
# [ContainerNotFound](#ContainerNotFound) error will be returned. If the container is not running, a [NoContainerRunning](#NoContainerRunning)
# error will be returned
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.GetContainerStats '{"name": "c33e4164f384"}'
# {
#   "container": {
#     "block_input": 0,
#     "block_output": 0,
#     "cpu": 2.571123918839990154678e-08,
#     "cpu_nano": 49037378,
#     "id": "c33e4164f384aa9d979072a63319d66b74fd7a128be71fa68ede24f33ec6cfee",
#     "mem_limit": 33080606720,
#     "mem_perc": 2.166828456524753747370e-03,
#     "mem_usage": 716800,
#     "name": "competent_wozniak",
#     "net_input": 768,
#     "net_output": 5910,
#     "pids": 1,
#     "system_nano": 10000000
#   }
# }
# ~~~
method GetContainerStats(name: string) -> (container: ContainerStats)

# GetContainerStatsWithHistory takes a previous set of container statistics and uses libpod functions
# to calculate the containers statistics based on current and previous measurements.
method GetContainerStatsWithHistory(previousStats: ContainerStats) -> (container: ContainerStats)

# This method has not be implemented yet.
# method ResizeContainerTty() -> (notimplemented: NotImplemented)

# StartContainer starts a created or stopped container. It takes the name or ID of container.  It returns
# the container ID once started.  If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
# error will be returned.  See also [CreateContainer](#CreateContainer).
method StartContainer(name: string) -> (container: string)

# StopContainer stops a container given a timeout.  It takes the name or ID of a container as well as a
# timeout value.  The timeout value the time before a forcible stop to the container is applied.  It
# returns the container ID once stopped. If the container cannot be found, a [ContainerNotFound](#ContainerNotFound)
# error will be returned instead. See also [KillContainer](KillContainer).
# #### Error
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.StopContainer '{"name": "135d71b9495f", "timeout": 5}'
# {
#   "container": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
# }
# ~~~
method StopContainer(name: string, timeout: int) -> (container: string)

# InitContainer initializes the given container. It accepts a container name or
# ID, and will initialize the container matching that ID if possible, and error
# if not. Containers can only be initialized when they are in the Created or
# Exited states. Initialization prepares a container to be started, but does not
# start the container. It is intended to be used to debug a container's state
# prior to starting it.
method InitContainer(name: string) -> (container: string)

# RestartContainer will restart a running container given a container name or ID and timeout value. The timeout
# value is the time before a forcible stop is used to stop the container.  If the container cannot be found by
# name or ID, a [ContainerNotFound](#ContainerNotFound)  error will be returned; otherwise, the ID of the
# container will be returned.
method RestartContainer(name: string, timeout: int) -> (container: string)

# KillContainer takes the name or ID of a container as well as a signal to be applied to the container.  Once the
# container has been killed, the container's ID is returned.  If the container cannot be found, a
# [ContainerNotFound](#ContainerNotFound) error is returned. See also [StopContainer](StopContainer).
method KillContainer(name: string, signal: int) -> (container: string)

# This method has not be implemented yet.
# method UpdateContainer() -> (notimplemented: NotImplemented)

# This method has not be implemented yet.
# method RenameContainer() -> (notimplemented: NotImplemented)

# PauseContainer takes the name or ID of container and pauses it.  If the container cannot be found,
# a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
# See also [UnpauseContainer](#UnpauseContainer).
method PauseContainer(name: string) -> (container: string)

# UnpauseContainer takes the name or ID of container and unpauses a paused container.  If the container cannot be
# found, a [ContainerNotFound](#ContainerNotFound) error will be returned; otherwise the ID of the container is returned.
# See also [PauseContainer](#PauseContainer).
method UnpauseContainer(name: string) -> (container: string)

# Attach takes the name or ID of a container and sets up the ability to remotely attach to its console. The start
# bool is whether you wish to start the container in question first.
method Attach(name: string, detachKeys: string, start: bool) -> ()

method AttachControl(name: string) -> ()

# GetAttachSockets takes the name or ID of an existing container.  It returns file paths for two sockets needed
# to properly communicate with a container.  The first is the actual I/O socket that the container uses.  The
# second is a "control" socket where things like resizing the TTY events are sent. If the container cannot be
# found, a [ContainerNotFound](#ContainerNotFound) error will be returned.
# #### Example
# ~~~
# $ varlink call -m unix:/run/io.podman/io.podman.GetAttachSockets '{"name": "b7624e775431219161"}'
# {
#   "sockets": {
#     "container_id": "b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca",
#     "control_socket": "/var/lib/containers/storage/overlay-containers/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/userdata/ctl",
#     "io_socket": "/var/run/libpod/socket/b7624e7754312191613245ce1a46844abee60025818fe3c3f3203435623a1eca/attach"
#   }
# }
# ~~~
method GetAttachSockets(name: string) -> (sockets: Sockets)

# WaitContainer takes the name or ID of a container and waits the given interval in milliseconds until the container
# stops.  Upon stopping, the return code of the container is returned. If the container container cannot be found by ID
# or name, a [ContainerNotFound](#ContainerNotFound) error is returned.
method WaitContainer(name: string, interval: int) -> (exitcode: int)

# RemoveContainer requires the name or ID of a container as well as a boolean that
# indicates whether a container should be forcefully removed (e.g., by stopping it), and a boolean
# indicating whether to remove builtin volumes. Upon successful removal of the
# container, its ID is returned.  If the
# container cannot be found by name or ID, a [ContainerNotFound](#ContainerNotFound) error will be returned.
# See also [EvictContainer](EvictContainer).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.RemoveContainer '{"name": "62f4fd98cb57"}'
# {
#   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
# }
# ~~~
method RemoveContainer(name: string, force: bool, removeVolumes: bool) -> (container: string)

# EvictContainer requires the name or ID of a container as well as a boolean that
# indicates to remove builtin volumes. Upon successful eviction of the container,
# its ID is returned.  If the container cannot be found by name or ID,
# a [ContainerNotFound](#ContainerNotFound) error will be returned.
# See also [RemoveContainer](RemoveContainer).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.EvictContainer '{"name": "62f4fd98cb57"}'
# {
#   "container": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
# }
# ~~~
method EvictContainer(name: string, removeVolumes: bool) -> (container: string)

# DeleteStoppedContainers will delete all containers that are not running. It will return a list the deleted
# container IDs.  See also [RemoveContainer](RemoveContainer).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteStoppedContainers
# {
#   "containers": [
#     "451410b931d00def8aa9b4f8084e4d4a39e5e04ea61f358cf53a5cf95afcdcee",
#     "8b60f754a3e01389494a9581ade97d35c2765b6e2f19acd2d3040c82a32d1bc0",
#     "cf2e99d4d3cad6073df199ed32bbe64b124f3e1aba6d78821aa8460e70d30084",
#     "db901a329587312366e5ecff583d08f0875b4b79294322df67d90fc6eed08fc1"
#   ]
# }
# ~~~
method DeleteStoppedContainers() -> (containers: []string)

# ListImages returns information about the images that are currently in storage.
# See also [InspectImage](#InspectImage).
method ListImages() -> (images: []Image)

# GetImage returns information about a single image in storage.
# If the image caGetImage returns be found, [ImageNotFound](#ImageNotFound) will be returned.
method GetImage(id: string) -> (image: Image)

# BuildImage takes a [BuildInfo](#BuildInfo) structure and builds an image.  At a minimum, you must provide the
# contextDir tarball path, the 'dockerfiles' path, and 'output' option in the BuildInfo structure.  The 'output'
# options is the name of the of the resulting build. It will return a [MoreResponse](#MoreResponse) structure
# that contains the build logs and resulting image ID.
# #### Example
# ~~~
# $ sudo varlink call -m unix:///run/podman/io.podman/io.podman.BuildImage '{"build":{"contextDir":"/tmp/t/context.tar","dockerfiles":["Dockerfile"], "output":"foobar"}}'
# {
#  "image": {
#    "id": "",
#    "logs": [
#      "STEP 1: FROM alpine\n"
#    ]
#  }
# }
# {
#  "image": {
#    "id": "",
#    "logs": [
#      "STEP 2: COMMIT foobar\n"
#    ]
#  }
# }
# {
#  "image": {
#    "id": "",
#    "logs": [
#      "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9\n"
#    ]
#  }
# }
# {
#  "image": {
#    "id": "b7b28af77ffec6054d13378df4fdf02725830086c7444d9c278af25312aa39b9",
#    "logs": []
#  }
# }
# ~~~
method BuildImage(build: BuildInfo) -> (image: MoreResponse)

# This function is not implemented yet.
# method CreateImage() -> (notimplemented: NotImplemented)

# InspectImage takes the name or ID of an image and returns a string representation of data associated with the
#image.  You must serialize the string into JSON to use it further.  An [ImageNotFound](#ImageNotFound) error will
# be returned if the image cannot be found.
method InspectImage(name: string) -> (image: string)

# HistoryImage takes the name or ID of an image and returns information about its history and layers.  The returned
# history is in the form of an array of ImageHistory structures.  If the image cannot be found, an
# [ImageNotFound](#ImageNotFound) error is returned.
method HistoryImage(name: string) -> (history: []ImageHistory)

# PushImage takes two input arguments: the name or ID of an image, the fully-qualified destination name of the image,
# It will return an [ImageNotFound](#ImageNotFound) error if
# the image cannot be found in local storage; otherwise it will return a [MoreResponse](#MoreResponse)
method PushImage(name: string, tag: string, compress: bool, format: string, removeSignatures: bool, signBy: string) -> (reply: MoreResponse)

# TagImage takes the name or ID of an image in local storage as well as the desired tag name.  If the image cannot
# be found, an [ImageNotFound](#ImageNotFound) error will be returned; otherwise, the ID of the image is returned on success.
method TagImage(name: string, tagged: string) -> (image: string)

# RemoveImage takes the name or ID of an image as well as a boolean that determines if containers using that image
# should be deleted.  If the image cannot be found, an [ImageNotFound](#ImageNotFound) error will be returned.  The
# ID of the removed image is returned when complete.  See also [DeleteUnusedImages](DeleteUnusedImages).
# #### Example
# ~~~
# varlink call -m unix:/run/podman/io.podman/io.podman.RemoveImage '{"name": "registry.fedoraproject.org/fedora", "force": true}'
# {
#   "image": "426866d6fa419873f97e5cbd320eeb22778244c1dfffa01c944db3114f55772e"
# }
# ~~~
method RemoveImage(name: string, force: bool) -> (image: string)

# SearchImages searches available registries for images that contain the
# contents of "query" in their name. If "limit" is given, limits the amount of
# search results per registry.
method SearchImages(query: string, limit: ?int, filter: ImageSearchFilter) -> (results: []ImageSearchResult)

# DeleteUnusedImages deletes any images not associated with a container.  The IDs of the deleted images are returned
# in a string array.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.DeleteUnusedImages
# {
#   "images": [
#     "166ea6588079559c724c15223f52927f514f73dd5c5cf2ae2d143e3b2e6e9b52",
#     "da86e6ba6ca197bf6bc5e9d900febd906b133eaa4750e6bed647b0fbe50ed43e",
#     "3ef70f7291f47dfe2b82931a993e16f5a44a0e7a68034c3e0e086d77f5829adc",
#     "59788edf1f3e78cd0ebe6ce1446e9d10788225db3dedcfd1a59f764bad2b2690"
#   ]
# }
# ~~~
method DeleteUnusedImages() -> (images: []string)

# Commit, creates an image from an existing container. It requires the name or
# ID of the container as well as the resulting image name.  Optionally, you can define an author and message
# to be added to the resulting image.  You can also define changes to the resulting image for the following
# attributes: _CMD, ENTRYPOINT, ENV, EXPOSE, LABEL, ONBUILD, STOPSIGNAL, USER, VOLUME, and WORKDIR_.  To pause the
# container while it is being committed, pass a _true_ bool for the pause argument.  If the container cannot
# be found by the ID or name provided, a (ContainerNotFound)[#ContainerNotFound] error will be returned; otherwise,
# the resulting image's ID will be returned as a string inside a MoreResponse.
method Commit(name: string, image_name: string, changes: []string, author: string, message: string, pause: bool, manifestType: string) -> (reply: MoreResponse)

# ImportImage imports an image from a source (like tarball) into local storage.  The image can have additional
# descriptions added to it using the message and changes options. See also [ExportImage](ExportImage).
method ImportImage(source: string, reference: string, message: string, changes: []string, delete: bool) -> (image: string)

# ExportImage takes the name or ID of an image and exports it to a destination like a tarball.  There is also
# a boolean option to force compression.  It also takes in a string array of tags to be able to save multiple
# tags of the same image to a tarball (each tag should be of the form <image>:<tag>).  Upon completion, the ID
# of the image is returned. If the image cannot be found in local storage, an [ImageNotFound](#ImageNotFound)
# error will be returned. See also [ImportImage](ImportImage).
method ExportImage(name: string, destination: string, compress: bool, tags: []string) -> (image: string)

# PullImage pulls an image from a repository to local storage.  After a successful pull, the image id and logs
# are returned as a [MoreResponse](#MoreResponse).  This connection also will handle a WantsMores request to send
# status as it occurs.
method PullImage(name: string) -> (reply: MoreResponse)

# CreatePod creates a new empty pod.  It uses a [PodCreate](#PodCreate) type for input.
# On success, the ID of the newly created pod will be returned.
# #### Example
# ~~~
# $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"name": "test"}}'
# {
#   "pod": "b05dee7bd4ccfee688099fe1588a7a898d6ddd6897de9251d4671c9b0feacb2a"
# }
#
# $ varlink call unix:/run/podman/io.podman/io.podman.CreatePod '{"create": {"infra": true, "share": ["ipc", "net", "uts"]}}'
# {
#   "pod": "d7697449a8035f613c1a8891286502aca68fff7d5d49a85279b3bda229af3b28"
# }
# ~~~
method CreatePod(create: PodCreate) -> (pod: string)

# ListPods returns a list of pods in no particular order.  They are
# returned as an array of ListPodData structs.  See also [GetPod](#GetPod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.ListPods
# {
#   "pods": [
#     {
#       "cgroup": "machine.slice",
#       "containersinfo": [
#         {
#           "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
#           "name": "1840835294cf-infra",
#           "status": "running"
#         },
#         {
#           "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
#           "name": "upbeat_murdock",
#           "status": "running"
#         }
#       ],
#       "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
#       "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
#       "name": "foobar",
#       "numberofcontainers": "2",
#       "status": "Running"
#     },
#     {
#       "cgroup": "machine.slice",
#       "containersinfo": [
#         {
#           "id": "1ca4b7bbba14a75ba00072d4b705c77f3df87db0109afaa44d50cb37c04a477e",
#           "name": "784306f655c6-infra",
#           "status": "running"
#         }
#       ],
#       "createdat": "2018-12-07 13:09:57.105112457 -0600 CST",
#       "id": "784306f655c6200aea321dd430ba685e9b2cc1f7d7528a72f3ff74ffb29485a2",
#       "name": "nostalgic_pike",
#       "numberofcontainers": "1",
#       "status": "Running"
#     }
#   ]
# }
# ~~~
method ListPods() -> (pods: []ListPodData)

# GetPod takes a name or ID of a pod and returns single [ListPodData](#ListPodData)
# structure.  A [PodNotFound](#PodNotFound) error will be returned if the pod cannot be found.
# See also [ListPods](ListPods).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.GetPod '{"name": "foobar"}'
# {
#   "pod": {
#     "cgroup": "machine.slice",
#     "containersinfo": [
#       {
#         "id": "00c130a45de0411f109f1a0cfea2e298df71db20fa939de5cab8b2160a36be45",
#         "name": "1840835294cf-infra",
#         "status": "running"
#       },
#       {
#         "id": "49a5cce72093a5ca47c6de86f10ad7bb36391e2d89cef765f807e460865a0ec6",
#         "name": "upbeat_murdock",
#         "status": "running"
#       }
#     ],
#     "createdat": "2018-12-07 13:10:15.014139258 -0600 CST",
#     "id": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f",
#     "name": "foobar",
#     "numberofcontainers": "2",
#     "status": "Running"
#   }
# }
# ~~~
method GetPod(name: string) -> (pod: ListPodData)

# InspectPod takes the name or ID of an image and returns a string representation of data associated with the
# pod.  You must serialize the string into JSON to use it further.  A [PodNotFound](#PodNotFound) error will
# be returned if the pod cannot be found.
method InspectPod(name: string) -> (pod: string)

# StartPod starts containers in a pod.  It takes the name or ID of pod.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
# error will be returned.  Containers in a pod are started independently. If there is an error starting one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was started with no errors, the pod ID is returned.
# See also [CreatePod](#CreatePod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.StartPod '{"name": "135d71b9495f"}'
# {
#   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6",
# }
# ~~~
method StartPod(name: string) -> (pod: string)

# StopPod stops containers in a pod.  It takes the name or ID of a pod and a timeout.
# If the pod cannot be found, a [PodNotFound](#PodNotFound) error will be returned instead.
# Containers in a pod are stopped independently. If there is an error stopping one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was stopped with no errors, the pod ID is returned.
# See also [KillPod](KillPod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.StopPod '{"name": "135d71b9495f"}'
# {
#   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
# }
# ~~~
method StopPod(name: string, timeout: int) -> (pod: string)

# RestartPod will restart containers in a pod given a pod name or ID. Containers in
# the pod that are running will be stopped, then all stopped containers will be run.
# If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
# Containers in a pod are restarted independently. If there is an error restarting one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was restarted with no errors, the pod ID is returned.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.RestartPod '{"name": "135d71b9495f"}'
# {
#   "pod": "135d71b9495f7c3967f536edad57750bfdb569336cd107d8aabab45565ffcfb6"
# }
# ~~~
method RestartPod(name: string) -> (pod: string)

# KillPod takes the name or ID of a pod as well as a signal to be applied to the pod.  If the pod cannot be found, a
# [PodNotFound](#PodNotFound) error is returned.
# Containers in a pod are killed independently. If there is an error killing one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was killed with no errors, the pod ID is returned.
# See also [StopPod](StopPod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.KillPod '{"name": "foobar", "signal": 15}'
# {
#   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
# }
# ~~~
method KillPod(name: string, signal: int) -> (pod: string)

# PausePod takes the name or ID of a pod and pauses the running containers associated with it.  If the pod cannot be found,
# a [PodNotFound](#PodNotFound) error will be returned.
# Containers in a pod are paused independently. If there is an error pausing one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was paused with no errors, the pod ID is returned.
# See also [UnpausePod](#UnpausePod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.PausePod '{"name": "foobar"}'
# {
#   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
# }
# ~~~
method PausePod(name: string) -> (pod: string)

# UnpausePod takes the name or ID of a pod and unpauses the paused containers associated with it.  If the pod cannot be
# found, a [PodNotFound](#PodNotFound) error will be returned.
# Containers in a pod are unpaused independently. If there is an error unpausing one container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was unpaused with no errors, the pod ID is returned.
# See also [PausePod](#PausePod).
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.UnpausePod '{"name": "foobar"}'
# {
#   "pod": "1840835294cf076a822e4e12ba4152411f131bd869e7f6a4e8b16df9b0ea5c7f"
# }
# ~~~
method UnpausePod(name: string) -> (pod: string)

# RemovePod takes the name or ID of a pod as well a boolean representing whether a running
# container in the pod can be stopped and removed.  If a pod has containers associated with it, and force is not true,
# an error will occur.
# If the pod cannot be found by name or ID, a [PodNotFound](#PodNotFound) error will be returned.
# Containers in a pod are removed independently. If there is an error removing any container, the ID of those containers
# will be returned in a list, along with the ID of the pod in a [PodContainerError](#PodContainerError).
# If the pod was removed with no errors, the pod ID is returned.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.RemovePod '{"name": "62f4fd98cb57", "force": "true"}'
# {
#   "pod": "62f4fd98cb57f529831e8f90610e54bba74bd6f02920ffb485e15376ed365c20"
# }
# ~~~
method RemovePod(name: string, force: bool) -> (pod: string)

# This method has not be implemented yet.
# method WaitPod() -> (notimplemented: NotImplemented)

method TopPod(pod: string, latest: bool, descriptors: []string) -> (stats: []string)

# GetPodStats takes the name or ID of a pod and returns a pod name and slice of ContainerStats structure which
# contains attributes like memory and cpu usage.  If the pod cannot be found, a [PodNotFound](#PodNotFound)
# error will be returned.  If the pod has no running containers associated with it, a [NoContainerRunning](#NoContainerRunning)
# error will be returned.
# #### Example
# ~~~
# $ varlink call unix:/run/podman/io.podman/io.podman.GetPodStats '{"name": "7f62b508b6f12b11d8fe02e"}'
# {
#   "containers": [
#     {
#       "block_input": 0,
#       "block_output": 0,
#       "cpu": 2.833470544016107524276e-08,
#       "cpu_nano": 54363072,
#       "id": "a64b51f805121fe2c5a3dc5112eb61d6ed139e3d1c99110360d08b58d48e4a93",
#       "mem_limit": 12276146176,
#       "mem_perc": 7.974359265237864966003e-03,
#       "mem_usage": 978944,
#       "name": "quirky_heisenberg",
#       "net_input": 866,
#       "net_output": 7388,
#       "pids": 1,
#       "system_nano": 20000000
#     }
#   ],
#   "pod": "7f62b508b6f12b11d8fe02e0db4de6b9e43a7d7699b33a4fc0d574f6e82b4ebd"
# }
# ~~~
method GetPodStats(name: string) -> (pod: string, containers: []ContainerStats)

# GetPodsByStatus searches for pods whose status is included in statuses
method GetPodsByStatus(statuses: []string) -> (pods: []string)

# ImageExists talks a full or partial image ID or name and returns an int as to whether
# the image exists in local storage. An int result of 0 means the image does exist in
# local storage; whereas 1 indicates the image does not exists in local storage.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.ImageExists '{"name": "imageddoesntexist"}'
# {
#   "exists": 1
# }
# ~~~
method ImageExists(name: string) -> (exists: int)

# ContainerExists takes a full or partial container ID or name and returns an int as to
# whether the container exists in local storage.  A result of 0 means the container does
# exists; whereas a result of 1 means it could not be found.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.ContainerExists '{"name": "flamboyant_payne"}'{
#   "exists": 0
# }
# ~~~
method ContainerExists(name: string) -> (exists: int)

# ContainerCheckPoint performs a checkpopint on a container by its name or full/partial container
# ID.  On successful checkpoint, the id of the checkpointed container is returned.
method ContainerCheckpoint(name: string, keep: bool, leaveRunning: bool, tcpEstablished: bool) -> (id: string)

# ContainerRestore restores a container that has been checkpointed.  The container to be restored can
# be identified by its name or full/partial container ID.  A successful restore will result in the return
# of the container's ID.
method ContainerRestore(name: string, keep: bool, tcpEstablished: bool) -> (id: string)

# ContainerRunlabel runs executes a command as described by a given container image label.
method ContainerRunlabel(runlabel: Runlabel) -> ()

# ExecContainer executes a command in the given container.
method ExecContainer(opts: ExecOpts) -> ()

# ListContainerMounts gathers all the mounted container mount points and returns them as an array
# of strings
# #### Example
# ~~~
# $ varlink call unix:/run/podman/io.podman/io.podman.ListContainerMounts
# {
#   "mounts": {
#     "04e4c255269ed2545e7f8bd1395a75f7949c50c223415c00c1d54bfa20f3b3d9": "/var/lib/containers/storage/overlay/a078925828f57e20467ca31cfca8a849210d21ec7e5757332b72b6924f441c17/merged",
#     "1d58c319f9e881a644a5122ff84419dccf6d138f744469281446ab243ef38924": "/var/lib/containers/storage/overlay/948fcf93f8cb932f0f03fd52e3180a58627d547192ffe3b88e0013b98ddcd0d2/merged"
#   }
# }
# ~~~
method ListContainerMounts() -> (mounts: [string]string)

# MountContainer mounts a container by name or full/partial ID.  Upon a successful mount, the destination
# mount is returned as a string.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.MountContainer '{"name": "jolly_shannon"}'{
#   "path": "/var/lib/containers/storage/overlay/419eeb04e783ea159149ced67d9fcfc15211084d65e894792a96bedfae0470ca/merged"
# }
# ~~~
method MountContainer(name: string) -> (path: string)

# UnmountContainer umounts a container by its name or full/partial container ID.
# #### Example
# ~~~
# $ varlink call -m unix:/run/podman/io.podman/io.podman.UnmountContainer '{"name": "jolly_shannon", "force": false}'
# {}
# ~~~
method  UnmountContainer(name: string, force: bool) -> ()

# ImagesPrune removes all unused images from the local store.  Upon successful pruning,
# the IDs of the removed images are returned.
method ImagesPrune(all: bool) -> (pruned: []string)

# This function is not implemented yet.
# method ListContainerPorts(name: string) -> (notimplemented: NotImplemented)

# GenerateKube generates a Kubernetes v1 Pod description of a Podman container or pod
# and its containers. The description is in YAML.  See also [ReplayKube](ReplayKube).
method GenerateKube(name: string, service: bool) -> (pod: KubePodService)

# ReplayKube recreates a pod and its containers based on a Kubernetes v1 Pod description (in YAML)
# like that created by GenerateKube. See also [GenerateKube](GenerateKube).
# method ReplayKube() -> (notimplemented: NotImplemented)

# ContainerConfig returns a container's config in string form. This call is for
# development of Podman only and generally should not be used.
method ContainerConfig(name: string) -> (config: string)

# ContainerArtifacts returns a container's artifacts in string form.  This call is for
# development of Podman only and generally should not be used.
method ContainerArtifacts(name: string, artifactName: string) -> (config: string)

# ContainerInspectData returns a container's inspect data in string form.  This call is for
# development of Podman only and generally should not be used.
method ContainerInspectData(name: string, size: bool) -> (config: string)

# ContainerStateData returns a container's state config in string form.  This call is for
# development of Podman only and generally should not be used.
method ContainerStateData(name: string) -> (config: string)

# PodStateData returns inspectr level information of a given pod in string form.  This call is for
# development of Podman only and generally should not be used.
method PodStateData(name: string) -> (config: string)

# This call is for the development of Podman only and should not be used.
method CreateFromCC(in: []string) -> (id: string)

# Spec returns the oci spec for a container.  This call is for development of Podman only and generally should not be used.
method Spec(name: string) -> (config: string)

# Sendfile allows a remote client to send a file to the host
method SendFile(type: string, length: int) -> (file_handle: string)

# ReceiveFile allows the host to send a remote client a file
method ReceiveFile(path: string, delete: bool) -> (len: int)

# VolumeCreate creates a volume on a remote host
method VolumeCreate(options: VolumeCreateOpts) -> (volumeName: string)

# VolumeRemove removes a volume on a remote host
method VolumeRemove(options: VolumeRemoveOpts) -> (successes: []string, failures: [string]string)

# GetVolumes gets slice of the volumes on a remote host
method GetVolumes(args: []string, all: bool) -> (volumes: []Volume)

# InspectVolume inspects a single volume. Returns inspect JSON in the form of a
# string.
method InspectVolume(name: string) -> (volume: string)

# VolumesPrune removes unused volumes on the host
method VolumesPrune() -> (prunedNames: []string, prunedErrors: []string)

# ImageSave allows you to save an image from the local image storage to a tarball
method ImageSave(options: ImageSaveOptions) -> (reply: MoreResponse)

# GetPodsByContext allows you to get a list pod ids depending on all, latest, or a list of
# pod names.  The definition of latest pod means the latest by creation date.  In a multi-
# user environment, results might differ from what you expect.
method GetPodsByContext(all: bool, latest: bool, args: []string) -> (pods: []string)

# LoadImage allows you to load an image into local storage from a tarball.
method LoadImage(name: string, inputFile: string, quiet: bool, deleteFile: bool) -> (reply: MoreResponse)

# GetEvents returns known libpod events filtered by the options provided.
method GetEvents(filter: []string, since: string, until: string) -> (events: Event)

# Diff returns a diff between libpod objects
method Diff(name: string) -> (diffs: []DiffInfo)

# GetLayersMapWithImageInfo is for the development of Podman and should not be used.
method GetLayersMapWithImageInfo() -> (layerMap: string)

# BuildImageHierarchyMap is for the development of Podman and should not be used.
method BuildImageHierarchyMap(name: string) -> (imageInfo: string)

# ImageNotFound means the image could not be found by the provided name or ID in local storage.
error ImageNotFound (id: string, reason: string)

# ContainerNotFound means the container could not be found by the provided name or ID in local storage.
error ContainerNotFound (id: string, reason: string)

# NoContainerRunning means none of the containers requested are running in a command that requires a running container.
error NoContainerRunning ()

# PodNotFound means the pod could not be found by the provided name or ID in local storage.
error PodNotFound (name: string, reason: string)

# VolumeNotFound means the volume could not be found by the name or ID in local storage.
error VolumeNotFound (id: string, reason: string)

# PodContainerError means a container associated with a pod failed to perform an operation. It contains
# a container ID of the container that failed.
error PodContainerError (podname: string, errors: []PodContainerErrorData)

# NoContainersInPod means a pod has no containers on which to perform the operation. It contains
# the pod ID.
error NoContainersInPod (name: string)

# InvalidState indicates that a container or pod was in an improper state for the requested operation
error InvalidState (id: string, reason: string)

# ErrorOccurred is a generic error for an error that occurs during the execution.  The actual error message
# is includes as part of the error's text.
error ErrorOccurred (reason: string)

# RuntimeErrors generally means a runtime could not be found or gotten.
error RuntimeError (reason: string)

# The Podman endpoint requires that you use a streaming connection.
error WantsMoreRequired (reason: string)

# Container is already stopped
error ErrCtrStopped (id: string)

# This function requires CGroupsV2 to run in rootless mode.
error ErrRequiresCgroupsV2ForRootless(reason: string)
`
}

// Generated service interface

type VarlinkInterface struct {
	iopodmanInterface
}

func VarlinkNew(m iopodmanInterface) *VarlinkInterface {
	return &VarlinkInterface{m}
}
