%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

%global with_lfc %{?_with_lfc:1}%{!?_with_lfc:0}
%global with_java %{!?_without_java:1}%{?_without_java:0}
%global with_gcj %{!?_without_gcj:1}%{?_without_gcj:0}

%global pkgdir arc

Name: nordugrid-arc-nox
Version: 0.9.0
Release: 1%{?dist}
Summary: ARC
Group: System Environment/Daemons
License: ASL 2.0
URL: http://www.nordugrid.org/
Source: %{name}-%{version}.tar.gz
BuildRoot:%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Provides: nordugrid-arc1 = %{version}
Obsoletes: nordugrid-arc1 < 1.0.0
BuildRequires: cppunit-devel
BuildRequires: pkgconfig
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6
BuildRequires: libuuid-devel
%else
BuildRequires: e2fsprogs-devel
%endif
BuildRequires: gettext
BuildRequires: python-devel
BuildRequires: glibmm24-devel
BuildRequires: glib2-devel
BuildRequires: libxml2-devel
BuildRequires: openssl-devel
BuildRequires: xmlsec1-devel >= 1.2.4
BuildRequires: xmlsec1-openssl-devel >= 1.2.4
BuildRequires: gsoap-devel >= 2.7.2
%if %{_vendor} == "suse"
BuildRequires: openldap2-devel
BuildRequires: gettext-devel
%endif
%if %{_vendor} != "suse"
BuildRequires: openldap-devel
%endif
BuildRequires: globus-common-devel
BuildRequires: globus-ftp-client-devel
BuildRequires: globus-ftp-control-devel
BuildRequires: globus-rls-client-devel
%if %{with_lfc}
BuildRequires: LFC-devel
%endif
%if %{_vendor} == "redhat"
BuildRequires: db4-devel
%endif
#%if %{_vendor} == "suse" && %{dist} != ".oss10.3"
#BuildRequires: db-devel
#%endif
#%if %{_vendor} == "suse" && %{dist} == ".oss10.3"
#BuildRequires: libdb_cxx-4_4-devel
#%endif
%if %{_vendor} == "suse"
BuildRequires: db-devel
%endif
%if %{with_java}
BuildRequires: java-devel
BuildRequires: jpackage-utils
%if %{with_gcj}
BuildRequires: java-gcj-compat-devel
%endif
%endif

%define pyver %(python -c 'import sys; print sys.version[:3]')
%if "%{pyver}" < "2.4"
%define ifpy #
%else
%define ifpy %{nil}
%endif

%description
ARC

%package client
Summary: ARC prototype clients
Group: Applications/Internet
Requires: %{name} = %{version}
Requires: %{name}-plugins-base = %{version}
Provides: nordugrid-arc1-client = %{version}
Obsoletes: nordugrid-arc1-client < 1.0.0

%description client
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
For the regular user of any ARC-based computational grid,
this client package contains (or depends on) all packages
that are needed to submit jobs, query their status and
retrieve results.

%package hed
Summary: ARC Hosting Environment Daemon
Group: System Environment/Libraries
Requires: %{name} = %{version}
Provides: nordugrid-arc1-server = %{version}
Obsoletes: nordugrid-arc1-server < 1.0.0

Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts

%description hed
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
The ARC Hosting Environment Daemon (HED). This daemon presents a
site to other participants on the grid.  An intrinsic component
of any grid system is a mechanism allowing for the secure stateful
communication with remote environments. HED prepares for such an
environment and as such is the core of the ARC middleware. HED
was however written in a way, that represents typical grid
computing tasks (the sharing of CPU time or storage) to become
just one possible service between a user and a remote machine.
Many others are thinkable, and HED takes considerable effort
away from the respective implementors.

%package charon
Summary: ARC charon service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description charon
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
CHARON is a remote policy decision point service.  It accepts formatted
policy decision request and return positive or negative response. When
running a CHARON (within the HED), the TLS layer can be used for
securing the communication, when the request or response  information
are critical.

%package hopi
Summary: ARC hopi service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description hopi
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
The HOPI service provides a simple implementation of an http(s)
server. It supports GET and PUT operations. It can be used as a simple
file transfer service and it is usable via common web browsers and
other http(s) clients (e.g. wget).

%package isis
Summary: ARC isis service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description isis
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
ISIS is the new ARC information system implemented within HED. ISIS
comes with P2P capabilities and a web-services interface. The new system
grants grid participants an increase in flexibility, robustness and it
also offers easier configuration and self-healing capability.

%package compiler
Summary: ARC compiler service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description compiler
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
The purpose of this service is to provide compilation capability on the
remote site utilizing its full CPU capacity for parallel compilation
tasks. The service presumes that the compilation task is described
in a usual make file. The current implementation supports GNU compilers
only.

%package delegation
Summary: ARC delegation service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description delegation
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
The description of the delegation services is still pending.

%package paul
Summary: ARC paul service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description paul
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
The Paul is a pull-based execution service for computing resources. In
these case the computing resource can be single SMP computer. The Paul
uses the iBES protocol to communicate with Scheduler services or any
other service which implements iBES. The Paul can interact with multiple
Scheduler and can controll multiple job in one time. Paul can be used
to run on desktops (MS Windows as well) to form a 'desktop' grid.

%package saml2sp
Summary: ARC saml2sp service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description saml2sp
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
Service Provider is a utility service which is supposed to work together
with external Identity Provider and user agent (client) to accomplish
the "SAML2.0 Web SSO Profile" which requires client to provider
"username/password" instead of X.509 certificate for authentication.

%package slcs
Summary: ARC slcs service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}

%description slcs
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).
.
ARC Short-lived credential service.

%package arex
Summary: ARC Remote EXecution service
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: %{name}-hed = %{version}
Requires: perl-XML-Simple
Provides: nordugrid-arc1-arex = %{version}
Obsoletes: nordugrid-arc1-arex < 1.0.0

Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts

%description arex
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
The ARC Remote EXecution service (AREX) represents those parts of
the middleware that is responsible for the execution of compute
jobs and the transfer of input or output data.


%package plugins-base
Summary: ARC base plugins
Group: System Environment/Libraries
Requires: %{name} = %{version}
Provides: nordugrid-arc1-plugins-base = %{version}
Obsoletes: nordugrid-arc1-plugins-base < 1.0.0

%description plugins-base
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
ARC base plugins. This includes the Message Chain Components (MCCs) and
Data Manager Components (DMCs).

%package plugins-globus
Summary: ARC Globus plugins
Group: System Environment/Libraries
Requires: %{name} = %{version}
Provides: nordugrid-arc1-plugins-globus = %{version}
Obsoletes: nordugrid-arc1-plugins-globus < 1.0.0

%description plugins-globus
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
ARC Globus plugins. This includes the Globus dependent Data Manager
Components (DMCs).

%package devel
Summary: ARC development files
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: glibmm24-devel
Requires: glib2-devel
Requires: libxml2-devel
Requires: openssl-devel
Provides: nordugrid-arc1-devel = %{version}
Obsoletes: nordugrid-arc1-devel < 1.0.0

%description devel
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
The ARC middleware's core functionality, the Hosting Environment
Daemon (HED) can be extended for novel services. Considerable parts
of a regular installation of a regular installation of the NorduGrid
represent such modules. 

%package python
Summary: ARC Python wrapper
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: python
Provides: nordugrid-arc1-python = %{version}
Obsoletes: nordugrid-arc1-python < 1.0.0

%description python
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
Developers with an interest to integrate the some functionality on
a remote site via an interface compatible with ARC, may find it
preferable to perform that remote invocation from within Python.
While today most services in ARC are associated with computation or
storage, there is no constraint on these applications.

%if %{with_java}
%package java
Summary: ARC Java wrapper
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: java
Requires: jpackage-utils
%if %{with_gcj}
Requires(post): java-gcj-compat
Requires(postun): java-gcj-compat
%endif
Provides: nordugrid-arc1-java = %{version}
Obsoletes: nordugrid-arc1-java < 1.0.0

%description java
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
Developers with an interest to integrate the some functionality on
a remote site via an interface compatible with ARC, may find it
preferable to perform that remote invocation from within Java.
While today most services in ARC are associated with computation or
storage, there is no constraint on these applications.
%endif

%package janitor
Summary: ARC dynamic installation of runtime environments
Group: Applications/Internet
Requires: wget
Requires: perl-Log-Log4perl
Provides: nordugrid-arc1-janitor = %{version}
Obsoletes: nordugrid-arc1-janitor < 1.0.0

%description janitor
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

For grid computing, a major challenge is to keep the working environments
homogeneous between the sites.  To help this situation, runtime
environments have been developed. Those can be added to or removed from
a site, and this Janitor service helps automating this process.

The Janitor is a recent development and the community to prepare
catalogues of dynamically installable packages still needs to
evolve.

%package doc
Summary: ARC API documentation
Group: Documentation
Provides: nordugrid-arc1-doc = %{version}
Obsoletes: nordugrid-arc1-doc < 1.0.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch: noarch
%endif

%description doc
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).
.
Reference to the ARC programming API. It is prepared with doxygen.

%prep
%setup -q

%build
%configure --disable-static \
%if ! %{with_java}
     --disable-java \
%endif
%if %{with_lfc}
     --enable-lfc \
%endif
     --enable-docs

make all doc %{?_smp_mflags}

%check
make check

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'

mkdir -p $RPM_BUILD_ROOT%{_initrddir}
cp -p src/hed/daemon/scripts/arched.redhat $RPM_BUILD_ROOT%{_initrddir}/arched
chmod +x $RPM_BUILD_ROOT%{_initrddir}/arched

# RPM does it's own doc handling
rm -fr $RPM_BUILD_ROOT%{_datadir}/doc/%{pkgdir}

%find_lang arc

%if %{with_gcj}
%{_bindir}/aot-compile-rpm
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post hed
/sbin/chkconfig --add arched

%preun hed
if [ $1 = 0 ]; then
  service arched stop > /dev/null 2>&1
  /sbin/chkconfig --del arched
fi

%postun hed
if [ "$1" -ge "1" ]; then
  service arched condrestart > /dev/null 2>&1
fi
exit 0

%post arex
/sbin/chkconfig --add a-rex

%preun arex
if [ $1 = 0 ]; then
  service a-rex stop > /dev/null 2>&1
  /sbin/chkconfig --del a-rex
fi

%postun arex
if [ "$1" -ge "1" ]; then
  service a-rex condrestart > /dev/null 2>&1
fi
exit 0

%post java
%if %{with_gcj}
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%postun java
%if %{with_gcj}
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%files -f arc.lang
%defattr(-,root,root,-)
%{_libdir}/lib*.so.*
%{_datadir}/%{pkgdir}/schema
%dir %{_datadir}/%{pkgdir}/perl
%dir %{_datadir}/%{pkgdir}
%doc README AUTHORS LICENSE

%files client
%defattr(-,root,root,-)
%{_bindir}/arccat
%{_bindir}/arcclean
%{_bindir}/arccp
%{_bindir}/arcdecision
%{_bindir}/arcecho
%{_bindir}/arcget
%{_bindir}/arcinfo
%{_bindir}/arckill
%{_bindir}/arcls
%{_bindir}/arcmigrate
%{_bindir}/arcproxy
%{_bindir}/arcrenew
%{_bindir}/arcresub
%{_bindir}/arcresume
%{_bindir}/arcrm
%{_bindir}/arcslcs
%{_bindir}/arcsrmping
%{_bindir}/arcstat
%{_bindir}/arcsub
%{_bindir}/arcsync
%{_bindir}/arcwsrf
%{_bindir}/chelonia
%{_bindir}/isistest
%{_bindir}/jura
%{_bindir}/perftest
%{_bindir}/saml_assertion_init
%config(noreplace) %{_sysconfdir}/%{pkgdir}/client.conf
%{_datadir}/%{pkgdir}/examples/client.conf.example
%doc %{_mandir}/man1/arccat.1*
%doc %{_mandir}/man1/arcclean.1*
%doc %{_mandir}/man1/arccp.1*
%doc %{_mandir}/man1/arcdecision.1*
%doc %{_mandir}/man1/arcecho.1*
%doc %{_mandir}/man1/arcget.1*
%doc %{_mandir}/man1/arcinfo.1*
%doc %{_mandir}/man1/arckill.1*
%doc %{_mandir}/man1/arcls.1*
%doc %{_mandir}/man1/arcmigrate.1*
%doc %{_mandir}/man1/arcproxy.1*
%doc %{_mandir}/man1/arcrenew.1*
%doc %{_mandir}/man1/arcresub.1*
%doc %{_mandir}/man1/arcresume.1*
%doc %{_mandir}/man1/arcrm.1*
%doc %{_mandir}/man1/arcslcs.1*
%doc %{_mandir}/man1/arcstat.1*
%doc %{_mandir}/man1/arcsrmping.1*
%doc %{_mandir}/man1/arcsub.1*
%doc %{_mandir}/man1/arcsync.1*
%doc %{_mandir}/man1/arcwsrf.1*
%doc %{_mandir}/man1/chelonia.1*
%doc %{_mandir}/man1/jura.1*
%doc %{_mandir}/man1/perftest.1.gz
%doc %{_mandir}/man1/saml_assertion_init.1*
%doc %{_datadir}/%{pkgdir}/examples/charon/charon_client.xml.example
%doc %{_datadir}/%{pkgdir}/examples/charon/charon_request.xml.example
%doc %{_datadir}/%{pkgdir}/examples/echo/echo.wsdl

%files hed
%defattr(-,root,root,-)
%{_initrddir}/arched
%{_sbindir}/arched
%{_libdir}/%{pkgdir}/libecho.so
%{_datadir}/%{pkgdir}/profiles
%{_datadir}/%{pkgdir}/examples/config
%doc %{_datadir}/%{pkgdir}/examples/echo/echo_service.xml.example
%doc %{_mandir}/man8/arched.8*

%files charon
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libcharon.so
%doc %{_datadir}/%{pkgdir}/examples/charon/charon_policy_arc.xml.example
%doc %{_datadir}/%{pkgdir}/examples/charon/charon_policy_xacml.xml.example
%doc %{_datadir}/%{pkgdir}/examples/charon/charon_service.xml.example

%files hopi
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libhopi.so
%doc %{_datadir}/%{pkgdir}/examples/hopi/hopi_service.xml.example

%files isis
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libisis.so

%files compiler
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libcompiler.so

%files delegation
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdelegation.so

%files paul
%defattr(-,root,root,-)
%{_sbindir}/manage_jobq
%{_libdir}/%{pkgdir}/libgrid_sched.so
%{_libdir}/%{pkgdir}/libpaul.so
%doc %{_mandir}/man8/manage_jobq.8*

%files saml2sp
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libsaml2sp.so

%files slcs
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libslcs.so

%files arex
%defattr(-,root,root,-)
%{_initrddir}/a-rex
%{_libexecdir}/%{pkgdir}/cache-clean
%{_libexecdir}/%{pkgdir}/cache-list
%{_libexecdir}/%{pkgdir}/downloader
%{_libexecdir}/%{pkgdir}/gm-jobs
%{_libexecdir}/%{pkgdir}/gm-kick
%{_libexecdir}/%{pkgdir}/smtp-send
%{_libexecdir}/%{pkgdir}/smtp-send.sh
%{_libexecdir}/%{pkgdir}/uploader
%{_libexecdir}/%{pkgdir}/cancel-*-job
%{_libexecdir}/%{pkgdir}/scan-*-job
%{_libexecdir}/%{pkgdir}/submit-*-job
%{_libexecdir}/%{pkgdir}/finish-condor-job
%{_libexecdir}/%{pkgdir}/CEinfo.pl
%{_libdir}/%{pkgdir}/libarex.so
%{_libdir}/%{pkgdir}/ARC0mod.pm
%{_libdir}/%{pkgdir}/FORKmod.pm
%{_libdir}/%{pkgdir}/SGEmod.pm
%{_libdir}/%{pkgdir}/LL.pm
%{_libdir}/%{pkgdir}/LSF.pm
%{_libdir}/%{pkgdir}/PBS.pm
%{_libdir}/%{pkgdir}/Condor.pm
%{_libdir}/%{pkgdir}/SLURM.pm
%{_libdir}/%{pkgdir}/ARC0ClusterInfo.pm
%{_libdir}/%{pkgdir}/ARC0ClusterSchema.pm
%{_libdir}/%{pkgdir}/ARC1ClusterInfo.pm
%{_libdir}/%{pkgdir}/ARC1ClusterSchema.pm
%{_libdir}/%{pkgdir}/ConfigCentral.pm
%{_libdir}/%{pkgdir}/GMJobsInfo.pm
%{_libdir}/%{pkgdir}/HostInfo.pm
%{_libdir}/%{pkgdir}/RTEInfo.pm
%{_libdir}/%{pkgdir}/InfoChecker.pm
%{_libdir}/%{pkgdir}/IniParser.pm
%{_libdir}/%{pkgdir}/LogUtils.pm
%{_libdir}/%{pkgdir}/LRMSInfo.pm
%{_libdir}/%{pkgdir}/Sysinfo.pm
%{_libdir}/%{pkgdir}/cancel_common.sh
%{_libdir}/%{pkgdir}/change-lsf-mode.sh
%{_libdir}/%{pkgdir}/condor_env.pm
%{_libdir}/%{pkgdir}/config_parser.sh
%{_libdir}/%{pkgdir}/configure-*-env.sh
%{_libdir}/%{pkgdir}/submit_common.sh
%{_datadir}/%{pkgdir}/nordugrid.schema
%doc %{_mandir}/man1/cache-clean.1*
%doc %{_mandir}/man1/cache-list.1*
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_minimalistic.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_secure.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_showcase.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_xmlonly.xml.example

%files devel
%defattr(-,root,root,-)
%{_includedir}/%{pkgdir}
%{_libdir}/lib*.so
%{_bindir}/wsdl2hed
%doc %{_mandir}/man1/wsdl2hed.1*
%{_bindir}/arcplugin
%doc %{_mandir}/man1/arcplugin.1*
%{_libdir}/pkgconfig/arcbase.pc

%files plugins-base
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC1.so
%{_libdir}/%{pkgdir}/libaccCREAM.so
%{_libdir}/%{pkgdir}/libaccBroker.so
%{_libdir}/%{pkgdir}/libaccUNICORE.so
%{_libdir}/%{pkgdir}/libarcshc.so
%{_libdir}/%{pkgdir}/libdmcarc.so
%{_libdir}/%{pkgdir}/libdmcfile.so
%{_libdir}/%{pkgdir}/libdmchttp.so
%{_libdir}/%{pkgdir}/libdmcldap.so
%{_libdir}/%{pkgdir}/libidentitymap.so
%{_libdir}/%{pkgdir}/libmcchttp.so
%{_libdir}/%{pkgdir}/libmccmsgvalidator.so
%{_libdir}/%{pkgdir}/libmccsoap.so
%{_libdir}/%{pkgdir}/libmcctcp.so
%{_libdir}/%{pkgdir}/libmcctls.so

%files plugins-globus
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC0.so
%{_libdir}/%{pkgdir}/libdmcgridftp.so
%if %{with_lfc}
%{_libdir}/%{pkgdir}/libdmclfc.so
%endif
%{_libdir}/%{pkgdir}/libdmcrls.so
%{_libdir}/%{pkgdir}/libdmcsrm.so
%{_libdir}/%{pkgdir}/libmccgsi.so

%files python
%defattr(-,root,root,-)
%{python_sitearch}/*
%{_libdir}/%{pkgdir}/libaccPythonBroker.so
%{ifpy}%{_libdir}/%{pkgdir}/libpythonservice.so
%{_datadir}/%{pkgdir}/examples/storage_service.xml.example
%doc %{_datadir}/%{pkgdir}/examples/PythonBroker/SampleBroker.py*

%if %{with_java}
%files java
%defattr(-,root,root,-)
%{_libdir}/java/libjarc.so
%{_libdir}/java/arc.jar
%{_libdir}/%{pkgdir}/libjavaservice.so
%if %{with_gcj}
%{_libdir}/gcj/%{name}
%endif
%endif

%files janitor
%defattr(-,root,root,-)
%{_libexecdir}/%{pkgdir}/janitor
%{_datadir}/%{pkgdir}/janitor
%{_datadir}/%{pkgdir}/perl/Janitor
%doc %{_mandir}/man8/janitor.8*

%files doc
%defattr(-,root,root,-)
%doc doc/tech_doc/doxygen/ARC1-API.pdf
%doc doc/tech_doc/doxygen/ARC1-ChainComponents.pdf
%doc doc/tech_doc/doxygen/ARC1-Services.pdf
%doc doc/tech_doc/hed/ARCHED_article.pdf
%doc doc/tech_doc/chelonia/arc-storage-documentation.pdf
%doc doc/tech_doc/a-rex/arex_tech_doc.pdf
%doc doc/tech_doc/backend_interface/Backends-arc1.pdf
%doc doc/tech_doc/client/client_technical.pdf
%doc doc/tech_doc/infosys/infosys_technical.pdf
%doc doc/tech_doc/infosys/TechnicalHandbook/ISIS-TechnicalHandbook.pdf
%doc doc/manuals/janitor/Janitor.pdf
%doc doc/tech_doc/jura/jura-tech-doc.pdf
%doc doc/tech_doc/sec/arc-security-documentation.pdf
%doc doc/manuals/user_interface/ui.pdf
%doc doc/manuals/ws-quick-guide/ws-quick-guide.pdf
%doc doc/tutorials/ws-programming-tutorial/doc/WS-tutorial.pdf

%changelog
* Wed Jan 20 2010 Anders Waananen <waananen@nbi.dk> - 0.9.0-1
- Initial release
