import arc
import traceback

log_levels = [arc.DEBUG, arc.VERBOSE, arc.INFO, arc.WARNING, arc.ERROR, arc.FATAL]

def get_logger(system = '<UNKNOWN>'):
    return Logger(arc.Logger(arc.Logger_getRootLogger(), system))

class Logger:

    def __init__(self, logger):
        self.logger = logger

    def msg(self, *args):
        """docstring for log"""
        # initializing logging facility
        args = list(args)
        if not args:
            severity = arc.VERBOSE
        elif args[0] in log_levels:
            severity = args.pop(0)
        else:
            severity = arc.VERBOSE
        if not args:
            args = ['Python exception:\n', traceback.format_exc()]
            severity = arc.ERROR
        mesg = ' '.join([str(arg) for arg in args])
        self.logger.msg(severity, mesg)
        return mesg
