import arc, sys, time, os
from arcom.service import false
from arcom.xmltree import XMLTree
from storage.client import BartenderClient, ByteIOClient
from storage.common import create_checksum, upload_to_turl, download_from_turl
args = sys.argv[1:]
if len(args) > 0 and args[0] == '-x':
    args.pop(0)
    print_xml = True
else:
    print_xml = False
try:
    bartender_url = os.environ['ARC_BARTENDER_URL']
    print '- The URL of the Bartender:', bartender_url
except:
    bartender_url = 'http://localhost:60000/Bartender'
    print '- ARC_BARTENDER_URL environment variable not found, using', bartender_url
ssl_config = {}
if bartender_url.startswith('https'):
    key_file = os.environ.get('ARC_KEY_FILE', None)
    cert_file = os.environ.get('ARC_CERT_FILE', None)
    proxy_file = os.environ.get('ARC_PROXY_FILE', None)
    ca_file = os.environ.get('ARC_CA_FILE', None)
    ca_dir = os.environ.get('ARC_CA_DIR', None)
    if proxy_file:
        ssl_config['proxy_file'] = proxy_file
        print '- The proxy certificate file:', ssl_config['proxy_file']
    else:
        if key_file and cert_file:                
            ssl_config['key_file'] = key_file
            ssl_config['cert_file'] = cert_file
            print '- The key file:', ssl_config['key_file']
            print '- The cert file:', ssl_config['cert_file']
    if ca_file:
        ssl_config['ca_file'] = ca_file
        print '- The CA file:', ssl_config['ca_file']
    elif ca_dir:
        ssl_config['ca_dir'] = ca_dir
        print '- The CA dir:', ssl_config['ca_dir']
bartender = BartenderClient(bartender_url, print_xml, ssl_config = ssl_config)    
if len(args) == 0 or args[0] not in ['stat', 'makeMountpoint','unmakeMountpoint', 'unmakeCollection', 'makeCollection', 'list', 'move', 'putFile', 'getFile', 'delFile', 'addReplica', 'modify']:
    print 'Supported methods: stat, makeCollection, unmakeCollection, list, move, putFile, getFile, delFile, addReplica, modify' 
else:
    command = args.pop(0)
    if command == 'stat':
        if len(args) < 1:
            print 'Usage: stat <LN> [<LN> ...]'
        else:
            request = dict([(i, args[i]) for i in range(len(args))])
            print 'stat', request
            stat = bartender.stat(request)
            print stat
            for i,s in stat.items():
                print '%s:' % args[int(i)]
                c = {}
                for k,v in s.items():
                    sect, prop = k
                    c[sect] = c.get(sect,[])
                    c[sect].append((prop, v))
                for k, vs in c.items():
                    print k
                    for p, v in vs:
                        print '  %s: %s' % (p, v)
    elif command == 'delFile':
        if len(args) < 1:
            print 'Usage: delFile <LN> [<LN> ...]'
        else:
            request = dict([(i, args[i]) for i in range(len(args))])
            print 'delFile', request
            response = bartender.delFile(request)
            print response
    elif command == 'getFile':
        if len(args) < 2:
            print 'Usage: getFile <target filename> <source LN>'
        else:
            LN = args[1]
            filename = args[0]
            f = file(filename, 'wb')
            request = {'0' : (LN, ['byteio', 'http'])}
            print 'getFile', request
            response = bartender.getFile(request)
            print response
            success, turl, protocol = response['0']
            print '\n', LN, success
            if success == 'done':
                print 'Downloading from', turl, 'to', filename, 'with', protocol
                download_from_turl(turl, protocol, f, ssl_config = ssl_config)
    elif command == 'addReplica':
        if len(args) < 2:
            print 'Usage: addReplica <source filename> <GUID>'
        else:
            filename = args[0]
            requests = {'0' : args[1]}
            protocols = ['byteio', 'http']
            print 'addReplica', requests, protocols
            response = bartender.addReplica(requests, protocols)
            print response
            success, turl, protocol = response['0']
            if success == 'done':
                f = file(filename,'rb')
                print 'Uploading from', filename, 'to', turl, 'with', protocol
                upload_to_turl(turl, protocol, f, ssl_config = ssl_config)
    elif command == 'putFile':
        if len(args) < 2:
            print 'Usage: putFile <source filename> <target LN>'
        else:
            filename = args[0]
            size = os.path.getsize(filename)
            f = file(filename,'rb')
            checksum = create_checksum(f, 'md5')
            LN = args[1]
            if LN.endswith('/'):
                LN = LN + filename.split('/')[-1]
            metadata = {('states', 'size') : size, ('states', 'checksum') : checksum,
                    ('states', 'checksumType') : 'md5', ('states', 'neededReplicas') : 2}
            request = {'0': (LN, metadata, ['byteio', 'http'])}
            print 'putFile', request
            response = bartender.putFile(request)
            print response
            success, turl, protocol = response['0']
            print '\n', LN, success
            if success == 'done':
                f = file(filename,'rb')
                print 'Uploading from', filename, 'to', turl, 'with', protocol
                upload_to_turl(turl, protocol, f, ssl_config = ssl_config)
    elif command == 'unmakeCollection':
        if len(args) < 1:
            print 'Usage: unmakeCollection <LN>'
        else:
            request = {'0': (args[0])}
            print 'unmakeCollection', request
            response = bartender.unmakeCollection(request)
            print response
            print '\n', response['0']
    elif command == 'makeCollection':
        if len(args) < 1:
            print 'Usage: makeCollection <LN>'
        else:
            request = {'0': (args[0], {('states', 'closed') : false})}
            print 'makeCollection', request
            response = bartender.makeCollection(request)
            print response
            print '\n', response['0']

    ### Created by Salman Toor ###
    elif command == 'unmakeMountpoint':
        if len(args) < 1:
            print 'Usage: unmakeMountpoint <LN>'
        else:
            request = {'0': (args[0])}
            print 'unmakeMountpoint', request
            response = bartender.unmakeMountpoint(request)
            print response
            print '\n', response['0']
    elif command == 'makeMountpoint':
        if len(args) < 2:
            print 'Usage: makeMountpoint <LN> <URL>'
        else:
            request = {'0': (args[0], {('states', 'closed') : false}, args[1])}
            print 'makeMountpoint', request
            response = bartender.makeMountpoint(request)
            print response
            print '\n', response['0']
    ###    ###		
    elif command == 'list':
        if len(args) < 1:
            print 'Usage: list <LN> [<LN> ...]'
        else:
            request = dict([(str(i), args[i]) for i in range(len(args))])
            print 'list', request
            response = bartender.list(request,[('entry','')])
            
            if isinstance(response, str):
                print response
            else:	
                print response    	
                for rID, (entries, status) in response.items():
                    print
                    if status == 'found':
                        print '%s:' % request[rID]
                        for name, (GUID, metadata) in entries.items():
                            print '\t%s\t<%s>' % (name, metadata.get(('entry', 'type'),'unknown'))
                    else:
                        print '%s: %s' % (request[rID], status)
    elif command == 'move':
        if len(args) < 2:
            print 'Usage: move <sourceLN> <targetLN> [preserve]'
        else:
            sourceLN = args.pop(0)
            targetLN = args.pop(0)
            preserveOriginal = False
            if len(args) > 0:
                if args[0] == 'preserve':
                    preserveOriginal = True
            request = {'0' : (sourceLN, targetLN, preserveOriginal)}
            print 'move', request
            response = bartender.move(request)
            print response
            print '\n', response['0'][0]
    elif command == 'modify':
        if len(args) < 5:
            print 'Usage: modify <LN> <changeType> <section> <property> <value>'
        else:
            request = {'0' : args}
            print 'modify', request
            print bartender.modify(request)
