////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Window class for Options dialog
////////////////////////////////////////////////////////////////////////////

#ifdef _WIN32
  #pragma warning(disable:4786)
  #include "_win/bootstart.h" //register program loading at boot time
#endif

#include "OptionsDialog.h"
#include "lib/IniFile.h"
#include "support.h"
#include "mru.h"
#include "gui/GuiLanguage.h"
#include "lib/FilePath.h"
#include "TreeView.h"
#include "TextView.h"
#include "callbacks.h"

extern MRU g_objMRU;
extern GtkWidget *window1;
extern GuiLanguage g_lang;
extern TreeView g_tree;
extern TextView g_text;
extern bool g_bMinimizeToTray;

void restart_autosave();
int gtkMessageBox(const char *szText, int nButtons = GTK_BUTTONS_OK, int nIcon = GTK_MESSAGE_INFO);
static void on_backup_checked (GtkMenuItem *menuitem, gpointer user_data);
static void on_ok_clicked (GtkMenuItem *menuitem, gpointer user_data);

OptionsDialog::OptionsDialog()
{
	Create();
}

OptionsDialog::~OptionsDialog()
{
	Destroy();
}

void OptionsDialog::Create()
{
	m_pDialog = create_options_dialog (window1);
	OnDialogInit();
}

void OptionsDialog::OnDialogInit()
{
	GtkWidget *treeview = lookup_widget(window1, "treeview1");
	GtkWidget *textview = lookup_widget(window1, "textview1");

	GtkWidget *bootstart_btn  = lookup_widget(m_pDialog, "bootstart_btn");
	GtkWidget *maximize_btn   = lookup_widget(m_pDialog, "maximize_btn");
	GtkWidget *singleinst_btn = lookup_widget(m_pDialog, "singleinst_btn");
	GtkWidget *reloadlast_btn = lookup_widget(m_pDialog, "reloadlast_btn");
	GtkWidget *regformats_btn = lookup_widget(m_pDialog, "regformats_btn");
	GtkWidget *wraptext_btn	  = lookup_widget(m_pDialog, "wraptext_btn");
	GtkWidget *fontbutton2	  = lookup_widget(m_pDialog, "fontbutton2");
	GtkWidget *fontbutton3	  = lookup_widget(m_pDialog, "fontbutton3");
	GtkWidget *comboboxentry1 = lookup_widget(m_pDialog, "comboboxentry1");
	GtkWidget *min2tray_btn   = lookup_widget(m_pDialog, "min2tray_btn");
	GtkWidget *last_pos_btn   = lookup_widget(m_pDialog, "last_position_btn");
	GtkWidget *autosave_btn   = lookup_widget(m_pDialog, "autosave_btn");
	GtkWidget *autosave_fld   = lookup_widget(m_pDialog, "autosave_fld");
	
	//read options from the INI
	IniFile file;
	file.Load(MRU::getfilename());

	bool bBootstart;
	if(file.GetValue("Startup", "BootStart", bBootstart))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bootstart_btn), bBootstart);
	
	bool bMaximize;
	if(file.GetValue("Startup", "Maximize", bMaximize))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(maximize_btn), bMaximize);

	bool bSingleInst;
	if(file.GetValue("Startup", "AllowSingleInstance", bSingleInst))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(singleinst_btn), bSingleInst);

	bool bLoadLast;
	if(file.GetValue("Startup", "ReloadLastDocument", bLoadLast))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(reloadlast_btn), bLoadLast);

	bool bRestoreLastPos = true;
	file.GetValue("Startup", "RestoreLastPosition", bRestoreLastPos, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(last_pos_btn), bRestoreLastPos);
	
	bool bRegisterFormats;
	if(file.GetValue("Startup", "RegisterFormats", bRegisterFormats))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(regformats_btn), bRegisterFormats);
	
	bool bWrapText;
	if(file.GetValue("Display", "WrapText", bWrapText))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wraptext_btn), bWrapText);

	bool bMin2Tray;
	if(file.GetValue("Display", "MinimizeToTray", bMin2Tray))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(min2tray_btn), bMin2Tray);

	bool bAutosave;
	if(file.GetValue("Other", "UseAutosave", bAutosave))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autosave_btn), bAutosave);

	int nAutosaveTimer;
	file.GetValue("Other", "AutosaveTimer", nAutosaveTimer, 30);
	char szBuffer[20];
	sprintf(szBuffer, "%d", nAutosaveTimer);
	gtk_entry_set_text(GTK_ENTRY(autosave_fld), szBuffer);

	//set initial fonts
	std::string strFont1;
	file.GetValue("Display", "TreeFont", strFont1, "");
	if(strFont1.empty()){
		//copy current font from treeview
		GtkStyle *style = gtk_widget_get_style(treeview);
		strFont1 = pango_font_description_to_string(style->font_desc);
	}
#if GTK_CHECK_VERSION(2,4,0) //define minimal version for this api
	gtk_font_button_set_font_name(GTK_FONT_BUTTON(fontbutton2), strFont1.c_str());
#endif

	std::string strFont2;
	file.GetValue("Display", "TextFont", strFont2, "");
	if(strFont2.empty()){
		//copy current font from treeview
		GtkStyle *style = gtk_widget_get_style(textview);
		strFont2 = pango_font_description_to_string(style->font_desc);
	}
#if GTK_CHECK_VERSION(2,4,0) //define minimal version for this api
	gtk_font_button_set_font_name(GTK_FONT_BUTTON(fontbutton3), strFont2.c_str());
#endif

	//fill combo box with available languages
	std::string strLang;
	gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxentry1), "English (default)");
	for(int i=0; i<g_lang.GetCatalogCount(); i++)
	{
		//map back from locale to Language name
		strLang = g_lang.GetLangName(g_lang.GetCatalogAt(i).c_str());
		gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxentry1), strLang.c_str()); 
	}

	//select current saved INI language in the combo (not necessarily current language)
	std::string strLocale;
	file.GetValue("Display", "Language", strLocale, "");
	int nPos = g_lang.GetLocaleIdx(strLocale.c_str());
	gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxentry1), nPos+1);
}
	
void OptionsDialog::OnDialogOK()
{
	GtkWidget *treeview = lookup_widget(window1, "treeview1");
	GtkWidget *textview = lookup_widget(window1, "textview1");

	GtkWidget *bootstart_btn  = lookup_widget(m_pDialog, "bootstart_btn");
	GtkWidget *maximize_btn   = lookup_widget(m_pDialog, "maximize_btn");
	GtkWidget *singleinst_btn = lookup_widget(m_pDialog, "singleinst_btn");
	GtkWidget *reloadlast_btn = lookup_widget(m_pDialog, "reloadlast_btn");
	GtkWidget *regformats_btn = lookup_widget(m_pDialog, "regformats_btn");
	GtkWidget *wraptext_btn	  = lookup_widget(m_pDialog, "wraptext_btn");
	GtkWidget *fontbutton2	  = lookup_widget(m_pDialog, "fontbutton2");
	GtkWidget *fontbutton3	  = lookup_widget(m_pDialog, "fontbutton3");
	GtkWidget *comboboxentry1 = lookup_widget(m_pDialog, "comboboxentry1");
	GtkWidget *min2tray_btn   = lookup_widget(m_pDialog, "min2tray_btn");
	GtkWidget *last_pos_btn   = lookup_widget(m_pDialog, "last_position_btn");
	GtkWidget *autosave_btn   = lookup_widget(m_pDialog, "autosave_btn");
	GtkWidget *autosave_fld   = lookup_widget(m_pDialog, "autosave_fld");

	//reload INI data because it might have changed in dialog
	IniFile file;
	file.Load(MRU::getfilename());

	//
	// write options back to the INI (and activate them if necessary)
	//
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bootstart_btn)))
	{
		file.SetValue("Startup", "BootStart", 1);
		#ifdef _WIN32
			//register program loading at boot time
			if(!IsBootKeySet("notecase"))
				RunProgramAtBoot("notecase", GetAppPath().c_str(), TRUE);	//set
		#endif
	}
	else
	{
		file.SetValue("Startup", "BootStart", 0);
		#ifdef _WIN32
			//unregister program loading at boot time
			if(IsBootKeySet("notecase"))
				RunProgramAtBoot("notecase", GetAppPath().c_str(), FALSE);	//remove
		#endif
	}

	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(maximize_btn)))
		file.SetValue("Startup", "Maximize", 1);
	else
		file.SetValue("Startup", "Maximize", 0);

	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(singleinst_btn)))
		file.SetValue("Startup", "AllowSingleInstance", 1);
	else
		file.SetValue("Startup", "AllowSingleInstance", 0);

	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(reloadlast_btn)))
		file.SetValue("Startup", "ReloadLastDocument", 1);
	else
		file.SetValue("Startup", "ReloadLastDocument", 0);

	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(regformats_btn)))
		file.SetValue("Startup", "RegisterFormats", 1);
	else
		file.SetValue("Startup", "RegisterFormats", 0);

	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(wraptext_btn)))
	{
		file.SetValue("Display", "WrapText", 1);
		//if default changed, change the current state also
		if(!g_text.IsWrapped()){
			set_wrap_activated(true);
		}
	}
	else
	{
		file.SetValue("Display", "WrapText", 0);
		//if default changed, change the current state also
		if(g_text.IsWrapped()){
			set_wrap_activated(false);
		}
	}

#if GTK_CHECK_VERSION(2,4,0) //define minimal version for this api
	//set fonts
	const gchar *szFont1 = gtk_font_button_get_font_name(GTK_FONT_BUTTON(fontbutton2));
	PangoFontDescription *desc1 = pango_font_description_from_string(szFont1);
	gtk_widget_modify_font(treeview, desc1);
	file.SetValue("Display", "TreeFont", szFont1); //save font description

	const gchar *szFont2 = gtk_font_button_get_font_name(GTK_FONT_BUTTON(fontbutton3));
	PangoFontDescription *desc2 = pango_font_description_from_string(szFont2);
	gtk_widget_modify_font(textview, desc2);
	file.SetValue("Display", "TextFont", szFont2);//save font description
#endif			

	//save selected language locale
	std::string strNewLocale;
	int nRes = gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxentry1));
	if(nRes > 0) //first item in the list is "Default"
		strNewLocale = g_lang.GetCatalogAt(nRes-1).c_str();
	file.SetValue("Display", "Language", strNewLocale.c_str());

	//"minimize to tray" setting
	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(min2tray_btn)))
		g_bMinimizeToTray = true;
	else
		g_bMinimizeToTray = false;
	file.SetValue("Display", "MinimizeToTray", g_bMinimizeToTray);

	//"restore position" settings
	bool bRestoreLastPos;
	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(last_pos_btn)))
		bRestoreLastPos = true;
	else
		bRestoreLastPos = false;
	file.SetValue("Startup", "RestoreLastPosition", bRestoreLastPos);

	//autosave settings
	bool bAutosave;
	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(autosave_btn)))
		bAutosave = true;
	else
		bAutosave = false;
	file.SetValue("Other", "UseAutosave", bAutosave);
	file.SetValue("Other", "AutosaveTimer", gtk_entry_get_text(GTK_ENTRY(autosave_fld)));

	//save new settings to INI
	file.Save();

	restart_autosave();

	//if language selection changed, issue the warning
	if(0 != strcmp(m_strLocale.c_str(), strNewLocale.c_str()))
	{
		GtkWidget* msgbox;
		msgbox = gtk_message_dialog_new ( (GtkWindow*)m_pDialog,
			GTK_DIALOG_DESTROY_WITH_PARENT,
			(GtkMessageType)GTK_MESSAGE_INFO,
			(GtkButtonsType)GTK_BUTTONS_OK,
			_("You must restart NoteCase for this change to take effect!"));
		gtk_dialog_run (GTK_DIALOG (msgbox));
		gtk_widget_destroy (msgbox);
	}
}

GtkWidget* OptionsDialog::create_options_dialog (GtkWidget* parent)
{
	GtkWidget *Options;
	GtkWidget *dialog_vbox3;
	GtkWidget *notebook1;
	GtkWidget *vbox4;
	GtkWidget *checkbutton0;
	GtkWidget *checkbutton1;
	GtkWidget *checkbutton2;
	GtkWidget *checkbutton3;
	GtkWidget *checkbutton4;
	GtkWidget *checkbutton7;
	GtkWidget *label5;
	GtkWidget *label3;
	GtkWidget *dialog_action_area3;
	GtkWidget *cancelbutton3;
	GtkWidget *okbutton3;
	GtkWidget *table1;
	GtkWidget *fontbutton2;
	GtkWidget *fontbutton3;
	GtkWidget *checkbutton5;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *comboboxentry1; 
	GtkWidget *label8;
	GtkWidget *checkbutton6;
	GtkWidget *label19;
	GtkWidget *label20;
	GtkWidget *table2;
	GtkWidget *checkbutton8;
	GtkWidget *entry1;
	
	Options = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (Options), _("Options"));
	gtk_window_set_modal (GTK_WINDOW (Options), TRUE);
	gtk_window_set_skip_pager_hint (GTK_WINDOW (Options), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW (Options), GDK_WINDOW_TYPE_HINT_DIALOG);
#ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW (Options), TRUE);
#endif
	if(parent)
		gtk_window_set_transient_for(GTK_WINDOW (Options), GTK_WINDOW(parent));   //set parent
		
#if GTK_CHECK_VERSION(2,4,0) //new API TOFIX set proper version
	#ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
		gtk_window_set_keep_above(GTK_WINDOW (Options), TRUE);
	#endif
#endif
	gtk_window_set_destroy_with_parent (GTK_WINDOW (Options), TRUE);
	gtk_window_set_resizable (GTK_WINDOW (Options), FALSE);
	gtk_widget_realize(Options);
	gdk_window_set_decorations(Options->window, (GdkWMDecoration)(GDK_DECOR_BORDER|GDK_DECOR_TITLE)); 

	dialog_vbox3 = GTK_DIALOG (Options)->vbox;
	gtk_widget_show (dialog_vbox3);
	
	notebook1 = gtk_notebook_new ();
	gtk_widget_show (notebook1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox3), notebook1, TRUE, TRUE, 0);

	//
	// 1st tab
	//
	
	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox4);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox4);

	checkbutton0 = gtk_check_button_new_with_mnemonic (_("Start at logon"));
	gtk_widget_show (checkbutton0);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton0, FALSE, FALSE, 0);
#ifndef _WIN32
	gtk_widget_set_sensitive (checkbutton0, FALSE); //TOFIX temp disable until implemented
#endif

	checkbutton1 = gtk_check_button_new_with_mnemonic (_("Maximize on startup"));
	gtk_widget_show (checkbutton1);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton1, FALSE, FALSE, 0);
	
	checkbutton2 = gtk_check_button_new_with_mnemonic (_("Allow single instance only"));
	gtk_widget_show (checkbutton2);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton2, FALSE, FALSE, 0);
#ifndef _WIN32
	gtk_widget_set_sensitive (checkbutton2, FALSE); //TOFIX temp disable until implemented
#endif
	
	checkbutton3 = gtk_check_button_new_with_mnemonic (_("Reload last used document"));
	gtk_widget_show (checkbutton3);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton3, FALSE, FALSE, 0);
	
	checkbutton4 = gtk_check_button_new_with_mnemonic (_("Register document formats"));
	gtk_widget_show (checkbutton4);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton4, FALSE, FALSE, 0);

	checkbutton7 = gtk_check_button_new_with_mnemonic (_("Restore last position/size"));
	gtk_widget_show (checkbutton7);
	gtk_box_pack_start (GTK_BOX (vbox4), checkbutton7, FALSE, FALSE, 0);

	label5 = gtk_label_new (_("Startup"));
	gtk_widget_show (label5);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label5);
	
	//
	// 2nd tab
	//

	table1 = gtk_table_new (2, 5, FALSE);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (notebook1), table1);

	label6 = gtk_label_new (_("Tree font:"));
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);

	label7 = gtk_label_new (_("Text font:"));
	gtk_widget_show (label7);
	gtk_table_attach (GTK_TABLE (table1), label7, 0, 1, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

#if GTK_CHECK_VERSION(2,4,0) //define minimal version for this api
	fontbutton2 = gtk_font_button_new ();
	gtk_widget_show (fontbutton2);
	gtk_table_attach (GTK_TABLE (table1), fontbutton2, 1, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_font_button_set_show_style(GTK_FONT_BUTTON(fontbutton2), TRUE);
	gtk_font_button_set_show_size(GTK_FONT_BUTTON(fontbutton2), TRUE);
	gtk_font_button_set_use_font(GTK_FONT_BUTTON(fontbutton2), TRUE);
	gtk_font_button_set_use_size(GTK_FONT_BUTTON(fontbutton2), TRUE);

	fontbutton3 = gtk_font_button_new ();
	gtk_widget_show (fontbutton3);
	gtk_table_attach (GTK_TABLE (table1), fontbutton3, 1, 2, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_font_button_set_show_style(GTK_FONT_BUTTON(fontbutton3), TRUE);
	gtk_font_button_set_show_size(GTK_FONT_BUTTON(fontbutton3), TRUE);
	gtk_font_button_set_use_font(GTK_FONT_BUTTON(fontbutton3), TRUE);
	gtk_font_button_set_use_size(GTK_FONT_BUTTON(fontbutton3), TRUE);
#endif

	comboboxentry1 = gtk_combo_box_new_text (); //ex gtk_combo_box_entry_new_text()
	gtk_widget_show (comboboxentry1);
	gtk_table_attach (GTK_TABLE (table1), comboboxentry1, 1, 2, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
 
	label8	= gtk_label_new (_("Language:"));
	gtk_widget_show (label8);
	gtk_table_attach (GTK_TABLE (table1), label8, 0, 1, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

	checkbutton5 = gtk_check_button_new_with_mnemonic (_("Wrap text"));
	gtk_widget_show (checkbutton5);
	gtk_table_attach (GTK_TABLE (table1), checkbutton5, 0, 2, 3, 4, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	checkbutton6 = gtk_check_button_new_with_mnemonic (_("Minimize to tray"));
	gtk_widget_show (checkbutton6);
	gtk_table_attach (GTK_TABLE (table1), checkbutton6, 0, 2, 4, 5, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	label3 = gtk_label_new (_("Display"));
	gtk_widget_show (label3);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label3);

	//
	// 3rd tab
	//

	table2 = gtk_table_new (2, 5, FALSE);
	gtk_widget_show (table2);
	gtk_container_add (GTK_CONTAINER (notebook1), table2);

	checkbutton8 = gtk_check_button_new_with_mnemonic (_("Backup document (autosave) every:"));
	gtk_widget_show (checkbutton8);
	gtk_table_attach (GTK_TABLE (table2), checkbutton8, 0, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	entry1 = gtk_entry_new ();
	gtk_widget_show (entry1);
	gtk_widget_set_sensitive (entry1, FALSE);
	gtk_table_attach (GTK_TABLE (table2), entry1, 0, 1, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	label20 = gtk_label_new (_("seconds"));
	gtk_widget_show (label20);
	gtk_table_attach (GTK_TABLE (table2), label20, 1, 2, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label20), 0, 0.5);

	label19 = gtk_label_new (_("Save"));
	gtk_widget_show (label19);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label19);

	//
	// action area
	//

	dialog_action_area3 = GTK_DIALOG (Options)->action_area;
	gtk_widget_show (dialog_action_area3);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);

	cancelbutton3 = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (cancelbutton3);
	gtk_dialog_add_action_widget (GTK_DIALOG (Options), cancelbutton3, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (cancelbutton3, GTK_CAN_DEFAULT);
	
	okbutton3 = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (okbutton3);
	gtk_container_add (GTK_CONTAINER(dialog_action_area3), okbutton3);
	GTK_WIDGET_SET_FLAGS (okbutton3, GTK_CAN_DEFAULT);

	g_signal_connect (okbutton3, "clicked",	G_CALLBACK (on_ok_clicked), this);
	g_signal_connect (checkbutton8, "clicked",  G_CALLBACK (on_backup_checked), this);
	
	// Store pointers to all widgets, for use by lookup_widget()
	GLADE_HOOKUP_OBJECT_NO_REF (Options, Options, "Options");
	GLADE_HOOKUP_OBJECT_NO_REF (Options, dialog_vbox3, "dialog_vbox3");
	GLADE_HOOKUP_OBJECT (Options, notebook1, "notebook1");
	GLADE_HOOKUP_OBJECT (Options, vbox4, "vbox4");
	GLADE_HOOKUP_OBJECT (Options, checkbutton0, "bootstart_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton1, "maximize_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton2, "singleinst_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton3, "reloadlast_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton4, "regformats_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton5, "wraptext_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton6, "min2tray_btn");
	GLADE_HOOKUP_OBJECT (Options, checkbutton7, "last_position_btn");
	GLADE_HOOKUP_OBJECT (Options, label5, "label5");
	GLADE_HOOKUP_OBJECT (Options, label3, "label3");
	GLADE_HOOKUP_OBJECT (Options, table1, "table1");
	GLADE_HOOKUP_OBJECT (Options, label6, "label6");
	GLADE_HOOKUP_OBJECT (Options, label7, "label7");
	GLADE_HOOKUP_OBJECT (Options, label8, "label8");
	GLADE_HOOKUP_OBJECT (Options, comboboxentry1, "comboboxentry1");
	GLADE_HOOKUP_OBJECT (Options, fontbutton2, "fontbutton2");
	GLADE_HOOKUP_OBJECT (Options, fontbutton3, "fontbutton3");
	GLADE_HOOKUP_OBJECT_NO_REF (Options, dialog_action_area3, "dialog_action_area3");
	GLADE_HOOKUP_OBJECT (Options, cancelbutton3, "cancelbutton3");
	GLADE_HOOKUP_OBJECT (Options, okbutton3, "okbutton3");
	GLADE_HOOKUP_OBJECT (Options, checkbutton8, "autosave_btn");
	GLADE_HOOKUP_OBJECT (Options, entry1, "autosave_fld");

	return Options;
}

void on_backup_checked (GtkMenuItem *menuitem, gpointer user_data)
{
	OptionsDialog *pDlg = (OptionsDialog *)user_data;

	GtkWidget *autosave_btn = lookup_widget(pDlg->m_pDialog, "autosave_btn");
	GtkWidget *autosave_fld = lookup_widget(pDlg->m_pDialog, "autosave_fld");
	
	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(autosave_btn)))
		gtk_widget_set_sensitive (autosave_fld, TRUE);	
	else
		gtk_widget_set_sensitive (autosave_fld, FALSE);
}

void on_ok_clicked (GtkMenuItem *menuitem, gpointer user_data)
{
	OptionsDialog *pDlg = (OptionsDialog *)user_data;
	pDlg->OnDialogOK();
	pDlg->Destroy();
}


